/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthHistory;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.AuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.InvalidCredentialsException;
import org.wso2.carbon.identity.application.authentication.framework.exception.LogoutFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.RequestPathBasedSequenceHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.DefaultSequenceHandlerUtils;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;

public class DefaultRequestPathBasedSequenceHandler
implements RequestPathBasedSequenceHandler {
    private static final Log log = LogFactory.getLog(DefaultRequestPathBasedSequenceHandler.class);
    private static volatile DefaultRequestPathBasedSequenceHandler instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultRequestPathBasedSequenceHandler getInstance() {
        if (instance != null) return instance;
        Class<DefaultRequestPathBasedSequenceHandler> clazz = DefaultRequestPathBasedSequenceHandler.class;
        synchronized (DefaultRequestPathBasedSequenceHandler.class) {
            if (instance != null) return instance;
            instance = new DefaultRequestPathBasedSequenceHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing the Request Path Authentication...");
        }
        SequenceConfig seqConfig = context.getSequenceConfig();
        List<AuthenticatorConfig> reqPathAuthenticators = seqConfig.getReqPathAuthenticators();
        for (AuthenticatorConfig reqPathAuthenticator : reqPathAuthenticators) {
            ApplicationAuthenticator authenticator = reqPathAuthenticator.getApplicationAuthenticator();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing " + authenticator.getName()));
            }
            if (!authenticator.canHandle(request)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(authenticator.getName() + " can handle the request"));
            }
            try {
                AuthenticatorFlowStatus status = authenticator.process(request, response, context);
                request.setAttribute("authenticatorFlowStatus", (Object)status);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(authenticator.getName() + ".authenticate() returned: " + status.toString()));
                }
                AuthenticatedUser authenticatedUser = context.getSubject();
                seqConfig.setAuthenticatedUser(authenticatedUser);
                if (log.isDebugEnabled()) {
                    if (authenticatedUser != null) {
                        log.debug((Object)("Authenticated User: " + authenticatedUser.getAuthenticatedSubjectIdentifier()));
                        log.debug((Object)("Authenticated User Tenant Domain: " + authenticatedUser.getTenantDomain()));
                    } else {
                        log.debug((Object)"Authenticated User is NULL.");
                    }
                }
                AuthenticatedIdPData authenticatedIdPData = new AuthenticatedIdPData();
                authenticatedIdPData.setUser(authenticatedUser);
                authenticatedIdPData.setIdpName("LOCAL");
                reqPathAuthenticator.setAuthenticatorStateInfo(context.getStateInfo());
                authenticatedIdPData.setAuthenticator(reqPathAuthenticator);
                seqConfig.setAuthenticatedReqPathAuthenticator(reqPathAuthenticator);
                context.getCurrentAuthenticatedIdPs().put("LOCAL", authenticatedIdPData);
                this.handlePostAuthentication(request, response, context, authenticatedIdPData);
                context.addAuthenticationStepHistory(new AuthHistory(authenticator.getName(), authenticatedIdPData.getIdpName()));
            }
            catch (InvalidCredentialsException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"A login attempt was failed due to invalid credentials", (Throwable)((Object)e));
                }
                context.setRequestAuthenticated(false);
            }
            catch (AuthenticationFailedException e) {
                log.error((Object)e.getMessage(), (Throwable)((Object)e));
                context.setRequestAuthenticated(false);
            }
            catch (LogoutFailedException e) {
                throw new FrameworkException(e.getMessage(), (Throwable)((Object)e));
            }
            context.getSequenceConfig().setCompleted(true);
            return;
        }
    }

    protected void handlePostAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, AuthenticatedIdPData authenticatedIdPData) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Handling Post Authentication tasks");
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("\"idps\":");
        jsonBuilder.append("[");
        jsonBuilder.append("{");
        jsonBuilder.append("\"idp\":\"").append(authenticatedIdPData.getIdpName()).append("\",");
        jsonBuilder.append("\"authenticator\":\"").append(authenticatedIdPData.getAuthenticator().getApplicationAuthenticator().getName()).append("\"");
        jsonBuilder.append("}");
        jsonBuilder.append("]");
        sequenceConfig.setAuthenticatedIdPs(IdentityApplicationManagementUtil.getSignedJWT((String)jsonBuilder.toString(), (ServiceProvider)sequenceConfig.getApplicationConfig().getServiceProvider()));
        Map<String, String> mappedAttrs = this.handleClaimMappings(context);
        String spRoleUri = this.getSpRoleClaimUri(sequenceConfig.getApplicationConfig());
        String roleAttr = mappedAttrs.get(spRoleUri);
        if (StringUtils.isNotBlank((String)roleAttr)) {
            String[] roles = roleAttr.split(Pattern.quote(FrameworkUtils.getMultiAttributeSeparator()));
            mappedAttrs.put(spRoleUri, this.getServiceProviderMappedUserRoles(sequenceConfig, Arrays.asList(roles)));
        }
        sequenceConfig.getAuthenticatedUser().setUserAttributes(FrameworkUtils.buildClaimMappings(mappedAttrs));
        if (StringUtils.isNotBlank((String)context.getSequenceConfig().getApplicationConfig().getSubjectClaimUri())) {
            Map unfilteredClaimValues = (Map)context.getProperty("UNFILTERED_LOCAL_CLAIM_VALUES");
            String subjectClaimUri = context.getSequenceConfig().getApplicationConfig().getSubjectClaimUri().trim();
            String subjectClaimValue = unfilteredClaimValues != null ? (String)unfilteredClaimValues.get(subjectClaimUri) : mappedAttrs.get(subjectClaimUri);
            if (subjectClaimValue != null) {
                AuthenticatedUser authenticatedUser = sequenceConfig.getAuthenticatedUser();
                authenticatedUser.setAuthenticatedSubjectIdentifier(subjectClaimValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authenticated User: " + sequenceConfig.getAuthenticatedUser().getAuthenticatedSubjectIdentifier()));
                    log.debug((Object)("Authenticated User Tenant Domain: " + sequenceConfig.getAuthenticatedUser().getTenantDomain()));
                }
            }
        }
    }

    protected String getServiceProviderMappedUserRoles(SequenceConfig sequenceConfig, List<String> locallyMappedUserRoles) throws FrameworkException {
        return DefaultSequenceHandlerUtils.getServiceProviderMappedUserRoles(sequenceConfig, locallyMappedUserRoles);
    }

    protected String getSpRoleClaimUri(ApplicationConfig appConfig) throws FrameworkException {
        Map<String, String> spToLocalClaimMapping;
        String spRoleClaimUri = appConfig.getRoleClaim();
        if (spRoleClaimUri == null && (spToLocalClaimMapping = appConfig.getClaimMappings()) != null && !spToLocalClaimMapping.isEmpty()) {
            for (Map.Entry<String, String> entry : spToLocalClaimMapping.entrySet()) {
                if (!"http://wso2.org/claims/role".equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        if (spRoleClaimUri == null) {
            spRoleClaimUri = "http://wso2.org/claims/role";
            if (log.isDebugEnabled()) {
                String serviceProvider = appConfig.getApplicationName();
                log.debug((Object)("Service Provider Role Claim URI not configured for SP: " + serviceProvider + ". Defaulting to " + spRoleClaimUri));
            }
        }
        return spRoleClaimUri;
    }

    protected Map<String, String> handleClaimMappings(AuthenticationContext context) throws FrameworkException {
        try {
            Map<String, String> mappedAttrs = FrameworkUtils.getClaimHandler().handleClaimMappings(null, context, null, false);
            return mappedAttrs;
        }
        catch (FrameworkException e) {
            log.error((Object)"Claim handling failed!", (Throwable)((Object)e));
            return Collections.emptyMap();
        }
    }
}

