/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.AsyncCaller;
import org.wso2.carbon.identity.application.authentication.framework.AsyncReturn;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.LongWaitStatus;
import org.wso2.carbon.identity.application.authentication.framework.store.LongWaitStatusStoreService;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class AsyncSequenceExecutor {
    private static final Log log = LogFactory.getLog(AsyncSequenceExecutor.class);
    private ExecutorService executorService;

    public void init() {
        String poolSizeString = IdentityUtil.getProperty((String)"AdaptiveAuth.AsyncSequenceExecutorPoolSize");
        int poolSize = poolSizeString != null ? Integer.parseInt(poolSizeString) : 5;
        this.executorService = Executors.newFixedThreadPool(poolSize);
    }

    public void exec(AsyncCaller caller, AsyncReturn returnFunction, AuthenticationContext authenticationContext) throws FrameworkException {
        if (returnFunction == null) {
            throw new FrameworkException("Can not execute the async process, as no callback function registered on returnFunction.");
        }
        AsyncReturn wrappedReturn = (ctx, m, r) -> this.execReturn(returnFunction, ctx, m, r);
        this.executorService.submit(new AsyncCallerTask(new ObservingAsyncProcess(caller, wrappedReturn, authenticationContext)));
    }

    private void execReturn(AsyncReturn returnFunction, AuthenticationContext authenticationContext, Map<String, Object> data, String result) {
        this.executorService.execute(new AsyncReturnWorker(returnFunction, authenticationContext, data, result));
    }

    private class ObservingAsyncProcess {
        private AsyncCaller caller;
        private AsyncReturn returnFunction;
        private AuthenticationContext authenticationContext;

        public ObservingAsyncProcess(AsyncCaller caller, AsyncReturn returnFunction, AuthenticationContext authenticationContext) {
            this.caller = caller;
            this.returnFunction = returnFunction;
            this.authenticationContext = authenticationContext;
        }

        private void call() throws FrameworkException {
            this.caller.accept(this.authenticationContext, this.returnFunction);
        }
    }

    private class AsyncReturnWorker
    implements Runnable {
        private AsyncReturn returnFunction;
        private AuthenticationContext authenticationContext;
        private Map<String, Object> data;
        private String result;

        public AsyncReturnWorker(AsyncReturn returnFunction, AuthenticationContext authenticationContext, Map<String, Object> data, String result) {
            this.returnFunction = returnFunction;
            this.authenticationContext = authenticationContext;
            this.data = data;
            this.result = result;
        }

        @Override
        public void run() {
            LongWaitStatusStoreService longWaitStatusStoreService = FrameworkServiceDataHolder.getInstance().getLongWaitStatusStoreService();
            try {
                LongWaitStatus longWaitStatus = longWaitStatusStoreService.getWait(this.authenticationContext.getContextIdentifier());
                if (longWaitStatus == null) {
                    log.error((Object)("Unknown wait key: " + this.authenticationContext.getContextIdentifier() + " found while trying to continue from long wait. "));
                    return;
                }
                longWaitStatus.setStatus(LongWaitStatus.Status.COMPLETED);
                this.returnFunction.accept(this.authenticationContext, this.data, this.result);
            }
            catch (FrameworkException e) {
                log.error((Object)"Error while resuming from the wait. ", (Throwable)((Object)e));
            }
        }
    }

    private class AsyncCallerTask
    implements Runnable {
        private ObservingAsyncProcess asyncProcess;

        public AsyncCallerTask(ObservingAsyncProcess asyncProcess) {
            this.asyncProcess = asyncProcess;
        }

        @Override
        public void run() {
            try {
                this.asyncProcess.call();
            }
            catch (FrameworkException e) {
                log.error((Object)"Error while calling async process. ", (Throwable)((Object)e));
            }
        }
    }
}

