/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementClientException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.AddReceiptResponse;
import org.wso2.carbon.consent.mgt.core.model.ConsentPurpose;
import org.wso2.carbon.consent.mgt.core.model.PIICategory;
import org.wso2.carbon.consent.mgt.core.model.PIICategoryValidity;
import org.wso2.carbon.consent.mgt.core.model.Purpose;
import org.wso2.carbon.consent.mgt.core.model.PurposeCategory;
import org.wso2.carbon.consent.mgt.core.model.Receipt;
import org.wso2.carbon.consent.mgt.core.model.ReceiptInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptListResponse;
import org.wso2.carbon.consent.mgt.core.model.ReceiptPurposeInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptService;
import org.wso2.carbon.consent.mgt.core.model.ReceiptServiceInput;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.ClaimMetaData;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.ConsentClaimsData;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.SSOConsentService;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.UserConsent;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.exception.SSOConsentDisabledException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.exception.SSOConsentServiceException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementService;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class SSOConsentServiceImpl
implements SSOConsentService {
    private static final Log log = LogFactory.getLog(SSOConsentServiceImpl.class);
    private static final String DEFAULT_PURPOSE = "DEFAULT";
    private static final String DEFAULT_PURPOSE_CATEGORY = "DEFAULT";
    private static final String DEFAULT_PURPOSE_GROUP = "DEFAULT";
    private static final String DEFAULT_PURPOSE_GROUP_TYPE = "SP";
    private boolean ssoConsentEnabled = true;

    public SSOConsentServiceImpl() {
        this.readSSOConsentEnabledConfig();
    }

    @Override
    public ConsentClaimsData getConsentRequiredClaimsWithExistingConsents(ServiceProvider serviceProvider, AuthenticatedUser authenticatedUser) throws SSOConsentServiceException {
        return this.getConsentRequiredClaims(serviceProvider, authenticatedUser, true);
    }

    @Override
    public ConsentClaimsData getConsentRequiredClaimsWithoutExistingConsents(ServiceProvider serviceProvider, AuthenticatedUser authenticatedUser) throws SSOConsentServiceException {
        return this.getConsentRequiredClaims(serviceProvider, authenticatedUser, false);
    }

    protected ConsentClaimsData getConsentRequiredClaims(ServiceProvider serviceProvider, AuthenticatedUser authenticatedUser, boolean useExistingConsents) throws SSOConsentServiceException {
        if (!this.isSSOConsentManagementEnabled(serviceProvider)) {
            String message = "Consent management for SSO is disabled.";
            throw new SSOConsentDisabledException(message, message);
        }
        if (serviceProvider == null) {
            throw new SSOConsentServiceException("Service provider cannot be null.");
        }
        String spName = serviceProvider.getApplicationName();
        String spTenantDomain = this.getSPTenantDomain(serviceProvider);
        String subject = this.buildSubjectWithUserStoreDomain(authenticatedUser);
        ClaimMapping[] claimMappings = this.getSpClaimMappings(serviceProvider);
        ArrayList<String> requestedClaims = new ArrayList<String>();
        ArrayList<String> mandatoryClaims = new ArrayList<String>();
        Map<ClaimMapping, String> userAttributes = authenticatedUser.getUserAttributes();
        String subjectClaimUri = this.getSubjectClaimUri(serviceProvider);
        if (this.isPassThroughScenario(claimMappings, userAttributes)) {
            for (Map.Entry<ClaimMapping, String> entry : userAttributes.entrySet()) {
                String remoteClaimUri = entry.getKey().getRemoteClaim().getClaimUri();
                if (subjectClaimUri.equals(remoteClaimUri) || "MultiAttributeSeparator".equals(remoteClaimUri)) continue;
                mandatoryClaims.add(remoteClaimUri);
            }
        } else {
            boolean isCustomClaimMapping = this.isCustomClaimMapping(serviceProvider);
            for (ClaimMapping claimMapping : claimMappings) {
                if (isCustomClaimMapping) {
                    if (subjectClaimUri.equals(claimMapping.getRemoteClaim().getClaimUri())) {
                        subjectClaimUri = claimMapping.getLocalClaim().getClaimUri();
                        continue;
                    }
                } else if (subjectClaimUri.equals(claimMapping.getLocalClaim().getClaimUri())) continue;
                if (claimMapping.isMandatory()) {
                    mandatoryClaims.add(claimMapping.getLocalClaim().getClaimUri());
                    continue;
                }
                if (!claimMapping.isRequested()) continue;
                requestedClaims.add(claimMapping.getLocalClaim().getClaimUri());
            }
        }
        ArrayList<ClaimMetaData> receiptConsentMetaData = new ArrayList();
        Receipt receipt = this.getConsentReceiptOfUser(serviceProvider, authenticatedUser, spName, spTenantDomain, subject);
        if (useExistingConsents && receipt != null) {
            receiptConsentMetaData = this.getConsentClaimsFromReceipt(receipt);
            List<String> claimsWithConsent = this.getClaimsFromConsentMetaData(receiptConsentMetaData);
            mandatoryClaims.removeAll(claimsWithConsent);
            requestedClaims.clear();
        }
        ConsentClaimsData consentClaimsData = this.getConsentRequiredClaimData(mandatoryClaims, requestedClaims, spTenantDomain);
        consentClaimsData.setClaimsWithConsent(receiptConsentMetaData);
        return consentClaimsData;
    }

    private boolean isCustomClaimMapping(ServiceProvider serviceProvider) {
        return !serviceProvider.getClaimConfig().isLocalClaimDialect();
    }

    private boolean isPassThroughScenario(ClaimMapping[] claimMappings, Map<ClaimMapping, String> userAttributes) {
        return ArrayUtils.isEmpty((Object[])claimMappings) && MapUtils.isNotEmpty(userAttributes);
    }

    private String getSubjectClaimUri(ServiceProvider serviceProvider) {
        String subjectClaimUri = serviceProvider.getLocalAndOutBoundAuthenticationConfig().getSubjectClaimUri();
        if (StringUtils.isBlank((String)subjectClaimUri)) {
            subjectClaimUri = "http://wso2.org/claims/username";
        }
        return subjectClaimUri;
    }

    private void readSSOConsentEnabledConfig() {
        String ssoConsentEnabledElemText;
        OMElement ssoConsentEnabledElem;
        IdentityConfigParser identityConfigParser = IdentityConfigParser.getInstance();
        OMElement consentElement = identityConfigParser.getConfigElement("Consent");
        if (consentElement != null && (ssoConsentEnabledElem = consentElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "EnableSSOConsentManagement"))) != null && StringUtils.isNotBlank((String)(ssoConsentEnabledElemText = ssoConsentEnabledElem.getText()))) {
            this.ssoConsentEnabled = Boolean.parseBoolean(ssoConsentEnabledElemText);
            if (this.isDebugEnabled()) {
                this.logDebug("Consent management for SSO is set to " + this.ssoConsentEnabled + " from configurations.");
            }
            return;
        }
        this.ssoConsentEnabled = true;
    }

    private ClaimMapping[] getSpClaimMappings(ServiceProvider serviceProvider) {
        if (serviceProvider.getClaimConfig() != null) {
            return serviceProvider.getClaimConfig().getClaimMappings();
        }
        return new ClaimMapping[0];
    }

    private String getSPTenantDomain(ServiceProvider serviceProvider) {
        User owner = serviceProvider.getOwner();
        String spTenantDomain = owner != null ? owner.getTenantDomain() : "carbon.super";
        return spTenantDomain;
    }

    @Override
    public void processConsent(List<Integer> consentApprovedClaimIds, ServiceProvider serviceProvider, AuthenticatedUser authenticatedUser, ConsentClaimsData consentClaimsData) throws SSOConsentServiceException {
        if (!this.isSSOConsentManagementEnabled(serviceProvider)) {
            String message = "Consent management for SSO is disabled.";
            throw new SSOConsentDisabledException(message, message);
        }
        if (this.isDebugEnabled()) {
            this.logDebug("User: " + authenticatedUser.getAuthenticatedSubjectIdentifier() + " has approved consent.");
        }
        UserConsent userConsent = this.processUserConsent(consentApprovedClaimIds, consentClaimsData);
        String subject = this.buildSubjectWithUserStoreDomain(authenticatedUser);
        List<ClaimMetaData> claimsWithConsent = this.getAllUserApprovedClaims(serviceProvider, authenticatedUser, userConsent);
        String spTenantDomain = this.getSPTenantDomain(serviceProvider);
        String subjectTenantDomain = authenticatedUser.getTenantDomain();
        if (CollectionUtils.isNotEmpty(claimsWithConsent)) {
            this.addReceipt(subject, subjectTenantDomain, serviceProvider, spTenantDomain, claimsWithConsent);
        }
    }

    @Override
    public List<ClaimMetaData> getClaimsWithConsents(ServiceProvider serviceProvider, AuthenticatedUser authenticatedUser) throws SSOConsentServiceException {
        String subject;
        if (!this.isSSOConsentManagementEnabled(serviceProvider)) {
            String message = "Consent management for SSO is disabled.";
            throw new SSOConsentDisabledException(message, message);
        }
        if (serviceProvider == null) {
            throw new SSOConsentServiceException("Service provider cannot be null.");
        }
        String spName = serviceProvider.getApplicationName();
        List<ClaimMetaData> receiptConsentMetaData = new ArrayList<ClaimMetaData>();
        String spTenantDomain = this.getSPTenantDomain(serviceProvider);
        Receipt receipt = this.getConsentReceiptOfUser(serviceProvider, authenticatedUser, spName, spTenantDomain, subject = this.buildSubjectWithUserStoreDomain(authenticatedUser));
        if (receipt == null) {
            return receiptConsentMetaData;
        }
        receiptConsentMetaData = this.getConsentClaimsFromReceipt(receipt);
        return receiptConsentMetaData;
    }

    @Override
    public boolean isSSOConsentManagementEnabled(ServiceProvider serviceProvider) {
        return this.ssoConsentEnabled;
    }

    private Receipt getConsentReceiptOfUser(ServiceProvider serviceProvider, AuthenticatedUser authenticatedUser, String spName, String spTenantDomain, String subject) throws SSOConsentServiceException {
        int receiptListLimit = 2;
        try {
            List<ReceiptListResponse> receiptListResponses = this.getReceiptListOfUserForSP(authenticatedUser, spName, spTenantDomain, subject, receiptListLimit);
            if (this.isDebugEnabled()) {
                String message = String.format("Retrieved %s receipts for user: %s, service provider: %s in tenant domain %s", receiptListResponses.size(), subject, serviceProvider, spTenantDomain);
                this.logDebug(message);
            }
            if (this.hasUserMultipleReceipts(receiptListResponses)) {
                throw new SSOConsentServiceException("Consent Management Error", "User cannot have more than one ACTIVE consent per service provider.");
            }
            if (this.hasUserSingleReceipt(receiptListResponses)) {
                String receiptId = this.getFirstConsentReceiptFromList(receiptListResponses);
                return this.getReceipt(authenticatedUser, receiptId);
            }
            return null;
        }
        catch (ConsentManagementException e) {
            throw new SSOConsentServiceException("Consent Management Error", "Error while retrieving user consents.", e);
        }
    }

    private AddReceiptResponse addReceipt(String subject, String subjectTenantDomain, ServiceProvider serviceProvider, String spTenantDomain, List<ClaimMetaData> claims) throws SSOConsentServiceException {
        AddReceiptResponse receiptResponse;
        ReceiptInput receiptInput = this.buildReceiptInput(subject, serviceProvider, spTenantDomain, claims);
        try {
            this.startTenantFlowWithUser(subject, subjectTenantDomain);
            receiptResponse = this.getConsentManager().addConsent(receiptInput);
        }
        catch (ConsentManagementException e) {
            throw new SSOConsentServiceException("Consent receipt error", "Error while adding the consent receipt", e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        if (this.isDebugEnabled()) {
            this.logDebug("Successfully added consent receipt: " + receiptResponse.getConsentReceiptId());
        }
        return receiptResponse;
    }

    private ReceiptInput buildReceiptInput(String subject, ServiceProvider serviceProvider, String spTenantDomain, List<ClaimMetaData> claims) throws SSOConsentServiceException {
        String collectionMethod = "Web Form - Sign-in";
        String jurisdiction = "NONE";
        String language = "us_EN";
        String consentType = "EXPLICIT";
        String termination = "VALID_UNTIL:INDEFINITE";
        String policyUrl = "NONE";
        Purpose purpose = this.getDefaultPurpose();
        PurposeCategory purposeCategory = this.getDefaultPurposeCategory();
        List<PIICategoryValidity> piiCategoryIds = this.getPiiCategoryValiditiesForClaims(claims, termination);
        ArrayList<ReceiptServiceInput> serviceInputs = new ArrayList<ReceiptServiceInput>();
        ArrayList<ReceiptPurposeInput> purposeInputs = new ArrayList<ReceiptPurposeInput>();
        ArrayList<Integer> purposeCategoryIds = new ArrayList<Integer>();
        HashMap<String, String> properties = new HashMap<String, String>();
        purposeCategoryIds.add(purposeCategory.getId());
        ReceiptPurposeInput purposeInput = this.getReceiptPurposeInput(consentType, termination, purpose, piiCategoryIds, purposeCategoryIds);
        purposeInputs.add(purposeInput);
        ReceiptServiceInput serviceInput = this.getReceiptServiceInput(serviceProvider, spTenantDomain, purposeInputs);
        serviceInputs.add(serviceInput);
        return this.getReceiptInput(subject, collectionMethod, jurisdiction, language, policyUrl, serviceInputs, properties);
    }

    private ReceiptInput getReceiptInput(String subject, String collectionMethod, String jurisdiction, String language, String policyUrl, List<ReceiptServiceInput> serviceInputs, Map<String, String> properties) {
        ReceiptInput receiptInput = new ReceiptInput();
        receiptInput.setCollectionMethod(collectionMethod);
        receiptInput.setJurisdiction(jurisdiction);
        receiptInput.setLanguage(language);
        receiptInput.setPolicyUrl(policyUrl);
        receiptInput.setServices(serviceInputs);
        receiptInput.setProperties(properties);
        receiptInput.setPiiPrincipalId(subject);
        return receiptInput;
    }

    private ReceiptServiceInput getReceiptServiceInput(ServiceProvider serviceProvider, String spTenantDomain, List<ReceiptPurposeInput> purposeInputs) {
        ReceiptServiceInput serviceInput = new ReceiptServiceInput();
        serviceInput.setPurposes(purposeInputs);
        serviceInput.setTenantDomain(spTenantDomain);
        if (serviceProvider == null) {
            return serviceInput;
        }
        String spName = serviceProvider.getApplicationName();
        String spDescription = serviceProvider.getDescription();
        if (StringUtils.isBlank((String)spDescription)) {
            spDescription = spName;
        }
        serviceInput.setService(spName);
        serviceInput.setSpDisplayName(spName);
        serviceInput.setSpDescription(spDescription);
        return serviceInput;
    }

    private ReceiptPurposeInput getReceiptPurposeInput(String consentType, String termination, Purpose purpose, List<PIICategoryValidity> piiCategoryIds, List<Integer> purposeCategoryIds) {
        ReceiptPurposeInput purposeInput = new ReceiptPurposeInput();
        purposeInput.setPrimaryPurpose(Boolean.valueOf(true));
        purposeInput.setTermination(termination);
        purposeInput.setConsentType(consentType);
        purposeInput.setThirdPartyDisclosure(Boolean.valueOf(false));
        purposeInput.setPurposeId(purpose.getId());
        purposeInput.setPurposeCategoryId(purposeCategoryIds);
        purposeInput.setPiiCategory(piiCategoryIds);
        return purposeInput;
    }

    private List<PIICategoryValidity> getPiiCategoryValiditiesForClaims(List<ClaimMetaData> claims, String termination) throws SSOConsentServiceException {
        ArrayList<PIICategoryValidity> piiCategoryIds = new ArrayList<PIICategoryValidity>();
        for (ClaimMetaData claim : claims) {
            PIICategory piiCategory;
            try {
                piiCategory = this.getConsentManager().getPIICategoryByName(claim.getClaimUri());
            }
            catch (ConsentManagementClientException e) {
                if (this.isInvalidPIICategoryError(e)) {
                    piiCategory = this.addPIICategoryForClaim(claim);
                }
                throw new SSOConsentServiceException("Consent PII category error", "Error while retrieving PII category: DEFAULT", e);
            }
            catch (ConsentManagementException e) {
                throw new SSOConsentServiceException("Consent PII category error", "Error while retrieving PII category: DEFAULT", e);
            }
            piiCategoryIds.add(new PIICategoryValidity(piiCategory.getId(), termination));
        }
        return piiCategoryIds;
    }

    private PIICategory addPIICategoryForClaim(ClaimMetaData claim) throws SSOConsentServiceException {
        PIICategory piiCategory;
        PIICategory piiCategoryInput = new PIICategory(claim.getClaimUri(), claim.getDescription(), Boolean.valueOf(false), claim.getDisplayName());
        try {
            piiCategory = this.getConsentManager().addPIICategory(piiCategoryInput);
        }
        catch (ConsentManagementException e) {
            throw new SSOConsentServiceException("Consent PII category error", "Error while adding PII category:DEFAULT", e);
        }
        return piiCategory;
    }

    private boolean isInvalidPIICategoryError(ConsentManagementClientException e) {
        return ConsentConstants.ErrorMessages.ERROR_CODE_PII_CAT_NAME_INVALID.getCode().equals(e.getErrorCode());
    }

    private PurposeCategory getDefaultPurposeCategory() throws SSOConsentServiceException {
        PurposeCategory purposeCategory;
        try {
            purposeCategory = this.getConsentManager().getPurposeCategoryByName("DEFAULT");
        }
        catch (ConsentManagementClientException e) {
            if (this.isInvalidPurposeCategoryError(e)) {
                purposeCategory = this.addDefaultPurposeCategory();
            }
            throw new SSOConsentServiceException("Consent purpose category error", "Error while retrieving purpose category: DEFAULT", e);
        }
        catch (ConsentManagementException e) {
            throw new SSOConsentServiceException("Consent purpose category error", "Error while retrieving purpose category: DEFAULT", e);
        }
        return purposeCategory;
    }

    private PurposeCategory addDefaultPurposeCategory() throws SSOConsentServiceException {
        PurposeCategory purposeCategory;
        PurposeCategory defaultPurposeCategory = new PurposeCategory("DEFAULT", "For core functionalities of the product");
        try {
            purposeCategory = this.getConsentManager().addPurposeCategory(defaultPurposeCategory);
        }
        catch (ConsentManagementException e) {
            throw new SSOConsentServiceException("Consent purpose category error", "Error while adding purpose category: DEFAULT", e);
        }
        return purposeCategory;
    }

    private boolean isInvalidPurposeCategoryError(ConsentManagementClientException e) {
        return ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_CAT_NAME_INVALID.getCode().equals(e.getErrorCode());
    }

    private Purpose getDefaultPurpose() throws SSOConsentServiceException {
        Purpose purpose;
        try {
            purpose = this.getConsentManager().getPurposeByName("DEFAULT", "DEFAULT", DEFAULT_PURPOSE_GROUP_TYPE);
        }
        catch (ConsentManagementClientException e) {
            if (this.isInvalidPurposeError(e)) {
                purpose = this.addDefaultPurpose();
            }
            throw new SSOConsentServiceException("Consent purpose error", "Error while retrieving purpose: DEFAULT", e);
        }
        catch (ConsentManagementException e) {
            throw new SSOConsentServiceException("Consent purpose error", "Error while retrieving purpose: DEFAULT", e);
        }
        return purpose;
    }

    private Purpose addDefaultPurpose() throws SSOConsentServiceException {
        Purpose purpose;
        Purpose defaultPurpose = new Purpose("DEFAULT", "For core functionalities of the product", "DEFAULT", DEFAULT_PURPOSE_GROUP_TYPE);
        try {
            purpose = this.getConsentManager().addPurpose(defaultPurpose);
        }
        catch (ConsentManagementException e) {
            throw new SSOConsentServiceException("Consent purpose error", "Error while adding purpose: DEFAULT", e);
        }
        return purpose;
    }

    private boolean isInvalidPurposeError(ConsentManagementClientException e) {
        return ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_NAME_INVALID.getCode().equals(e.getErrorCode());
    }

    private UserConsent processUserConsent(List<Integer> consentApprovedClaimIds, ConsentClaimsData consentClaimsData) throws SSOConsentServiceException {
        UserConsent userConsent = new UserConsent();
        List<ClaimMetaData> approvedClamMetaData = this.buildApprovedClaimList(consentApprovedClaimIds, consentClaimsData);
        List<ClaimMetaData> consentRequiredClaimMetaData = this.getConsentRequiredClaimMetaData(consentClaimsData);
        List<ClaimMetaData> disapprovedClaims = this.buildDisapprovedClaimList(consentRequiredClaimMetaData, approvedClamMetaData);
        if (this.isMandatoryClaimsDisapproved(consentClaimsData.getMandatoryClaims(), disapprovedClaims)) {
            throw new SSOConsentServiceException("Consent Denied for Mandatory Attributes", "User denied consent to share mandatory attributes.");
        }
        userConsent.setApprovedClaims(approvedClamMetaData);
        userConsent.setDisapprovedClaims(disapprovedClaims);
        return userConsent;
    }

    private List<ClaimMetaData> getAllUserApprovedClaims(ServiceProvider serviceProvider, AuthenticatedUser authenticatedUser, UserConsent userConsent) throws SSOConsentServiceException {
        ArrayList<ClaimMetaData> claimsWithConsent = new ArrayList<ClaimMetaData>();
        claimsWithConsent.addAll(userConsent.getApprovedClaims());
        String spName = serviceProvider.getApplicationName();
        String spTenantDomain = this.getSPTenantDomain(serviceProvider);
        String subject = this.buildSubjectWithUserStoreDomain(authenticatedUser);
        Receipt receipt = this.getConsentReceiptOfUser(serviceProvider, authenticatedUser, spName, spTenantDomain, subject);
        if (receipt == null) {
            return claimsWithConsent;
        }
        List<PIICategoryValidity> piiCategoriesFromServices = this.getPIICategoriesFromServices(receipt.getServices());
        List<ClaimMetaData> claimsFromPIICategoryValidity = this.getClaimsFromPIICategoryValidity(piiCategoriesFromServices);
        claimsWithConsent.addAll(claimsFromPIICategoryValidity);
        return this.getDistinctClaims(claimsWithConsent);
    }

    private List<ClaimMetaData> getDistinctClaims(List<ClaimMetaData> claimsWithConsent) {
        return claimsWithConsent.stream().filter(this.distinctByKey(ClaimMetaData::getClaimUri)).collect(Collectors.toList());
    }

    private Predicate<ClaimMetaData> distinctByKey(Function<ClaimMetaData, String> keyExtractor) {
        HashSet claimUris = new HashSet();
        return claimUri -> claimUris.add(keyExtractor.apply((ClaimMetaData)claimUri));
    }

    private List<ClaimMetaData> getConsentRequiredClaimMetaData(ConsentClaimsData consentClaimsData) {
        ArrayList<ClaimMetaData> consentRequiredClaims = new ArrayList<ClaimMetaData>();
        if (CollectionUtils.isNotEmpty(consentClaimsData.getMandatoryClaims())) {
            consentRequiredClaims.addAll(consentClaimsData.getMandatoryClaims());
        }
        if (CollectionUtils.isNotEmpty(consentClaimsData.getRequestedClaims())) {
            consentRequiredClaims.addAll(consentClaimsData.getRequestedClaims());
        }
        return consentRequiredClaims;
    }

    private List<ClaimMetaData> buildDisapprovedClaimList(List<ClaimMetaData> consentRequiredClaims, List<ClaimMetaData> approvedClaims) {
        List<ClaimMetaData> disapprovedClaims = new ArrayList<ClaimMetaData>();
        if (CollectionUtils.isNotEmpty(consentRequiredClaims)) {
            consentRequiredClaims.removeAll(approvedClaims);
            disapprovedClaims = consentRequiredClaims;
        }
        return disapprovedClaims;
    }

    private List<ClaimMetaData> buildApprovedClaimList(List<Integer> consentApprovedClaimIds, ConsentClaimsData consentClaimsData) {
        ArrayList<ClaimMetaData> approvedClaims = new ArrayList<ClaimMetaData>();
        for (Integer claimId : consentApprovedClaimIds) {
            List<ClaimMetaData> requestedClaims;
            ClaimMetaData consentClaim = new ClaimMetaData();
            consentClaim.setId(claimId);
            List<ClaimMetaData> mandatoryClaims = consentClaimsData.getMandatoryClaims();
            int claimIndex = mandatoryClaims.indexOf(consentClaim);
            if (claimIndex != -1) {
                approvedClaims.add(mandatoryClaims.get(claimIndex));
            }
            if ((claimIndex = (requestedClaims = consentClaimsData.getRequestedClaims()).indexOf(consentClaim)) == -1) continue;
            approvedClaims.add(requestedClaims.get(claimIndex));
        }
        return approvedClaims;
    }

    private String buildSubjectWithUserStoreDomain(AuthenticatedUser authenticatedUser) {
        String userStoreDomain = authenticatedUser.isFederatedUser() ? this.getFederatedUserDomain(authenticatedUser.getFederatedIdPName()) : authenticatedUser.getUserStoreDomain();
        return UserCoreUtil.addDomainToName((String)authenticatedUser.getUserName(), (String)userStoreDomain);
    }

    private String getFederatedUserDomain(String authenticatedIDP) {
        if (StringUtils.isNotBlank((String)authenticatedIDP)) {
            return "FEDERATED:" + authenticatedIDP;
        }
        return "FEDERATED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReceiptListResponse> getReceiptListOfUserForSP(AuthenticatedUser authenticatedUser, String serviceProvider, String spTenantDomain, String subject, int limit) throws ConsentManagementException {
        List receiptListResponses;
        this.startTenantFlowWithUser(subject, authenticatedUser.getTenantDomain());
        try {
            receiptListResponses = this.getConsentManager().searchReceipts(limit, 0, subject, spTenantDomain, serviceProvider, "ACTIVE");
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return receiptListResponses;
    }

    private List<PIICategoryValidity> getPIICategoriesFromServices(List<ReceiptService> receiptServices) {
        ArrayList<PIICategoryValidity> piiCategoryValidityMap = new ArrayList<PIICategoryValidity>();
        for (ReceiptService receiptService : receiptServices) {
            List purposes = receiptService.getPurposes();
            for (ConsentPurpose purpose : purposes) {
                piiCategoryValidityMap.addAll(piiCategoryValidityMap.size(), purpose.getPiiCategory());
            }
        }
        return piiCategoryValidityMap;
    }

    private List<ClaimMetaData> getConsentClaimsFromReceipt(Receipt receipt) {
        List services = receipt.getServices();
        List<PIICategoryValidity> piiCategories = this.getPIICategoriesFromServices(services);
        List<ClaimMetaData> claimsFromPIICategoryValidity = this.getClaimsFromPIICategoryValidity(piiCategories);
        if (this.isDebugEnabled()) {
            String message = String.format("User: %s has provided consent in receipt: %s for claims: " + claimsFromPIICategoryValidity, receipt.getPiiPrincipalId(), receipt.getConsentReceiptId());
            this.logDebug(message);
        }
        return claimsFromPIICategoryValidity;
    }

    private List<ClaimMetaData> getClaimsFromPIICategoryValidity(List<PIICategoryValidity> piiCategories) {
        ArrayList<ClaimMetaData> claimMetaDataList = new ArrayList<ClaimMetaData>();
        for (PIICategoryValidity piiCategoryValidity : piiCategories) {
            if (!this.isConsentForClaimValid(piiCategoryValidity)) continue;
            ClaimMetaData claimMetaData = new ClaimMetaData();
            claimMetaData.setClaimUri(piiCategoryValidity.getName());
            claimMetaData.setDisplayName(piiCategoryValidity.getDisplayName());
            claimMetaDataList.add(claimMetaData);
        }
        return claimMetaDataList;
    }

    protected boolean isConsentForClaimValid(PIICategoryValidity piiCategoryValidity) {
        String consentValidity = piiCategoryValidity.getValidity();
        if (StringUtils.isEmpty((String)consentValidity)) {
            return true;
        }
        List<String> consentValidityEntries = Arrays.asList(consentValidity.split(","));
        for (String consentValidityEntry : consentValidityEntries) {
            block7: {
                if (!this.isSupportedExpiryType(consentValidityEntry)) continue;
                String[] validityEntry = consentValidityEntry.split(":", 2);
                if (validityEntry.length == 2) {
                    try {
                        String validTime = validityEntry[1];
                        if (this.isDebugEnabled()) {
                            String message = String.format("Validity time for PII category: %s is %s.", piiCategoryValidity.getName(), validTime);
                            this.logDebug(message);
                        }
                        if (this.isExpiryIndefinite(validTime)) {
                            return true;
                        }
                        long consentExpiryInMillis = Long.parseLong(validTime);
                        long currentTimeMillis = System.currentTimeMillis();
                        return this.isExpired(currentTimeMillis, consentExpiryInMillis);
                    }
                    catch (NumberFormatException e) {
                        if (!this.isDebugEnabled()) break block7;
                        String message = String.format("Cannot parse timestamp: %s. for PII category %s.", consentValidity, piiCategoryValidity.getName());
                        this.logDebug(message);
                    }
                }
            }
            return false;
        }
        return true;
    }

    private boolean isSupportedExpiryType(String consentValidityEntry) {
        return consentValidityEntry.toUpperCase().startsWith("VALID_UNTIL");
    }

    private boolean isExpired(long currentTimeMillis, long consentExpiryInMillis) {
        return consentExpiryInMillis > currentTimeMillis;
    }

    private boolean isExpiryIndefinite(String validTime) {
        return "INDEFINITE".equalsIgnoreCase(validTime);
    }

    private boolean isMandatoryClaimsDisapproved(List<ClaimMetaData> consentMandatoryClaims, List<ClaimMetaData> disapprovedClaims) {
        return CollectionUtils.isNotEmpty(consentMandatoryClaims) && !Collections.disjoint(disapprovedClaims, consentMandatoryClaims);
    }

    private ConsentClaimsData getConsentRequiredClaimData(List<String> mandatoryClaims, List<String> requestedClaims, String tenantDomain) throws SSOConsentServiceException {
        ConsentClaimsData consentClaimsData = new ConsentClaimsData();
        try {
            ClaimMetaData claimMetaData;
            List localClaims = this.getClaimMetadataManagementService().getLocalClaims(tenantDomain);
            ArrayList<ClaimMetaData> mandatoryClaimsMetaData = new ArrayList<ClaimMetaData>();
            ArrayList<ClaimMetaData> requestedClaimsMetaData = new ArrayList<ClaimMetaData>();
            int claimId = 0;
            if (CollectionUtils.isNotEmpty((Collection)localClaims)) {
                for (LocalClaim localClaim : localClaims) {
                    ClaimMetaData claimMetaData2;
                    if (this.isAllRequiredClaimsChecked(mandatoryClaims, requestedClaims)) break;
                    String claimURI = localClaim.getClaimURI();
                    if (mandatoryClaims.remove(claimURI)) {
                        claimMetaData2 = this.buildClaimMetaData(claimId, localClaim, claimURI);
                        mandatoryClaimsMetaData.add(claimMetaData2);
                        ++claimId;
                        continue;
                    }
                    if (!requestedClaims.remove(claimURI)) continue;
                    claimMetaData2 = this.buildClaimMetaData(claimId, localClaim, claimURI);
                    requestedClaimsMetaData.add(claimMetaData2);
                    ++claimId;
                }
            }
            if (CollectionUtils.isNotEmpty(mandatoryClaims)) {
                for (String claimUri : mandatoryClaims) {
                    claimMetaData = this.buildClaimMetaData(claimId, claimUri);
                    mandatoryClaimsMetaData.add(claimMetaData);
                    ++claimId;
                }
            }
            if (CollectionUtils.isNotEmpty(requestedClaims)) {
                for (String claimUri : mandatoryClaims) {
                    claimMetaData = this.buildClaimMetaData(claimId, claimUri);
                    requestedClaimsMetaData.add(claimMetaData);
                    ++claimId;
                }
            }
            consentClaimsData.setMandatoryClaims(mandatoryClaimsMetaData);
            consentClaimsData.setRequestedClaims(requestedClaimsMetaData);
        }
        catch (ClaimMetadataException e) {
            throw new SSOConsentServiceException("Error while retrieving local claims", "Error occurred while retrieving local claims for tenant: " + tenantDomain, e);
        }
        return consentClaimsData;
    }

    private boolean isAllRequiredClaimsChecked(List<String> mandatoryClaims, List<String> requestedClaims) {
        return CollectionUtils.isEmpty(mandatoryClaims) && CollectionUtils.isEmpty(requestedClaims);
    }

    private ClaimMetaData buildClaimMetaData(int claimId, String claimUri) {
        LocalClaim localClaim = new LocalClaim(claimUri);
        return this.buildClaimMetaData(claimId, localClaim, claimUri);
    }

    private ClaimMetaData buildClaimMetaData(int claimId, LocalClaim localClaim, String claimURI) {
        ClaimMetaData claimMetaData = new ClaimMetaData();
        claimMetaData.setId(claimId);
        claimMetaData.setClaimUri(claimURI);
        String displayName = (String)localClaim.getClaimProperties().get("DisplayName");
        if (StringUtils.isNotBlank((String)displayName)) {
            claimMetaData.setDisplayName(displayName);
        } else {
            claimMetaData.setDisplayName(claimURI);
        }
        String description = localClaim.getClaimProperty("Description");
        if (StringUtils.isNotBlank((String)description)) {
            claimMetaData.setDescription(description);
        } else {
            claimMetaData.setDescription("");
        }
        return claimMetaData;
    }

    private List<String> getClaimsFromConsentMetaData(List<ClaimMetaData> claimMetaDataList) {
        ArrayList<String> claims = new ArrayList<String>();
        for (ClaimMetaData claimMetaData : claimMetaDataList) {
            claims.add(claimMetaData.getClaimUri());
        }
        return claims;
    }

    private String getFirstConsentReceiptFromList(List<ReceiptListResponse> receiptListResponses) {
        return receiptListResponses.get(0).getConsentReceiptId();
    }

    private Receipt getReceipt(AuthenticatedUser authenticatedUser, String receiptId) throws SSOConsentServiceException {
        Receipt currentReceipt;
        String subject = this.buildSubjectWithUserStoreDomain(authenticatedUser);
        try {
            this.initializeTenantRegistry(authenticatedUser);
            this.startTenantFlowWithUser(subject, authenticatedUser.getTenantDomain());
            currentReceipt = this.getConsentManager().getReceipt(receiptId);
        }
        catch (ConsentManagementException e) {
            throw new SSOConsentServiceException("Consent Management Error", "Error while retrieving user consents.", e);
        }
        catch (IdentityException e) {
            throw new SSOConsentServiceException("Consent Management Error", "Error while initializing registry for the tenant domain: " + authenticatedUser.getTenantDomain(), e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        return currentReceipt;
    }

    private void initializeTenantRegistry(AuthenticatedUser authenticatedUser) throws IdentityException {
        IdentityTenantUtil.initializeRegistry((int)IdentityTenantUtil.getTenantId((String)authenticatedUser.getTenantDomain()));
    }

    private boolean hasUserSingleReceipt(List<ReceiptListResponse> receiptListResponses) {
        return receiptListResponses.size() == 1;
    }

    private boolean hasUserMultipleReceipts(List<ReceiptListResponse> receiptListResponses) {
        return receiptListResponses.size() > 1;
    }

    private void startTenantFlowWithUser(String subject, String subjectTenantDomain) {
        this.startTenantFlow(subjectTenantDomain);
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(subject);
    }

    private void startTenantFlow(String tenantDomain) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
    }

    private boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    private void logDebug(String message) {
        log.debug((Object)message);
    }

    private ConsentManager getConsentManager() {
        return FrameworkServiceDataHolder.getInstance().getConsentManager();
    }

    private ClaimMetadataManagementService getClaimMetadataManagementService() {
        return FrameworkServiceDataHolder.getInstance().getClaimMetadataManagementService();
    }
}

