/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.PostAuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.AbstractPostAuthnHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthnHandlerFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.ClaimMetaData;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.ConsentClaimsData;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.SSOConsentService;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.UserConsent;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.exception.SSOConsentDisabledException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.exception.SSOConsentServiceException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.User;

public class ConsentMgtPostAuthnHandler
extends AbstractPostAuthnHandler {
    private static final String HTTP_WSO2_ORG_OIDC_CLAIM = "http://wso2.org/oidc/claim";
    private static final String HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_05_IDENTITY = "http://schemas.xmlsoap.org/ws/2005/05/identity";
    private static final String HTTP_AXSCHEMA_ORG = "http://axschema.org";
    private static final String URN_SCIM_SCHEMAS_CORE_1_0 = "urn:scim:schemas:core:1.0";
    private static final String CONSENT_PROMPTED = "consentPrompted";
    private static final String CLAIM_SEPARATOR = ",";
    private static final String REQUESTED_CLAIMS_PARAM = "requestedClaims";
    private static final String MANDATORY_CLAIMS_PARAM = "mandatoryClaims";
    private static final String CONSENT_CLAIM_META_DATA = "consentClaimMetaData";
    private static final String REQUEST_TYPE_OAUTH2 = "oauth2";
    private static final String SP_NAME_DEFAULT = "DEFAULT";
    private static final Log log = LogFactory.getLog(ConsentMgtPostAuthnHandler.class);

    @Override
    public PostAuthnHandlerFlowStatus handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(context);
        if (authenticatedUser == null) {
            if (this.isDebugEnabled()) {
                String message = "User not available in AuthenticationContext. Returning";
                this.logDebug(message);
            }
            return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
        }
        if (this.isOAuthFlow(context) || this.isOpenIDFlow(context)) {
            return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
        }
        if (FrameworkUtils.isConsentPageSkippedForSP(this.getServiceProvider(context))) {
            return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
        }
        if (this.isConsentPrompted(context)) {
            return this.handlePostConsent(request, response, context);
        }
        return this.handlePreConsent(request, response, context);
    }

    private boolean isOAuthFlow(AuthenticationContext context) {
        return "oidc".equals(context.getRequestType()) || REQUEST_TYPE_OAUTH2.equalsIgnoreCase(context.getRequestType());
    }

    private boolean isOpenIDFlow(AuthenticationContext context) {
        return "openid".equals(context.getRequestType());
    }

    private boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    private void logDebug(String message) {
        log.debug((Object)message);
    }

    protected PostAuthnHandlerFlowStatus handlePreConsent(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        String spName = context.getSequenceConfig().getApplicationConfig().getApplicationName();
        if (SP_NAME_DEFAULT.equalsIgnoreCase(spName)) {
            return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
        }
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(context);
        ServiceProvider serviceProvider = this.getServiceProvider(context);
        try {
            String message;
            ConsentClaimsData consentClaimsData = this.getSSOConsentService().getConsentRequiredClaimsWithExistingConsents(serviceProvider, authenticatedUser);
            if (this.isDebugEnabled()) {
                message = String.format("Retrieving required consent data of user: %s for service provider: %s in tenant domain: %s.", authenticatedUser.getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
                this.logDebug(message);
            }
            if (CollectionUtils.isNotEmpty(consentClaimsData.getClaimsWithConsent())) {
                this.removeClaimsWithoutConsent(context, consentClaimsData);
            }
            if (this.hasConsentForRequiredClaims(consentClaimsData)) {
                if (this.isDebugEnabled()) {
                    message = String.format("Required consent data is empty for user: %s for service provider: %s in tenant domain: %s. Post authentication completed.", authenticatedUser.getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
                    this.logDebug(message);
                }
                return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
            }
            String mandatoryLocalClaims = this.buildConsentClaimString(consentClaimsData.getMandatoryClaims());
            String requestedLocalClaims = this.buildConsentClaimString(consentClaimsData.getRequestedClaims());
            if (this.isDebugEnabled()) {
                String message2 = "Require consent for mandatory claims: %s, requested claims: %s, from user: %s for service provider: %s in tenant domain: %s.";
                message2 = String.format(message2, consentClaimsData.getMandatoryClaims(), consentClaimsData.getRequestedClaims(), authenticatedUser.getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
                this.logDebug(message2);
            }
            this.redirectToConsentPage(response, context, requestedLocalClaims, mandatoryLocalClaims);
            this.setConsentPoppedUpState(context);
            context.addParameter(CONSENT_CLAIM_META_DATA, consentClaimsData);
            return PostAuthnHandlerFlowStatus.INCOMPLETE;
        }
        catch (SSOConsentDisabledException e) {
            return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
        }
        catch (SSOConsentServiceException e) {
            String error = String.format("Error occurred while retrieving consent data of user: %s for service provider: %s in tenant domain: %s.", authenticatedUser.getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
            throw new PostAuthenticationFailedException("Authentication failed. Error occurred while processing user consent.", error, (Throwable)((Object)e));
        }
    }

    private boolean hasConsentForRequiredClaims(ConsentClaimsData consentClaimsData) {
        return CollectionUtils.isEmpty(consentClaimsData.getMandatoryClaims()) && CollectionUtils.isEmpty(consentClaimsData.getRequestedClaims());
    }

    private void removeClaimsWithoutConsent(AuthenticationContext context, ConsentClaimsData consentClaimsData) throws PostAuthenticationFailedException {
        List<ClaimMetaData> claimsWithConsent = consentClaimsData.getClaimsWithConsent();
        List<String> claimsURIsWithConsent = this.getClaimsFromMetaData(claimsWithConsent);
        Set<String> claimsWithoutConsent = this.getClaimsWithoutConsent(claimsURIsWithConsent, context);
        String spStandardDialect = this.getStandardDialect(context);
        this.removeUserClaimsFromContext(context, new ArrayList<String>(claimsWithoutConsent), spStandardDialect);
    }

    private ServiceProvider getServiceProvider(AuthenticationContext context) {
        return context.getSequenceConfig().getApplicationConfig().getServiceProvider();
    }

    private String getSPTenantDomain(ServiceProvider serviceProvider) {
        User owner = serviceProvider.getOwner();
        String spTenantDomain = owner != null ? owner.getTenantDomain() : "carbon.super";
        return spTenantDomain;
    }

    private Set<String> getClaimsWithoutConsent(List<String> claimWithConsent, AuthenticationContext context) throws PostAuthenticationFailedException {
        ArrayList<String> requestedClaims = new ArrayList<String>(this.getSPRequestedLocalClaims(context));
        ArrayList<String> mandatoryClaims = new ArrayList<String>(this.getSPMandatoryLocalClaims(context));
        Set<String> consentClaims = this.getUniqueLocalClaims(requestedClaims, mandatoryClaims);
        consentClaims.removeAll(claimWithConsent);
        consentClaims.removeAll(mandatoryClaims);
        return consentClaims;
    }

    private String buildConsentClaimString(List<ClaimMetaData> consentClaimsData) {
        StringJoiner joiner = new StringJoiner(CLAIM_SEPARATOR);
        for (ClaimMetaData claimMetaData : consentClaimsData) {
            joiner.add(claimMetaData.getId() + "_" + claimMetaData.getDisplayName());
        }
        return joiner.toString();
    }

    private Set<String> getUniqueLocalClaims(List<String> requestedClaims, List<String> mandatoryClaims) {
        return Stream.concat(requestedClaims.stream(), mandatoryClaims.stream()).collect(Collectors.toSet());
    }

    protected PostAuthnHandlerFlowStatus handlePostConsent(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        String USER_CONSENT_INPUT = "consent";
        String USER_CONSENT_APPROVE = "approve";
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(context);
        ApplicationConfig applicationConfig = context.getSequenceConfig().getApplicationConfig();
        ServiceProvider serviceProvider = this.getServiceProvider(context);
        if (request.getParameter("consent").equalsIgnoreCase("approve")) {
            if (this.isDebugEnabled()) {
                String message = "User: %s has approved consent for service provider: %s in tenant domain %s.";
                message = String.format(message, authenticatedUser.getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
                this.logDebug(message);
            }
            UserConsent userConsent = this.processUserConsent(request, context);
            ConsentClaimsData consentClaimsData = this.getConsentClaimsData(context, authenticatedUser, serviceProvider);
            try {
                List<Integer> claimIdsWithConsent = this.getClaimIdsWithConsent(userConsent);
                this.getSSOConsentService().processConsent(claimIdsWithConsent, serviceProvider, authenticatedUser, consentClaimsData);
                this.removeDisapprovedClaims(context, userConsent);
            }
            catch (SSOConsentDisabledException e) {
                String error = "Authentication Failure: Consent management is disabled for SSO.";
                String errorDesc = "Illegal operation. Consent management is disabled, but post authentication for sso consent management is invoked.";
                throw new PostAuthenticationFailedException(error, errorDesc, (Throwable)((Object)e));
            }
            catch (SSOConsentServiceException e) {
                String error = "Error occurred while processing consent input of user: %s, for service provider: %s in tenant domain: %s.";
                error = String.format(error, authenticatedUser.getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
                throw new PostAuthenticationFailedException("Authentication failed. Error while processing user consent input.", error, (Throwable)((Object)e));
            }
        } else {
            String error = String.format("Authentication failed. User denied consent to share information with %s.", applicationConfig.getApplicationName());
            if (this.isDebugEnabled()) {
                this.logDebug(String.format("User: %s denied consent to share information with the service provider: %s.", authenticatedUser.getAuthenticatedSubjectIdentifier(), applicationConfig.getApplicationName()));
            }
            throw new PostAuthenticationFailedException(error, error);
        }
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }

    private ConsentClaimsData getConsentClaimsData(AuthenticationContext context, AuthenticatedUser authenticatedUser, ServiceProvider serviceProvider) throws PostAuthenticationFailedException {
        ConsentClaimsData consentClaimsData = (ConsentClaimsData)context.getParameter(CONSENT_CLAIM_META_DATA);
        if (consentClaimsData == null) {
            if (this.isDebugEnabled()) {
                this.logDebug("Cannot find consentClaimMetaData entry in AuthenticationContext. Retrieving from SSOConsentService.");
            }
            try {
                consentClaimsData = this.getSSOConsentService().getConsentRequiredClaimsWithExistingConsents(serviceProvider, authenticatedUser);
            }
            catch (SSOConsentDisabledException e) {
                String error = "Authentication Failure: Consent management is disabled for SSO.";
                String errorDesc = "Illegal operation. Consent management is disabled, but post authentication for sso consent management is invoked.";
                throw new PostAuthenticationFailedException(error, errorDesc, (Throwable)((Object)e));
            }
            catch (SSOConsentServiceException e) {
                String error = String.format("Error occurred while retrieving consent data of user: %s for service provider: %s in tenant domain: %s.", authenticatedUser.getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
                throw new PostAuthenticationFailedException("Authentication failed. Error occurred while processing user consent.", error, (Throwable)((Object)e));
            }
        }
        return consentClaimsData;
    }

    private List<Integer> getClaimIdsWithConsent(UserConsent userConsent) {
        return userConsent.getApprovedClaims().stream().map(ClaimMetaData::getId).collect(Collectors.toList());
    }

    private void removeDisapprovedClaims(AuthenticationContext context, UserConsent userConsent) {
        String spStandardDialect = this.getStandardDialect(context);
        List<String> disapprovedClaims = this.getClaimsFromMetaData(userConsent.getDisapprovedClaims());
        if (this.isDebugEnabled()) {
            String message = "Removing disapproved claims: %s in the dialect: %s by user: %s for service provider: %s in tenant domain: %s.";
            ServiceProvider serviceProvider = this.getServiceProvider(context);
            message = String.format(message, disapprovedClaims, StringUtils.defaultString((String)spStandardDialect), this.getAuthenticatedUser(context).getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
            this.logDebug(message);
        }
        this.removeUserClaimsFromContext(context, disapprovedClaims, spStandardDialect);
    }

    private List<String> getClaimsFromMetaData(List<ClaimMetaData> claimMetaDataList) {
        ArrayList<String> claims = new ArrayList<String>();
        for (ClaimMetaData claimMetaData : claimMetaDataList) {
            claims.add(claimMetaData.getClaimUri());
        }
        return claims;
    }

    private UserConsent processUserConsent(HttpServletRequest request, AuthenticationContext context) throws PostAuthenticationFailedException {
        String consentClaimsPrefix = "consent_";
        UserConsent userConsent = new UserConsent();
        ConsentClaimsData consentClaimsData = (ConsentClaimsData)context.getParameter(CONSENT_CLAIM_META_DATA);
        Map requestParams = request.getParameterMap();
        List<ClaimMetaData> approvedClamMetaData = this.buildApprovedClaimList(consentClaimsPrefix, requestParams, consentClaimsData);
        List<ClaimMetaData> consentRequiredClaimMetaData = this.getConsentRequiredClaimMetaData(consentClaimsData);
        List<ClaimMetaData> disapprovedClaims = this.buildDisapprovedClaimList(consentRequiredClaimMetaData, approvedClamMetaData);
        if (this.isMandatoryClaimsDisapproved(consentClaimsData.getMandatoryClaims(), disapprovedClaims)) {
            throw new PostAuthenticationFailedException("Authentication failed. Consent denied for mandatory attributes.", "User denied consent to share mandatory attributes.");
        }
        userConsent.setApprovedClaims(approvedClamMetaData);
        userConsent.setDisapprovedClaims(disapprovedClaims);
        return userConsent;
    }

    private List<ClaimMetaData> getConsentRequiredClaimMetaData(ConsentClaimsData consentClaimsData) {
        ArrayList<ClaimMetaData> consentRequiredClaims = new ArrayList<ClaimMetaData>();
        if (CollectionUtils.isNotEmpty(consentClaimsData.getMandatoryClaims())) {
            consentRequiredClaims.addAll(consentClaimsData.getMandatoryClaims());
        }
        if (CollectionUtils.isNotEmpty(consentClaimsData.getRequestedClaims())) {
            consentRequiredClaims.addAll(consentClaimsData.getRequestedClaims());
        }
        return consentRequiredClaims;
    }

    private boolean isMandatoryClaimsDisapproved(List<ClaimMetaData> consentMandatoryClaims, List<ClaimMetaData> disapprovedClaims) {
        return CollectionUtils.isNotEmpty(consentMandatoryClaims) && !Collections.disjoint(disapprovedClaims, consentMandatoryClaims);
    }

    private List<ClaimMetaData> buildDisapprovedClaimList(List<ClaimMetaData> consentRequiredClaims, List<ClaimMetaData> approvedClaims) {
        List<ClaimMetaData> disapprovedClaims = new ArrayList<ClaimMetaData>();
        if (CollectionUtils.isNotEmpty(consentRequiredClaims)) {
            consentRequiredClaims.removeAll(approvedClaims);
            disapprovedClaims = consentRequiredClaims;
        }
        return disapprovedClaims;
    }

    private List<ClaimMetaData> buildApprovedClaimList(String consentClaimsPrefix, Map<String, String[]> requestParams, ConsentClaimsData consentClaimsData) {
        ArrayList<ClaimMetaData> approvedClaims = new ArrayList<ClaimMetaData>();
        for (Map.Entry<String, String[]> entry : requestParams.entrySet()) {
            List<ClaimMetaData> requestedClaims;
            if (!entry.getKey().startsWith(consentClaimsPrefix)) continue;
            String claimId = entry.getKey().substring(consentClaimsPrefix.length());
            ClaimMetaData consentClaim = new ClaimMetaData();
            try {
                consentClaim.setId(Integer.parseInt(claimId));
            }
            catch (NumberFormatException e) {
                continue;
            }
            List<ClaimMetaData> mandatoryClaims = consentClaimsData.getMandatoryClaims();
            int claimIndex = mandatoryClaims.indexOf(consentClaim);
            if (claimIndex != -1) {
                approvedClaims.add(mandatoryClaims.get(claimIndex));
            }
            if ((claimIndex = (requestedClaims = consentClaimsData.getRequestedClaims()).indexOf(consentClaim)) == -1) continue;
            approvedClaims.add(requestedClaims.get(claimIndex));
        }
        return approvedClaims;
    }

    private void redirectToConsentPage(HttpServletResponse response, AuthenticationContext context, String requestedLocalClaims, String mandatoryLocalClaims) throws PostAuthenticationFailedException {
        try {
            URIBuilder uriBuilder = this.getUriBuilder(context, requestedLocalClaims, mandatoryLocalClaims);
            response.sendRedirect(uriBuilder.build().toString());
        }
        catch (IOException e) {
            throw new PostAuthenticationFailedException("Authentication failed. Error while processing consent requirements.", "Error while redirecting to consent page.", e);
        }
        catch (URISyntaxException e) {
            throw new PostAuthenticationFailedException("Authentication failed. Error while processing consent requirements.", "Error while building redirect URI.", e);
        }
    }

    private String getSubjectClaimUri(ApplicationConfig applicationConfig) {
        String subjectClaimUri = applicationConfig.getSubjectClaimUri();
        if (StringUtils.isEmpty((String)subjectClaimUri)) {
            subjectClaimUri = "http://wso2.org/claims/username";
        }
        return subjectClaimUri;
    }

    private List<String> getSPRequestedLocalClaims(AuthenticationContext context) throws PostAuthenticationFailedException {
        ArrayList<String> spRequestedLocalClaims = new ArrayList();
        ApplicationConfig applicationConfig = context.getSequenceConfig().getApplicationConfig();
        if (applicationConfig == null) {
            ServiceProvider serviceProvider = this.getServiceProvider(context);
            String error = "Application configs are null in AuthenticationContext for SP: " + serviceProvider.getApplicationName() + " in tenant domain: " + this.getSPTenantDomain(serviceProvider);
            throw new PostAuthenticationFailedException("Authentication failed. Error while processing application claim configurations.", error);
        }
        Map<String, String> claimMappings = applicationConfig.getRequestedClaimMappings();
        if (MapUtils.isNotEmpty(claimMappings) && CollectionUtils.isNotEmpty(claimMappings.values())) {
            spRequestedLocalClaims = new ArrayList<String>(claimMappings.values());
        }
        String subjectClaimUri = this.getSubjectClaimUri(applicationConfig);
        spRequestedLocalClaims.remove(subjectClaimUri);
        if (this.isDebugEnabled()) {
            String message = String.format("Requested claims for SP: %s - " + spRequestedLocalClaims, applicationConfig.getApplicationName());
            this.logDebug(message);
        }
        return spRequestedLocalClaims;
    }

    private List<String> getSPMandatoryLocalClaims(AuthenticationContext context) throws PostAuthenticationFailedException {
        String subjectClaimUri;
        ArrayList<String> spMandatoryLocalClaims = new ArrayList<String>();
        ApplicationConfig applicationConfig = context.getSequenceConfig().getApplicationConfig();
        if (applicationConfig == null) {
            ServiceProvider serviceProvider = this.getServiceProvider(context);
            String error = "Application configs are null in AuthenticationContext for SP: " + serviceProvider.getApplicationName() + " in tenant domain: " + this.getSPTenantDomain(serviceProvider);
            throw new PostAuthenticationFailedException("Authentication failed. Error while processing application claim configurations.", error);
        }
        Map<String, String> claimMappings = applicationConfig.getMandatoryClaimMappings();
        if (MapUtils.isNotEmpty(claimMappings) && CollectionUtils.isNotEmpty(claimMappings.values())) {
            spMandatoryLocalClaims = new ArrayList<String>(claimMappings.values());
        }
        if (!spMandatoryLocalClaims.contains(subjectClaimUri = this.getSubjectClaimUri(applicationConfig))) {
            spMandatoryLocalClaims.add(subjectClaimUri);
        }
        if (this.isDebugEnabled()) {
            String message = String.format("Mandatory claims for SP: %s - " + spMandatoryLocalClaims, applicationConfig.getApplicationName());
            this.logDebug(message);
        }
        return spMandatoryLocalClaims;
    }

    private URIBuilder getUriBuilder(AuthenticationContext context, String requestedLocalClaims, String mandatoryLocalClaims) throws URISyntaxException {
        String LOGIN_ENDPOINT = "login.do";
        String CONSENT_ENDPOINT = "consent.do";
        String CONSENT_ENDPOINT_URL = ConfigurationFacade.getInstance().getAuthenticationEndpointURL().replace("login.do", "consent.do");
        URIBuilder uriBuilder = new URIBuilder(CONSENT_ENDPOINT_URL);
        if (StringUtils.isNotBlank((String)requestedLocalClaims)) {
            if (this.isDebugEnabled()) {
                this.logDebug("Appending requested local claims to redirect URI: " + requestedLocalClaims);
            }
            uriBuilder.addParameter(REQUESTED_CLAIMS_PARAM, requestedLocalClaims);
        }
        if (StringUtils.isNotBlank((String)mandatoryLocalClaims)) {
            if (this.isDebugEnabled()) {
                this.logDebug("Appending mandatory local claims to redirect URI: " + mandatoryLocalClaims);
            }
            uriBuilder.addParameter(MANDATORY_CLAIMS_PARAM, mandatoryLocalClaims);
        }
        uriBuilder.addParameter("sessionDataKey", context.getContextIdentifier());
        uriBuilder.addParameter("sp", context.getSequenceConfig().getApplicationConfig().getApplicationName());
        return uriBuilder;
    }

    private AuthenticatedUser getAuthenticatedUser(AuthenticationContext authenticationContext) {
        return authenticationContext.getSequenceConfig().getAuthenticatedUser();
    }

    private void setConsentPoppedUpState(AuthenticationContext authenticationContext) {
        authenticationContext.addParameter(CONSENT_PROMPTED, true);
    }

    private boolean isConsentPrompted(AuthenticationContext authenticationContext) {
        return authenticationContext.getParameter(CONSENT_PROMPTED) != null;
    }

    private void removeUserClaimsFromContext(AuthenticationContext context, List<String> disapprovedClaims, String spStandardDialect) {
        Map<ClaimMapping, String> userAttributes = this.getUserAttributes(context);
        HashMap<ClaimMapping, String> modifiedUserAttributes = new HashMap<ClaimMapping, String>();
        if (this.isDebugEnabled()) {
            String message = "Removing disapproved claims: %s from context of user: %s for service provider: %s in tenant domain: %s";
            ServiceProvider serviceProvider = this.getServiceProvider(context);
            message = String.format(message, disapprovedClaims, this.getAuthenticatedUser(context).getAuthenticatedSubjectIdentifier(), serviceProvider.getApplicationName(), this.getSPTenantDomain(serviceProvider));
            this.logDebug(message);
        }
        if (this.isStandardDialect(spStandardDialect)) {
            Map<String, String> standardToCarbonClaimMappings = this.getSPToCarbonClaimMappings(context);
            this.filterClaims(userAttributes, disapprovedClaims, standardToCarbonClaimMappings, modifiedUserAttributes);
        } else {
            Map<String, String> customToLocalClaimMappings = context.getSequenceConfig().getApplicationConfig().getRequestedClaimMappings();
            this.filterClaims(userAttributes, disapprovedClaims, customToLocalClaimMappings, modifiedUserAttributes);
        }
        context.getSequenceConfig().getAuthenticatedUser().setUserAttributes(modifiedUserAttributes);
    }

    private boolean isWSO2StandardDialect(String spStandardDialect) {
        return StringUtils.equals((String)spStandardDialect, (String)"http://wso2.org/claims");
    }

    private boolean isStandardDialect(String spStandardDialect) {
        return StringUtils.isNotBlank((String)spStandardDialect) && !this.isWSO2StandardDialect(spStandardDialect);
    }

    private Map<ClaimMapping, String> getUserAttributes(AuthenticationContext context) {
        return context.getSequenceConfig().getAuthenticatedUser().getUserAttributes();
    }

    private void filterClaims(Map<ClaimMapping, String> userAttributes, List<String> disapprovedClaims, Map<String, String> claimMappings, Map<ClaimMapping, String> modifiedUserAttributes) {
        for (Map.Entry<ClaimMapping, String> entry : userAttributes.entrySet()) {
            String claimKey = entry.getKey().getLocalClaim().getClaimUri();
            if (!this.isConsentApprovedForClaim(disapprovedClaims, claimMappings, claimKey)) continue;
            modifiedUserAttributes.put(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> getSPToCarbonClaimMappings(AuthenticationContext context) {
        Object mapping = context.getProperty("SP_TO_CARBON_CLAIM_MAPPING");
        if (mapping != null && mapping instanceof HashMap) {
            return (Map)mapping;
        }
        return new HashMap<String, String>();
    }

    private boolean isConsentApprovedForClaim(List<String> disapprovedClaims, Map<String, String> carbonToSPClaimMapping, String localClaimUri) {
        return !disapprovedClaims.contains(localClaimUri) && !disapprovedClaims.contains(carbonToSPClaimMapping.get(localClaimUri));
    }

    private String getStandardDialect(AuthenticationContext context) {
        String clientType = context.getRequestType();
        ApplicationConfig appConfig = context.getSequenceConfig().getApplicationConfig();
        Map<String, String> claimMappings = appConfig.getClaimMappings();
        if ("oidc".equals(clientType)) {
            return HTTP_WSO2_ORG_OIDC_CLAIM;
        }
        if ("sts".equals(clientType)) {
            return HTTP_SCHEMAS_XMLSOAP_ORG_WS_2005_05_IDENTITY;
        }
        if ("openid".equals(clientType)) {
            return HTTP_AXSCHEMA_ORG;
        }
        if ("wso2".equals(clientType)) {
            return "http://wso2.org/claims";
        }
        if ("scim".equals(clientType)) {
            return URN_SCIM_SCHEMAS_CORE_1_0;
        }
        if (claimMappings == null || claimMappings.isEmpty()) {
            return "http://wso2.org/claims";
        }
        boolean isAtLeastOneNotEqual = false;
        for (Map.Entry<String, String> entry : claimMappings.entrySet()) {
            if (entry.getKey().equalsIgnoreCase(entry.getValue())) continue;
            isAtLeastOneNotEqual = true;
            break;
        }
        if (!isAtLeastOneNotEqual) {
            return "http://wso2.org/claims";
        }
        return null;
    }

    private SSOConsentService getSSOConsentService() {
        return FrameworkServiceDataHolder.getInstance().getSSOConsentService();
    }

    public String getName() {
        return "ConsentMgtPostAuthenticationHandler";
    }
}

