/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.PostAuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.AbstractPostAuthnHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthnHandlerFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.exception.FederatedAssociationManagerException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class PostAuthnMissingClaimHandler
extends AbstractPostAuthnHandler {
    private static final Log log = LogFactory.getLog(PostAuthnMissingClaimHandler.class);
    private static final Log AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    private static volatile PostAuthnMissingClaimHandler instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PostAuthnMissingClaimHandler getInstance() {
        if (instance != null) return instance;
        Class<PostAuthnMissingClaimHandler> clazz = PostAuthnMissingClaimHandler.class;
        synchronized (PostAuthnMissingClaimHandler.class) {
            if (instance != null) return instance;
            instance = new PostAuthnMissingClaimHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public int getPriority() {
        return 100;
    }

    public String getName() {
        return "MissingClaimPostAuthnHandler";
    }

    @Override
    public PostAuthnHandlerFlowStatus handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Post authentication handling for missing claims started");
        }
        if (this.getAuthenticatedUser(context) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No authenticated user found. Hence returning without handling mandatory claims");
            }
            return PostAuthnHandlerFlowStatus.UNSUCCESS_COMPLETED;
        }
        boolean postAuthRequestTriggered = this.isPostAuthRequestTriggered(context);
        if (!postAuthRequestTriggered) {
            PostAuthnHandlerFlowStatus flowStatus = this.handlePostAuthenticationForMissingClaimsRequest(request, response, context);
            return flowStatus;
        }
        this.handlePostAuthenticationForMissingClaimsResponse(request, response, context);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully returning from missing claim handler");
        }
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }

    private boolean isPostAuthRequestTriggered(AuthenticationContext context) {
        Object object = context.getProperty("postAuthenticationRedirectionTriggered");
        boolean postAuthRequestTriggered = false;
        if (object != null && object instanceof Boolean) {
            postAuthRequestTriggered = (Boolean)object;
        }
        return postAuthRequestTriggered;
    }

    private PostAuthnHandlerFlowStatus handlePostAuthenticationForMissingClaimsRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        String[] missingClaims = FrameworkUtils.getMissingClaims(context);
        if (StringUtils.isNotBlank((String)missingClaims[0])) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mandatory claims missing for the application : " + missingClaims[0]));
            }
            try {
                ClaimManager claimManager = this.getUserRealm(context.getTenantDomain()).getClaimManager();
                Map<String, String> missingClaimMap = FrameworkUtils.getMissingClaimsMap(context);
                for (Map.Entry<String, String> missingClaim : missingClaimMap.entrySet()) {
                    Claim claimObj = claimManager.getClaim(missingClaim.getValue());
                    if (claimObj == null || !claimObj.isReadOnly()) continue;
                    throw new PostAuthenticationFailedException("One or more read-only claim is missing in the requested claim set. Please contact your administrator for more information about this issue.", "One or more read-only claim is missing in the requested claim set");
                }
                URIBuilder uriBuilder = new URIBuilder(ConfigurationFacade.getInstance().getAuthenticationEndpointMissingClaimsURL());
                uriBuilder.addParameter("missingClaims", missingClaims[0]);
                uriBuilder.addParameter("sessionDataKey", context.getContextIdentifier());
                uriBuilder.addParameter("sp", context.getSequenceConfig().getApplicationConfig().getApplicationName());
                response.sendRedirect(uriBuilder.build().toString());
                context.setProperty("postAuthenticationRedirectionTriggered", true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Redirecting to outside to pick mandatory claims");
                }
            }
            catch (IOException e) {
                throw new PostAuthenticationFailedException("Error while handling missing mandatory claims", "Error while redirecting to request claims page", e);
            }
            catch (URISyntaxException e) {
                throw new PostAuthenticationFailedException("Error while handling missing mandatory claims", "Error while building redirect URI", e);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new PostAuthenticationFailedException("Error while handling missing mandatory claims", "Error while retrieving claim from claim URI.", e);
            }
            return PostAuthnHandlerFlowStatus.INCOMPLETE;
        }
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }

    private void handlePostAuthenticationForMissingClaimsResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting to process the response with missing claims");
        }
        HashMap<String, String> claims = new HashMap<String, String>();
        HashMap<String, String> claimsForContext = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        boolean persistClaims = false;
        AuthenticatedUser user = context.getSequenceConfig().getAuthenticatedUser();
        HashMap carbonToSPClaimMapping = new HashMap();
        Object spToCarbonClaimMappingObject = context.getProperty("SP_TO_CARBON_CLAIM_MAPPING");
        if (spToCarbonClaimMappingObject instanceof Map) {
            Map spToCarbonClaimMapping = (Map)spToCarbonClaimMappingObject;
            for (Map.Entry entry : spToCarbonClaimMapping.entrySet()) {
                carbonToSPClaimMapping.put(entry.getValue(), entry.getKey());
            }
        }
        for (Map.Entry entry : requestParams.entrySet()) {
            if (!((String)entry.getKey()).startsWith("claim_mand_")) continue;
            String string = ((String)entry.getKey()).substring("claim_mand_".length());
            claims.put(string, ((String[])entry.getValue())[0]);
            if (spToCarbonClaimMappingObject != null) {
                String spClaimURI = (String)carbonToSPClaimMapping.get(string);
                claimsForContext.put(spClaimURI, ((String[])entry.getValue())[0]);
                continue;
            }
            claimsForContext.put(string, ((String[])entry.getValue())[0]);
        }
        Map<ClaimMapping, String> authenticatedUserAttributes = FrameworkUtils.buildClaimMappings(claimsForContext);
        authenticatedUserAttributes.putAll(user.getUserAttributes());
        for (Map.Entry<Integer, StepConfig> entry : context.getSequenceConfig().getStepMap().entrySet()) {
            StepConfig stepConfig = entry.getValue();
            if (!stepConfig.isSubjectAttributeStep()) continue;
            if (stepConfig.getAuthenticatedUser() != null) {
                user = stepConfig.getAuthenticatedUser();
            }
            if (!user.isFederatedUser()) {
                persistClaims = true;
                break;
            }
            String subject = user.getAuthenticatedSubjectIdentifier();
            try {
                FederatedAssociationManager federatedAssociationManager = FrameworkUtils.getFederatedAssociationManager();
                String string = federatedAssociationManager.getUserForFederatedAssociation(context.getTenantDomain(), stepConfig.getAuthenticatedIdP(), subject);
                if (!StringUtils.isNotBlank((String)string)) break;
                String fullQualifiedAssociatedUserId = FrameworkUtils.prependUserStoreDomainToName(string + "@" + context.getTenantDomain());
                UserCoreUtil.setDomainInThreadLocal((String)UserCoreUtil.extractDomainFromName((String)string));
                user = AuthenticatedUser.createLocalAuthenticatedUserFromSubjectIdentifier(fullQualifiedAssociatedUserId);
                persistClaims = true;
                break;
            }
            catch (FrameworkException | FederatedAssociationManagerException e) {
                throw new PostAuthenticationFailedException("Error while handling missing mandatory claims", "Error while getting association for " + subject, (Throwable)e);
            }
        }
        if (persistClaims) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Local user mapping found. Claims will be persisted");
            }
            try {
                Map<String, String> map = context.getSequenceConfig().getApplicationConfig().getClaimMappings();
                HashMap hashMap = new HashMap();
                for (Map.Entry entry : claims.entrySet()) {
                    String localClaim = map.get(entry.getKey());
                    hashMap.put(localClaim, entry.getValue());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Updating user profile of user : " + user.getUserName()));
                }
                UserRealm realm = this.getUserRealm(user.getTenantDomain());
                UserStoreManager userStoreManager = realm.getUserStoreManager().getSecondaryUserStoreManager(user.getUserStoreDomain());
                userStoreManager.setUserClaimValues(user.getUserName(), hashMap, null);
            }
            catch (UserStoreException userStoreException) {
                throw new PostAuthenticationFailedException("Error while handling missing mandatory claims", "Error while updating claims for local user. Could not update profile", userStoreException);
            }
        }
        context.getSequenceConfig().getAuthenticatedUser().setUserAttributes(authenticatedUserAttributes);
    }

    private UserRealm getUserRealm(String tenantDomain) throws PostAuthenticationFailedException {
        UserRealm realm;
        try {
            realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)FrameworkServiceComponent.getRegistryService(), (RealmService)FrameworkServiceComponent.getRealmService(), (String)tenantDomain);
        }
        catch (CarbonException e) {
            throw new PostAuthenticationFailedException("Error while handling missing mandatory claims", "Error occurred while retrieving the Realm for " + tenantDomain + " to handle local claims", e);
        }
        return realm;
    }

    private AuthenticatedUser getAuthenticatedUser(AuthenticationContext authenticationContext) {
        AuthenticatedUser user = authenticationContext.getSequenceConfig().getAuthenticatedUser();
        return user;
    }
}

