/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.AbstractPostAuthnHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthnHandlerFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class PostAuthenticatedSubjectIdentifierHandler
extends AbstractPostAuthnHandler {
    private static final Log log = LogFactory.getLog(PostAuthenticatedSubjectIdentifierHandler.class);
    private static PostAuthenticatedSubjectIdentifierHandler instance = new PostAuthenticatedSubjectIdentifierHandler();

    protected PostAuthenticatedSubjectIdentifierHandler() {
    }

    public static PostAuthenticatedSubjectIdentifierHandler getInstance() {
        return instance;
    }

    public int getPriority() {
        int priority = super.getPriority();
        if (priority == -1) {
            priority = 30;
        }
        return priority;
    }

    public String getName() {
        return "PostAuthenticatedSubjectIdentifierHandler";
    }

    @Override
    public PostAuthnHandlerFlowStatus handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        if (!FrameworkUtils.isStepBasedSequenceHandlerExecuted(context)) {
            return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        String subjectClaimURI = sequenceConfig.getApplicationConfig().getSubjectClaimUri();
        String subjectValue = (String)context.getProperty("ServiceProviderSubjectClaimValue");
        if (StringUtils.isNotBlank((String)subjectClaimURI)) {
            if (subjectValue != null) {
                this.handleUserStoreAndTenantDomain(sequenceConfig, subjectValue);
            } else {
                log.warn((Object)"Subject claim could not be found. Defaulting to Name Identifier.");
                this.setAuthenticatedSujectIdentifierBasedOnUserName(sequenceConfig);
            }
        } else {
            this.setAuthenticatedSujectIdentifierBasedOnUserName(sequenceConfig);
        }
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }

    private void handleUserStoreAndTenantDomain(SequenceConfig sequenceConfig, String subjectValue) {
        sequenceConfig.getAuthenticatedUser().setAuthenticatedSubjectIdentifier(subjectValue);
        if (sequenceConfig.getApplicationConfig().isUseTenantDomainInLocalSubjectIdentifier()) {
            String tenantDomain = sequenceConfig.getAuthenticatedUser().getTenantDomain();
            subjectValue = UserCoreUtil.addTenantDomainToEntry((String)subjectValue, (String)tenantDomain);
            sequenceConfig.getAuthenticatedUser().setAuthenticatedSubjectIdentifier(subjectValue);
        }
        if (sequenceConfig.getApplicationConfig().isUseUserstoreDomainInLocalSubjectIdentifier()) {
            String userStoreDomain = sequenceConfig.getAuthenticatedUser().getUserStoreDomain();
            subjectValue = UserCoreUtil.addDomainToName((String)subjectValue, (String)userStoreDomain);
            sequenceConfig.getAuthenticatedUser().setAuthenticatedSubjectIdentifier(subjectValue);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authenticated User: " + sequenceConfig.getAuthenticatedUser().getAuthenticatedSubjectIdentifier()));
            log.debug((Object)("Authenticated User Tenant Domain: " + sequenceConfig.getAuthenticatedUser().getTenantDomain()));
        }
    }

    private void setAuthenticatedSujectIdentifierBasedOnUserName(SequenceConfig sequenceConfig) {
        String authenticatedUserName = sequenceConfig.getAuthenticatedUser().getUserName();
        boolean isUserstoreDomainInLocalSubjectIdentifier = sequenceConfig.getApplicationConfig().isUseUserstoreDomainInLocalSubjectIdentifier();
        boolean isUseTenantDomainInLocalSubjectIdentifier = sequenceConfig.getApplicationConfig().isUseTenantDomainInLocalSubjectIdentifier();
        if (StringUtils.isNotEmpty((String)authenticatedUserName)) {
            sequenceConfig.getAuthenticatedUser().setAuthenticatedSubjectIdentifier(sequenceConfig.getAuthenticatedUser().getUsernameAsSubjectIdentifier(isUserstoreDomainInLocalSubjectIdentifier, isUseTenantDomainInLocalSubjectIdentifier));
        }
    }
}

