/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.FederatedApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.PostAuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.AbstractPostAuthnHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthnHandlerFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.DefaultSequenceHandlerUtils;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkErrorConstants;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.exception.FederatedAssociationManagerException;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class PostAuthAssociationHandler
extends AbstractPostAuthnHandler {
    private static final Log log = LogFactory.getLog(PostAuthAssociationHandler.class);
    private static PostAuthAssociationHandler instance = new PostAuthAssociationHandler();
    private static final String USER_TENANT_DOMAIN = "user-tenant-domain";

    public static PostAuthAssociationHandler getInstance() {
        return instance;
    }

    protected PostAuthAssociationHandler() {
    }

    public int getPriority() {
        int priority = super.getPriority();
        if (priority == -1) {
            priority = 25;
        }
        return priority;
    }

    public String getName() {
        return "PostAuthAssociationHandler";
    }

    @Override
    public PostAuthnHandlerFlowStatus handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        if (!FrameworkUtils.isStepBasedSequenceHandlerExecuted(context)) {
            return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        for (Map.Entry<Integer, StepConfig> entry : sequenceConfig.getStepMap().entrySet()) {
            ApplicationAuthenticator authenticator;
            StepConfig stepConfig = entry.getValue();
            AuthenticatorConfig authenticatorConfig = stepConfig.getAuthenticatedAutenticator();
            if (authenticatorConfig == null || !((authenticator = authenticatorConfig.getApplicationAuthenticator()) instanceof FederatedApplicationAuthenticator) || !stepConfig.isSubjectIdentifierStep()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(authenticator.getName() + " has been set up for subject identifier step."));
            }
            String associatedLocalUserName = null;
            if (sequenceConfig.getApplicationConfig().isAlwaysSendMappedLocalSubjectId()) {
                associatedLocalUserName = this.getUserNameAssociatedWith(context, stepConfig);
            }
            if (!StringUtils.isNotEmpty(associatedLocalUserName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("AlwaysSendMappedLocalSubjectID is selected in service provider level, equavlent local user : " + associatedLocalUserName));
            }
            this.setAssociatedLocalUserToContext(associatedLocalUserName, context, stepConfig);
        }
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }

    private void setAssociatedLocalUserToContext(String associatedLocalUserName, AuthenticationContext context, StepConfig stepConfig) throws PostAuthenticationFailedException {
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        String fullQualifiedAssociatedUserId = FrameworkUtils.prependUserStoreDomainToName(associatedLocalUserName + "@" + context.getTenantDomain());
        UserCoreUtil.setDomainInThreadLocal((String)UserCoreUtil.extractDomainFromName((String)associatedLocalUserName));
        sequenceConfig.setAuthenticatedUser(AuthenticatedUser.createLocalAuthenticatedUserFromSubjectIdentifier(fullQualifiedAssociatedUserId));
        sequenceConfig.getApplicationConfig().setMappedSubjectIDSelected(true);
        Map<String, String> mappedAttrs = this.handleClaimMappings(stepConfig, context);
        this.handleRoleMapping(context, sequenceConfig, mappedAttrs);
        Map<ClaimMapping, String> authenticatedUserAttributes = this.getClaimMapping(context, mappedAttrs);
        if (MapUtils.isNotEmpty(authenticatedUserAttributes)) {
            sequenceConfig.getAuthenticatedUser().setUserAttributes(authenticatedUserAttributes);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Local claims from the local user: " + associatedLocalUserName + ", set as user attributed for the federated scenario"));
            }
        }
        String tenantDomain = MultitenantUtils.getTenantDomain((String)associatedLocalUserName);
        Map<String, Object> authProperties = context.getProperties();
        if (authProperties == null) {
            authProperties = new HashMap<String, Object>();
            context.setProperties(authProperties);
        }
        authProperties.put(USER_TENANT_DOMAIN, tenantDomain);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authenticated User: " + sequenceConfig.getAuthenticatedUser().getAuthenticatedSubjectIdentifier()));
            log.debug((Object)("Authenticated User Tenant Domain: " + tenantDomain));
        }
    }

    private String getUserNameAssociatedWith(AuthenticationContext context, StepConfig stepConfig) throws PostAuthenticationFailedException {
        String associatesUserName;
        String originalExternalIdpSubjectValueForThisStep = stepConfig.getAuthenticatedUser().getAuthenticatedSubjectIdentifier();
        try {
            FrameworkUtils.startTenantFlow(context.getTenantDomain());
            FederatedAssociationManager federatedAssociationManager = FrameworkUtils.getFederatedAssociationManager();
            associatesUserName = federatedAssociationManager.getUserForFederatedAssociation(context.getTenantDomain(), stepConfig.getAuthenticatedIdP(), originalExternalIdpSubjectValueForThisStep);
            if (StringUtils.isNotBlank((String)associatesUserName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User : " + (Object)((Object)stepConfig.getAuthenticatedUser()) + " has an associated account as " + associatesUserName + ". Hence continuing as " + associatesUserName));
                }
                stepConfig.getAuthenticatedUser().setUserName(associatesUserName);
                stepConfig.getAuthenticatedUser().setTenantDomain(context.getTenantDomain());
                stepConfig.setAuthenticatedUser(stepConfig.getAuthenticatedUser());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("User " + (Object)((Object)stepConfig.getAuthenticatedUser()) + " doesn't have an associated account. Hence continuing as the same user."));
            }
        }
        catch (FrameworkException | FederatedAssociationManagerException e) {
            throw new PostAuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_LOCAL_USER_ID.getCode(), String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_IDP_BY_NAME.getMessage(), originalExternalIdpSubjectValueForThisStep), (Throwable)e);
        }
        finally {
            FrameworkUtils.endTenantFlow();
        }
        return associatesUserName;
    }

    private Map<ClaimMapping, String> getClaimMapping(AuthenticationContext context, Map<String, String> mappedAttrs) {
        Map<ClaimMapping, String> mappedClaims = null;
        Map localClaimValues = (Map)context.getProperty("UNFILTERED_LOCAL_CLAIM_VALUES");
        Map idpClaimValues = (Map)context.getProperty("UNFILTERED_IDP_CLAIM_VALUES");
        if (context.getSequenceConfig().getApplicationConfig().getRequestedClaimMappings() == null || context.getSequenceConfig().getApplicationConfig().getRequestedClaimMappings().isEmpty()) {
            if (MapUtils.isNotEmpty((Map)localClaimValues)) {
                mappedAttrs = localClaimValues;
            } else if (MapUtils.isNotEmpty((Map)idpClaimValues)) {
                mappedAttrs = idpClaimValues;
            }
        }
        if (MapUtils.isNotEmpty((Map)mappedAttrs)) {
            mappedClaims = FrameworkUtils.buildClaimMappings(mappedAttrs);
        }
        return mappedClaims;
    }

    private void handleRoleMapping(AuthenticationContext context, SequenceConfig sequenceConfig, Map<String, String> mappedAttrs) throws PostAuthenticationFailedException {
        Object[] roles;
        String spRoleUri = DefaultSequenceHandlerUtils.getSpRoleClaimUri(sequenceConfig.getApplicationConfig());
        try {
            roles = DefaultSequenceHandlerUtils.getRolesFromSPMappedClaims(context, sequenceConfig, mappedAttrs, spRoleUri);
        }
        catch (FrameworkException e) {
            throw new PostAuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_HANDLING_CLAIM_MAPPINGS.getCode(), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_HANDLING_CLAIM_MAPPINGS.getMessage(), (Throwable)((Object)e));
        }
        if (!ArrayUtils.isEmpty((Object[])roles)) {
            String spMappedUserRoles = DefaultSequenceHandlerUtils.getServiceProviderMappedUserRoles(sequenceConfig, Arrays.asList(roles));
            mappedAttrs.put(spRoleUri, spMappedUserRoles);
        }
    }

    private Map<String, String> handleClaimMappings(StepConfig stepConfig, AuthenticationContext context) throws PostAuthenticationFailedException {
        try {
            Map<String, String> mappedAttrs = FrameworkUtils.getClaimHandler().handleClaimMappings(stepConfig, context, null, false);
            return mappedAttrs;
        }
        catch (FrameworkException e) {
            throw new PostAuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_CLAIM_MAPPINGS.getCode(), String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_CLAIM_MAPPINGS.getMessage(), context.getSequenceConfig().getAuthenticatedUser().getUserName()), (Throwable)((Object)e));
        }
    }
}

