/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.PIICategoryValidity;
import org.wso2.carbon.consent.mgt.core.model.ReceiptInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptPurposeInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptServiceInput;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.FederatedApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.PostAuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.AbstractPostAuthnHandler;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.PostAuthnHandlerFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkErrorConstants;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.exception.FederatedAssociationManagerException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class JITProvisioningPostAuthenticationHandler
extends AbstractPostAuthnHandler {
    private static final Log log = LogFactory.getLog(JITProvisioningPostAuthenticationHandler.class);
    private static volatile JITProvisioningPostAuthenticationHandler instance = new JITProvisioningPostAuthenticationHandler();

    public static JITProvisioningPostAuthenticationHandler getInstance() {
        return instance;
    }

    protected JITProvisioningPostAuthenticationHandler() {
    }

    public int getPriority() {
        int priority = super.getPriority();
        if (priority == -1) {
            priority = 20;
        }
        return priority;
    }

    public String getName() {
        return "JITProvisionHandler";
    }

    @Override
    public PostAuthnHandlerFlowStatus handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        Object isProvisionUIRedirectionTriggered;
        if (!FrameworkUtils.isStepBasedSequenceHandlerExecuted(context)) {
            return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
        }
        if (log.isDebugEnabled()) {
            AuthenticatedUser authenticatedUser = context.getSequenceConfig().getAuthenticatedUser();
            log.debug((Object)("Continuing with JIT flow for the user: " + (Object)((Object)authenticatedUser)));
        }
        if ((isProvisionUIRedirectionTriggered = context.getProperty("passwordProvisioningRedirectionTriggered")) != null && ((Boolean)isProvisionUIRedirectionTriggered).booleanValue()) {
            if (log.isDebugEnabled()) {
                AuthenticatedUser authenticatedUser = context.getSequenceConfig().getAuthenticatedUser();
                log.debug((Object)("The request  has hit the response flow of JIT provisioning flow for the user: " + (Object)((Object)authenticatedUser)));
            }
            return this.handleResponseFlow(request, context);
        }
        return this.handleRequestFlow(request, response, context);
    }

    private PostAuthnHandlerFlowStatus handleResponseFlow(HttpServletRequest request, AuthenticationContext context) throws PostAuthenticationFailedException {
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        for (Map.Entry<Integer, StepConfig> entry : sequenceConfig.getStepMap().entrySet()) {
            Object unfilteredLocalClaimValues;
            StepConfig stepConfig = entry.getValue();
            AuthenticatorConfig authenticatorConfig = stepConfig.getAuthenticatedAutenticator();
            ApplicationAuthenticator authenticator = authenticatorConfig.getApplicationAuthenticator();
            if (!(authenticator instanceof FederatedApplicationAuthenticator)) continue;
            String externalIdPConfigName = stepConfig.getAuthenticatedIdP();
            ExternalIdPConfig externalIdPConfig = this.getExternalIdpConfig(externalIdPConfigName, context);
            context.setExternalIdP(externalIdPConfig);
            if (externalIdPConfig == null || !externalIdPConfig.isProvisioningEnabled()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("JIT provisioning response flow has hit for the IDP " + externalIdPConfigName + " for the user, " + sequenceConfig.getAuthenticatedUser().getUserName()));
            }
            HashMap<String, String> localClaimValues = (unfilteredLocalClaimValues = context.getProperty("UNFILTERED_LOCAL_CLAIM_VALUES")) == null ? new HashMap() : (Map)unfilteredLocalClaimValues;
            Map<String, String> combinedLocalClaims = this.getCombinedClaims(request, localClaimValues, context);
            if (externalIdPConfig.isPasswordProvisioningEnabled()) {
                combinedLocalClaims.put("password", request.getParameter("password"));
            }
            String username = sequenceConfig.getAuthenticatedUser().getUserName();
            if (context.getProperty("changingUserNameAllowed") != null) {
                username = request.getParameter("username");
            }
            this.callDefaultProvisioningHandler(username, context, externalIdPConfig, combinedLocalClaims, stepConfig);
            this.handleConsents(request, stepConfig, context.getTenantDomain());
        }
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }

    private Map<String, String> getCombinedClaims(HttpServletRequest request, Map<String, String> localClaimValues, AuthenticationContext context) throws PostAuthenticationFailedException {
        String externalIdPConfigName = context.getExternalIdP().getIdPName();
        ClaimMapping[] claims = this.getClaimsForTenant(context.getTenantDomain(), externalIdPConfigName);
        HashMap<String, String> missingClaims = new HashMap<String, String>();
        if (claims != null) {
            for (ClaimMapping claimMapping : claims) {
                String uri = claimMapping.getClaim().getClaimUri();
                String claimValue = request.getParameter(uri);
                if (StringUtils.isNotBlank((String)claimValue) && StringUtils.isEmpty((String)localClaimValues.get(uri))) {
                    localClaimValues.put(uri, claimValue);
                    continue;
                }
                claimValue = request.getParameter("missing-" + uri);
                if (!StringUtils.isNotEmpty((String)claimValue)) continue;
                localClaimValues.put(uri, claimValue);
                missingClaims.put(uri, claimValue);
            }
        }
        if (MapUtils.isNotEmpty(missingClaims)) {
            AuthenticatedUser authenticatedUser = context.getSequenceConfig().getAuthenticatedUser();
            Map<org.wso2.carbon.identity.application.common.model.ClaimMapping, String> userAttributes = authenticatedUser.getUserAttributes();
            userAttributes.putAll(FrameworkUtils.buildClaimMappings(missingClaims));
            authenticatedUser.setUserAttributes(userAttributes);
            context.getSequenceConfig().setAuthenticatedUser(authenticatedUser);
        }
        return localClaimValues;
    }

    private PostAuthnHandlerFlowStatus handleRequestFlow(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws PostAuthenticationFailedException {
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        boolean isUserCreated = false;
        for (Map.Entry<Integer, StepConfig> entry : sequenceConfig.getStepMap().entrySet()) {
            ApplicationAuthenticator authenticator;
            StepConfig stepConfig = entry.getValue();
            AuthenticatorConfig authenticatorConfig = stepConfig.getAuthenticatedAutenticator();
            if (authenticatorConfig == null || !((authenticator = authenticatorConfig.getApplicationAuthenticator()) instanceof FederatedApplicationAuthenticator)) continue;
            String externalIdPConfigName = stepConfig.getAuthenticatedIdP();
            ExternalIdPConfig externalIdPConfig = this.getExternalIdpConfig(externalIdPConfigName, context);
            context.setExternalIdP(externalIdPConfig);
            Map<String, String> localClaimValues = (Map<String, String>)context.getProperty("UNFILTERED_LOCAL_CLAIM_VALUES");
            if (localClaimValues == null || localClaimValues.size() == 0) {
                Map<org.wso2.carbon.identity.application.common.model.ClaimMapping, String> userAttributes = stepConfig.getAuthenticatedUser().getUserAttributes();
                localClaimValues = FrameworkUtils.getClaimMappings(userAttributes, false);
            }
            if (externalIdPConfig == null || !externalIdPConfig.isProvisioningEnabled()) continue;
            if (localClaimValues == null) {
                localClaimValues = new HashMap<String, String>();
            }
            String associatedLocalUser = this.getLocalUserAssociatedForFederatedIdentifier(stepConfig.getAuthenticatedIdP(), stepConfig.getAuthenticatedUser().getAuthenticatedSubjectIdentifier(), context.getTenantDomain());
            String userIdClaimUriInLocalDialect = this.getUserIdClaimUriInLocalDialect(externalIdPConfig);
            String username = this.isUserNameFoundFromUserIDClaimURI(localClaimValues, userIdClaimUriInLocalDialect) ? localClaimValues.get(userIdClaimUriInLocalDialect) : associatedLocalUser;
            if (StringUtils.isEmpty((String)associatedLocalUser) && !isUserCreated) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sequenceConfig.getAuthenticatedUser().getUserName() + " coming from " + externalIdPConfig.getIdPName() + " do not have a local account, hence redirecting to the UI to sign up."));
                }
                if (externalIdPConfig.isPromptConsentEnabled()) {
                    if (StringUtils.isEmpty((String)username)) {
                        username = this.getTenantDomainAppendedUserName(sequenceConfig.getAuthenticatedUser().getUserName(), context.getTenantDomain());
                    }
                    this.redirectToAccountCreateUI(externalIdPConfig, context, localClaimValues, response, username, request);
                    context.setProperty("passwordProvisioningRedirectionTriggered", true);
                    return PostAuthnHandlerFlowStatus.INCOMPLETE;
                }
            }
            if (StringUtils.isEmpty((String)username)) {
                username = sequenceConfig.getAuthenticatedUser().getUserName();
                isUserCreated = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("User : " + sequenceConfig.getAuthenticatedUser().getUserName() + " coming from " + externalIdPConfig.getIdPName() + " do have a local account, with the username " + username));
            }
            this.callDefaultProvisioningHandler(username, context, externalIdPConfig, localClaimValues, stepConfig);
        }
        return PostAuthnHandlerFlowStatus.SUCCESS_COMPLETED;
    }

    private boolean isUserNameFoundFromUserIDClaimURI(Map<String, String> localClaimValues, String userIdClaimUriInLocalDialect) {
        return StringUtils.isNotBlank((String)userIdClaimUriInLocalDialect) && StringUtils.isNotBlank((String)localClaimValues.get(userIdClaimUriInLocalDialect));
    }

    private ReceiptInput buildConsentForResidentIDP(String piiPrincipalId, String consent, String policyURL) {
        ReceiptInput receiptInput = new ReceiptInput();
        receiptInput.setJurisdiction("USA");
        receiptInput.setCollectionMethod("Web Form - Just In Time Provisioning");
        receiptInput.setLanguage("en");
        receiptInput.setPiiPrincipalId(piiPrincipalId);
        receiptInput.setPolicyUrl(policyURL);
        JSONObject receipt = new JSONObject(consent);
        receiptInput.setServices(this.getReceiptServiceInputs(receipt));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Built consent from endpoint util : " + consent));
        }
        return receiptInput;
    }

    private List<ReceiptServiceInput> getReceiptServiceInputs(JSONObject receipt) {
        JSONArray services = receipt.getJSONArray("services");
        ArrayList<ReceiptServiceInput> receiptServiceInputs = new ArrayList<ReceiptServiceInput>();
        for (int serviceIndex = 0; serviceIndex < services.length(); ++serviceIndex) {
            JSONObject service = services.getJSONObject(serviceIndex);
            ReceiptServiceInput receiptServiceInput = new ReceiptServiceInput();
            JSONArray purposes = service.getJSONArray("purposes");
            ArrayList<ReceiptPurposeInput> receiptPurposeInputs = new ArrayList<ReceiptPurposeInput>();
            for (int purposeIndex = 0; purposeIndex < purposes.length(); ++purposeIndex) {
                receiptPurposeInputs.add(this.getReceiptPurposeInputs((JSONObject)purposes.get(purposeIndex)));
            }
            receiptServiceInput.setPurposes(receiptPurposeInputs);
            receiptServiceInputs.add(receiptServiceInput);
        }
        return receiptServiceInputs;
    }

    private ReceiptPurposeInput getReceiptPurposeInputs(JSONObject receiptPurpose) {
        ReceiptPurposeInput receiptPurposeInput = new ReceiptPurposeInput();
        receiptPurposeInput.setConsentType("EXPLICIT");
        receiptPurposeInput.setPrimaryPurpose(Boolean.valueOf(true));
        receiptPurposeInput.setThirdPartyDisclosure(Boolean.valueOf(false));
        receiptPurposeInput.setPurposeId(Integer.valueOf(receiptPurpose.getInt("purposeId")));
        JSONArray purposeCategoryId = receiptPurpose.getJSONArray("purposeCategoryId");
        ArrayList<Integer> purposeCategoryIdArray = new ArrayList<Integer>();
        for (int index = 0; index < purposeCategoryId.length(); ++index) {
            purposeCategoryIdArray.add(purposeCategoryId.getInt(index));
        }
        receiptPurposeInput.setTermination("DATE_UNTIL:INDEFINITE");
        receiptPurposeInput.setPurposeCategoryId(purposeCategoryIdArray);
        receiptPurposeInput.setTermination("DATE_UNTIL:INDEFINITE");
        ArrayList<PIICategoryValidity> piiCategoryValidities = new ArrayList<PIICategoryValidity>();
        JSONArray piiCategories = (JSONArray)receiptPurpose.get("piiCategory");
        for (int categoryIndex = 0; categoryIndex < piiCategories.length(); ++categoryIndex) {
            JSONObject piiCategory = (JSONObject)piiCategories.get(categoryIndex);
            PIICategoryValidity piiCategoryValidity = new PIICategoryValidity(Integer.valueOf(piiCategory.getInt("piiCategoryId")), "DATE_UNTIL:INDEFINITE");
            piiCategoryValidities.add(piiCategoryValidity);
        }
        receiptPurposeInput.setPiiCategory(piiCategoryValidities);
        return receiptPurposeInput;
    }

    private String getTenantDomainAppendedUserName(String userName, String tenantDomain) {
        if (!userName.endsWith("@" + tenantDomain)) {
            userName = MultitenantUtils.getTenantAwareUsername((String)userName);
            if (!"carbon.super".equalsIgnoreCase(tenantDomain)) {
                userName = UserCoreUtil.addTenantDomainToEntry((String)userName, (String)tenantDomain);
            }
        }
        return userName;
    }

    private String getLocalUserAssociatedForFederatedIdentifier(String idpName, String authenticatedSubjectIdentifier, String tenantDomain) throws PostAuthenticationFailedException {
        String username = null;
        try {
            FederatedAssociationManager federatedAssociationManager = FrameworkUtils.getFederatedAssociationManager();
            username = federatedAssociationManager.getUserForFederatedAssociation(tenantDomain, idpName, authenticatedSubjectIdentifier);
        }
        catch (FrameworkException | FederatedAssociationManagerException e) {
            this.handleExceptions(String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_USERNAME_ASSOCIATED_WITH_IDP.getMessage(), idpName), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_USERNAME_ASSOCIATED_WITH_IDP.getCode(), (Exception)e);
        }
        return username;
    }

    private void handleExceptions(String errorMessage, String errorCode, Exception e) throws PostAuthenticationFailedException {
        throw new PostAuthenticationFailedException(errorCode, errorMessage, e);
    }

    private void redirectToAccountCreateUI(ExternalIdPConfig externalIdPConfig, AuthenticationContext context, Map<String, String> localClaimValues, HttpServletResponse response, String username, HttpServletRequest request) throws PostAuthenticationFailedException {
        try {
            ServiceURLBuilder uriBuilder = ServiceURLBuilder.create();
            if (externalIdPConfig.isModifyUserNameAllowed()) {
                context.setProperty("changingUserNameAllowed", true);
                uriBuilder = uriBuilder.addPath(new String[]{FrameworkUtils.getUserNameProvisioningUIUrl()});
                uriBuilder.addParameter("allowchangeusername", String.valueOf(true));
                if (log.isDebugEnabled()) {
                    log.debug((Object)(externalIdPConfig.getName() + " allow to change the username, redirecting to registration endpoint to provision the user: " + username));
                }
            } else {
                uriBuilder = uriBuilder.addPath(new String[]{FrameworkUtils.getPasswordProvisioningUIUrl()});
                if (log.isDebugEnabled() && externalIdPConfig.isPasswordProvisioningEnabled()) {
                    log.debug((Object)(externalIdPConfig.getName() + " supports password provisioning, redirecting to sign up endpoint to provision the user : " + username));
                }
            }
            if (externalIdPConfig.isPasswordProvisioningEnabled()) {
                uriBuilder.addParameter("passwordProvisionEnabled", String.valueOf(true));
            }
            if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
                uriBuilder.addParameter("TenantDomain", context.getTenantDomain());
            }
            uriBuilder.addParameter("serviceProvider", context.getSequenceConfig().getApplicationConfig().getApplicationName());
            uriBuilder.addParameter("username", username);
            uriBuilder.addParameter("skipsignupenablecheck", String.valueOf(true));
            uriBuilder.addParameter("sessionDataKey", context.getContextIdentifier());
            this.addMissingClaims(uriBuilder, context);
            localClaimValues.forEach((arg_0, arg_1) -> ((ServiceURLBuilder)uriBuilder).addParameter(arg_0, arg_1));
            response.sendRedirect(uriBuilder.build().getRelativePublicURL());
        }
        catch (IOException | URLBuilderException e) {
            this.handleExceptions(String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_TRYING_CALL_SIGN_UP_ENDPOINT_FOR_PASSWORD_PROVISIONING.getMessage(), username, externalIdPConfig.getName()), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_TRYING_CALL_SIGN_UP_ENDPOINT_FOR_PASSWORD_PROVISIONING.getCode(), (Exception)e);
        }
    }

    private void addMissingClaims(ServiceURLBuilder uriBuilder, AuthenticationContext context) {
        String[] missingClaims = FrameworkUtils.getMissingClaims(context);
        if (StringUtils.isNotEmpty((String)missingClaims[1])) {
            if (log.isDebugEnabled()) {
                String username = context.getSequenceConfig().getAuthenticatedUser().getAuthenticatedSubjectIdentifier();
                String idPName = context.getExternalIdP().getIdPName();
                log.debug((Object)("Mandatory claims for SP, " + missingClaims[1] + " is missing for the user : " + username + " from the IDP " + idPName));
            }
            uriBuilder.addParameter("missingClaims", missingClaims[1]);
            uriBuilder.addParameter("missingClaimsDisplayName", missingClaims[0]);
        }
    }

    private ExternalIdPConfig getExternalIdpConfig(String externalIdPConfigName, AuthenticationContext context) throws PostAuthenticationFailedException {
        ExternalIdPConfig externalIdPConfig = null;
        try {
            externalIdPConfig = ConfigurationFacade.getInstance().getIdPConfigByName(externalIdPConfigName, context.getTenantDomain());
        }
        catch (IdentityProviderManagementException e) {
            this.handleExceptions(String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_IDP_BY_NAME.getMessage(), externalIdPConfigName, context.getTenantDomain()), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_IDP_BY_NAME.getCode(), (Exception)((Object)e));
        }
        return externalIdPConfig;
    }

    private ClaimMapping[] getClaimsForTenant(String tenantDomain, String externalIdPConfigName) throws PostAuthenticationFailedException {
        RealmService realmService = FrameworkServiceComponent.getRealmService();
        UserRealm realm = null;
        try {
            int usersTenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            realm = (UserRealm)realmService.getTenantUserRealm(usersTenantId);
        }
        catch (UserStoreException e) {
            this.handleExceptions(String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_REALM_IN_POST_AUTHENTICATION.getMessage(), tenantDomain), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_GETTING_REALM_IN_POST_AUTHENTICATION.getCode(), (Exception)((Object)e));
        }
        ClaimMapping[] claimMappings = null;
        try {
            ClaimManager claimManager;
            if (realm != null && (claimManager = realm.getClaimManager()) != null) {
                claimMappings = claimManager.getAllClaimMappings();
            }
        }
        catch (UserStoreException e) {
            this.handleExceptions(String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_TRYING_TO_GET_CLAIMS_WHILE_TRYING_TO_PASSWORD_PROVISION.getMessage(), externalIdPConfigName), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_TRYING_TO_GET_CLAIMS_WHILE_TRYING_TO_PASSWORD_PROVISION.getCode(), (Exception)((Object)e));
        }
        if (log.isDebugEnabled() && !ArrayUtils.isEmpty(claimMappings)) {
            StringBuilder claimMappingString = new StringBuilder();
            for (ClaimMapping claimMapping : claimMappings) {
                claimMappingString.append(claimMapping.getClaim().getClaimUri()).append(" ");
            }
            log.debug((Object)("Claims in tenant " + tenantDomain + " : " + claimMappingString.toString()));
        }
        return claimMappings;
    }

    private void callDefaultProvisioningHandler(String username, AuthenticationContext context, ExternalIdPConfig externalIdPConfig, Map<String, String> localClaimValues, StepConfig stepConfig) throws PostAuthenticationFailedException {
        boolean useDefaultIdpDialect = externalIdPConfig.useDefaultLocalIdpDialect();
        ApplicationAuthenticator authenticator = stepConfig.getAuthenticatedAutenticator().getApplicationAuthenticator();
        String idPStandardDialect = authenticator.getClaimDialectURI();
        String idpRoleClaimUri = FrameworkUtils.getIdpRoleClaimUri(externalIdPConfig);
        Map<org.wso2.carbon.identity.application.common.model.ClaimMapping, String> extAttrs = stepConfig.getAuthenticatedUser().getUserAttributes();
        Map<String, String> originalExternalAttributeValueMap = FrameworkUtils.getClaimMappings(extAttrs, false);
        Map claimMapping = null;
        if (useDefaultIdpDialect && StringUtils.isNotBlank((String)idPStandardDialect)) {
            try {
                claimMapping = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(idPStandardDialect, originalExternalAttributeValueMap.keySet(), context.getTenantDomain(), true);
            }
            catch (ClaimMetadataException e) {
                throw new PostAuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_HANDLING_CLAIM_MAPPINGS.getCode(), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_HANDLING_CLAIM_MAPPINGS.getMessage(), e);
            }
        }
        if (claimMapping != null) {
            idpRoleClaimUri = (String)claimMapping.get("http://wso2.org/claims/role");
        } else if (idPStandardDialect == null && !useDefaultIdpDialect) {
            idpRoleClaimUri = FrameworkUtils.getIdpRoleClaimUri(externalIdPConfig);
        }
        List<String> identityProviderMappedUserRolesUnmappedExclusive = FrameworkUtils.getIdentityProvideMappedUserRoles(externalIdPConfig, originalExternalAttributeValueMap, idpRoleClaimUri, true);
        localClaimValues.put("associatedID", stepConfig.getAuthenticatedUser().getAuthenticatedSubjectIdentifier());
        localClaimValues.put("idpId", stepConfig.getAuthenticatedIdP());
        localClaimValues.remove(FrameworkUtils.getLocalClaimUriMappedForIdPRoleClaim(externalIdPConfig));
        try {
            FrameworkUtils.getStepBasedSequenceHandler().callJitProvisioning(username, context, identityProviderMappedUserRolesUnmappedExclusive, localClaimValues);
        }
        catch (FrameworkException e) {
            this.handleExceptions(String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_TRYING_TO_PROVISION_USER_WITHOUT_PASSWORD_PROVISIONING.getMessage(), username, externalIdPConfig.getName()), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_TRYING_TO_PROVISION_USER_WITHOUT_PASSWORD_PROVISIONING.getCode(), (Exception)((Object)e));
        }
    }

    private void handleConsents(HttpServletRequest request, StepConfig stepConfig, String tenantDomain) throws PostAuthenticationFailedException {
        String userName = this.getLocalUserAssociatedForFederatedIdentifier(stepConfig.getAuthenticatedIdP(), stepConfig.getAuthenticatedUser().getAuthenticatedSubjectIdentifier(), tenantDomain);
        String consent = request.getParameter("consent");
        String policyURL = request.getParameter("policy");
        if (StringUtils.isNotEmpty((String)consent)) {
            ReceiptInput receiptInput = this.buildConsentForResidentIDP(userName, consent, policyURL);
            this.addConsent(receiptInput, tenantDomain);
        }
    }

    private void addConsent(ReceiptInput receiptInput, String tenantDomain) throws PostAuthenticationFailedException {
        ConsentManager consentManager = FrameworkServiceDataHolder.getInstance().getConsentManager();
        if (receiptInput.getServices().size() == 0) {
            throw new PostAuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_ADDING_CONSENT.getCode(), String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_ADDING_CONSENT.getMessage(), tenantDomain));
        }
        ReceiptServiceInput receiptServiceInput = (ReceiptServiceInput)receiptInput.getServices().get(0);
        receiptServiceInput.setTenantDomain(tenantDomain);
        try {
            this.setIDPData(tenantDomain, receiptServiceInput);
            receiptInput.setTenantDomain(tenantDomain);
            consentManager.addConsent(receiptInput);
        }
        catch (ConsentManagementException e) {
            this.handleExceptions(String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_ADDING_CONSENT.getMessage(), tenantDomain), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_ADDING_CONSENT.getCode(), (Exception)((Object)e));
        }
    }

    private void setIDPData(String tenantDomain, ReceiptServiceInput receiptServiceInput) throws PostAuthenticationFailedException {
        String resideIdpDescription = "Resident IDP";
        IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
        IdentityProvider residentIdP = null;
        try {
            residentIdP = idpManager.getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            this.handleExceptions(String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_SETTING_IDP_DATA.getMessage(), tenantDomain), FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_SETTING_IDP_DATA.getCode(), (Exception)((Object)e));
        }
        if (residentIdP == null) {
            throw new PostAuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_SETTING_IDP_DATA_IDP_IS_NULL.getCode(), String.format(FrameworkErrorConstants.ErrorMessages.ERROR_WHILE_SETTING_IDP_DATA_IDP_IS_NULL.getMessage(), tenantDomain));
        }
        if (StringUtils.isEmpty((String)receiptServiceInput.getService())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No service name found. Hence adding resident IDP home realm ID");
            }
            receiptServiceInput.setService(residentIdP.getHomeRealmId());
        }
        if (StringUtils.isEmpty((String)receiptServiceInput.getTenantDomain())) {
            receiptServiceInput.setTenantDomain(tenantDomain);
        }
        if (StringUtils.isEmpty((String)receiptServiceInput.getSpDescription())) {
            if (StringUtils.isNotEmpty((String)residentIdP.getIdentityProviderDescription())) {
                receiptServiceInput.setSpDescription(residentIdP.getIdentityProviderDescription());
            } else {
                receiptServiceInput.setSpDescription(resideIdpDescription);
            }
        }
        if (StringUtils.isEmpty((String)receiptServiceInput.getSpDisplayName())) {
            if (StringUtils.isNotEmpty((String)residentIdP.getDisplayName())) {
                receiptServiceInput.setSpDisplayName(residentIdP.getDisplayName());
            } else {
                receiptServiceInput.setSpDisplayName(resideIdpDescription);
            }
        }
    }

    private String getUserIdClaimUriInLocalDialect(ExternalIdPConfig idPConfig) {
        String userIdClaimUri = idPConfig.getUserIdClaimUri();
        if (StringUtils.isBlank((String)userIdClaimUri)) {
            return null;
        }
        boolean useDefaultLocalIdpDialect = idPConfig.useDefaultLocalIdpDialect();
        if (useDefaultLocalIdpDialect) {
            return userIdClaimUri;
        }
        Object[] claimMappings = idPConfig.getClaimMappings();
        if (!ArrayUtils.isEmpty((Object[])claimMappings)) {
            for (Object claimMapping : claimMappings) {
                if (!userIdClaimUri.equals(claimMapping.getRemoteClaim().getClaimUri())) continue;
                return claimMapping.getLocalClaim().getClaimUri();
            }
        }
        return null;
    }
}

