/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationFlowHandler;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.context.TransientObjectWrapper;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.JsFailureException;
import org.wso2.carbon.identity.application.authentication.framework.exception.MisconfigurationException;
import org.wso2.carbon.identity.application.authentication.framework.exception.PostAuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.RequestCoordinator;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.AbstractRequestCoordinator;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.CommonAuthResponseWrapper;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authentication.framework.util.LoginContextManagementUtil;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;

public class DefaultRequestCoordinator
extends AbstractRequestCoordinator
implements RequestCoordinator {
    private static final Log log = LogFactory.getLog(DefaultRequestCoordinator.class);
    private static final String USER_TENANT_DOMAIN = "user-tenant-domain";
    private static volatile DefaultRequestCoordinator instance;
    private static final String ACR_VALUES_ATTRIBUTE = "acr_values";
    private static final String REQUESTED_ATTRIBUTES = "requested_attributes";
    private static final String SERVICE_PROVIDER_QUERY_KEY = "serviceProvider";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultRequestCoordinator getInstance() {
        if (instance != null) return instance;
        Class<DefaultRequestCoordinator> clazz = DefaultRequestCoordinator.class;
        synchronized (DefaultRequestCoordinator.class) {
            if (instance != null) return instance;
            instance = new DefaultRequestCoordinator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AuthenticationRequestCacheEntry getAuthenticationRequestFromRequest(HttpServletRequest request) {
        return (AuthenticationRequestCacheEntry)((Object)request.getAttribute("authRequest"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CommonAuthResponseWrapper responseWrapper = null;
        if (response instanceof CommonAuthResponseWrapper) {
            responseWrapper = (CommonAuthResponseWrapper)response;
        } else {
            responseWrapper = new CommonAuthResponseWrapper(response);
            responseWrapper.setWrappedByFramework(true);
        }
        AuthenticationContext context = null;
        String sessionDataKey = request.getParameter("sessionDataKey");
        try {
            boolean returning;
            AuthenticationRequestCacheEntry authRequest;
            block47: {
                block44: {
                    block46: {
                        block45: {
                            authRequest = null;
                            returning = false;
                            if (request.getParameter("type") == null) break block44;
                            if (sessionDataKey == null) break block45;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Retrieving authentication request from cache for the sessionDataKey: " + sessionDataKey));
                            }
                            if ((authRequest = this.getAuthenticationRequest(request, sessionDataKey)) == null) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("No authentication request found in the cache for sessionDataKey: " + sessionDataKey));
                                }
                                if (!this.isCommonAuthLogoutRequest(request)) throw new FrameworkException("Invalid authentication request with sessionDataKey: " + sessionDataKey);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Ignoring the invalid sessionDataKey: " + sessionDataKey + " in the CommonAuthLogout request."));
                                }
                            }
                            break block46;
                        }
                        if (!this.isCommonAuthLogoutRequest(request)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Session data key is null in the request and not a logout request.");
                            }
                            FrameworkUtils.sendToRetryPage(request, response);
                        }
                    }
                    if (authRequest != null) {
                        request = FrameworkUtils.getCommonAuthReqWithParams(request, authRequest);
                        FrameworkUtils.removeAuthenticationRequestFromCache(sessionDataKey);
                    }
                    context = this.initializeFlow(request, (HttpServletResponse)responseWrapper);
                    context.initializeAnalyticsData();
                    break block47;
                }
                returning = true;
                context = FrameworkUtils.getContextData(request);
                this.associateTransientRequestData(request, (HttpServletResponse)responseWrapper, context);
            }
            if (context != null) {
                StepConfig stepConfig;
                boolean isIDFAuthenticatorInCurrentStep;
                if (StringUtils.isNotBlank((String)context.getServiceProviderName())) {
                    MDC.put((String)SERVICE_PROVIDER_QUERY_KEY, (String)context.getServiceProviderName());
                }
                AuthenticationContext authenticationContext = context;
                // MONITORENTER : authenticationContext
                if (!context.isActiveInAThread()) {
                    context.setActiveInAThread(true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Context id: " + context.getContextIdentifier() + " is active in the thread with id: " + Thread.currentThread().getId()));
                    }
                } else {
                    log.error((Object)"Same context is currently in used by a different thread. Possible double submit.");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Same context is currently in used by a different thread. Possible double submit.\nContext id: " + context.getContextIdentifier() + "\nOriginating address: " + request.getRemoteAddr() + "\nRequest Headers: " + this.getHeaderString(request) + "\nThread Id: " + Thread.currentThread().getId()));
                    }
                    FrameworkUtils.sendToRetryPage(request, (HttpServletResponse)responseWrapper);
                    // MONITOREXIT : authenticationContext
                    return;
                }
                // MONITOREXIT : authenticationContext
                if (this.isIdentifierFirstRequest(request) && !(isIDFAuthenticatorInCurrentStep = this.isIDFAuthenticatorFoundInStep(stepConfig = context.getSequenceConfig().getStepMap().get(context.getCurrentStep())))) {
                    this.handleIdentifierRequestInPreviousSteps(context);
                }
                this.setSPAttributeToRequest(request, context);
                context.setReturning(returning);
                if (!context.isReturning() && authRequest != null) {
                    context.setAuthenticationRequest(authRequest.getAuthenticationRequest());
                }
                if (!context.isLogoutRequest()) {
                    FrameworkUtils.getAuthenticationRequestHandler().handle(request, (HttpServletResponse)responseWrapper, context);
                    return;
                }
                FrameworkUtils.getLogoutRequestHandler().handle(request, (HttpServletResponse)responseWrapper, context);
                return;
            }
            if (log.isDebugEnabled()) {
                String key = request.getParameter("sessionDataKey");
                if (key == null) {
                    log.debug((Object)"Session data key is null in the request");
                } else {
                    log.debug((Object)("Session data key  :  " + key));
                }
            }
            String userAgent = request.getHeader("User-Agent");
            String referer = request.getHeader("Referer");
            String message = "Requested client: " + request.getRemoteAddr() + ", URI :" + request.getMethod() + ":" + request.getRequestURI() + ", User-Agent: " + userAgent + " , Referer: " + referer;
            log.error((Object)("Context does not exist. Probably due to invalidated cache. " + message));
            FrameworkUtils.sendToRetryPage(request, (HttpServletResponse)responseWrapper);
            return;
        }
        catch (JsFailureException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Script initiated Exception occured.", (Throwable)((Object)e));
            }
            this.publishAuthenticationFailure(request, context, context.getSequenceConfig().getAuthenticatedUser(), e.getErrorCode());
            if (!log.isDebugEnabled()) return;
            log.debug((Object)"User will be redirected to retry page or the error page provided by script.");
            return;
        }
        catch (MisconfigurationException e) {
            FrameworkUtils.sendToRetryPage(request, (HttpServletResponse)responseWrapper, "misconfiguration.error", "something.went.wrong.contact.admin");
            return;
        }
        catch (PostAuthenticationFailedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while evaluating post authentication", (Throwable)((Object)e));
            }
            FrameworkUtils.removeCookie(request, (HttpServletResponse)responseWrapper, FrameworkUtils.getPASTRCookieName(context.getContextIdentifier()));
            this.publishAuthenticationFailure(request, context, context.getSequenceConfig().getAuthenticatedUser(), e.getErrorCode());
            FrameworkUtils.sendToRetryPage(request, (HttpServletResponse)responseWrapper, "Authentication attempt failed.", e.getErrorCode());
            return;
        }
        catch (Throwable e) {
            log.error((Object)"Exception in Authentication Framework", e);
            if (e instanceof FrameworkException && "sessionNonceErrorCode".equals(((FrameworkException)((Object)e)).getErrorCode())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getMessage(), e);
                }
                FrameworkUtils.sendToRetryPage(request, response, "suspicious.authentication.attempts", "suspicious.authentication.attempts.description");
                return;
            }
            FrameworkUtils.sendToRetryPage(request, (HttpServletResponse)responseWrapper);
            return;
        }
        finally {
            if (context != null) {
                context.setActiveInAThread(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Context id: " + context.getContextIdentifier() + " left the thread with id: " + Thread.currentThread().getId()));
                }
                if (!LoginContextManagementUtil.isPostAuthenticationExtensionCompleted(context) || context.isLogoutRequest()) {
                    FrameworkUtils.addAuthenticationContextToCache(context.getContextIdentifier(), context);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Context with id: " + context.getContextIdentifier() + " added to the cache."));
                    }
                }
            }
            this.unwrapResponse(responseWrapper, sessionDataKey, response, context);
        }
    }

    protected void unwrapResponse(CommonAuthResponseWrapper responseWrapper, String sessionDataKey, HttpServletResponse response, AuthenticationContext context) throws IOException {
        if (responseWrapper.isRedirect()) {
            String redirectURL;
            if (context != null) {
                redirectURL = FrameworkUtils.getRedirectURLWithFilteredParams(responseWrapper.getRedirectURL(), context);
            } else {
                log.warn((Object)("Authentication context is null, redirect parameter filtering will not be done for " + sessionDataKey));
                redirectURL = responseWrapper.getRedirectURL();
            }
            if (responseWrapper.isWrappedByFramework()) {
                response.sendRedirect(redirectURL);
            } else {
                responseWrapper.sendRedirect(redirectURL);
            }
        } else if (responseWrapper.isWrappedByFramework()) {
            responseWrapper.write();
        }
    }

    private void handleIdentifierRequestInPreviousSteps(AuthenticationContext context) {
        boolean isIDFAuthenticatorFound = false;
        int currentStep = context.getCurrentStep();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Started to handle the IDF request as previous steps since the current steps cannot handle the IDF request");
        }
        while (currentStep > 1 && !isIDFAuthenticatorFound) {
            isIDFAuthenticatorFound = this.isIDFAuthenticatorFoundInStep(context.getSequenceConfig().getStepMap().get(--currentStep));
        }
        if (isIDFAuthenticatorFound) {
            context.setCurrentStep(currentStep);
            context.setProperty("BACK_TO_PREVIOUS_STEP", true);
            context.getCurrentAuthenticatedIdPs().clear();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"IDF requests cannot handle in any of the previous steps.");
        }
    }

    private boolean isIDFAuthenticatorFoundInStep(StepConfig stepConfig) {
        boolean isIDFAuthenticatorInCurrentStep = false;
        if (stepConfig != null) {
            List<AuthenticatorConfig> authenticatorList = stepConfig.getAuthenticatorList();
            for (AuthenticatorConfig config : authenticatorList) {
                if (!(config.getApplicationAuthenticator() instanceof AuthenticationFlowHandler)) continue;
                isIDFAuthenticatorInCurrentStep = true;
            }
        }
        return isIDFAuthenticatorInCurrentStep;
    }

    private boolean isIdentifierFirstRequest(HttpServletRequest request) {
        String authType = request.getParameter("authType");
        return "idf".equals(authType) || request.getParameter("identifier_consent") != null;
    }

    private String getHeaderString(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        StringBuilder stringBuilder = new StringBuilder();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            stringBuilder.append("Header Name: ").append(headerName).append(", ").append("Value: ").append(request.getHeader(headerName)).append(". ");
        }
        return stringBuilder.toString();
    }

    private void associateTransientRequestData(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        if (context == null) {
            return;
        }
        context.setProperty("HttpServletRequest", new TransientObjectWrapper<HttpServletRequest>(request));
        context.setProperty("HttpServletResponse", new TransientObjectWrapper<HttpServletResponse>(response));
    }

    private boolean isCommonAuthLogoutRequest(HttpServletRequest request) {
        return Boolean.parseBoolean(request.getParameter("commonAuthLogout"));
    }

    private AuthenticationRequestCacheEntry getAuthenticationRequest(HttpServletRequest request, String sessionDataKey) {
        AuthenticationRequestCacheEntry authRequest = this.getAuthenticationRequestFromRequest(request);
        if (authRequest == null) {
            authRequest = FrameworkUtils.getAuthenticationRequestFromCache(sessionDataKey);
        }
        return authRequest;
    }

    protected AuthenticationContext initializeFlow(HttpServletRequest request, HttpServletResponse response) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the flow");
        }
        String callerSessionDataKey = request.getParameter("sessionDataKey");
        String callerPath = this.getCallerPath(request);
        String requestType = request.getParameter("type");
        String relyingParty = request.getParameter("relyingParty");
        String tenantDomain = this.getTenantDomain(request);
        AuthenticationContext context = new AuthenticationContext();
        context.setCallerSessionKey(callerSessionDataKey);
        context.setCallerPath(callerPath);
        context.setRequestType(requestType);
        context.setRelyingParty(relyingParty);
        context.setTenantDomain(tenantDomain);
        String contextId = UUIDGenerator.generateUUID();
        context.setContextIdentifier(contextId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Framework contextId: " + contextId));
        }
        if (request.getParameter("commonAuthLogout") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting a logout flow");
            }
            context.setLogoutRequest(true);
            if (context.getRelyingParty() == null || context.getRelyingParty().trim().length() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"relyingParty param is null. This is a possible logout scenario.");
                }
                Cookie cookie = FrameworkUtils.getAuthCookie(request);
                String sessionContextKey = null;
                sessionContextKey = cookie != null ? DigestUtils.sha256Hex((String)cookie.getValue()) : request.getParameter("sessionId");
                context.setSessionIdentifier(sessionContextKey);
                return context;
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Starting an authentication flow");
        }
        List requestedClaimsInRequest = (List)request.getAttribute(REQUESTED_ATTRIBUTES);
        context.setProperty("SP_REQUESTED_CLAIMS_IN_REQUEST", requestedClaimsInRequest);
        this.associateTransientRequestData(request, response, context);
        this.findPreviousAuthenticatedSession(request, context);
        this.buildOutboundQueryString(request, context);
        return context;
    }

    private List<String> getAcrRequested(HttpServletRequest request) {
        List<String> acrValuesList = (List<String>)request.getAttribute(ACR_VALUES_ATTRIBUTE);
        if (acrValuesList == null) {
            acrValuesList = Collections.emptyList();
        }
        return acrValuesList;
    }

    private String getCallerPath(HttpServletRequest request) throws FrameworkException {
        String callerPath = request.getParameter("commonAuthCallerPath");
        try {
            if (callerPath != null) {
                callerPath = URLDecoder.decode(callerPath, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new FrameworkException(e.getMessage(), e);
        }
        return callerPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTenantDomain(HttpServletRequest request) throws FrameworkException {
        String tenantId;
        String tenantDomain = this.getTenantDomainFromContext();
        if (StringUtils.isNotBlank((String)tenantDomain)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant domain resolved from the thread local context: " + tenantDomain));
            }
        } else {
            tenantDomain = request.getParameter("tenantDomain");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant domain resolved from request parameter: " + tenantDomain));
            }
        }
        if (tenantDomain != null && !tenantDomain.isEmpty()) {
            if (!"null".equals(tenantDomain)) return tenantDomain;
        }
        if ((tenantId = request.getParameter("tenantId")) == null) return "carbon.super";
        if ("-1234".equals(tenantId)) return "carbon.super";
        try {
            Tenant tenant = FrameworkServiceComponent.getRealmService().getTenantManager().getTenant(Integer.parseInt(tenantId));
            if (tenant == null) return tenantDomain;
            return tenant.getDomain();
        }
        catch (Exception e) {
            throw new FrameworkException(e.getMessage(), e);
        }
    }

    private String getTenantDomainFromContext() {
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
            return IdentityTenantUtil.getTenantDomainFromContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findPreviousAuthenticatedSession(HttpServletRequest request, AuthenticationContext context) throws FrameworkException {
        Cookie cookie;
        List<String> acrRequested = this.getAcrRequested(request);
        if (acrRequested != null) {
            for (String string : acrRequested) {
                context.addRequestedAcr(string);
            }
        }
        SequenceConfig effectiveSequence = this.getSequenceConfig(context, request.getParameterMap());
        if (acrRequested != null) {
            for (String acr : acrRequested) {
                effectiveSequence.addRequestedAcr(acr);
            }
        }
        if ((cookie = FrameworkUtils.getAuthCookie(request)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("commonAuthId cookie is available with the value: " + cookie.getValue()));
            }
            String sessionContextKey = DigestUtils.sha256Hex((String)cookie.getValue());
            SessionContext sessionContext = null;
            try {
                FrameworkUtils.startTenantFlow(context.getTenantDomain());
                sessionContext = FrameworkUtils.getSessionContextFromCache(request, context, sessionContextKey);
            }
            finally {
                FrameworkUtils.endTenantFlow();
            }
            if (sessionContext != null) {
                SequenceConfig previousAuthenticatedSeq;
                context.setSessionIdentifier(sessionContextKey);
                String appName = effectiveSequence.getApplicationConfig().getApplicationName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Service Provider is: " + appName));
                }
                if ((previousAuthenticatedSeq = sessionContext.getAuthenticatedSequences().get(appName)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A previously authenticated sequence found for the SP: " + appName));
                    }
                    context.setPreviousSessionFound(true);
                    effectiveSequence.setStepMap(new HashMap<Integer, StepConfig>(previousAuthenticatedSeq.getStepMap()));
                    effectiveSequence.setReqPathAuthenticators(new ArrayList<AuthenticatorConfig>(previousAuthenticatedSeq.getReqPathAuthenticators()));
                    effectiveSequence.setAuthenticatedUser(previousAuthenticatedSeq.getAuthenticatedUser());
                    effectiveSequence.setAuthenticatedIdPs(previousAuthenticatedSeq.getAuthenticatedIdPs());
                    effectiveSequence.setAuthenticatedReqPathAuthenticator(previousAuthenticatedSeq.getAuthenticatedReqPathAuthenticator());
                    AuthenticatedUser authenticatedUser = previousAuthenticatedSeq.getAuthenticatedUser();
                    if (authenticatedUser != null) {
                        if (this.isUserAllowedToLogin(authenticatedUser)) {
                            String authenticatedUserTenantDomain = authenticatedUser.getTenantDomain();
                            context.setSubject(authenticatedUser);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Already authenticated by username: " + authenticatedUser.getAuthenticatedSubjectIdentifier()));
                            }
                            if (authenticatedUserTenantDomain != null) {
                                context.setProperty(USER_TENANT_DOMAIN, authenticatedUserTenantDomain);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Authenticated user tenant domain: " + authenticatedUserTenantDomain));
                                }
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("User %s is not allowed to authenticate from previous session.", authenticatedUser.toString()));
                            }
                            context.setPreviousSessionFound(false);
                            FrameworkUtils.removeSessionContextFromCache(sessionContextKey);
                            sessionContext.setAuthenticatedIdPs(new HashMap<String, AuthenticatedIdPData>());
                        }
                    }
                    this.refreshAppConfig(effectiveSequence, request.getParameter("relyingParty"), context.getRequestType(), context.getTenantDomain());
                }
                context.setPreviousAuthenticatedIdPs(sessionContext.getAuthenticatedIdPs());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to find the SessionContext from the cache. Possible cache timeout.");
            }
        }
        context.setServiceProviderName(effectiveSequence.getApplicationConfig().getApplicationName());
        context.setSequenceConfig(effectiveSequence);
    }

    private boolean isReinitialize(SequenceConfig previousAuthenticatedSeq, SequenceConfig sequenceConfig, HttpServletRequest request, AuthenticationContext context) {
        List<String> newAcrList = this.getAcrRequested(request);
        List<String> previousAcrList = previousAuthenticatedSeq.getRequestedAcr();
        return newAcrList != null && !newAcrList.isEmpty() && this.isDifferent(newAcrList, previousAcrList);
    }

    private boolean isDifferent(List<String> newAcrList, List<String> previousAcrList) {
        if (previousAcrList == null || previousAcrList.size() != newAcrList.size()) {
            return true;
        }
        for (int i = 0; i < previousAcrList.size(); ++i) {
            if (newAcrList.get(i).equals(previousAcrList.get(i))) continue;
            return true;
        }
        return false;
    }

    private void buildOutboundQueryString(HttpServletRequest request, AuthenticationContext context) throws FrameworkException {
        StringBuilder outboundQueryStringBuilder = new StringBuilder();
        outboundQueryStringBuilder.append(FrameworkUtils.getQueryStringWithConfiguredParams(request));
        if (StringUtils.isNotEmpty((String)outboundQueryStringBuilder.toString())) {
            outboundQueryStringBuilder.append("&");
        }
        try {
            outboundQueryStringBuilder.append("sessionDataKey=").append(context.getContextIdentifier()).append("&relyingParty=").append(URLEncoder.encode(context.getRelyingParty(), "UTF-8")).append("&type=").append(context.getRequestType()).append("&").append("sp").append("=").append(URLEncoder.encode(context.getServiceProviderName(), "UTF-8")).append("&isSaaSApp=").append(context.getSequenceConfig().getApplicationConfig().isSaaSApp());
        }
        catch (UnsupportedEncodingException e) {
            throw new FrameworkException("Error while URL Encoding", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Outbound Query String: " + outboundQueryStringBuilder.toString()));
        }
        context.setContextIdIncludedQueryParams(outboundQueryStringBuilder.toString());
        context.setOrignalRequestQueryParams(outboundQueryStringBuilder.toString());
    }

    private void refreshAppConfig(SequenceConfig sequenceConfig, String clientId, String clientType, String tenantDomain) throws FrameworkException {
        try {
            ServiceProvider serviceProvider = this.getServiceProvider(clientType, clientId, tenantDomain);
            ApplicationConfig appConfig = new ApplicationConfig(serviceProvider);
            sequenceConfig.setApplicationConfig(appConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Refresh application config in sequence config for application id: " + sequenceConfig.getApplicationId() + " in tenant: " + tenantDomain));
            }
        }
        catch (FrameworkException e) {
            String message = "No application found for application id: " + sequenceConfig.getApplicationId() + " in tenant: " + tenantDomain + " Probably, the Service Provider would have been removed.";
            throw new FrameworkException(message, (Throwable)((Object)e));
        }
    }

    private void publishAuthenticationFailure(HttpServletRequest request, AuthenticationContext context, AuthenticatedUser user, String errorCode) {
        Serializable authenticationStartTime = context.getAnalyticsData("authenticationStartTime");
        if (authenticationStartTime instanceof Long) {
            context.setAnalyticsData("authenticationDuration", Long.valueOf(System.currentTimeMillis() - (Long)authenticationStartTime));
        }
        context.setAnalyticsData("authenticationErrorCode", (Serializable)((Object)errorCode));
        AuthenticationDataPublisher authnDataPublisherProxy = FrameworkServiceDataHolder.getInstance().getAuthnDataPublisherProxy();
        if (authnDataPublisherProxy != null && authnDataPublisherProxy.isEnabled(context)) {
            HashMap<String, AuthenticatedUser> paramMap = new HashMap<String, AuthenticatedUser>();
            paramMap.put("user", user);
            Map<String, Object> unmodifiableParamMap = Collections.unmodifiableMap(paramMap);
            authnDataPublisherProxy.publishAuthenticationFailure(request, context, unmodifiableParamMap);
        }
    }

    private void setSPAttributeToRequest(HttpServletRequest req, AuthenticationContext context) {
        req.setAttribute("sp", (Object)context.getServiceProviderName());
        req.setAttribute("tenantDomain", (Object)context.getTenantDomain());
    }

    private boolean isUserAllowedToLogin(AuthenticatedUser user) {
        if (user.isFederatedUser()) {
            return true;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)user.getTenantDomain());
        try {
            UserRealm userRealm = (UserRealm)FrameworkServiceComponent.getRealmService().getTenantUserRealm(tenantId);
            UserStoreManager userStoreManager = userRealm.getUserStoreManager().getSecondaryUserStoreManager(user.getUserStoreDomain());
            if (userStoreManager.isExistingUser(user.getUserName())) {
                return !this.isUserDisabled(userStoreManager, user) && !this.isUserLocked(userStoreManager, user);
            }
            log.error((Object)("Trying to authenticate non existing user: " + user.getUserName()));
        }
        catch (UserStoreException e) {
            log.error((Object)("Error while checking existence of user: " + user.getUserName()), (Throwable)e);
        }
        catch (FrameworkException e) {
            log.error((Object)("Error while validating user: " + user.getUserName()), (Throwable)((Object)e));
        }
        return false;
    }

    private boolean isUserLocked(UserStoreManager userStoreManager, AuthenticatedUser user) throws FrameworkException {
        if (!this.isAccountLockingEnabled(user.getTenantDomain())) {
            return false;
        }
        String accountLockedClaimValue = this.getClaimValue(user.getUserName(), userStoreManager, "http://wso2.org/claims/identity/accountLocked");
        boolean accountLocked = Boolean.parseBoolean(accountLockedClaimValue);
        if (accountLocked) {
            long unlockTime = 0L;
            String accountUnlockTimeClaimValue = this.getClaimValue(user.getUserName(), userStoreManager, "http://wso2.org/claims/identity/unlockTime");
            if (NumberUtils.isNumber((String)accountUnlockTimeClaimValue)) {
                unlockTime = Long.parseLong(accountUnlockTimeClaimValue);
            }
            if (unlockTime != 0L && System.currentTimeMillis() >= unlockTime) {
                return false;
            }
        }
        return accountLocked;
    }

    private boolean isUserDisabled(UserStoreManager userStoreManager, AuthenticatedUser user) throws FrameworkException {
        if (!this.isAccountDisablingEnabled(user.getTenantDomain())) {
            return false;
        }
        String accountDisabledClaimValue = this.getClaimValue(user.getUserName(), userStoreManager, "http://wso2.org/claims/identity/accountDisabled");
        return Boolean.parseBoolean(accountDisabledClaimValue);
    }

    private boolean isAccountLockingEnabled(String tenantDomain) throws FrameworkException {
        Property accountLockConfigProperty = FrameworkUtils.getResidentIdpConfiguration("account.lock.handler.enable", tenantDomain);
        return accountLockConfigProperty != null && Boolean.parseBoolean(accountLockConfigProperty.getValue());
    }

    private boolean isAccountDisablingEnabled(String tenantDomain) throws FrameworkException {
        Property accountDisableConfigProperty = FrameworkUtils.getResidentIdpConfiguration("account.disable.handler.enable", tenantDomain);
        return accountDisableConfigProperty != null && Boolean.parseBoolean(accountDisableConfigProperty.getValue());
    }

    private String getClaimValue(String username, UserStoreManager userStoreManager, String claimURI) throws FrameworkException {
        try {
            Map values = userStoreManager.getUserClaimValues(username, new String[]{claimURI}, "default");
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%s claim value of user %s is set to: " + (String)values.get(claimURI), claimURI, username));
            }
            return (String)values.get(claimURI);
        }
        catch (UserStoreException e) {
            throw new FrameworkException("Error occurred while retrieving claim: " + claimURI, e);
        }
    }
}

