/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorStateInfo;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthHistory;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.AuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.LogoutFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.UserSessionException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.LogoutRequestHandler;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationResult;
import org.wso2.carbon.identity.application.authentication.framework.model.CommonAuthResponseWrapper;
import org.wso2.carbon.identity.application.authentication.framework.store.UserSessionStore;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;

public class DefaultLogoutRequestHandler
implements LogoutRequestHandler {
    private static final Log log = LogFactory.getLog(DefaultLogoutRequestHandler.class);
    private static volatile DefaultLogoutRequestHandler instance;
    private static final Log AUDIT_LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultLogoutRequestHandler getInstance() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Inside getInstance()");
        }
        if (instance != null) return instance;
        Class<DefaultLogoutRequestHandler> clazz = DefaultLogoutRequestHandler.class;
        synchronized (DefaultLogoutRequestHandler.class) {
            if (instance != null) return instance;
            instance = new DefaultLogoutRequestHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Inside handle()");
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        SessionContext sessionContext = FrameworkUtils.getSessionContextFromCache(context.getSessionIdentifier());
        ExternalIdPConfig externalIdPConfig = null;
        this.clearUserSessionData(request);
        if (FrameworkServiceDataHolder.getInstance().getAuthnDataPublisherProxy() != null && FrameworkServiceDataHolder.getInstance().getAuthnDataPublisherProxy().isEnabled(context) && sessionContext != null) {
            Iterator<AuthHistory> authenticatedUserObj = sessionContext.getProperty("AuthenticatedUser");
            AuthenticatedUser authenticatedUser = new AuthenticatedUser();
            if (authenticatedUserObj instanceof AuthenticatedUser) {
                authenticatedUser = (AuthenticatedUser)((Object)authenticatedUserObj);
            }
            FrameworkUtils.publishSessionEvent(context.getSessionIdentifier(), request, context, sessionContext, authenticatedUser, "sessionTerminated");
        }
        if (sessionContext != null && StringUtils.isNotBlank((String)context.getSessionIdentifier()) && sessionContext.getSessionAuthHistory().getHistory() != null) {
            for (AuthHistory authHistory : sessionContext.getSessionAuthHistory().getHistory()) {
                if (!"SAMLSSOAuthenticator".equals(authHistory.getAuthenticatorName())) continue;
                try {
                    UserSessionStore.getInstance().removeFederatedAuthSessionInfo(context.getSessionIdentifier());
                    break;
                }
                catch (UserSessionException e) {
                    throw new FrameworkException("Error while deleting federated authentication session details for the session context key :" + context.getSessionIdentifier(), (Throwable)((Object)e));
                }
            }
        }
        FrameworkUtils.removeSessionContextFromCache(context.getSessionIdentifier());
        FrameworkUtils.removeAuthCookie(request, response);
        if (context.isPreviousSessionFound()) {
            if (context.getCurrentStep() == 0) {
                context.setCurrentStep(1);
            }
            int stepCount = sequenceConfig.getStepMap().size();
            while (context.getCurrentStep() <= stepCount) {
                int currentStep = context.getCurrentStep();
                StepConfig stepConfig = sequenceConfig.getStepMap().get(currentStep);
                AuthenticatorConfig authenticatorConfig = stepConfig.getAuthenticatedAutenticator();
                if (authenticatorConfig == null) {
                    authenticatorConfig = sequenceConfig.getAuthenticatedReqPathAuthenticator();
                }
                ApplicationAuthenticator authenticator = authenticatorConfig.getApplicationAuthenticator();
                String idpName = stepConfig.getAuthenticatedIdP();
                if ((idpName == null || "null".equalsIgnoreCase(idpName) || idpName.isEmpty()) && sequenceConfig.getAuthenticatedReqPathAuthenticator() != null) {
                    idpName = "LOCAL";
                }
                try {
                    externalIdPConfig = ConfigurationFacade.getInstance().getIdPConfigByName(idpName, context.getTenantDomain());
                    context.setExternalIdP(externalIdPConfig);
                    context.setAuthenticatorProperties(FrameworkUtils.getAuthenticatorPropertyMapFromIdP(externalIdPConfig, authenticator.getName()));
                    if (authenticatorConfig.getAuthenticatorStateInfo() != null) {
                        context.setStateInfo(authenticatorConfig.getAuthenticatorStateInfo());
                    } else {
                        context.setStateInfo(this.getStateInfoFromPreviousAuthenticatedIdPs(idpName, authenticatorConfig.getName(), context));
                    }
                    AuthenticatorFlowStatus status = authenticator.process(request, response, context);
                    request.setAttribute("authenticatorFlowStatus", (Object)status);
                    if (!status.equals(AuthenticatorFlowStatus.INCOMPLETE)) {
                        context.setCurrentStep(++currentStep);
                        continue;
                    }
                    return;
                }
                catch (AuthenticationFailedException | LogoutFailedException e) {
                    throw new FrameworkException("Exception while handling logout request", e);
                }
                catch (IdentityProviderManagementException e) {
                    log.error((Object)"Exception while getting IdP by name", (Throwable)e);
                }
            }
        }
        try {
            this.sendResponse(request, response, context, true);
        }
        catch (IOException | ServletException e) {
            throw new FrameworkException(e.getMessage(), e);
        }
    }

    protected void sendResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, boolean isLoggedOut) throws ServletException, IOException {
        String redirectURL;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Inside sendLogoutResponseToCaller()");
        }
        request.setAttribute("commonAuthLoggedOut", (Object)isLoggedOut);
        if (context.getCallerSessionKey() != null) {
            request.setAttribute("sessionDataKey", (Object)context.getCallerSessionKey());
            AuthenticationResult authenticationResult = new AuthenticationResult();
            authenticationResult.setLoggedOut(true);
            SequenceConfig sequenceConfig = context.getSequenceConfig();
            if (sequenceConfig != null) {
                authenticationResult.setSaaSApp(sequenceConfig.getApplicationConfig().isSaaSApp());
            }
            if (FrameworkUtils.getCacheDisabledAuthenticators().contains(context.getRequestType()) && response instanceof CommonAuthResponseWrapper && !((CommonAuthResponseWrapper)response).isWrappedByFramework()) {
                this.addAuthenticationResultToRequest(request, authenticationResult);
            } else {
                FrameworkUtils.addAuthenticationResultToCache(context.getCallerSessionKey(), authenticationResult);
            }
            String sessionDataKeyParam = "sessionDataKey=" + URLEncoder.encode(context.getCallerSessionKey(), "UTF-8");
            redirectURL = FrameworkUtils.appendQueryParamsStringToUrl(context.getCallerPath(), sessionDataKeyParam);
        } else {
            redirectURL = context.getCallerPath();
        }
        String retainCache = System.getProperty("retainCache");
        if (retainCache == null) {
            FrameworkUtils.removeAuthenticationContextFromCache(context.getContextIdentifier());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending response back to: " + context.getCallerPath() + "...\n" + "commonAuthLoggedOut" + " : " + isLoggedOut + "\n" + "sessionDataKey" + ": " + context.getCallerSessionKey()));
        }
        response.sendRedirect(redirectURL);
    }

    private void addAuthenticationResultToRequest(HttpServletRequest request, AuthenticationResult authenticationResult) {
        request.setAttribute("authResult", (Object)authenticationResult);
    }

    private AuthenticatorStateInfo getStateInfoFromPreviousAuthenticatedIdPs(String idpName, String authenticatorName, AuthenticationContext context) {
        if (context.getPreviousAuthenticatedIdPs() == null || context.getPreviousAuthenticatedIdPs().get(idpName) == null || context.getPreviousAuthenticatedIdPs().get(idpName).getAuthenticators() == null) {
            return null;
        }
        for (AuthenticatorConfig authenticatorConfig : context.getPreviousAuthenticatedIdPs().get(idpName).getAuthenticators()) {
            if (!authenticatorName.equals(authenticatorConfig.getName())) continue;
            return authenticatorConfig.getAuthenticatorStateInfo();
        }
        return null;
    }

    private void clearUserSessionData(HttpServletRequest request) {
        if (!FrameworkServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
            return;
        }
        Cookie commonAuthCookie = FrameworkUtils.getAuthCookie(request);
        if (commonAuthCookie != null) {
            String commonAuthCookieValue = commonAuthCookie.getValue();
            String sessionId = null;
            if (commonAuthCookieValue != null) {
                sessionId = DigestUtils.sha256Hex((String)commonAuthCookieValue);
            }
            if (sessionId != null) {
                ArrayList<String> terminatedSessionId = new ArrayList<String>();
                terminatedSessionId.add(sessionId);
                UserSessionStore.getInstance().removeTerminatedSessionRecords(terminatedSessionId);
            }
        }
    }

    static {
        AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    }
}

