/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationResultCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthHistory;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.DuplicatedAuthUserException;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.exception.UserSessionException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.AuthenticationRequestHandler;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationContextProperty;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationResult;
import org.wso2.carbon.identity.application.authentication.framework.model.CommonAuthResponseWrapper;
import org.wso2.carbon.identity.application.authentication.framework.services.PostAuthenticationMgtService;
import org.wso2.carbon.identity.application.authentication.framework.store.UserSessionStore;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authentication.framework.util.LoginContextManagementUtil;
import org.wso2.carbon.identity.application.authentication.framework.util.SessionNonceCookieUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.core.config.UserStorePreferenceOrderSupplier;
import org.wso2.carbon.user.core.model.UserMgtContext;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class DefaultAuthenticationRequestHandler
implements AuthenticationRequestHandler {
    public static final String AUTHZ_FAIL_REASON = "AUTHZ_FAIL_REASON";
    private static final Log log = LogFactory.getLog(DefaultAuthenticationRequestHandler.class);
    private static final Log AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    private static volatile DefaultAuthenticationRequestHandler instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultAuthenticationRequestHandler getInstance() {
        if (instance != null) return instance;
        Class<DefaultAuthenticationRequestHandler> clazz = DefaultAuthenticationRequestHandler.class;
        synchronized (DefaultAuthenticationRequestHandler.class) {
            if (instance != null) return instance;
            instance = new DefaultAuthenticationRequestHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        int currentStep;
        if (log.isDebugEnabled()) {
            log.debug((Object)"In authentication flow");
        }
        if (context.isReturning()) {
            if (request.getParameter("deny") != null) {
                this.handleDenyFromLoginPage(request, response, context);
                return;
            }
            this.handleRememberMeOptionFromLoginPage(request, context);
        }
        if ((currentStep = context.getCurrentStep()) == 0) {
            this.handleSequenceStart(request, response, context);
        }
        SequenceConfig seqConfig = context.getSequenceConfig();
        List<AuthenticatorConfig> reqPathAuthenticators = seqConfig.getReqPathAuthenticators();
        boolean addOrUpdateNonceCookie = false;
        try {
            UserStorePreferenceOrderSupplier<List<String>> userStorePreferenceOrderSupplier = FrameworkUtils.getUserStorePreferenceOrderSupplier(context, null);
            if (userStorePreferenceOrderSupplier != null) {
                UserMgtContext userMgtContext = new UserMgtContext();
                userMgtContext.setUserStorePreferenceOrderSupplier(userStorePreferenceOrderSupplier);
                UserCoreUtil.setUserMgtContextInThreadLocal((UserMgtContext)userMgtContext);
            }
            if (reqPathAuthenticators != null && !reqPathAuthenticators.isEmpty() && currentStep == 0) {
                FrameworkUtils.getRequestPathBasedSequenceHandler().handle(request, response, context);
            }
            if (!context.getSequenceConfig().isCompleted() || reqPathAuthenticators == null || reqPathAuthenticators.isEmpty()) {
                context.setProperty("stepBasedSequenceHandlerTriggered", true);
                if (SessionNonceCookieUtil.isNonceCookieEnabled()) {
                    String nonceCookieName = SessionNonceCookieUtil.getNonceCookieName(context);
                    if (context.isReturning()) {
                        if (!SessionNonceCookieUtil.validateNonceCookie(request, context)) throw new FrameworkException("sessionNonceErrorCode", "Session nonce cookie value is not matching for session with sessionDataKey: " + request.getParameter("sessionDataKey"));
                        addOrUpdateNonceCookie = true;
                    } else if (context.getProperty(nonceCookieName) == null) {
                        addOrUpdateNonceCookie = true;
                    }
                }
                FrameworkUtils.getStepBasedSequenceHandler().handle(request, response, context);
            }
        }
        catch (FrameworkException e) {
            SessionNonceCookieUtil.removeNonceCookie(request, response, context);
            throw e;
        }
        finally {
            UserCoreUtil.removeUserMgtContextInThreadLocal();
        }
        try {
            this.handlePostAuthentication(request, response, context);
        }
        catch (FrameworkException e) {
            SessionNonceCookieUtil.removeNonceCookie(request, response, context);
            throw e;
        }
        if (this.canConcludeFlow(context)) {
            if (addOrUpdateNonceCookie) {
                SessionNonceCookieUtil.removeNonceCookie(request, response, context);
            }
            this.concludeFlow(request, response, context);
            return;
        } else {
            if (!addOrUpdateNonceCookie) return;
            SessionNonceCookieUtil.addNonceCookie(request, response, context);
        }
    }

    protected boolean canConcludeFlow(AuthenticationContext context) {
        return LoginContextManagementUtil.isPostAuthenticationExtensionCompleted(context);
    }

    protected void handlePostAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Handling post authentication");
        }
        PostAuthenticationMgtService postAuthenticationMgtService = FrameworkServiceDataHolder.getInstance().getPostAuthenticationMgtService();
        if (context.getSequenceConfig().isCompleted()) {
            if (postAuthenticationMgtService != null) {
                postAuthenticationMgtService.handlePostAuthentication(request, response, context);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No post authentication service found. Hence not evaluating post authentication.");
                }
                LoginContextManagementUtil.markPostAuthenticationCompleted(context);
            }
        } else {
            log.debug((Object)"Sequence is not completed yet. Hence skipping post authentication");
        }
    }

    private void handleDenyFromLoginPage(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User has pressed Deny or Cancel in the login page. Terminating the authentication flow");
        }
        context.getSequenceConfig().setCompleted(true);
        context.setRequestAuthenticated(false);
        this.concludeFlow(request, response, context);
    }

    private void handleRememberMeOptionFromLoginPage(HttpServletRequest request, AuthenticationContext context) {
        if (context.isRememberMe()) {
            return;
        }
        String rememberMe = request.getParameter("chkRemember");
        if ("on".equalsIgnoreCase(rememberMe)) {
            context.setRememberMe(true);
        } else {
            context.setRememberMe(false);
        }
    }

    protected boolean handleSequenceStart(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        boolean passiveAuthenticate;
        boolean reAuthenticate;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting the sequence");
        }
        boolean forceAuthenticate = request.getParameter("forceAuth") != null ? Boolean.valueOf(request.getParameter("forceAuth")) : false;
        context.setForceAuthenticate(forceAuthenticate);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Force Authenticate : " + forceAuthenticate));
        }
        boolean bl = reAuthenticate = request.getParameter("reAuth") != null ? Boolean.valueOf(request.getParameter("reAuth")) : false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Re-Authenticate : " + reAuthenticate));
        }
        context.setReAuthenticate(reAuthenticate);
        String passiveAuthReqParam = request.getParameter("passiveAuth");
        boolean bl2 = passiveAuthenticate = passiveAuthReqParam != null ? Boolean.valueOf(passiveAuthReqParam) : false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Passive Authenticate : " + passiveAuthenticate));
        }
        context.setPassiveAuthenticate(passiveAuthenticate);
        return false;
    }

    protected void concludeFlow(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Concluding the Authentication Flow");
        }
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        sequenceConfig.setCompleted(false);
        AuthenticationResult authenticationResult = new AuthenticationResult();
        boolean isAuthenticated = context.isRequestAuthenticated();
        authenticationResult.setAuthenticated(isAuthenticated);
        String authenticatedUserTenantDomain = this.getAuthenticatedUserTenantDomain(context, authenticationResult);
        authenticationResult.setSaaSApp(sequenceConfig.getApplicationConfig().isSaaSApp());
        if (isAuthenticated) {
            if (!sequenceConfig.getApplicationConfig().isSaaSApp()) {
                String spTenantDomain = context.getTenantDomain();
                String userTenantDomain = sequenceConfig.getAuthenticatedUser().getTenantDomain();
                if (StringUtils.isNotEmpty((String)userTenantDomain) && StringUtils.isNotEmpty((String)spTenantDomain) && !spTenantDomain.equals(userTenantDomain)) {
                    throw new FrameworkException("Service Provider tenant domain must be equal to user tenant domain for non-SaaS applications");
                }
            }
            authenticationResult.setSubject(new AuthenticatedUser(sequenceConfig.getAuthenticatedUser()));
            ApplicationConfig appConfig = sequenceConfig.getApplicationConfig();
            if (appConfig.getServiceProvider().getLocalAndOutBoundAuthenticationConfig().isAlwaysSendBackAuthenticatedListOfIdPs()) {
                authenticationResult.setAuthenticatedIdPs(sequenceConfig.getAuthenticatedIdPs());
            }
            SessionContext sessionContext = null;
            String commonAuthCookie = null;
            String sessionContextKey = null;
            String analyticsSessionAction = null;
            if (FrameworkUtils.getAuthCookie(request) != null && !context.isForceAuthenticate() && (commonAuthCookie = FrameworkUtils.getAuthCookie(request).getValue()) != null) {
                sessionContextKey = DigestUtils.sha256Hex((String)commonAuthCookie);
                sessionContext = FrameworkUtils.getSessionContextFromCache(sessionContextKey);
            }
            String applicationTenantDomain = this.getApplicationTenantDomain(context);
            if (sessionContext != null) {
                Long createdTime;
                analyticsSessionAction = "sessionUpdated";
                sessionContext.getAuthenticatedSequences().put(appConfig.getApplicationName(), sequenceConfig);
                sessionContext.getAuthenticatedIdPs().putAll(context.getCurrentAuthenticatedIdPs());
                sessionContext.getSessionAuthHistory().resetHistory(AuthHistory.merge(sessionContext.getSessionAuthHistory().getHistory(), context.getAuthenticationStepHistory()));
                this.populateAuthenticationContextHistory(authenticationResult, context, sessionContext);
                long updatedSessionTime = System.currentTimeMillis();
                if (!context.isPreviousAuthTime()) {
                    sessionContext.addProperty("UpdatedTimestamp", updatedSessionTime);
                }
                ArrayList<AuthenticationContextProperty> authenticationContextProperties = new ArrayList<AuthenticationContextProperty>();
                if (sessionContext.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES") != null) {
                    List existingAuthenticationContextProperties = (List)sessionContext.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES");
                    block8: for (AuthenticationContextProperty contextProperty : existingAuthenticationContextProperties) {
                        for (StepConfig stepConfig : context.getSequenceConfig().getStepMap().values()) {
                            if (!stepConfig.getAuthenticatedIdP().equals(contextProperty.getIdPName())) continue;
                            authenticationContextProperties.add(contextProperty);
                            continue block8;
                        }
                    }
                }
                if ((createdTime = (Long)sessionContext.getProperty("CreatedTimestamp")) != null) {
                    authenticationResult.addProperty("CreatedTimestamp", createdTime);
                }
                if (context.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES") != null) {
                    authenticationContextProperties.addAll((List)context.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES"));
                    if (sessionContext.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES") == null) {
                        sessionContext.addProperty("AUTHENTICATION_CONTEXT_PROPERTIES", authenticationContextProperties);
                    } else {
                        List existingAuthenticationContextProperties = (List)sessionContext.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES");
                        existingAuthenticationContextProperties.addAll((List)context.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES"));
                    }
                }
                if (!authenticationContextProperties.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"AuthenticationContextProperties are available.");
                    }
                    authenticationResult.addProperty("AUTHENTICATION_CONTEXT_PROPERTIES", authenticationContextProperties);
                }
                if (FrameworkServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
                    try {
                        UserSessionStore.getInstance().updateSessionMetaData(sessionContextKey, "Last Access Time", Long.toString(updatedSessionTime));
                    }
                    catch (UserSessionException e) {
                        log.error((Object)"Updating session meta data failed.", (Throwable)((Object)e));
                    }
                }
                if (sessionContext.isRememberMe() && Boolean.parseBoolean(IdentityUtil.getProperty((String)"TimeConfig.ExtendRememberMeSessionTimeoutOnAuth"))) {
                    context.setRememberMe(sessionContext.isRememberMe());
                    this.setAuthCookie(request, response, context, commonAuthCookie, applicationTenantDomain);
                }
                FrameworkUtils.addSessionContextToCache(sessionContextKey, sessionContext, applicationTenantDomain);
            } else {
                analyticsSessionAction = "sessionCreated";
                sessionContext = new SessionContext();
                context.setProperty("isInitialLogin", true);
                sessionContext.getAuthenticatedSequences().put(appConfig.getApplicationName(), sequenceConfig);
                sessionContext.setAuthenticatedIdPs(context.getCurrentAuthenticatedIdPs());
                sessionContext.setRememberMe(context.isRememberMe());
                if (context.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES") != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"AuthenticationContextProperties are available.");
                    }
                    authenticationResult.addProperty("AUTHENTICATION_CONTEXT_PROPERTIES", context.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES"));
                    sessionContext.addProperty("AUTHENTICATION_CONTEXT_PROPERTIES", context.getProperty("AUTHENTICATION_CONTEXT_PROPERTIES"));
                }
                String sessionKey = UUIDGenerator.generateUUID();
                sessionContextKey = DigestUtils.sha256Hex((String)sessionKey);
                sessionContext.addProperty("AuthenticatedUser", (Object)authenticationResult.getSubject());
                Long createdTimeMillis = System.currentTimeMillis();
                sessionContext.addProperty("CreatedTimestamp", createdTimeMillis);
                authenticationResult.addProperty("CreatedTimestamp", createdTimeMillis);
                sessionContext.getSessionAuthHistory().resetHistory(AuthHistory.merge(sessionContext.getSessionAuthHistory().getHistory(), context.getAuthenticationStepHistory()));
                this.populateAuthenticationContextHistory(authenticationResult, context, sessionContext);
                FrameworkUtils.addSessionContextToCache(sessionContextKey, sessionContext, applicationTenantDomain);
                this.setAuthCookie(request, response, context, sessionKey, applicationTenantDomain);
                if (FrameworkServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
                    try {
                        this.storeSessionMetaData(sessionContextKey, request);
                    }
                    catch (UserSessionException e) {
                        log.error((Object)"Storing session meta data failed.", (Throwable)((Object)e));
                    }
                }
            }
            if (authenticatedUserTenantDomain == null) {
                PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            }
            if (FrameworkServiceDataHolder.getInstance().isUserSessionMappingEnabled()) {
                try {
                    this.storeSessionData(context, sessionContextKey);
                }
                catch (UserSessionException e) {
                    throw new FrameworkException("Error while storing session details of the authenticated user to the database", (Throwable)((Object)e));
                }
            }
            if (context.getAuthenticationStepHistory() != null) {
                for (AuthHistory authHistory : context.getAuthenticationStepHistory()) {
                    if (!"SAMLSSOAuthenticator".equals(authHistory.getAuthenticatorName()) || !StringUtils.isNotBlank((String)authHistory.getIdpSessionIndex()) || !StringUtils.isNotBlank((String)authHistory.getIdpName())) continue;
                    try {
                        UserSessionStore.getInstance().storeFederatedAuthSessionInfo(sessionContextKey, authHistory);
                    }
                    catch (UserSessionException e) {
                        throw new FrameworkException("Error while storing federated authentication session details of the authenticated user to the database", (Throwable)((Object)e));
                    }
                }
            }
            FrameworkUtils.publishSessionEvent(sessionContextKey, request, context, sessionContext, sequenceConfig.getAuthenticatedUser(), analyticsSessionAction);
            this.publishAuthenticationSuccess(request, context, sequenceConfig.getAuthenticatedUser());
        }
        if (FrameworkUtils.getCacheDisabledAuthenticators().contains(context.getRequestType()) && response instanceof CommonAuthResponseWrapper && !((CommonAuthResponseWrapper)response).isWrappedByFramework()) {
            request.setAttribute("sessionDataKey", (Object)context.getCallerSessionKey());
            this.addAuthenticationResultToRequest(request, authenticationResult);
        } else {
            FrameworkUtils.addAuthenticationResultToCache(context.getCallerSessionKey(), authenticationResult);
        }
        String retainCache = System.getProperty("retainCache");
        if (retainCache == null) {
            FrameworkUtils.removeAuthenticationContextFromCache(context.getContextIdentifier());
        }
        this.sendResponse(request, response, context);
    }

    private void populateAuthenticationContextHistory(AuthenticationResult authenticationResult, AuthenticationContext context, SessionContext sessionContext) {
        if (context.getSelectedAcr() != null) {
            sessionContext.getSessionAuthHistory().setSelectedAcrValue(context.getSelectedAcr());
            sessionContext.getSessionAuthHistory().setSessionCreatedTime(this.calculateCreatedTime(sessionContext));
        }
        authenticationResult.addProperty("SESSION_AUTH_HISTORY", sessionContext.getSessionAuthHistory());
    }

    private DateTime calculateCreatedTime(SessionContext sessionContext) {
        Object createdTsObject = sessionContext.getProperty("CreatedTimestamp");
        if (createdTsObject != null) {
            long createdTimeLong = Long.parseLong(createdTsObject.toString());
            return new DateTime(createdTimeLong);
        }
        return DateTime.now();
    }

    private void storeSessionData(AuthenticationContext context, String sessionContextKey) throws UserSessionException {
        String subject = context.getSequenceConfig().getAuthenticatedUser().getAuthenticatedSubjectIdentifier();
        String appName = context.getServiceProviderName();
        int appTenantId = IdentityTenantUtil.getTenantId((String)context.getTenantDomain());
        String inboundAuth = context.getCallerPath().substring(1);
        int appId = UserSessionStore.getInstance().getAppId(appName, appTenantId);
        for (AuthenticatedIdPData authenticatedIdPData : context.getCurrentAuthenticatedIdPs().values()) {
            String userName = authenticatedIdPData.getUser().getUserName();
            String tenantDomain = this.getAuthenticatedUserTenantDomain(context, null);
            if (tenantDomain == null) {
                tenantDomain = authenticatedIdPData.getUser().getTenantDomain();
            }
            int tenantId = tenantDomain == null ? -1 : IdentityTenantUtil.getTenantId((String)tenantDomain);
            String userStoreDomain = authenticatedIdPData.getUser().getUserStoreDomain();
            String idpName = authenticatedIdPData.getIdpName();
            boolean persistUserToSessionMapping = true;
            try {
                String userId;
                block13: {
                    int idpId = UserSessionStore.getInstance().getIdPId(idpName);
                    if (StringUtils.isBlank((String)FrameworkUtils.resolveUserIdFromUsername(tenantId, userStoreDomain, userName)) && this.isFederatedUser(authenticatedIdPData.getUser())) {
                        userId = UserSessionStore.getInstance().getUserId(userName, tenantId, userStoreDomain, idpId);
                        try {
                            if (userId == null) {
                                userId = UUID.randomUUID().toString();
                                UserSessionStore.getInstance().storeUserData(userId, userName, tenantId, userStoreDomain, idpId);
                            }
                            break block13;
                        }
                        catch (DuplicatedAuthUserException e) {
                            persistUserToSessionMapping = false;
                            String msg = "User authenticated is already persisted. Username: " + userName + " Tenant Domain:" + tenantDomain + " User Store Domain: " + userStoreDomain + " IdP: " + idpName;
                            log.warn((Object)msg);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)msg, (Throwable)((Object)e));
                            }
                            break block13;
                        }
                    }
                    userId = FrameworkUtils.resolveUserIdFromUsername(tenantId, userStoreDomain, userName);
                }
                if (StringUtils.isNotEmpty((String)userId)) {
                    if (!persistUserToSessionMapping || UserSessionStore.getInstance().isExistingMapping(userId, sessionContextKey)) continue;
                    UserSessionStore.getInstance().storeUserSessionData(userId, sessionContextKey);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("A unique user id is not set for the user," + userName + "of userstore domain, " + userStoreDomain + "in tenant, " + tenantDomain + ". Hence the session information of the user is not stored."));
            }
            catch (UserSessionException e) {
                throw new UserSessionException("Error while storing session data for user: " + userName + " of user store domain: " + userStoreDomain + " in tenant domain: " + tenantDomain, (Throwable)((Object)e));
            }
        }
        try {
            if (appId > 0) {
                UserSessionStore.getInstance().storeAppSessionDataIfNotExist(sessionContextKey, subject, appId, inboundAuth);
            }
        }
        catch (DataAccessException e) {
            throw new UserSessionException("Error while storing Application session data in the database.", e);
        }
    }

    private boolean isFederatedUser(AuthenticatedUser authenticatedUser) {
        return authenticatedUser.isFederatedUser();
    }

    private void storeSessionMetaData(String sessionId, HttpServletRequest request) throws UserSessionException {
        String userAgent = request.getHeader("User-Agent");
        String ip = IdentityUtil.getClientIpAddress((HttpServletRequest)request);
        String time = Long.toString(System.currentTimeMillis());
        HashMap<String, String> metaDataMap = new HashMap<String, String>();
        metaDataMap.put("User Agent", userAgent);
        metaDataMap.put("IP", ip);
        metaDataMap.put("Login Time", time);
        metaDataMap.put("Last Access Time", time);
        UserSessionStore.getInstance().storeSessionMetaData(sessionId, metaDataMap);
    }

    private String getApplicationTenantDomain(AuthenticationContext context) {
        return StringUtils.isNotEmpty((String)context.getTenantDomain()) ? context.getTenantDomain() : "carbon.super";
    }

    private void publishAuthenticationSuccess(HttpServletRequest request, AuthenticationContext context, AuthenticatedUser user) {
        AuthenticationDataPublisher authnDataPublisherProxy;
        Serializable authenticationStartTime = context.getAnalyticsData("authenticationStartTime");
        if (authenticationStartTime instanceof Long) {
            context.setAnalyticsData("authenticationDuration", Long.valueOf(System.currentTimeMillis() - (Long)authenticationStartTime));
        }
        if ((authnDataPublisherProxy = FrameworkServiceDataHolder.getInstance().getAuthnDataPublisherProxy()) != null && authnDataPublisherProxy.isEnabled(context)) {
            HashMap<String, AuthenticatedUser> paramMap = new HashMap<String, AuthenticatedUser>();
            paramMap.put("user", user);
            Map<String, Object> unmodifiableParamMap = Collections.unmodifiableMap(paramMap);
            authnDataPublisherProxy.publishAuthenticationSuccess(request, context, unmodifiableParamMap);
        }
    }

    private void addAuthenticationResultToRequest(HttpServletRequest request, AuthenticationResult authenticationResult) {
        request.setAttribute("authResult", (Object)authenticationResult);
    }

    private void setAuthCookie(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, String sessionKey, String tenantDomain) throws FrameworkException {
        Integer authCookieAge = null;
        if (context.isRememberMe()) {
            authCookieAge = IdPManagementUtil.getRememberMeTimeout((String)tenantDomain);
        }
        FrameworkUtils.storeAuthCookie(request, response, sessionKey, authCookieAge);
    }

    private String getAuthenticatedUserTenantDomain(AuthenticationContext context, AuthenticationResult authenticationResult) {
        String authenticatedUserTenantDomain = null;
        if (context.getProperties() != null) {
            authenticatedUserTenantDomain = (String)context.getProperties().get("user-tenant-domain");
        }
        return authenticatedUserTenantDomain;
    }

    protected void sendResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws FrameworkException {
        if (log.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append("Sending response back to: ");
            debugMessage.append(context.getCallerPath()).append("...\n");
            debugMessage.append("commonAuthAuthenticated").append(": ");
            debugMessage.append(String.valueOf(context.isRequestAuthenticated())).append("\n");
            debugMessage.append("authenticatedUser").append(": ");
            if (context.getSequenceConfig().getAuthenticatedUser() != null) {
                debugMessage.append(context.getSequenceConfig().getAuthenticatedUser().getAuthenticatedSubjectIdentifier()).append("\n");
            } else {
                debugMessage.append("No Authenticated User").append("\n");
            }
            debugMessage.append("authenticatedIdPs").append(": ");
            debugMessage.append(context.getSequenceConfig().getAuthenticatedIdPs()).append("\n");
            debugMessage.append("sessionDataKey").append(": ");
            debugMessage.append(context.getCallerSessionKey());
            log.debug((Object)debugMessage);
        }
        String rememberMeParam = "";
        if (context.isRequestAuthenticated() && context.isRememberMe()) {
            rememberMeParam = rememberMeParam + "chkRemember=on";
        }
        if (!context.isRequestAuthenticated()) {
            this.populateErrorInformation(request, response, context);
        }
        String commonauthCallerPath = context.getCallerPath();
        try {
            String queryParamsString = "";
            if (context.getCallerSessionKey() != null) {
                queryParamsString = "sessionDataKey=" + URLEncoder.encode(context.getCallerSessionKey(), "UTF-8");
            }
            if (StringUtils.isNotEmpty((String)rememberMeParam)) {
                queryParamsString = queryParamsString + "&" + rememberMeParam;
            }
            String redirectURL = FrameworkUtils.appendQueryParamsStringToUrl(commonauthCallerPath, queryParamsString);
            response.sendRedirect(redirectURL);
        }
        catch (IOException e) {
            throw new FrameworkException(e.getMessage(), e);
        }
    }

    protected void populateErrorInformation(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        AuthenticationResult authenticationResult = this.getAuthenticationResult(request, response, context);
        String errorCode = String.valueOf(context.getProperty("AuthErrorCode"));
        String errorMessage = String.valueOf(context.getProperty("AuthErrorMessage"));
        String errorUri = String.valueOf(context.getProperty("AuthErrorURI"));
        if (authenticationResult != null) {
            if (IdentityUtil.isNotBlank((String)errorCode)) {
                authenticationResult.addProperty("AuthErrorCode", errorCode);
            }
            if (IdentityUtil.isNotBlank((String)errorMessage)) {
                authenticationResult.addProperty("AuthErrorMessage", errorMessage);
            }
            if (IdentityUtil.isNotBlank((String)errorUri)) {
                authenticationResult.addProperty("AuthErrorURI", errorUri);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Populated errorCode=" + errorCode + ", errorMessage=" + errorMessage + ", errorUri=" + errorUri + " to the AuthenticationResult."));
            }
            request.setAttribute("authResult", (Object)authenticationResult);
        }
    }

    private AuthenticationResult getAuthenticationResult(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) {
        AuthenticationResult authenticationResult = null;
        if (FrameworkUtils.getCacheDisabledAuthenticators().contains(context.getRequestType()) && response instanceof CommonAuthResponseWrapper && !((CommonAuthResponseWrapper)response).isWrappedByFramework()) {
            authenticationResult = (AuthenticationResult)request.getAttribute("authResult");
        } else {
            AuthenticationResultCacheEntry authenticationResultCacheEntry = FrameworkUtils.getAuthenticationResultFromCache(context.getCallerSessionKey());
            if (authenticationResultCacheEntry != null) {
                authenticationResult = authenticationResultCacheEntry.getResult();
            }
        }
        return authenticationResult;
    }
}

