/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.request.impl;

import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.loader.SequenceLoader;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.RequestCoordinator;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;

public abstract class AbstractRequestCoordinator
implements RequestCoordinator {
    public SequenceConfig getSequenceConfig(AuthenticationContext context, Map<String, String[]> parameterMap) throws FrameworkException {
        String requestType = context.getRequestType();
        Object[] issuers = parameterMap.get("relyingParty");
        Object issuer = null;
        if (!ArrayUtils.isEmpty((Object[])issuers)) {
            issuer = issuers[0];
        }
        String tenantDomain = context.getTenantDomain();
        SequenceLoader sequenceBuilder = FrameworkServiceDataHolder.getInstance().getSequenceLoader();
        if (sequenceBuilder != null) {
            ServiceProvider serviceProvider = this.getServiceProvider(requestType, (String)issuer, tenantDomain);
            return sequenceBuilder.getSequenceConfig(context, parameterMap, serviceProvider);
        }
        return ConfigurationFacade.getInstance().getSequenceConfig((String)issuer, requestType, tenantDomain);
    }

    protected ServiceProvider getServiceProvider(String reqType, String clientId, String tenantDomain) throws FrameworkException {
        ServiceProvider serviceProvider;
        ApplicationManagementService appInfo = ApplicationManagementService.getInstance();
        if ("oidc".equals(reqType)) {
            reqType = "oauth2";
        }
        try {
            serviceProvider = appInfo.getServiceProviderByClientId(clientId, reqType, tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new FrameworkException("Error occurred while retrieving service provider for client ID: " + clientId + " and tenant: " + tenantDomain, e);
        }
        return serviceProvider;
    }
}

