/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.provisioning.impl;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.core.util.PermissionUpdateUtil;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.handler.provisioning.ProvisioningHandler;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.FederatedAssociationManager;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.constant.FederatedAssociationConstants;
import org.wso2.carbon.identity.user.profile.mgt.association.federation.exception.FederatedAssociationManagerException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DefaultProvisioningHandler
implements ProvisioningHandler {
    private static final Log log = LogFactory.getLog(DefaultProvisioningHandler.class);
    private static final String ALREADY_ASSOCIATED_MESSAGE = "UserAlreadyAssociated";
    private static volatile DefaultProvisioningHandler instance;
    private SecureRandom random = new SecureRandom();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultProvisioningHandler getInstance() {
        if (instance != null) return instance;
        Class<DefaultProvisioningHandler> clazz = DefaultProvisioningHandler.class;
        synchronized (DefaultProvisioningHandler.class) {
            if (instance != null) return instance;
            instance = new DefaultProvisioningHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void handle(List<String> roles, String subject, Map<String, String> attributes, String provisioningUserStoreId, String tenantDomain) throws FrameworkException {
        RegistryService registryService = FrameworkServiceComponent.getRegistryService();
        RealmService realmService = FrameworkServiceComponent.getRealmService();
        try {
            String userStoreDomain;
            UserStoreManager userStoreManager;
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
            String username = MultitenantUtils.getTenantAwareUsername((String)subject);
            if ("As in username".equalsIgnoreCase(provisioningUserStoreId)) {
                String userStoreDomainFromSubject = UserCoreUtil.extractDomainFromName((String)subject);
                try {
                    userStoreManager = this.getUserStoreManager(realm, userStoreDomainFromSubject);
                    userStoreDomain = userStoreDomainFromSubject;
                }
                catch (FrameworkException e) {
                    log.error((Object)("User store domain " + userStoreDomainFromSubject + " does not exist for the tenant " + tenantDomain + ", hence provisioning user to " + "PRIMARY"));
                    userStoreDomain = "PRIMARY";
                    userStoreManager = this.getUserStoreManager(realm, userStoreDomain);
                }
            } else {
                userStoreDomain = this.getUserStoreDomain(provisioningUserStoreId, realm);
                userStoreManager = this.getUserStoreManager(realm, userStoreDomain);
            }
            username = UserCoreUtil.removeDomainFromName((String)username);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User: " + username + " with roles : " + roles + " is going to be provisioned"));
            }
            List<String> rolesToAdd = this.convertInternalRoleDomainsToCamelCase(roles);
            String idp = attributes.remove("idpId");
            String subjectVal = attributes.remove("associatedID");
            Map<String, String> userClaims = this.prepareClaimMappings(attributes);
            if (userStoreManager.isExistingUser(username)) {
                String associatedUserName;
                if (!userClaims.isEmpty()) {
                    userClaims.remove("password");
                    userClaims.remove("http://wso2.org/claims/username");
                    userStoreManager.setUserClaimValues(UserCoreUtil.removeDomainFromName((String)username), userClaims, null);
                }
                if (StringUtils.isEmpty((String)(associatedUserName = FrameworkUtils.getFederatedAssociationManager().getUserForFederatedAssociation(tenantDomain, idp, subjectVal)))) {
                    this.associateUser(username, userStoreDomain, tenantDomain, subjectVal, idp);
                }
            } else {
                String password = this.generatePassword();
                String passwordFromUser = userClaims.get("password");
                if (StringUtils.isNotEmpty((String)passwordFromUser)) {
                    password = passwordFromUser;
                }
                if (userClaims.containsKey("http://wso2.org/claims/username") && !userClaims.get("http://wso2.org/claims/username").equals(username)) {
                    userClaims.put("http://wso2.org/claims/username", username);
                }
                userClaims.remove("password");
                userStoreManager.addUser(username, (Object)password, null, userClaims, null);
                this.associateUser(username, userStoreDomain, tenantDomain, subjectVal, idp);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Federated user: " + username + " is provisioned by authentication framework."));
                }
            }
            if (roles != null) {
                List<String> currentRolesList = Arrays.asList(userStoreManager.getRoleListOfUser(username));
                List<String> deletingRoles = this.retrieveRolesToBeDeleted(realm, currentRolesList, rolesToAdd);
                rolesToAdd.removeAll(currentRolesList);
                this.handleFederatedUserNameEqualsToSuperAdminUserName(realm, username, userStoreManager, deletingRoles);
                this.updateUserWithNewRoleSet(username, userStoreManager, rolesToAdd, deletingRoles);
            }
            PermissionUpdateUtil.updatePermissionTree((int)tenantId);
        }
        catch (CarbonException | FederatedAssociationManagerException | org.wso2.carbon.user.api.UserStoreException e) {
            throw new FrameworkException("Error while provisioning user : " + subject, e);
        }
        finally {
            IdentityUtil.clearIdentityErrorMsg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associateUser(String username, String userStoreDomain, String tenantDomain, String subject, String idp) throws FrameworkException {
        block8: {
            String usernameWithUserstoreDomain = UserCoreUtil.addDomainToName((String)username, (String)userStoreDomain);
            try {
                FrameworkUtils.startTenantFlow(tenantDomain);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername(usernameWithUserstoreDomain);
                if (!StringUtils.isEmpty((String)idp) && !StringUtils.isEmpty((String)subject)) {
                    FederatedAssociationManager federatedAssociationManager = FrameworkUtils.getFederatedAssociationManager();
                    User user = this.getAssociatedUser(tenantDomain, userStoreDomain, username);
                    federatedAssociationManager.createFederatedAssociation(user, idp, subject);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Associated local user: " + usernameWithUserstoreDomain + " in tenant: " + tenantDomain + " to the federated subject : " + subject + " in IdP: " + idp));
                    }
                    break block8;
                }
                throw new FrameworkException("Error while associating local user: " + usernameWithUserstoreDomain + " in tenant: " + tenantDomain + " to the federated subject : " + subject + " in IdP: " + idp);
            }
            catch (FederatedAssociationManagerException e) {
                if (this.isUserAlreadyAssociated(e)) {
                    log.info((Object)("An association already exists for user: " + subject + ". Skip association while JIT provisioning"));
                    break block8;
                }
                throw new FrameworkException("Error while associating local user: " + usernameWithUserstoreDomain + " in tenant: " + tenantDomain + " to the federated subject : " + subject + " in IdP: " + idp, e);
            }
            finally {
                FrameworkUtils.endTenantFlow();
            }
        }
    }

    private User getAssociatedUser(String tenantDomain, String userStoreDomain, String username) {
        User user = new User();
        user.setTenantDomain(tenantDomain);
        user.setUserStoreDomain(userStoreDomain);
        user.setUserName(MultitenantUtils.getTenantAwareUsername((String)username));
        return user;
    }

    private boolean isUserAlreadyAssociated(FederatedAssociationManagerException e) {
        return e.getMessage() != null && e.getMessage().contains(FederatedAssociationConstants.ErrorMessages.FEDERATED_ASSOCIATION_ALREADY_EXISTS.getDescription());
    }

    private void updateUserWithNewRoleSet(String username, UserStoreManager userStoreManager, List<String> rolesToAdd, Collection<String> deletingRoles) throws UserStoreException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting roles : " + Arrays.toString(deletingRoles.toArray(new String[0])) + " and Adding roles : " + Arrays.toString(rolesToAdd.toArray(new String[0]))));
        }
        userStoreManager.updateRoleListOfUser(username, deletingRoles.toArray(new String[0]), rolesToAdd.toArray(new String[0]));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Federated user: " + username + " is updated by authentication framework with roles : " + rolesToAdd));
        }
    }

    private void handleFederatedUserNameEqualsToSuperAdminUserName(UserRealm realm, String username, UserStoreManager userStoreManager, Collection<String> deletingRoles) throws UserStoreException, FrameworkException {
        if (userStoreManager.getRealmConfiguration().isPrimary() && username.equals(realm.getRealmConfiguration().getAdminUserName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Federated user's username is equal to super admin's username of local IdP.");
            }
            if (deletingRoles.contains(realm.getRealmConfiguration().getAdminRoleName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Federated user doesn't have super admin role. Unable to sync roles, since super admin role cannot be unassigned from super admin user");
                }
                throw new FrameworkException("Federated user which having same username to super admin username of local IdP, trying login without having super admin role assigned");
            }
        }
    }

    private Map<String, String> prepareClaimMappings(Map<String, String> attributes) {
        HashMap<String, String> userClaims = new HashMap<String, String>();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String claimURI = entry.getKey();
                String claimValue = entry.getValue();
                if (StringUtils.isEmpty((String)claimURI) || StringUtils.isEmpty((String)claimValue)) continue;
                userClaims.put(claimURI, claimValue);
            }
        }
        return userClaims;
    }

    private UserStoreManager getUserStoreManager(UserRealm realm, String userStoreDomain) throws UserStoreException, FrameworkException {
        UserStoreManager userStoreManager = userStoreDomain != null && !userStoreDomain.isEmpty() ? realm.getUserStoreManager().getSecondaryUserStoreManager(userStoreDomain) : realm.getUserStoreManager();
        if (userStoreManager == null) {
            throw new FrameworkException("Specified user store is invalid");
        }
        return userStoreManager;
    }

    private String getUserStoreDomain(String userStoreDomain, UserRealm realm) throws FrameworkException, UserStoreException {
        if (userStoreDomain != null && realm.getUserStoreManager().getSecondaryUserStoreManager(userStoreDomain) == null) {
            throw new FrameworkException("Specified user store domain " + userStoreDomain + " is not valid.");
        }
        return userStoreDomain;
    }

    protected String generatePassword() {
        return RandomStringUtils.randomNumeric((int)12);
    }

    private List<String> removeDomainFromNamesExcludeInternal(List<String> names, int tenantId) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (String name : names) {
            String userStoreDomain = IdentityUtil.extractDomainFromName((String)name);
            if ("Internal".equalsIgnoreCase(userStoreDomain)) {
                nameList.add(name);
                continue;
            }
            nameList.add(UserCoreUtil.removeDomainFromName((String)name));
        }
        return nameList;
    }

    private List<String> convertInternalRoleDomainsToCamelCase(List<String> roles) {
        ArrayList<String> updatedRoles = new ArrayList<String>();
        if (roles != null) {
            for (String role : roles) {
                if (StringUtils.containsIgnoreCase((String)role, (String)("Internal" + CarbonConstants.DOMAIN_SEPARATOR))) {
                    updatedRoles.add("Internal" + CarbonConstants.DOMAIN_SEPARATOR + UserCoreUtil.removeDomainFromName((String)role));
                    continue;
                }
                if (StringUtils.containsIgnoreCase((String)role, (String)("Application" + CarbonConstants.DOMAIN_SEPARATOR))) {
                    updatedRoles.add("Application" + CarbonConstants.DOMAIN_SEPARATOR + UserCoreUtil.removeDomainFromName((String)role));
                    continue;
                }
                if (StringUtils.containsIgnoreCase((String)role, (String)("Workflow" + CarbonConstants.DOMAIN_SEPARATOR))) {
                    updatedRoles.add("Workflow" + CarbonConstants.DOMAIN_SEPARATOR + UserCoreUtil.removeDomainFromName((String)role));
                    continue;
                }
                updatedRoles.add(role);
            }
        }
        return updatedRoles;
    }

    protected List<String> retrieveRolesToBeDeleted(UserRealm realm, List<String> currentRolesList, List<String> rolesToAdd) throws UserStoreException {
        ArrayList<String> deletingRoles = new ArrayList<String>();
        deletingRoles.addAll(currentRolesList);
        deletingRoles.removeAll(rolesToAdd);
        deletingRoles.remove(realm.getRealmConfiguration().getEveryOneRoleName());
        return deletingRoles;
    }
}

