/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.claims.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.builder.FileBasedConfigurationBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.handler.claims.ClaimHandler;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.ClaimManager;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;

public class DefaultClaimHandler
implements ClaimHandler {
    public static final String SERVICE_PROVIDER_SUBJECT_CLAIM_VALUE = "ServiceProviderSubjectClaimValue";
    private static final Log log = LogFactory.getLog(DefaultClaimHandler.class);
    private static volatile DefaultClaimHandler instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultClaimHandler getInstance() {
        if (instance != null) return instance;
        Class<DefaultClaimHandler> clazz = DefaultClaimHandler.class;
        synchronized (DefaultClaimHandler.class) {
            if (instance != null) return instance;
            instance = new DefaultClaimHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Map<String, String> handleClaimMappings(StepConfig stepConfig, AuthenticationContext context, Map<String, String> remoteClaims, boolean isFederatedClaims) throws FrameworkException {
        if (log.isDebugEnabled()) {
            this.logInput(remoteClaims, isFederatedClaims);
        }
        ApplicationConfig appConfig = context.getSequenceConfig().getApplicationConfig();
        String spStandardDialect = this.getStandardDialect(context.getRequestType(), appConfig);
        context.setProperty("SP_STANDARD_DIALECT", spStandardDialect);
        List<org.wso2.carbon.identity.application.common.model.ClaimMapping> selectedRequestedClaims = FrameworkServiceDataHolder.getInstance().getHighestPriorityClaimFilter().getFilteredClaims(context, appConfig);
        this.setMandatoryAndRequestedClaims(appConfig, selectedRequestedClaims);
        context.getSequenceConfig().setApplicationConfig(appConfig);
        Map<String, String> returningClaims = isFederatedClaims ? this.handleFederatedClaims(remoteClaims, spStandardDialect, stepConfig, context) : this.handleLocalClaims(spStandardDialect, stepConfig, context);
        if (log.isDebugEnabled()) {
            this.logOutput(returningClaims, context);
        }
        return returningClaims;
    }

    protected Map<String, String> handleFederatedClaims(Map<String, String> remoteClaims, String spStandardDialect, StepConfig stepConfig, AuthenticationContext context) throws FrameworkException {
        Map<String, String> spClaimMappings;
        org.wso2.carbon.identity.application.common.model.ClaimMapping[] idPClaimMappings = context.getExternalIdP().getClaimMappings();
        if (idPClaimMappings == null) {
            idPClaimMappings = new org.wso2.carbon.identity.application.common.model.ClaimMapping[]{};
        }
        if ((spClaimMappings = context.getSequenceConfig().getApplicationConfig().getClaimMappings()) == null) {
            spClaimMappings = new HashMap<String, String>();
        }
        Map<String, String> spRequestedClaimMappings = context.getSequenceConfig().getApplicationConfig().getRequestedClaimMappings();
        if (StringUtils.isNotBlank((String)spStandardDialect) && !StringUtils.equals((String)spStandardDialect, (String)"http://wso2.org/claims")) {
            Map<String, String> carbonToStandardClaimMapping = this.getCarbonToStandardDialectMapping(spStandardDialect, context, spRequestedClaimMappings, context.getTenantDomain());
            spRequestedClaimMappings = this.mapRequestClaimsInStandardDialect(spRequestedClaimMappings, carbonToStandardClaimMapping);
            context.setProperty("SP_TO_CARBON_CLAIM_MAPPING", spRequestedClaimMappings);
        }
        ApplicationAuthenticator authenticator = stepConfig.getAuthenticatedAutenticator().getApplicationAuthenticator();
        boolean useDefaultIdpDialect = context.getExternalIdP().useDefaultLocalIdpDialect();
        String idPStandardDialect = null;
        if (useDefaultIdpDialect || !this.useLocalClaimDialectForClaimMappings()) {
            idPStandardDialect = authenticator.getClaimDialectURI();
        }
        remoteClaims.putAll(context.getRuntimeClaims());
        context.setProperty("UNFILTERED_IDP_CLAIM_VALUES", remoteClaims);
        HashMap<String, String> localUnfilteredClaims = new HashMap<String, String>();
        HashMap<String, String> spUnfilteredClaims = new HashMap<String, String>();
        HashMap<String, String> spFilteredClaims = new HashMap<String, String>();
        Map<String, String> localToIdPClaimMap = null;
        HashMap<String, String> defaultValuesForClaims = new HashMap<String, String>();
        this.loadDefaultValuesForClaims(idPClaimMappings, defaultValuesForClaims);
        if (idPStandardDialect != null || useDefaultIdpDialect) {
            localToIdPClaimMap = this.getLocalToIdpClaimMappingWithStandardDialect(remoteClaims, idPClaimMappings, context, idPStandardDialect);
        } else if (idPClaimMappings.length > 0) {
            localToIdPClaimMap = FrameworkUtils.getClaimMappings(idPClaimMappings, true);
        } else {
            log.warn((Object)("Authenticator : " + authenticator.getFriendlyName() + " does not have a standard dialect and IdP : " + context.getExternalIdP().getIdPName() + " does not have custom claim mappings. Cannot proceed with claim mappings"));
            return spFilteredClaims;
        }
        this.mapRemoteClaimsToLocalClaims(remoteClaims, localUnfilteredClaims, localToIdPClaimMap, defaultValuesForClaims);
        context.setProperty("UNFILTERED_LOCAL_CLAIM_VALUES", localUnfilteredClaims);
        Map<String, String> localToSPClaimMappings = this.mapLocalSpClaimsToRemoteSPClaims(spStandardDialect, context, spClaimMappings);
        this.filterSPClaims(spRequestedClaimMappings, localUnfilteredClaims, spUnfilteredClaims, spFilteredClaims, localToSPClaimMappings);
        context.setProperty("UNFILTERED_SP_CLAIM_VALUES", spUnfilteredClaims);
        if ("openid".equals(context.getRequestType())) {
            spFilteredClaims = spUnfilteredClaims;
        }
        if (spStandardDialect != null) {
            this.setSubjectClaimForFederatedClaims(localUnfilteredClaims, spStandardDialect, context);
        } else {
            this.setSubjectClaimForFederatedClaims(spUnfilteredClaims, null, context);
        }
        UserRealm realm = this.getUserRealm("carbon.super");
        UserStoreManager userStore = this.getUserStoreManager("carbon.super", realm, null);
        this.addMultiAttributeSperatorToRequestedClaims(null, (org.wso2.carbon.user.core.UserStoreManager)userStore, spFilteredClaims);
        return spFilteredClaims;
    }

    private void setMandatoryAndRequestedClaims(ApplicationConfig appConfig, List<org.wso2.carbon.identity.application.common.model.ClaimMapping> selectedRequestedClaims) {
        HashMap<String, String> claimMappings = new HashMap<String, String>();
        HashMap<String, String> requestedClaims = new HashMap<String, String>();
        HashMap<String, String> mandatoryClaims = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(selectedRequestedClaims)) {
            selectedRequestedClaims.stream().filter(claim -> claim.getRemoteClaim() != null && claim.getRemoteClaim().getClaimUri() != null).forEach(claim -> {
                if (claim.getLocalClaim() != null) {
                    this.setClaimsWhenLocalClaimExists((Map<String, String>)claimMappings, (Map<String, String>)requestedClaims, (Map<String, String>)mandatoryClaims, (org.wso2.carbon.identity.application.common.model.ClaimMapping)claim);
                } else {
                    this.setClaimsWhenLocalClaimNotExists((Map<String, String>)claimMappings, (Map<String, String>)requestedClaims, (Map<String, String>)mandatoryClaims, (org.wso2.carbon.identity.application.common.model.ClaimMapping)claim);
                }
            });
        }
        appConfig.setClaimMappings(claimMappings);
        appConfig.setRequestedClaims(requestedClaims);
        appConfig.setMandatoryClaims(mandatoryClaims);
    }

    private void setClaimsWhenLocalClaimNotExists(Map<String, String> claimMappings, Map<String, String> requestedClaims, Map<String, String> mandatoryClaims, org.wso2.carbon.identity.application.common.model.ClaimMapping claim) {
        claimMappings.put(claim.getRemoteClaim().getClaimUri(), null);
        if (claim.isRequested()) {
            requestedClaims.put(claim.getRemoteClaim().getClaimUri(), null);
        }
        if (claim.isMandatory()) {
            mandatoryClaims.put(claim.getRemoteClaim().getClaimUri(), null);
        }
    }

    private void setClaimsWhenLocalClaimExists(Map<String, String> claimMappings, Map<String, String> requestedClaims, Map<String, String> mandatoryClaims, org.wso2.carbon.identity.application.common.model.ClaimMapping claim) {
        claimMappings.put(claim.getRemoteClaim().getClaimUri(), claim.getLocalClaim().getClaimUri());
        if (claim.isRequested()) {
            requestedClaims.put(claim.getRemoteClaim().getClaimUri(), claim.getLocalClaim().getClaimUri());
        }
        if (claim.isMandatory()) {
            mandatoryClaims.put(claim.getRemoteClaim().getClaimUri(), claim.getLocalClaim().getClaimUri());
        }
    }

    private void filterSPClaims(Map<String, String> spRequestedClaimMappings, Map<String, String> localUnfilteredClaims, Map<String, String> spUnfilteredClaims, Map<String, String> spFilteredClaims, Map<String, String> localToSPClaimMappings) {
        localToSPClaimMappings.entrySet().stream().filter(entry -> StringUtils.isNotBlank((String)((String)localUnfilteredClaims.get(entry.getKey())))).forEach(entry -> {
            spUnfilteredClaims.put((String)entry.getValue(), (String)localUnfilteredClaims.get(entry.getKey()));
            if (StringUtils.isNotBlank((String)((String)spRequestedClaimMappings.get(entry.getValue())))) {
                spFilteredClaims.put((String)entry.getValue(), (String)localUnfilteredClaims.get(entry.getKey()));
            }
        });
    }

    private Map<String, String> mapLocalSpClaimsToRemoteSPClaims(String spStandardDialect, AuthenticationContext context, Map<String, String> spClaimMappings) throws FrameworkException {
        Map<String, String> localToSPClaimMappings = null;
        if (spStandardDialect != null) {
            try {
                localToSPClaimMappings = this.getClaimMappings(spStandardDialect, null, context.getTenantDomain(), true);
            }
            catch (Exception e) {
                throw new FrameworkException("Error occurred while getting all claim mappings from " + spStandardDialect + " dialect to " + "http://wso2.org/claims" + " dialect for " + context.getTenantDomain() + " to handle federated claims", e);
            }
        } else if (!spClaimMappings.isEmpty()) {
            localToSPClaimMappings = FrameworkUtils.getLocalToSPClaimMappings(spClaimMappings);
        } else {
            throw new AssertionError((Object)"Authenticator Error! Authenticator does not have a standard dialect and no custom claim mappings defined for IdP");
        }
        return localToSPClaimMappings;
    }

    private void mapRemoteClaimsToLocalClaims(Map<String, String> remoteClaims, Map<String, String> localUnfilteredClaims, Map<String, String> localToIdPClaimMap, Map<String, String> defaultValuesForClaims) {
        for (Map.Entry<String, String> entry : localToIdPClaimMap.entrySet()) {
            String localClaimURI = entry.getKey();
            String claimValue = remoteClaims.get(localToIdPClaimMap.get(localClaimURI));
            if (StringUtils.isEmpty((String)claimValue)) {
                claimValue = defaultValuesForClaims.get(localClaimURI);
            }
            if (StringUtils.isEmpty((String)claimValue)) continue;
            localUnfilteredClaims.put(localClaimURI, claimValue);
        }
    }

    private Map<String, String> getLocalToIdpClaimMappingWithStandardDialect(Map<String, String> remoteClaims, org.wso2.carbon.identity.application.common.model.ClaimMapping[] idPClaimMappings, AuthenticationContext context, String idPStandardDialect) throws FrameworkException {
        Map<String, String> localToIdPClaimMap;
        if (idPStandardDialect == null) {
            idPStandardDialect = "http://wso2.org/claims";
        }
        try {
            localToIdPClaimMap = this.getClaimMappings(idPStandardDialect, remoteClaims.keySet(), context.getTenantDomain(), true);
        }
        catch (Exception e) {
            throw new FrameworkException("Error occurred while getting claim mappings for received remote claims from " + idPStandardDialect + " dialect to " + "http://wso2.org/claims" + " dialect for " + context.getTenantDomain() + " to handle federated claims", e);
        }
        localToIdPClaimMap.putAll(Arrays.stream(idPClaimMappings).filter(claimMapping -> StringUtils.isNotBlank((String)claimMapping.getDefaultValue()) && !localToIdPClaimMap.containsKey(claimMapping.getLocalClaim().getClaimUri())).collect(Collectors.toMap(claimMapping -> claimMapping.getLocalClaim().getClaimUri(), org.wso2.carbon.identity.application.common.model.ClaimMapping::getDefaultValue)));
        return localToIdPClaimMap;
    }

    private void loadDefaultValuesForClaims(org.wso2.carbon.identity.application.common.model.ClaimMapping[] idPClaimMappings, Map<String, String> defaultValuesForClaims) {
        defaultValuesForClaims.putAll(Arrays.asList(idPClaimMappings).stream().filter(claimMapping -> StringUtils.isNotBlank((String)claimMapping.getDefaultValue())).collect(Collectors.toMap(claimMapping -> claimMapping.getLocalClaim().getClaimUri(), claimMapping -> claimMapping.getDefaultValue())));
    }

    private static String getServiceProviderMappedUserRoles(ApplicationConfig applicationConfig, List<String> locallyMappedUserRoles, String claimSeparator) throws FrameworkException {
        Map<String, String> localToSpRoleMapping = applicationConfig.getRoleMappings();
        if (MapUtils.isNotEmpty(localToSpRoleMapping)) {
            localToSpRoleMapping.entrySet().stream().filter(roleMapping -> locallyMappedUserRoles.contains(roleMapping.getKey())).forEach(roleMapping -> {
                locallyMappedUserRoles.remove(roleMapping.getKey());
                locallyMappedUserRoles.add((String)roleMapping.getValue());
            });
        }
        return StringUtils.join(locallyMappedUserRoles, (String)claimSeparator);
    }

    protected Map<String, String> handleLocalClaims(String spStandardDialect, StepConfig stepConfig, AuthenticationContext context) throws FrameworkException {
        Map<String, String> requestedClaimMappings;
        ApplicationConfig appConfig = context.getSequenceConfig().getApplicationConfig();
        Map<String, String> spToLocalClaimMappings = appConfig.getClaimMappings();
        if (spToLocalClaimMappings == null) {
            spToLocalClaimMappings = new HashMap<String, String>();
        }
        if ((requestedClaimMappings = appConfig.getRequestedClaimMappings()) == null) {
            requestedClaimMappings = new HashMap<String, String>();
        }
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(stepConfig, context);
        String tenantDomain = authenticatedUser.getTenantDomain();
        String tenantAwareUserName = authenticatedUser.getUserName();
        UserRealm realm = this.getUserRealm(tenantDomain);
        if (realm == null) {
            log.warn((Object)"No valid tenant domain provider. No claims returned back");
            return new HashMap<String, String>();
        }
        ClaimManager claimManager = this.getClaimManager(tenantDomain, realm);
        UserStoreManager userStore = this.getUserStoreManager(tenantDomain, realm, authenticatedUser.getUserStoreDomain());
        HashMap<String, String> allSPMappedClaims = new HashMap<String, String>();
        HashMap<String, String> spRequestedClaims = new HashMap<String, String>();
        Map<String, String> allLocalClaims = this.retrieveAllNunNullUserClaimValues(authenticatedUser, claimManager, appConfig, (org.wso2.carbon.user.core.UserStoreManager)userStore);
        allLocalClaims.putAll(context.getRuntimeClaims());
        this.handleRoleClaim(context, allLocalClaims);
        context.setProperty("UNFILTERED_LOCAL_CLAIM_VALUES", allLocalClaims);
        spToLocalClaimMappings = this.getStandardDialectToCarbonMapping(spStandardDialect, context, spToLocalClaimMappings, tenantDomain);
        if (StringUtils.isNotBlank((String)spStandardDialect) && !StringUtils.equals((String)spStandardDialect, (String)"http://wso2.org/claims")) {
            Map<String, String> carbonToStandardClaimMapping = this.getCarbonToStandardDialectMapping(spStandardDialect, context, spToLocalClaimMappings, tenantDomain);
            requestedClaimMappings = this.mapRequestClaimsInStandardDialect(requestedClaimMappings, carbonToStandardClaimMapping);
            context.setProperty("SP_TO_CARBON_CLAIM_MAPPING", requestedClaimMappings);
        }
        this.mapSPClaimsAndFilterRequestedClaims(spToLocalClaimMappings, requestedClaimMappings, allLocalClaims, allSPMappedClaims, spRequestedClaims);
        context.setProperty("UNFILTERED_SP_CLAIM_VALUES", allSPMappedClaims);
        if (spStandardDialect != null) {
            this.setSubjectClaimForLocalClaims(tenantAwareUserName, userStore, allLocalClaims, spStandardDialect, context);
        } else {
            this.setSubjectClaimForLocalClaims(tenantAwareUserName, userStore, allSPMappedClaims, null, context);
        }
        if ("openid".equals(context.getRequestType())) {
            spRequestedClaims = allSPMappedClaims;
        }
        this.addMultiAttributeSperatorToRequestedClaims(authenticatedUser, (org.wso2.carbon.user.core.UserStoreManager)userStore, spRequestedClaims);
        return spRequestedClaims;
    }

    private Map<String, String> mapRequestClaimsInStandardDialect(Map<String, String> requestedClaimMappings, Map<String, String> carbonToStandardClaimMapping) {
        if (MapUtils.isEmpty(requestedClaimMappings)) {
            return new HashMap<String, String>();
        }
        return requestedClaimMappings.values().stream().distinct().filter(mapping -> StringUtils.isNotBlank((String)((String)carbonToStandardClaimMapping.get(mapping)))).collect(Collectors.toMap(carbonToStandardClaimMapping::get, Function.identity()));
    }

    private void addMultiAttributeSperatorToRequestedClaims(AuthenticatedUser authenticatedUser, org.wso2.carbon.user.core.UserStoreManager userStore, Map<String, String> spRequestedClaims) {
        RealmConfiguration realmConfiguration;
        String claimSeparator;
        if (!spRequestedClaims.isEmpty() && StringUtils.isNotBlank((String)(claimSeparator = (realmConfiguration = userStore.getRealmConfiguration()).getUserStoreProperty("MultiAttributeSeparator")))) {
            spRequestedClaims.putIfAbsent("MultiAttributeSeparator", claimSeparator);
        }
    }

    private void mapSPClaimsAndFilterRequestedClaims(Map<String, String> spToLocalClaimMappings, Map<String, String> requestedClaimMappings, Map<String, String> allLocalClaims, Map<String, String> allSPMappedClaims, Map<String, String> spRequestedClaims) {
        spToLocalClaimMappings.entrySet().stream().filter(entry -> StringUtils.isNotBlank((String)((String)allLocalClaims.get(entry.getValue())))).forEach(entry -> {
            allSPMappedClaims.put((String)entry.getKey(), (String)allLocalClaims.get(entry.getValue()));
            if (requestedClaimMappings.get(entry.getKey()) != null) {
                spRequestedClaims.put((String)entry.getKey(), (String)allLocalClaims.get(entry.getValue()));
            }
        });
    }

    private Map<String, String> getStandardDialectToCarbonMapping(String spStandardDialect, AuthenticationContext context, Map<String, String> spToLocalClaimMappings, String tenantDomain) throws FrameworkException {
        if (spStandardDialect != null) {
            try {
                spToLocalClaimMappings = this.getClaimMappings(spStandardDialect, null, context.getTenantDomain(), false);
            }
            catch (Exception e) {
                throw new FrameworkException("Error occurred while getting all claim mappings from " + spStandardDialect + " dialect to " + "http://wso2.org/claims" + " dialect for " + tenantDomain + " to handle local claims", e);
            }
        }
        return spToLocalClaimMappings;
    }

    private Map<String, String> getCarbonToStandardDialectMapping(String spStandardDialect, AuthenticationContext context, Map<String, String> spToLocalClaimMappings, String tenantDomain) throws FrameworkException {
        if (spStandardDialect != null) {
            try {
                spToLocalClaimMappings = this.getClaimMappings(spStandardDialect, null, context.getTenantDomain(), true);
            }
            catch (Exception e) {
                throw new FrameworkException("Error occurred while getting all claim mappings from http://wso2.org/claims dialect to " + spStandardDialect + " dialect for " + tenantDomain + " to handle local claims", e);
            }
        }
        return spToLocalClaimMappings;
    }

    private Map<String, String> retrieveAllNunNullUserClaimValues(AuthenticatedUser authenticatedUser, ClaimManager claimManager, ApplicationConfig appConfig, org.wso2.carbon.user.core.UserStoreManager userStore) throws FrameworkException {
        String tenantDomain = authenticatedUser.getTenantDomain();
        String tenantAwareUserName = authenticatedUser.getUserName();
        Map<String, String> allLocalClaims = new HashMap<String, String>();
        try {
            ClaimMapping[] claimMappings = claimManager.getAllClaimMappings("http://wso2.org/claims");
            ArrayList<String> localClaimURIs = new ArrayList<String>();
            for (ClaimMapping mapping : claimMappings) {
                String claimURI = mapping.getClaim().getClaimUri();
                localClaimURIs.add(claimURI);
            }
            allLocalClaims = userStore.getUserClaimValues(tenantAwareUserName, localClaimURIs.toArray(new String[localClaimURIs.size()]), null);
            if (allLocalClaims == null) {
                return new HashMap<String, String>();
            }
        }
        catch (UserStoreException e) {
            if (e.getMessage().contains("UserNotFound")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User " + tenantAwareUserName + " not found in user store"));
                }
            }
            throw new FrameworkException("Error occurred while getting all user claims for " + (Object)((Object)authenticatedUser) + " in " + tenantDomain, e);
        }
        return allLocalClaims;
    }

    private UserStoreManager getUserStoreManager(String tenantDomain, UserRealm realm, String userDomain) throws FrameworkException {
        org.wso2.carbon.user.core.UserStoreManager userStore = null;
        try {
            userStore = realm.getUserStoreManager();
            if (StringUtils.isNotBlank((String)userDomain)) {
                userStore = realm.getUserStoreManager().getSecondaryUserStoreManager(userDomain);
            }
            if (userStore == null) {
                throw new FrameworkException("Invalid user store domain name : " + userDomain + " in tenant : " + tenantDomain);
            }
        }
        catch (UserStoreException e) {
            throw new FrameworkException("Error occurred while retrieving the UserStoreManager from Realm for " + tenantDomain + " to handle local claims", e);
        }
        return userStore;
    }

    private ClaimManager getClaimManager(String tenantDomain, UserRealm realm) throws FrameworkException {
        org.wso2.carbon.user.core.claim.ClaimManager claimManager = null;
        try {
            claimManager = realm.getClaimManager();
        }
        catch (UserStoreException e) {
            throw new FrameworkException("Error occurred while retrieving the ClaimManager from Realm for " + tenantDomain + " to handle local claims", e);
        }
        return claimManager;
    }

    private UserRealm getUserRealm(String tenantDomain) throws FrameworkException {
        UserRealm realm;
        try {
            realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)FrameworkServiceComponent.getRegistryService(), (RealmService)FrameworkServiceComponent.getRealmService(), (String)tenantDomain);
        }
        catch (CarbonException e) {
            throw new FrameworkException("Error occurred while retrieving the Realm for " + tenantDomain + " to handle local claims", e);
        }
        return realm;
    }

    private AuthenticatedUser getAuthenticatedUser(StepConfig stepConfig, AuthenticationContext context) {
        AuthenticatedUser authenticatedUser;
        if (stepConfig != null) {
            authenticatedUser = stepConfig.getAuthenticatedUser();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authenticated user found from step config.");
            }
        } else {
            authenticatedUser = context.getSequenceConfig().getAuthenticatedUser();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Authenticated user found from authentication context.");
            }
        }
        return authenticatedUser;
    }

    private void setSubjectClaimForFederatedClaims(Map<String, String> attributesMap, String spStandardDialect, AuthenticationContext context) {
        String subjectURI = context.getSequenceConfig().getApplicationConfig().getSubjectClaimUri();
        if (subjectURI != null && !subjectURI.isEmpty()) {
            if (spStandardDialect != null) {
                this.setSubjectClaim(null, null, attributesMap, spStandardDialect, context);
                if (context.getProperty(SERVICE_PROVIDER_SUBJECT_CLAIM_VALUE) == null) {
                    log.warn((Object)"Subject claim could not be found amongst locally mapped unfiltered remote claims");
                }
            } else {
                this.setSubjectClaim(null, null, attributesMap, null, context);
                if (context.getProperty(SERVICE_PROVIDER_SUBJECT_CLAIM_VALUE) == null) {
                    log.warn((Object)"Subject claim could not be found amongst service provider mapped unfiltered remote claims");
                }
            }
        }
    }

    private void setSubjectClaimForLocalClaims(String tenantAwareUserId, UserStoreManager userStore, Map<String, String> attributesMap, String spStandardDialect, AuthenticationContext context) {
        String subjectURI = context.getSequenceConfig().getApplicationConfig().getSubjectClaimUri();
        if (subjectURI != null && !subjectURI.isEmpty()) {
            if (spStandardDialect != null) {
                this.setSubjectClaim(tenantAwareUserId, userStore, attributesMap, spStandardDialect, context);
                if (context.getProperty(SERVICE_PROVIDER_SUBJECT_CLAIM_VALUE) == null) {
                    log.warn((Object)"Subject claim could not be found amongst unfiltered local claims");
                }
            } else {
                this.setSubjectClaim(tenantAwareUserId, userStore, attributesMap, null, context);
                if (context.getProperty(SERVICE_PROVIDER_SUBJECT_CLAIM_VALUE) == null) {
                    log.warn((Object)"Subject claim could not be found amongst service provider mapped unfiltered local claims");
                }
            }
        }
    }

    private void setSubjectClaim(String tenantAwareUserId, UserStoreManager userStore, Map<String, String> attributesMap, String spStandardDialect, AuthenticationContext context) {
        String subjectURI = context.getSequenceConfig().getApplicationConfig().getSubjectClaimUri();
        ApplicationConfig applicationConfig = context.getSequenceConfig().getApplicationConfig();
        ServiceProvider serviceProvider = applicationConfig.getServiceProvider();
        ClaimConfig claimConfig = serviceProvider.getClaimConfig();
        boolean isLocalClaimDialect = claimConfig.isLocalClaimDialect();
        Map<String, String> spToLocalClaimMappings = applicationConfig.getClaimMappings();
        if (subjectURI != null) {
            if (!isLocalClaimDialect && spStandardDialect != null && spToLocalClaimMappings != null) {
                subjectURI = spToLocalClaimMappings.get(subjectURI);
            }
            if (attributesMap.get(subjectURI) != null) {
                context.setProperty(SERVICE_PROVIDER_SUBJECT_CLAIM_VALUE, attributesMap.get(subjectURI));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting 'ServiceProviderSubjectClaimValue' property value from attribute map " + attributesMap.get(subjectURI)));
                }
            } else {
                log.debug((Object)"Subject claim not found among attributes");
            }
            if (tenantAwareUserId == null || userStore == null) {
                log.debug((Object)"Tenant aware username or user store 'NULL'. Possibly federated case");
                return;
            }
            if (spStandardDialect != null) {
                this.setSubjectClaimForStandardDialect(tenantAwareUserId, userStore, context, subjectURI);
            }
        }
    }

    private void setSubjectClaimForStandardDialect(String tenantAwareUserId, UserStoreManager userStore, AuthenticationContext context, String subjectURI) {
        try {
            String value = userStore.getUserClaimValue(tenantAwareUserId, subjectURI, null);
            if (value != null) {
                context.setProperty(SERVICE_PROVIDER_SUBJECT_CLAIM_VALUE, value);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting 'ServiceProviderSubjectClaimValue' property value from user store " + value));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Subject claim for " + tenantAwareUserId + " not found in user store"));
            }
        }
        catch (UserStoreException e) {
            log.error((Object)("Error occurred while retrieving " + subjectURI + " claim value for user " + tenantAwareUserId), (Throwable)e);
        }
    }

    private Map<String, String> getClaimMappings(String otherDialect, Set<String> keySet, String tenantDomain, boolean useLocalDialectAsKey) throws FrameworkException {
        HashMap claimMapping = null;
        try {
            claimMapping = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(otherDialect, keySet, tenantDomain, useLocalDialectAsKey);
        }
        catch (ClaimMetadataException e) {
            throw new FrameworkException("Error while loading mappings.", e);
        }
        if (claimMapping == null) {
            claimMapping = new HashMap();
        }
        return claimMapping;
    }

    protected String getStandardDialect(String clientType, ApplicationConfig appConfig) {
        Map<String, String> claimMappings = appConfig.getClaimMappings();
        if ("oidc".equals(clientType)) {
            return "http://wso2.org/oidc/claim";
        }
        if ("sts".equals(clientType)) {
            return "http://schemas.xmlsoap.org/ws/2005/05/identity";
        }
        if ("openid".equals(clientType)) {
            return "http://axschema.org";
        }
        if ("scim".equals(clientType)) {
            return "urn:scim:schemas:core:1.0";
        }
        if ("wso2".equals(clientType)) {
            return "http://wso2.org/claims";
        }
        if (claimMappings == null || claimMappings.isEmpty()) {
            return "http://wso2.org/claims";
        }
        boolean isAtLeastOneNotEqual = false;
        for (Map.Entry<String, String> entry : claimMappings.entrySet()) {
            if (entry.getKey().equals(entry.getValue())) continue;
            isAtLeastOneNotEqual = true;
            break;
        }
        if (!isAtLeastOneNotEqual) {
            return "http://wso2.org/claims";
        }
        return null;
    }

    private void logInput(Map<String, String> remoteClaims, boolean isFederatedClaims) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (remoteClaims != null) {
            for (Map.Entry<String, String> entry : remoteClaims.entrySet()) {
                sb.append(entry.getKey());
                sb.append(":");
                sb.append(entry.getValue());
                sb.append(",");
            }
        }
        sb.append("]");
        log.debug((Object)("Executing claim handler. isFederatedClaims = " + isFederatedClaims + " and remote claims = " + sb.toString()));
    }

    private void logOutput(Map<String, String> returningClaims, AuthenticationContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<String, String> entry : returningClaims.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
            sb.append(",");
        }
        sb.append("]");
        log.debug((Object)("Returning claims from claim handler = " + sb.toString()));
        Map claimsProperty = (Map)context.getProperty("UNFILTERED_IDP_CLAIM_VALUES");
        if (claimsProperty != null) {
            sb = new StringBuilder();
            sb.append("[");
            for (Map.Entry entry : claimsProperty.entrySet()) {
                sb.append((String)entry.getKey());
                sb.append(":");
                sb.append((String)entry.getValue());
                sb.append(",");
            }
            sb.append("]");
        }
        log.debug((Object)("UNFILTERED_IDP_CLAIM_VALUES map property set to " + sb.toString()));
        claimsProperty = (Map)context.getProperty("UNFILTERED_LOCAL_CLAIM_VALUES");
        if (claimsProperty != null) {
            sb = new StringBuilder();
            sb.append("[");
            for (Map.Entry entry : claimsProperty.entrySet()) {
                sb.append((String)entry.getKey());
                sb.append(":");
                sb.append((String)entry.getValue());
                sb.append(",");
            }
            sb.append("]");
        }
        log.debug((Object)("UNFILTERED_LOCAL_CLAIM_VALUES map property set to " + sb.toString()));
        claimsProperty = (Map)context.getProperty("UNFILTERED_SP_CLAIM_VALUES");
        if (claimsProperty != null) {
            sb = new StringBuilder();
            sb.append("[");
            for (Map.Entry entry : claimsProperty.entrySet()) {
                sb.append((String)entry.getKey());
                sb.append(":");
                sb.append((String)entry.getValue());
                sb.append(",");
            }
            sb.append("]");
        }
        log.debug((Object)("UNFILTERED_SP_CLAIM_VALUES map property set to " + sb.toString()));
    }

    private boolean useLocalClaimDialectForClaimMappings() {
        return FileBasedConfigurationBuilder.getInstance().isCustomClaimMappingsForAuthenticatorsAllowed();
    }

    private void handleRoleClaim(AuthenticationContext context, Map<String, String> mappedAttrs) {
        if (mappedAttrs.containsKey("http://wso2.org/claims/role")) {
            String[] groups = mappedAttrs.get("http://wso2.org/claims/role").split(Pattern.quote(FrameworkUtils.getMultiAttributeSeparator()));
            SequenceConfig sequenceConfig = context.getSequenceConfig();
            if (DefaultClaimHandler.isRemoveUserDomainInRole(sequenceConfig)) {
                mappedAttrs.put("http://wso2.org/claims/role", FrameworkUtils.removeDomainFromNamesExcludeHybrid(Arrays.asList(groups)));
            }
        }
    }

    private static boolean isRemoveUserDomainInRole(SequenceConfig sequenceConfig) {
        return !sequenceConfig.getApplicationConfig().getServiceProvider().getLocalAndOutBoundAuthenticationConfig().isUseUserstoreDomainInRoles();
    }
}

