/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.handler.claims.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.handler.claims.ClaimFilter;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;

public class DefaultClaimFilter
implements ClaimFilter {
    private static int priority = 0;
    private static final Log log = LogFactory.getLog(DefaultClaimFilter.class);

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public List<ClaimMapping> getFilteredClaims(AuthenticationContext context, ApplicationConfig appConfig) {
        List<ClaimMapping> spClaimMappings = this.getSpClaimMappings(appConfig);
        List requestedClaimsInRequest = null;
        if (context != null) {
            requestedClaimsInRequest = (List)context.getProperty("SP_REQUESTED_CLAIMS_IN_REQUEST");
        }
        return this.filterRequestedClaims(spClaimMappings, requestedClaimsInRequest);
    }

    @Override
    public List<ClaimMapping> filterRequestedClaims(List<ClaimMapping> spClaimMappings, List<ClaimMapping> requestedClaimsInRequest) {
        ArrayList<ClaimMapping> selectedRequestedClaims = new ArrayList<ClaimMapping>();
        if (this.requestedClaimsFromRequest(spClaimMappings, requestedClaimsInRequest)) {
            selectedRequestedClaims.addAll(requestedClaimsInRequest);
        } else if (this.requestedClaimsFromSpConfig(spClaimMappings, requestedClaimsInRequest)) {
            selectedRequestedClaims.addAll(spClaimMappings);
        } else if (this.requestedClaimsFromSpConfigAndRequest(spClaimMappings, requestedClaimsInRequest)) {
            for (ClaimMapping claimMappingInSPConfig : spClaimMappings) {
                for (ClaimMapping claimMappingInRequest : requestedClaimsInRequest) {
                    if (!claimMappingInRequest.getRemoteClaim().equals((Object)claimMappingInSPConfig.getRemoteClaim())) continue;
                    claimMappingInRequest.setLocalClaim(claimMappingInSPConfig.getLocalClaim());
                    selectedRequestedClaims.add(claimMappingInRequest);
                }
            }
        }
        return selectedRequestedClaims;
    }

    private List<ClaimMapping> getSpClaimMappings(ApplicationConfig appConfig) {
        Map<String, String> spClaimMapping = appConfig.getClaimMappings();
        Map<String, String> mandatoryClaims = appConfig.getMandatoryClaimMappings();
        Map<String, String> requestedClaims = appConfig.getRequestedClaimMappings();
        ArrayList<ClaimMapping> spClaimMappingsList = new ArrayList<ClaimMapping>();
        spClaimMapping.forEach((key, value) -> {
            ClaimMapping claimMapping = ClaimMapping.build((String)value, (String)key, null, (boolean)false);
            mandatoryClaims.entrySet().stream().filter(entry1 -> key.equals(entry1.getKey())).map(entry1 -> true).forEach(arg_0 -> ((ClaimMapping)claimMapping).setMandatory(arg_0));
            requestedClaims.entrySet().stream().filter(entry2 -> key.equals(entry2.getKey())).map(entry2 -> true).forEach(arg_0 -> ((ClaimMapping)claimMapping).setRequested(arg_0));
            spClaimMappingsList.add(claimMapping);
        });
        return spClaimMappingsList;
    }

    private boolean requestedClaimsFromSpConfigAndRequest(List<ClaimMapping> claimMappings, List<ClaimMapping> requestedClaimsInRequest) {
        return !CollectionUtils.isEmpty(claimMappings) && !CollectionUtils.isEmpty(requestedClaimsInRequest);
    }

    private boolean requestedClaimsFromSpConfig(List<ClaimMapping> claimMappings, List<ClaimMapping> requestedClaimsInRequest) {
        return !CollectionUtils.isEmpty(claimMappings) && CollectionUtils.isEmpty(requestedClaimsInRequest);
    }

    private boolean requestedClaimsFromRequest(List<ClaimMapping> claimMappings, List<ClaimMapping> requestedClaimsInRequest) {
        return CollectionUtils.isEmpty(claimMappings) && !CollectionUtils.isEmpty(requestedClaimsInRequest);
    }
}

