/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.dao.impl;

import java.util.HashMap;
import java.util.List;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.application.authentication.framework.dao.UserSessionDAO;
import org.wso2.carbon.identity.application.authentication.framework.exception.session.mgt.SessionManagementServerException;
import org.wso2.carbon.identity.application.authentication.framework.model.Application;
import org.wso2.carbon.identity.application.authentication.framework.model.UserSession;
import org.wso2.carbon.identity.application.authentication.framework.util.JdbcUtils;
import org.wso2.carbon.identity.application.authentication.framework.util.SessionMgtConstants;

public class UserSessionDAOImpl
implements UserSessionDAO {
    @Override
    public UserSession getSession(String sessionId) throws SessionManagementServerException {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            List applicationList = jdbcTemplate.executeQuery("SELECT SUBJECT, APP_NAME , APP_ID, UUID FROM IDN_AUTH_SESSION_APP_INFO SESSION_STORE, SP_APP APP where SESSION_STORE.APP_ID = APP.ID AND SESSION_ID = ?", (resultSet, rowNumber) -> new Application(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4)), preparedStatement -> preparedStatement.setString(1, sessionId));
            jdbcTemplate.executeQuery("SELECT PROPERTY_TYPE, VALUE FROM IDN_AUTH_SESSION_META_DATA WHERE SESSION_ID = ?", (resultSet, rowNumber) -> propertiesMap.put(resultSet.getString(1), resultSet.getString(2)), preparedStatement -> preparedStatement.setString(1, sessionId));
            UserSession userSession = new UserSession();
            userSession.setSessionId(sessionId);
            propertiesMap.forEach((key, value) -> {
                switch (key) {
                    case "User Agent": {
                        userSession.setUserAgent((String)value);
                        break;
                    }
                    case "IP": {
                        userSession.setIp((String)value);
                        break;
                    }
                    case "Last Access Time": {
                        userSession.setLastAccessTime((String)value);
                        break;
                    }
                    case "Login Time": {
                        userSession.setLoginTime((String)value);
                    }
                }
            });
            if (!applicationList.isEmpty()) {
                userSession.setApplications(applicationList);
                return userSession;
            }
        }
        catch (DataAccessException e) {
            throw new SessionManagementServerException(SessionMgtConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_GET_SESSION, SessionMgtConstants.ErrorMessages.ERROR_CODE_UNABLE_TO_GET_SESSION.getDescription(), e);
        }
        return null;
    }
}

