/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.dao.LongWaitStatusDAO;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.model.LongWaitStatus;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;

public class LongWaitStatusDAOImpl
implements LongWaitStatusDAO {
    private static final Log log = LogFactory.getLog(LongWaitStatusDAOImpl.class);

    @Override
    public void addWaitStatus(int tenantId, String waitKey, LongWaitStatus status, Timestamp createdTime, Timestamp expireTime) throws FrameworkException {
        String query = "INSERT INTO IDN_AUTH_WAIT_STATUS (TENANT_ID, LONG_WAIT_KEY, WAIT_STATUS, TIME_CREATED, EXPIRE_TIME) VALUES (?, ?, ?, ?, ?)";
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement addPrepStmt = connection.prepareStatement(query);){
                addPrepStmt.setInt(1, tenantId);
                addPrepStmt.setString(2, waitKey);
                if (LongWaitStatus.Status.WAITING == status.getStatus()) {
                    addPrepStmt.setString(3, "1");
                } else {
                    addPrepStmt.setString(3, "0");
                }
                addPrepStmt.setTimestamp(4, createdTime);
                addPrepStmt.setTimestamp(5, expireTime);
                addPrepStmt.execute();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added wait status for wait key: " + waitKey));
                }
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new FrameworkException("Error while adding wait status for key:" + waitKey, e);
            }
        }
        catch (SQLException e) {
            throw new FrameworkException("Error while adding wait status for key:" + waitKey, e);
        }
    }

    @Override
    public void removeWaitStatus(String waitKey) throws FrameworkException {
        String query = "DELETE FROM IDN_AUTH_WAIT_STATUS WHERE LONG_WAIT_KEY=?";
        try (Connection connection = IdentityDatabaseUtil.getDBConnection();){
            try (PreparedStatement addPrepStmt = connection.prepareStatement(query);){
                addPrepStmt.setString(1, waitKey);
                addPrepStmt.execute();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removed wait status for wait key: " + waitKey));
                }
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new FrameworkException("Error while removing wait status with key:" + waitKey, e);
            }
        }
        catch (SQLException e) {
            throw new FrameworkException("Error while removing wait status with key:" + waitKey, e);
        }
    }

    @Override
    public LongWaitStatus getWaitStatus(String waitKey) throws FrameworkException {
        String query = "SELECT WAIT_STATUS FROM IDN_AUTH_WAIT_STATUS WHERE LONG_WAIT_KEY=?";
        LongWaitStatus longWaitStatus = new LongWaitStatus();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement addPrepStmt = connection.prepareStatement(query);){
                addPrepStmt.setString(1, waitKey);
                try (ResultSet resultSet = addPrepStmt.executeQuery();){
                    if (resultSet.next()) {
                        String wait_status = resultSet.getString("WAIT_STATUS");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Searched for wait status for wait key: " + waitKey + ". Result: " + ("1".equals(wait_status) ? "WAITING" : "COMPLETED")));
                        }
                        if (wait_status.equals("1")) {
                            longWaitStatus.setStatus(LongWaitStatus.Status.WAITING);
                        } else {
                            longWaitStatus.setStatus(LongWaitStatus.Status.COMPLETED);
                        }
                    } else {
                        longWaitStatus.setStatus(LongWaitStatus.Status.UNKNOWN);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Searched for wait status for wait key: " + waitKey + ". Result: UNKNOWN"));
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new FrameworkException("Error while searching for wait status with key:" + waitKey, e);
            }
        }
        catch (SQLException e) {
            throw new FrameworkException("Error while searching for wait status with key:" + waitKey, e);
        }
        if (longWaitStatus.getStatus() == null) {
            longWaitStatus.setStatus(LongWaitStatus.Status.UNKNOWN);
        }
        return longWaitStatus;
    }
}

