/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.dao.impl;

import java.sql.Timestamp;
import org.wso2.carbon.identity.application.authentication.framework.cache.LongWaitResultCache;
import org.wso2.carbon.identity.application.authentication.framework.cache.LongWaitResultCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.LongWaitResultCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.dao.LongWaitStatusDAO;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.model.LongWaitStatus;

public class CacheBackedLongWaitStatusDAO
implements LongWaitStatusDAO {
    private LongWaitStatusDAO waitStatusDAO;

    public CacheBackedLongWaitStatusDAO(LongWaitStatusDAO waitStatusDAO) {
        this.waitStatusDAO = waitStatusDAO;
    }

    @Override
    public void addWaitStatus(int tenantId, String waitKey, LongWaitStatus status, Timestamp createdTime, Timestamp expireTime) throws FrameworkException {
        if (waitKey != null) {
            this.waitStatusDAO.addWaitStatus(tenantId, waitKey, status, createdTime, expireTime);
            LongWaitResultCacheKey cacheKey = new LongWaitResultCacheKey(waitKey);
            LongWaitResultCacheEntry cacheEntry = new LongWaitResultCacheEntry(status);
            LongWaitResultCache.getInstance().addToCache(cacheKey, cacheEntry);
        }
    }

    @Override
    public void removeWaitStatus(String waitKey) throws FrameworkException {
        this.waitStatusDAO.removeWaitStatus(waitKey);
        LongWaitResultCacheKey cacheKey = new LongWaitResultCacheKey(waitKey);
        LongWaitStatus status = new LongWaitStatus();
        status.setStatus(LongWaitStatus.Status.UNKNOWN);
        LongWaitResultCacheEntry cacheEntry = new LongWaitResultCacheEntry(status);
        LongWaitResultCache.getInstance().addToCache(cacheKey, cacheEntry);
    }

    @Override
    public LongWaitStatus getWaitStatus(String waitKey) throws FrameworkException {
        LongWaitStatus status = null;
        LongWaitResultCacheEntry valueFromCache = LongWaitResultCache.getInstance().getValueFromCache(new LongWaitResultCacheKey(waitKey));
        if (valueFromCache != null) {
            status = valueFromCache.getWaitStatus();
        }
        if (status == null) {
            status = this.waitStatusDAO.getWaitStatus(waitKey);
            LongWaitResultCacheKey cacheKey = new LongWaitResultCacheKey(waitKey);
            LongWaitResultCacheEntry cacheEntry = new LongWaitResultCacheEntry(status);
            LongWaitResultCache.getInstance().addToCache(cacheKey, cacheEntry);
        }
        return status;
    }
}

