/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthHistory;

public class SessionAuthHistory
implements Serializable {
    private static final long serialVersionUID = -4403150321922576472L;
    private String selectedAcrValue;
    private DateTime sessionCreatedTime;
    private LinkedList<AuthHistory> authenticationStepHistory = new LinkedList();

    public String getSelectedAcrValue() {
        return this.selectedAcrValue;
    }

    public void setSelectedAcrValue(String selectedAcrValue) {
        this.selectedAcrValue = selectedAcrValue;
    }

    public void push(AuthHistory historyElement) {
        this.authenticationStepHistory.addLast(historyElement);
    }

    public AuthHistory undo() {
        return this.authenticationStepHistory.removeLast();
    }

    public AuthHistory undoUpto(AuthHistory historyElement) {
        LinkedList<AuthHistory> modifyingHistory = new LinkedList<AuthHistory>();
        AuthHistory matchedEntry = null;
        for (AuthHistory historyEntry : this.authenticationStepHistory) {
            if (historyEntry.equals(historyElement)) {
                matchedEntry = historyEntry;
                break;
            }
            modifyingHistory.add(historyEntry);
        }
        if (matchedEntry != null) {
            this.authenticationStepHistory = modifyingHistory;
        }
        return matchedEntry;
    }

    public List<AuthHistory> getHistory() {
        return Collections.unmodifiableList(this.authenticationStepHistory);
    }

    public void resetHistory(List<AuthHistory> authHistories) {
        this.authenticationStepHistory = new LinkedList<AuthHistory>(authHistories);
    }

    public DateTime getSessionCreatedTime() {
        return this.sessionCreatedTime;
    }

    public void setSessionCreatedTime(DateTime sessionCreatedTime) {
        this.sessionCreatedTime = sessionCreatedTime;
    }
}

