/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorStateInfo;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AcrRule;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthHistory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticationRequest;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.bean.context.MessageContext;

public class AuthenticationContext
extends MessageContext
implements Serializable {
    private static final long serialVersionUID = 6438291349985653402L;
    private String contextIdentifier;
    private String sessionIdentifier;
    private String callerPath;
    private String callerSessionKey;
    private String relyingParty;
    private String queryParams;
    private String requestType;
    private boolean isLogoutRequest;
    private int currentStep;
    private SequenceConfig sequenceConfig;
    private ExternalIdPConfig externalIdP;
    private boolean rememberMe;
    private String tenantDomain;
    private int retryCount;
    private int currentPostAuthHandlerIndex = 0;
    private Map<String, String> authenticatorProperties = new HashMap<String, String>();
    private String serviceProviderName;
    private String contextIdIncludedQueryParams;
    private String currentAuthenticator;
    private Map<String, Serializable> endpointParams = new HashMap<String, Serializable>();
    private boolean forceAuthenticate;
    private boolean reAuthenticate;
    private boolean passiveAuthenticate;
    private boolean previousAuthTime;
    private AuthenticationRequest authenticationRequest;
    private Map<String, AuthenticatedIdPData> previousAuthenticatedIdPs = new HashMap<String, AuthenticatedIdPData>();
    private Map<String, AuthenticatedIdPData> currentAuthenticatedIdPs = new HashMap<String, AuthenticatedIdPData>();
    private volatile boolean activeInAThread;
    private boolean requestAuthenticated = true;
    private boolean returning;
    private boolean retrying;
    private boolean previousSessionFound;
    private List<AuthHistory> authenticationStepHistory = new ArrayList<AuthHistory>();
    private List<String> requestedAcr;
    private AcrRule acrRule = AcrRule.EXACT;
    private String selectedAcr;
    private AuthenticatedUser lastAuthenticatedUser;
    private AuthenticatedUser subject;
    private AuthenticatorStateInfo stateInfo;
    private List<String> executedPostAuthHandlers = new ArrayList<String>();

    public String getCallerPath() {
        return this.callerPath;
    }

    public void setCallerPath(String callerPath) {
        this.callerPath = callerPath;
    }

    public String getCallerSessionKey() {
        return this.callerSessionKey;
    }

    public void setCallerSessionKey(String callerSessionKey) {
        this.callerSessionKey = callerSessionKey;
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(String queryParams) {
        this.queryParams = queryParams;
    }

    public void setOrignalRequestQueryParams(String queryParams) {
        this.queryParams = queryParams;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public boolean isLogoutRequest() {
        return this.isLogoutRequest;
    }

    public void setLogoutRequest(boolean isLogoutRequest) {
        this.isLogoutRequest = isLogoutRequest;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public SequenceConfig getSequenceConfig() {
        return this.sequenceConfig;
    }

    public void setSequenceConfig(SequenceConfig sequenceConfig) {
        this.sequenceConfig = sequenceConfig;
    }

    public AuthenticatedUser getSubject() {
        return this.subject;
    }

    public void setSubject(AuthenticatedUser subject) {
        this.subject = subject;
        if (subject != null) {
            this.lastAuthenticatedUser = subject;
        }
    }

    public String getContextIdentifier() {
        return this.contextIdentifier;
    }

    public void setContextIdentifier(String contextIdentifier) {
        this.contextIdentifier = contextIdentifier;
    }

    public boolean isRequestAuthenticated() {
        return this.requestAuthenticated;
    }

    public void setRequestAuthenticated(boolean requestAuthenticated) {
        this.requestAuthenticated = requestAuthenticated;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public String getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    public void setSessionIdentifier(String sessionIdentifier) {
        this.sessionIdentifier = sessionIdentifier;
    }

    public Map<String, Object> getProperties() {
        return this.parameters;
    }

    public void setProperties(Map<String, Object> properties) {
        this.parameters = properties;
    }

    public void setProperty(String key, Object value) {
        this.parameters.put(key, value);
    }

    public void removeProperty(String key) {
        this.parameters.remove(key);
    }

    public Object getProperty(String key) {
        return this.parameters.get(key);
    }

    public ExternalIdPConfig getExternalIdP() {
        return this.externalIdP;
    }

    public void setExternalIdP(ExternalIdPConfig externalIdP) {
        this.externalIdP = externalIdP;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public AuthenticatorStateInfo getStateInfo() {
        return this.stateInfo;
    }

    public void setStateInfo(AuthenticatorStateInfo stateInfo) {
        this.stateInfo = stateInfo;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Map<String, String> getAuthenticatorProperties() {
        return this.authenticatorProperties;
    }

    public void setAuthenticatorProperties(Map<String, String> authenticatorProperties) {
        this.authenticatorProperties = authenticatorProperties;
    }

    public String getServiceProviderName() {
        return this.serviceProviderName;
    }

    public void setServiceProviderName(String serviceProviderName) {
        this.serviceProviderName = serviceProviderName;
    }

    public boolean isForceAuthenticate() {
        return this.forceAuthenticate;
    }

    public void setForceAuthenticate(boolean forceAuthenticate) {
        this.forceAuthenticate = forceAuthenticate;
    }

    public boolean isPassiveAuthenticate() {
        return this.passiveAuthenticate;
    }

    public void setPassiveAuthenticate(boolean passiveAuthenticate) {
        this.passiveAuthenticate = passiveAuthenticate;
    }

    public boolean isReAuthenticate() {
        return this.reAuthenticate;
    }

    public void setReAuthenticate(boolean reAuthenticate) {
        this.reAuthenticate = reAuthenticate;
    }

    public String getContextIdIncludedQueryParams() {
        return this.contextIdIncludedQueryParams;
    }

    public void setContextIdIncludedQueryParams(String contextIdIncludedQueryParams) {
        this.contextIdIncludedQueryParams = contextIdIncludedQueryParams;
    }

    public boolean isReturning() {
        return this.returning;
    }

    public void setReturning(boolean returning) {
        this.returning = returning;
    }

    public Map<String, AuthenticatedIdPData> getCurrentAuthenticatedIdPs() {
        return this.currentAuthenticatedIdPs;
    }

    public void setCurrentAuthenticatedIdPs(Map<String, AuthenticatedIdPData> currentAuthenticatedIdPs) {
        this.currentAuthenticatedIdPs = currentAuthenticatedIdPs;
    }

    public Map<String, AuthenticatedIdPData> getPreviousAuthenticatedIdPs() {
        return this.previousAuthenticatedIdPs;
    }

    public void setPreviousAuthenticatedIdPs(Map<String, AuthenticatedIdPData> previousAuthenticatedIdPs) {
        this.previousAuthenticatedIdPs = previousAuthenticatedIdPs;
    }

    public boolean isRetrying() {
        return this.retrying;
    }

    public void setRetrying(boolean retrying) {
        this.retrying = retrying;
    }

    public String getCurrentAuthenticator() {
        return this.currentAuthenticator;
    }

    public void setCurrentAuthenticator(String currentAuthenticator) {
        this.currentAuthenticator = currentAuthenticator;
    }

    public boolean isPreviousSessionFound() {
        return this.previousSessionFound;
    }

    public void setPreviousSessionFound(boolean previousSessionFound) {
        this.previousSessionFound = previousSessionFound;
    }

    public String getRelyingParty() {
        return this.relyingParty;
    }

    public void setRelyingParty(String relyingParty) {
        this.relyingParty = relyingParty;
    }

    public AuthenticationRequest getAuthenticationRequest() {
        return this.authenticationRequest;
    }

    public void setAuthenticationRequest(AuthenticationRequest authenticationRequest) {
        this.authenticationRequest = authenticationRequest;
    }

    public boolean isPreviousAuthTime() {
        return this.previousAuthTime;
    }

    public void setPreviousAuthTime(boolean previousAuthTime) {
        this.previousAuthTime = previousAuthTime;
    }

    public void addAuthenticationStepHistory(AuthHistory history) {
        this.authenticationStepHistory.add(history);
    }

    public List<AuthHistory> getAuthenticationStepHistory() {
        return Collections.unmodifiableList(this.authenticationStepHistory);
    }

    public AcrRule getAcrRule() {
        return this.acrRule;
    }

    public void setAcrRule(AcrRule acrRule) {
        this.acrRule = acrRule;
    }

    public String getSelectedAcr() {
        return this.selectedAcr;
    }

    public void setSelectedAcr(String selectedAcr) {
        this.selectedAcr = selectedAcr;
    }

    public List<String> getRequestedAcr() {
        if (this.requestedAcr == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.requestedAcr);
    }

    public void addRequestedAcr(String acr) {
        if (this.requestedAcr == null) {
            this.requestedAcr = new ArrayList<String>();
        }
        this.requestedAcr.add(acr);
    }

    public AuthenticatedUser getLastAuthenticatedUser() {
        return this.lastAuthenticatedUser;
    }

    public int getCurrentPostAuthHandlerIndex() {
        return this.currentPostAuthHandlerIndex;
    }

    public List<String> getExecutedPostAuthHandlers() {
        return this.executedPostAuthHandlers;
    }

    public void setExecutedPostAuthHandler(String postAuthHandler) {
        this.executedPostAuthHandlers.add(postAuthHandler);
        ++this.currentPostAuthHandlerIndex;
    }

    public void addAuthenticatorParams(Map<String, Map<String, String>> authenticatorParams) {
        if (MapUtils.isEmpty(authenticatorParams)) {
            return;
        }
        Object runtimeParamsObj = this.getParameter("RUNTIME_PARAMS");
        if (runtimeParamsObj == null) {
            this.addParameter("RUNTIME_PARAMS", authenticatorParams);
            return;
        }
        if (runtimeParamsObj instanceof Map) {
            Map runtimeParams = (Map)runtimeParamsObj;
            for (Map.Entry<String, Map<String, String>> params : authenticatorParams.entrySet()) {
                if (runtimeParams.get(params.getKey()) != null) {
                    ((Map)runtimeParams.get(params.getKey())).putAll(params.getValue());
                    continue;
                }
                runtimeParams.put(params.getKey(), params.getValue());
            }
        } else {
            throw IdentityRuntimeException.error((String)"There is already a object set with RUNTIME_PARAMS key in the message context.");
        }
    }

    public Map<String, String> getAuthenticatorParams(String authenticatorName) {
        Map runtimeParams;
        Map authenticatorParams;
        Object parameter = this.getParameter("RUNTIME_PARAMS");
        if (this.parameters != null && parameter instanceof Map && MapUtils.isNotEmpty((Map)(authenticatorParams = (Map)(runtimeParams = (Map)parameter).get(authenticatorName)))) {
            return authenticatorParams;
        }
        return Collections.emptyMap();
    }

    public void addEndpointParam(String key, Serializable value) {
        this.endpointParams.put(key, value);
    }

    public void addEndpointParams(Map<String, Serializable> params) {
        this.endpointParams.putAll(params);
    }

    public Map<String, Serializable> getEndpointParams() {
        return this.endpointParams;
    }

    public boolean isActiveInAThread() {
        return this.activeInAThread;
    }

    public void setActiveInAThread(boolean activeInAThread) {
        this.activeInAThread = activeInAThread;
    }

    public void initializeAnalyticsData() {
        HashMap analyticsData = new HashMap();
        this.addParameter("dataMap", analyticsData);
        this.setAnalyticsData("authenticationStartTime", Long.valueOf(System.currentTimeMillis()));
    }

    public void setAnalyticsData(String key, Serializable value) {
        HashMap analyticsData = (HashMap)this.getParameter("dataMap");
        analyticsData.put(key, value);
    }

    public Serializable getAnalyticsData(String key) {
        if (this.getParameters().containsKey("dataMap")) {
            HashMap analyticsData = (HashMap)this.getParameter("dataMap");
            return (Serializable)analyticsData.get(key);
        }
        return null;
    }

    public String getRuntimeClaim(String claimUri) {
        Object parameter = this.getProperty("RUNTIME_CLAIMS");
        if (parameter instanceof Map) {
            Map tempClaims = (Map)parameter;
            return (String)tempClaims.get(claimUri);
        }
        return null;
    }

    public void addRuntimeClaim(String claimUri, String claimValue) {
        Object parameter = this.getProperty("RUNTIME_CLAIMS");
        if (parameter instanceof Map) {
            Map tempClaims = (Map)parameter;
            tempClaims.put(claimUri, claimValue);
        } else {
            HashMap<String, String> tempClaims = new HashMap<String, String>();
            tempClaims.put(claimUri, claimValue);
            this.setProperty("RUNTIME_CLAIMS", tempClaims);
        }
    }

    public Map<String, String> getRuntimeClaims() {
        Object parameter = this.getProperty("RUNTIME_CLAIMS");
        if (parameter instanceof Map) {
            return (Map)parameter;
        }
        return Collections.emptyMap();
    }
}

