/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AuthHistory
implements Serializable {
    private static final long serialVersionUID = 6438291340985653402L;
    private String authenticatorName;
    private String idpName;
    private String idpSessionIndex;
    private String requestType;
    private String code;
    private long duration;
    private boolean success;

    public AuthHistory(String authenticatorName, String idpName) {
        this.authenticatorName = authenticatorName;
        this.idpName = idpName;
    }

    public AuthHistory(String authenticatorName, String idpName, String code) {
        this.authenticatorName = authenticatorName;
        this.idpName = idpName;
        this.code = code;
    }

    public void setIdpSessionIndex(String idpSessionIndex) {
        this.idpSessionIndex = idpSessionIndex;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getAuthenticatorName() {
        return this.authenticatorName;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public String getCode() {
        return this.code;
    }

    public String getIdpSessionIndex() {
        return this.idpSessionIndex;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public static List<AuthHistory> merge(List<AuthHistory> ... authHistoriesToJoin) {
        ArrayList<AuthHistory> result = new ArrayList<AuthHistory>();
        if (authHistoriesToJoin != null) {
            for (List<AuthHistory> authHistories : authHistoriesToJoin) {
                if (authHistories == null) continue;
                for (AuthHistory authHistory : authHistories) {
                    if (result.contains(authHistory)) continue;
                    result.add(authHistory);
                }
            }
        }
        return result;
    }

    public String toTranslatableString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.authenticatorName);
        if (this.code != null) {
            builder.append("_").append(this.code);
        }
        return builder.toString();
    }

    public String toString() {
        return AuthHistory.class.getSimpleName() + "{authenticatorName='" + this.authenticatorName + '\'' + ", idpName='" + this.idpName + '\'' + ", code='" + this.code + '\'' + ", idpSessionId='" + this.idpSessionIndex + '\'' + ", requestType='" + this.requestType + '}';
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(11, 13).append((Object)this.authenticatorName).append((Object)this.idpName).append((Object)this.code);
        return hashCodeBuilder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthHistory) {
            AuthHistory rhs = (AuthHistory)obj;
            return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.authenticatorName, (Object)rhs.authenticatorName).append((Object)this.idpName, (Object)rhs.idpName).append((Object)this.code, (Object)rhs.code).isEquals();
        }
        return false;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}

