/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.AbstractJSContextMemberObject;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsAuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsSteps;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;

public class JsStep
extends AbstractJSContextMemberObject {
    private static final Log LOG = LogFactory.getLog(JsSteps.class);
    private int step;
    private String authenticatedIdp;

    public JsStep(int step, String authenticatedIdp) {
        this.step = step;
        this.authenticatedIdp = authenticatedIdp;
    }

    public JsStep(AuthenticationContext context, int step, String authenticatedIdp) {
        this(step, authenticatedIdp);
        this.initializeContext(context);
    }

    public Object getMember(String name) {
        switch (name) {
            case "subject": {
                return new JsAuthenticatedUser(this.getContext(), this.getSubject(), this.step, this.authenticatedIdp);
            }
            case "idp": {
                return this.authenticatedIdp;
            }
            case "options": {
                return this.getOptions();
            }
        }
        return super.getMember(name);
    }

    public boolean hasMember(String name) {
        switch (name) {
            case "subject": {
                return true;
            }
            case "idp": {
                return true;
            }
        }
        return super.hasMember(name);
    }

    public void removeMember(String name) {
        LOG.warn((Object)"Step is readonly, hence the can't remove the member.");
    }

    public void setMember(String name, Object value) {
        LOG.warn((Object)"Step is readonly, hence the setter is ignored.");
    }

    private AuthenticatedUser getSubject() {
        if (this.authenticatedIdp != null) {
            AuthenticatedIdPData idPData = this.getContext().getCurrentAuthenticatedIdPs().get(this.authenticatedIdp);
            if (idPData == null) {
                idPData = this.getContext().getPreviousAuthenticatedIdPs().get(this.authenticatedIdp);
            }
            if (idPData != null) {
                return idPData.getUser();
            }
        }
        return null;
    }

    private List<Map<String, String>> getOptions() {
        ArrayList<Map<String, String>> optionsList = new ArrayList<Map<String, String>>();
        Optional<StepConfig> optionalStepConfig = this.getContext().getSequenceConfig().getStepMap().values().stream().filter(stepConfig -> stepConfig.getOrder() == this.step).findFirst();
        optionalStepConfig.ifPresent(stepConfig -> stepConfig.getAuthenticatorList().forEach(authConfig -> authConfig.getIdpNames().forEach(name -> {
            HashMap<String, String> option = new HashMap<String, String>();
            option.put("idp", (String)name);
            option.put("authenticator", authConfig.getApplicationAuthenticator().getName());
            optionsList.add(option);
        })));
        return optionsList;
    }
}

