/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js;

import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.AbstractJSObjectWrapper;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsCookie;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsParameters;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsWritableParameters;
import org.wso2.carbon.identity.application.authentication.framework.context.TransientObjectWrapper;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class JsServletRequest
extends AbstractJSObjectWrapper<TransientObjectWrapper<HttpServletRequest>> {
    public JsServletRequest(TransientObjectWrapper<HttpServletRequest> wrapped) {
        super(wrapped);
    }

    public Object getMember(String name) {
        switch (name) {
            case "headers": {
                HashMap<String, String> headers = new HashMap<String, String>();
                Enumeration headerNames = this.getRequest().getHeaderNames();
                if (headerNames != null) {
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        headers.put(headerName, this.getRequest().getHeader(headerName));
                    }
                }
                return new JsWritableParameters(headers);
            }
            case "params": {
                return new JsParameters(this.getRequest().getParameterMap());
            }
            case "cookies": {
                HashMap<String, JsCookie> cookies = new HashMap<String, JsCookie>();
                Cookie[] cookieArr = this.getRequest().getCookies();
                if (cookieArr != null) {
                    for (Cookie cookie : cookieArr) {
                        cookies.put(cookie.getName(), new JsCookie(cookie));
                    }
                }
                return new JsWritableParameters(cookies);
            }
            case "ip": {
                return IdentityUtil.getClientIpAddress((HttpServletRequest)this.getRequest());
            }
        }
        return super.getMember(name);
    }

    public boolean hasMember(String name) {
        if (this.getRequest() == null) {
            return false;
        }
        switch (name) {
            case "headers": {
                return this.getRequest().getHeaderNames() != null;
            }
            case "params": {
                return this.getRequest().getParameterMap() != null;
            }
            case "cookies": {
                return this.getRequest().getCookies() != null;
            }
        }
        return super.hasMember(name);
    }

    private HttpServletRequest getRequest() {
        TransientObjectWrapper transientObjectWrapper = (TransientObjectWrapper)this.getWrapped();
        return (HttpServletRequest)transientObjectWrapper.getWrapped();
    }
}

