/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js;

import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsClaims;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;

public class JsRuntimeClaims
extends JsClaims {
    public JsRuntimeClaims(AuthenticationContext context, int step, String idp) {
        super(context, step, idp, false);
    }

    public JsRuntimeClaims(AuthenticationContext context, AuthenticatedUser user) {
        super(context, user, false);
    }

    @Override
    public Object getMember(String claimUri) {
        if (this.authenticatedUser != null) {
            return this.getRuntimeClaim(claimUri);
        }
        return null;
    }

    @Override
    public boolean hasMember(String claimUri) {
        if (this.authenticatedUser != null) {
            return this.hasRuntimeClaim(claimUri);
        }
        return false;
    }

    @Override
    public void setMember(String claimUri, Object claimValue) {
        if (this.authenticatedUser != null) {
            this.setRuntimeClaim(claimUri, claimValue);
        }
    }

    private Object getRuntimeClaim(String claimUri) {
        String runtimeClaimValue = this.getContext().getRuntimeClaim(claimUri);
        if (runtimeClaimValue != null) {
            return runtimeClaimValue;
        }
        if (this.isFederatedIdP()) {
            return this.getFederatedClaim(claimUri);
        }
        return this.getLocalClaim(claimUri);
    }

    private boolean hasRuntimeClaim(String claimUri) {
        String claim = this.getContext().getRuntimeClaim(claimUri);
        if (claim != null) {
            return true;
        }
        if (this.isFederatedIdP()) {
            return this.hasFederatedClaim(claimUri);
        }
        return this.hasLocalClaim(claimUri);
    }

    private void setRuntimeClaim(String claimUri, Object claimValue) {
        if (claimValue == null) {
            claimValue = "";
        }
        this.getContext().addRuntimeClaim(claimUri, String.valueOf(claimValue));
    }
}

