/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.AbstractJSContextMemberObject;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataHandler;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class JsClaims
extends AbstractJSContextMemberObject {
    private static final Log LOG = LogFactory.getLog(JsClaims.class);
    private String idp;
    private boolean isRemoteClaimRequest;
    private int step;
    protected transient AuthenticatedUser authenticatedUser;

    public JsClaims(AuthenticationContext context, int step, String idp, boolean isRemoteClaimRequest) {
        this(step, idp, isRemoteClaimRequest);
        this.initializeContext(context);
    }

    public JsClaims(int step, String idp, boolean isRemoteClaimRequest) {
        this.isRemoteClaimRequest = isRemoteClaimRequest;
        this.idp = idp;
        this.step = step;
    }

    @Override
    public void initializeContext(AuthenticationContext context) {
        super.initializeContext(context);
        this.authenticatedUser = StringUtils.isNotBlank((String)this.idp) && this.getContext().getCurrentAuthenticatedIdPs().containsKey(this.idp) ? this.getContext().getCurrentAuthenticatedIdPs().get(this.idp).getUser() : this.getAuthenticatedUserFromSubjectIdentifierStep();
    }

    private AuthenticatedUser getAuthenticatedUserFromSubjectIdentifierStep() {
        AuthenticatedUser authenticatedUser = null;
        StepConfig stepConfig = this.getCurrentSubjectIdentifierStep();
        if (stepConfig != null) {
            authenticatedUser = this.getCurrentSubjectIdentifierStep().getAuthenticatedUser();
        }
        return authenticatedUser;
    }

    private StepConfig getCurrentSubjectIdentifierStep() {
        if (this.getContext().getSequenceConfig() == null) {
            return null;
        }
        Map<Integer, StepConfig> stepConfigs = this.getContext().getSequenceConfig().getStepMap();
        Optional<StepConfig> subjectIdentifierStep = stepConfigs.values().stream().filter(stepConfig -> stepConfig.isCompleted() && stepConfig.isSubjectIdentifierStep()).findFirst();
        if (subjectIdentifierStep.isPresent()) {
            return subjectIdentifierStep.get();
        }
        if (this.getContext().getCurrentStep() > 0) {
            return stepConfigs.get(this.getContext().getCurrentStep());
        }
        return null;
    }

    public JsClaims(AuthenticatedUser authenticatedUser, boolean isRemoteClaimRequest) {
        this.isRemoteClaimRequest = isRemoteClaimRequest;
        this.authenticatedUser = authenticatedUser;
    }

    public JsClaims(AuthenticationContext context, AuthenticatedUser authenticatedUser, boolean isRemoteClaimRequest) {
        this(authenticatedUser, isRemoteClaimRequest);
        this.initializeContext(context);
    }

    public Object getMember(String claimUri) {
        if (this.authenticatedUser != null) {
            if (this.isRemoteClaimRequest) {
                return this.getFederatedClaim(claimUri);
            }
            return this.getLocalClaim(claimUri);
        }
        return null;
    }

    public boolean hasMember(String claimUri) {
        if (this.authenticatedUser != null) {
            if (this.isRemoteClaimRequest) {
                return this.hasFederatedClaim(claimUri);
            }
            return this.hasLocalClaim(claimUri);
        }
        return false;
    }

    public void setMember(String claimUri, Object claimValue) {
        if (this.authenticatedUser != null) {
            if (this.isRemoteClaimRequest) {
                this.setFederatedClaim(claimUri, claimValue);
                return;
            }
            this.setLocalClaim(claimUri, claimValue);
            return;
        }
        super.setMember(claimUri, claimValue);
    }

    private void setLocalClaim(String claimUri, Object claimValue) {
        if (this.isFederatedIdP()) {
            this.setLocalMappedClaim(claimUri, claimValue);
        } else {
            this.setLocalUserClaim(claimUri, claimValue);
        }
    }

    private void setLocalMappedClaim(String localClaimURI, Object claimValue) {
        Map<ClaimMapping, String> idpAttributesMap = this.authenticatedUser.getUserAttributes();
        Map<String, String> remoteMapping = FrameworkUtils.getClaimMappings(idpAttributesMap, false);
        String mappedRemoteClaim = this.getRemoteClaimMappedToLocalClaim(localClaimURI, remoteMapping);
        if (mappedRemoteClaim != null) {
            this.setFederatedClaim(mappedRemoteClaim, String.valueOf(claimValue));
        }
    }

    private void setLocalUserClaim(String claimUri, Object claimValue) {
        int usersTenantId = IdentityTenantUtil.getTenantId((String)this.authenticatedUser.getTenantDomain());
        RealmService realmService = FrameworkServiceDataHolder.getInstance().getRealmService();
        String usernameWithDomain = UserCoreUtil.addDomainToName((String)this.authenticatedUser.getUserName(), (String)this.authenticatedUser.getUserStoreDomain());
        try {
            UserRealm userRealm = realmService.getTenantUserRealm(usersTenantId);
            HashMap<String, String> claimUriMap = new HashMap<String, String>();
            claimUriMap.put(claimUri, String.valueOf(claimValue));
            userRealm.getUserStoreManager().setUserClaimValues(usernameWithDomain, claimUriMap, null);
        }
        catch (UserStoreException e) {
            LOG.error((Object)String.format("Error when setting claim : %s of user: %s to value: %s", new Object[]{claimUri, this.authenticatedUser, String.valueOf(claimValue)}), (Throwable)e);
        }
    }

    private String getRemoteClaimMappedToLocalClaim(String localClaim, Map<String, String> remoteClaimsMap) {
        String authenticatorDialect = null;
        Map localToIdpClaimMapping = null;
        String tenantDomain = this.getContext().getTenantDomain();
        try {
            ApplicationAuthenticator authenticator = this.getContext().getSequenceConfig().getStepMap().get(this.step).getAuthenticatedAutenticator().getApplicationAuthenticator();
            authenticatorDialect = authenticator.getClaimDialectURI();
            ExternalIdPConfig idPConfig = ConfigurationFacade.getInstance().getIdPConfigByName(this.idp, tenantDomain);
            boolean useDefaultIdpDialect = idPConfig.useDefaultLocalIdpDialect();
            if (authenticatorDialect != null || useDefaultIdpDialect) {
                if (authenticatorDialect == null) {
                    authenticatorDialect = "http://wso2.org/claims";
                }
                localToIdpClaimMapping = ClaimMetadataHandler.getInstance().getMappingsMapFromOtherDialectToCarbon(authenticatorDialect, remoteClaimsMap.keySet(), tenantDomain, true);
            } else {
                localToIdpClaimMapping = IdentityProviderManager.getInstance().getMappedIdPClaimsMap(this.idp, tenantDomain, Collections.singletonList(localClaim));
            }
            if (localToIdpClaimMapping != null) {
                return (String)localToIdpClaimMapping.get(localClaim);
            }
        }
        catch (IdentityProviderManagementException e) {
            LOG.error((Object)String.format("Error when getting claim : %s of user: %s", new Object[]{localClaim, this.authenticatedUser}), (Throwable)e);
        }
        catch (ClaimMetadataException e) {
            LOG.error((Object)("Error when getting claim mappings from " + authenticatorDialect + " for tenant domain: " + tenantDomain));
        }
        return null;
    }

    protected boolean hasFederatedClaim(String claimUri) {
        if (this.isFederatedIdP()) {
            Map<ClaimMapping, String> attributesMap = this.authenticatedUser.getUserAttributes();
            Map<String, String> remoteMapping = FrameworkUtils.getClaimMappings(attributesMap, false);
            return remoteMapping.containsKey(claimUri);
        }
        return false;
    }

    protected boolean hasLocalClaim(String claimUri) {
        int usersTenantId = IdentityTenantUtil.getTenantId((String)this.authenticatedUser.getTenantDomain());
        RealmService realmService = FrameworkServiceDataHolder.getInstance().getRealmService();
        try {
            Claim[] supportedClaims;
            UserRealm userRealm = realmService.getTenantUserRealm(usersTenantId);
            for (Claim claim : supportedClaims = IdentityClaimManager.getInstance().getAllSupportedClaims((org.wso2.carbon.user.core.UserRealm)userRealm)) {
                if (!claim.getClaimUri().equals(claimUri)) continue;
                return true;
            }
        }
        catch (UserStoreException e) {
            LOG.error((Object)("Error when retrieving user realm for tenant : " + usersTenantId), (Throwable)e);
        }
        catch (IdentityException e) {
            LOG.error((Object)"Error when initializing identity claim manager.", (Throwable)e);
        }
        return false;
    }

    protected String getFederatedClaim(String claimUri) {
        if (this.isFederatedIdP()) {
            Map<ClaimMapping, String> attributesMap = this.authenticatedUser.getUserAttributes();
            Map<String, String> remoteMapping = FrameworkUtils.getClaimMappings(attributesMap, false);
            return remoteMapping.get(claimUri);
        }
        return null;
    }

    protected String getLocalClaim(String claimUri) {
        if (this.isFederatedIdP()) {
            return this.getLocalMappedClaim(claimUri);
        }
        return this.getLocalUserClaim(claimUri);
    }

    protected boolean isFederatedIdP() {
        return StringUtils.isNotBlank((String)this.idp) && !"LOCAL".equals(this.idp);
    }

    private void setFederatedClaim(String claimUri, Object claimValue) {
        if (claimValue == null) {
            claimValue = "";
        }
        ClaimMapping newClaimMapping = ClaimMapping.build((String)claimUri, (String)claimUri, null, (boolean)false);
        this.authenticatedUser.getUserAttributes().put(newClaimMapping, String.valueOf(claimValue));
    }

    private String getLocalMappedClaim(String claimUri) {
        Map<ClaimMapping, String> idpAttributesMap = this.authenticatedUser.getUserAttributes();
        Map<String, String> remoteMapping = FrameworkUtils.getClaimMappings(idpAttributesMap, false);
        String remoteMappedClaim = this.getRemoteClaimMappedToLocalClaim(claimUri, remoteMapping);
        if (remoteMappedClaim != null) {
            return remoteMapping.get(remoteMappedClaim);
        }
        return null;
    }

    private String getLocalUserClaim(String claimUri) {
        int usersTenantId = IdentityTenantUtil.getTenantId((String)this.authenticatedUser.getTenantDomain());
        String usernameWithDomain = UserCoreUtil.addDomainToName((String)this.authenticatedUser.getUserName(), (String)this.authenticatedUser.getUserStoreDomain());
        RealmService realmService = FrameworkServiceDataHolder.getInstance().getRealmService();
        try {
            UserRealm userRealm = realmService.getTenantUserRealm(usersTenantId);
            Map claimValues = userRealm.getUserStoreManager().getUserClaimValues(usernameWithDomain, new String[]{claimUri}, null);
            return (String)claimValues.get(claimUri);
        }
        catch (UserStoreException e) {
            LOG.error((Object)String.format("Error when getting claim : %s of user: %s", new Object[]{claimUri, this.authenticatedUser}), (Throwable)e);
            return null;
        }
    }
}

