/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js;

import java.util.Map;
import java.util.Optional;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.AbstractJSObjectWrapper;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsAuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsServletRequest;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsServletResponse;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsStep;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsSteps;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.TransientObjectWrapper;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;

public class JsAuthenticationContext
extends AbstractJSObjectWrapper<AuthenticationContext> {
    public JsAuthenticationContext(AuthenticationContext wrapped) {
        super(wrapped);
        this.initializeContext(wrapped);
    }

    public Object getMember(String name) {
        switch (name) {
            case "requestedAcr": {
                return ((AuthenticationContext)this.getWrapped()).getRequestedAcr();
            }
            case "tenantDomain": {
                return ((AuthenticationContext)this.getWrapped()).getTenantDomain();
            }
            case "serviceProviderName": {
                return ((AuthenticationContext)this.getWrapped()).getServiceProviderName();
            }
            case "lastLoginFailedUser": {
                return this.getLastLoginFailedUserFromWrappedContext();
            }
            case "request": {
                return new JsServletRequest((TransientObjectWrapper)((AuthenticationContext)this.getWrapped()).getParameter("HttpServletRequest"));
            }
            case "response": {
                return new JsServletResponse((TransientObjectWrapper)((AuthenticationContext)this.getWrapped()).getParameter("HttpServletResponse"));
            }
            case "steps": {
                return new JsSteps((AuthenticationContext)this.getWrapped());
            }
            case "currentStep": {
                return new JsStep(this.getContext(), this.getContext().getCurrentStep(), this.getAuthenticatedIdPOfCurrentStep());
            }
            case "currentKnownSubject": {
                StepConfig stepConfig = this.getCurrentSubjectIdentifierStep();
                if (stepConfig != null) {
                    return new JsAuthenticatedUser(this.getContext(), stepConfig.getAuthenticatedUser(), stepConfig.getOrder(), stepConfig.getAuthenticatedIdP());
                }
                return null;
            }
            case "retry": {
                return ((AuthenticationContext)this.getWrapped()).isRetrying();
            }
        }
        return super.getMember(name);
    }

    public boolean hasMember(String name) {
        switch (name) {
            case "requestedAcr": {
                return ((AuthenticationContext)this.getWrapped()).getRequestedAcr() != null;
            }
            case "tenantDomain": {
                return ((AuthenticationContext)this.getWrapped()).getTenantDomain() != null;
            }
            case "serviceProviderName": {
                return ((AuthenticationContext)this.getWrapped()).getServiceProviderName() != null;
            }
            case "lastLoginFailedUser": {
                return ((AuthenticationContext)this.getWrapped()).getProperty("lastLoginFailedUser") != null;
            }
            case "request": {
                return this.hasTransientValueInParameters("HttpServletRequest");
            }
            case "response": {
                return this.hasTransientValueInParameters("HttpServletResponse");
            }
            case "steps": {
                return !((AuthenticationContext)this.getWrapped()).getSequenceConfig().getStepMap().isEmpty();
            }
        }
        return super.hasMember(name);
    }

    public void removeMember(String name) {
        switch (name) {
            case "selectedAcr": {
                ((AuthenticationContext)this.getWrapped()).setSelectedAcr(null);
                break;
            }
            default: {
                super.removeMember(name);
            }
        }
    }

    public void setMember(String name, Object value) {
        switch (name) {
            case "selectedAcr": {
                ((AuthenticationContext)this.getWrapped()).setSelectedAcr(String.valueOf(value));
                break;
            }
            default: {
                super.setMember(name, value);
            }
        }
    }

    private boolean hasTransientValueInParameters(String key) {
        TransientObjectWrapper transientObjectWrapper = (TransientObjectWrapper)((AuthenticationContext)this.getWrapped()).getParameter(key);
        return transientObjectWrapper != null && transientObjectWrapper.getWrapped() != null;
    }

    private JsAuthenticatedUser getLastLoginFailedUserFromWrappedContext() {
        Object lastLoginFailedUser = ((AuthenticationContext)this.getWrapped()).getProperty("lastLoginFailedUser");
        if (lastLoginFailedUser instanceof AuthenticatedUser) {
            return new JsAuthenticatedUser((AuthenticationContext)this.getWrapped(), (AuthenticatedUser)((Object)lastLoginFailedUser));
        }
        return null;
    }

    private String getAuthenticatedIdPOfCurrentStep() {
        if (this.getContext().getSequenceConfig() == null) {
            return null;
        }
        StepConfig stepConfig = this.getContext().getSequenceConfig().getStepMap().get(this.getContext().getCurrentStep());
        if (stepConfig != null) {
            return stepConfig.getAuthenticatedIdP();
        }
        return null;
    }

    private StepConfig getCurrentSubjectIdentifierStep() {
        if (this.getContext().getSequenceConfig() == null) {
            return null;
        }
        Map<Integer, StepConfig> stepConfigs = this.getContext().getSequenceConfig().getStepMap();
        Optional<StepConfig> subjectIdentifierStep = stepConfigs.values().stream().filter(stepConfig -> stepConfig.isCompleted() && stepConfig.isSubjectIdentifierStep()).findFirst();
        if (subjectIdentifierStep.isPresent()) {
            return subjectIdentifierStep.get();
        }
        if (this.getContext().getCurrentStep() > 0) {
            return stepConfigs.get(this.getContext().getCurrentStep());
        }
        return null;
    }
}

