/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.AbstractJSObjectWrapper;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsClaims;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsRuntimeClaims;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class JsAuthenticatedUser
extends AbstractJSObjectWrapper<AuthenticatedUser> {
    private static final Log LOG = LogFactory.getLog(JsAuthenticatedUser.class);
    private int step;
    private String idp;

    public JsAuthenticatedUser(AuthenticationContext context, AuthenticatedUser wrappedUser, int step, String idp) {
        this(wrappedUser, step, idp);
        this.initializeContext(context);
    }

    public JsAuthenticatedUser(AuthenticatedUser wrappedUser, int step, String idp) {
        super(wrappedUser);
        this.step = step;
        this.idp = idp;
    }

    public JsAuthenticatedUser(AuthenticatedUser wrappedUser) {
        super(wrappedUser);
    }

    public JsAuthenticatedUser(AuthenticationContext context, AuthenticatedUser wrappedUser) {
        this(wrappedUser);
        this.initializeContext(context);
    }

    public Object getMember(String name) {
        switch (name) {
            case "identifier": {
                return ((AuthenticatedUser)((Object)this.getWrapped())).getAuthenticatedSubjectIdentifier();
            }
            case "username": {
                return ((AuthenticatedUser)((Object)this.getWrapped())).getUserName();
            }
            case "userStoreDomain": {
                return ((AuthenticatedUser)((Object)this.getWrapped())).getUserStoreDomain();
            }
            case "tenantDomain": {
                return ((AuthenticatedUser)((Object)this.getWrapped())).getTenantDomain();
            }
            case "localClaims": {
                if (StringUtils.isNotBlank((String)this.idp)) {
                    return new JsClaims(this.getContext(), this.step, this.idp, false);
                }
                return new JsClaims(this.getContext(), (AuthenticatedUser)((Object)this.getWrapped()), false);
            }
            case "remoteClaims": {
                if (StringUtils.isNotBlank((String)this.idp)) {
                    return new JsClaims(this.getContext(), this.step, this.idp, true);
                }
                return new JsClaims(this.getContext(), (AuthenticatedUser)((Object)this.getWrapped()), true);
            }
            case "roles": {
                return this.getLocalRoles();
            }
            case "claims": {
                if (StringUtils.isNotBlank((String)this.idp)) {
                    return new JsRuntimeClaims(this.getContext(), this.step, this.idp);
                }
                return new JsRuntimeClaims(this.getContext(), (AuthenticatedUser)((Object)this.getWrapped()));
            }
        }
        return super.getMember(name);
    }

    public void setMember(String name, Object value) {
        switch (name) {
            case "username": {
                ((AuthenticatedUser)((Object)this.getWrapped())).setUserName((String)value);
                break;
            }
            case "userStoreDomain": {
                ((AuthenticatedUser)((Object)this.getWrapped())).setUserStoreDomain((String)value);
                break;
            }
            case "tenantDomain": {
                ((AuthenticatedUser)((Object)this.getWrapped())).setTenantDomain((String)value);
                break;
            }
            default: {
                super.setMember(name, value);
            }
        }
    }

    public boolean hasMember(String name) {
        switch (name) {
            case "identifier": {
                return ((AuthenticatedUser)((Object)this.getWrapped())).getAuthenticatedSubjectIdentifier() != null;
            }
            case "username": {
                return ((AuthenticatedUser)((Object)this.getWrapped())).getUserName() != null;
            }
            case "userStoreDomain": {
                return ((AuthenticatedUser)((Object)this.getWrapped())).getUserStoreDomain() != null;
            }
            case "tenantDomain": {
                return ((AuthenticatedUser)((Object)this.getWrapped())).getTenantDomain() != null;
            }
            case "localClaims": {
                return this.idp != null;
            }
            case "remoteClaims": {
                return this.idp != null && !"LOCAL".equals(this.idp);
            }
        }
        return super.hasMember(name);
    }

    private String[] getLocalRoles() {
        if (this.idp == null || "LOCAL".equals(this.idp)) {
            RealmService realmService = FrameworkServiceDataHolder.getInstance().getRealmService();
            int usersTenantId = IdentityTenantUtil.getTenantId((String)((AuthenticatedUser)((Object)this.getWrapped())).getTenantDomain());
            try {
                String usernameWithDomain = UserCoreUtil.addDomainToName((String)((AuthenticatedUser)((Object)this.getWrapped())).getUserName(), (String)((AuthenticatedUser)((Object)this.getWrapped())).getUserStoreDomain());
                UserRealm userRealm = realmService.getTenantUserRealm(usersTenantId);
                return userRealm.getUserStoreManager().getRoleListOfUser(usernameWithDomain);
            }
            catch (UserStoreException e) {
                LOG.error((Object)("Error when getting role list of user: " + this.getWrapped()), (Throwable)e);
            }
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

