/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model.graph;

import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.AuthGraphNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.JsGraphBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.AbstractJSObjectWrapper;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsLogger;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.handler.sequence.impl.SelectAcrFromFunction;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;

public class JsGraphBuilderFactory {
    private static final Log LOG = LogFactory.getLog(JsGraphBuilderFactory.class);
    private static final String JS_BINDING_CURRENT_CONTEXT = "JS_BINDING_CURRENT_CONTEXT";
    private NashornScriptEngineFactory factory;

    public void init() {
        this.factory = new NashornScriptEngineFactory();
    }

    public static void restoreCurrentContext(AuthenticationContext context, ScriptEngine engine) throws FrameworkException {
        Map map = (Map)context.getProperty(JS_BINDING_CURRENT_CONTEXT);
        Bindings bindings = engine.getBindings(100);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object deserializedValue = FrameworkUtils.fromJsSerializable(entry.getValue(), engine);
                if (deserializedValue instanceof AbstractJSObjectWrapper) {
                    ((AbstractJSObjectWrapper)deserializedValue).initializeContext(context);
                }
                bindings.put((String)entry.getKey(), deserializedValue);
            }
        }
    }

    public static void persistCurrentContext(AuthenticationContext context, ScriptEngine engine) {
        Bindings engineBindings = engine.getBindings(100);
        HashMap persistableMap = new HashMap();
        engineBindings.forEach((key, value) -> persistableMap.put(key, FrameworkUtils.toJsSerializable(value)));
        context.setProperty(JS_BINDING_CURRENT_CONTEXT, persistableMap);
    }

    public ScriptEngine createEngine(AuthenticationContext authenticationContext) {
        ScriptEngine engine = this.factory.getScriptEngine(new String[]{"--no-java"});
        Bindings bindings = engine.createBindings();
        engine.setBindings(bindings, 200);
        engine.setBindings(engine.createBindings(), 100);
        SelectAcrFromFunction selectAcrFromFunction = new SelectAcrFromFunction();
        bindings.put("selectAcrFrom", selectAcrFromFunction::evaluate);
        JsLogger jsLogger = new JsLogger();
        bindings.put("Log", (Object)jsLogger);
        return engine;
    }

    public JsGraphBuilder createBuilder(AuthenticationContext authenticationContext, Map<Integer, StepConfig> stepConfigMap) {
        return new JsGraphBuilder(authenticationContext, stepConfigMap, this.createEngine(authenticationContext));
    }

    public JsGraphBuilder createBuilder(AuthenticationContext authenticationContext, Map<Integer, StepConfig> stepConfigMap, AuthGraphNode currentNode) {
        return new JsGraphBuilder(authenticationContext, stepConfigMap, this.createEngine(authenticationContext), currentNode);
    }
}

