/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.JSObject;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.AsyncProcess;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDecisionEvaluator;
import org.wso2.carbon.identity.application.authentication.framework.JsFunctionRegistry;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.AuthGraphNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.AuthenticationGraph;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.DynamicDecisionNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.EndStep;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.FailNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.JsGraphBuilderFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.LongWaitNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.SerializableJsFunction;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.ShowPromptNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.StepConfigGraphNode;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.js.JsAuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.ApplicationAuthenticatorService;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.functions.library.mgt.FunctionLibraryManagementService;
import org.wso2.carbon.identity.functions.library.mgt.exception.FunctionLibraryManagementException;
import org.wso2.carbon.identity.functions.library.mgt.model.FunctionLibrary;

public class JsGraphBuilder {
    private static final Log log = LogFactory.getLog(JsGraphBuilder.class);
    private Map<Integer, StepConfig> stepNamedMap;
    private AuthenticationGraph result = new AuthenticationGraph();
    private AuthGraphNode currentNode = null;
    private AuthenticationContext authenticationContext;
    private ScriptEngine engine;
    private static ThreadLocal<AuthenticationContext> contextForJs = new ThreadLocal();
    private static ThreadLocal<AuthGraphNode> dynamicallyBuiltBaseNode = new ThreadLocal();
    private static ThreadLocal<JsGraphBuilder> currentBuilder = new ThreadLocal();

    public JsGraphBuilder(AuthenticationContext authenticationContext, Map<Integer, StepConfig> stepConfigMap, ScriptEngine scriptEngine) {
        this.engine = scriptEngine;
        this.authenticationContext = authenticationContext;
        this.stepNamedMap = stepConfigMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public JsGraphBuilder(AuthenticationContext authenticationContext, Map<Integer, StepConfig> stepConfigMap, ScriptEngine scriptEngine, AuthGraphNode currentNode) {
        this.engine = scriptEngine;
        this.authenticationContext = authenticationContext;
        this.currentNode = currentNode;
        this.stepNamedMap = stepConfigMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public AuthenticationGraph build() {
        if (this.result.isBuildSuccessful()) {
            if (this.currentNode != null && !(this.currentNode instanceof EndStep)) {
                JsGraphBuilder.attachToLeaf(this.currentNode, new EndStep());
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Not building the graph as the initialization was unsuccessful.");
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsGraphBuilder createWith(String script) {
        try {
            currentBuilder.set(this);
            Bindings globalBindings = this.engine.getBindings(200);
            Bindings engineBindings = this.engine.getBindings(100);
            globalBindings.put("executeStep", this::executeStep);
            globalBindings.put("sendError", this::sendError);
            globalBindings.put("fail", this::fail);
            globalBindings.put("prompt", this::addShowPrompt);
            globalBindings.put("loadLocalLibrary", this::loadLocalLibrary);
            engineBindings.put("exit", this::exitFunction);
            engineBindings.put("quit", this::quitFunction);
            JsFunctionRegistry jsFunctionRegistrar = FrameworkServiceDataHolder.getInstance().getJsFunctionRegistry();
            if (jsFunctionRegistrar != null) {
                Map<String, Object> functionMap = jsFunctionRegistrar.getSubsystemFunctionsMap(JsFunctionRegistry.Subsystem.SEQUENCE_HANDLER);
                functionMap.forEach(globalBindings::put);
            }
            Invocable invocable = (Invocable)((Object)this.engine);
            this.engine.eval(FrameworkServiceDataHolder.getInstance().getCodeForRequireFunction());
            this.engine.eval(script);
            invocable.invokeFunction("onLoginRequest", new JsAuthenticationContext(this.authenticationContext));
            JsGraphBuilderFactory.persistCurrentContext(this.authenticationContext, this.engine);
        }
        catch (ScriptException e) {
            this.result.setBuildSuccessful(false);
            this.result.setErrorReason("Error in executing the Javascript. Nested exception is: " + e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error in executing the Javascript.", (Throwable)e);
            }
        }
        catch (NoSuchMethodException e) {
            this.result.setBuildSuccessful(false);
            this.result.setErrorReason("Error in executing the Javascript. onLoginRequest function is not defined.");
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error in executing the Javascript.", (Throwable)e);
            }
        }
        finally {
            JsGraphBuilder.clearCurrentBuilder();
        }
        return this;
    }

    public static void clearCurrentBuilder() {
        currentBuilder.remove();
    }

    public static JsGraphBuilder getCurrentBuilder() {
        return currentBuilder.get();
    }

    public static void sendErrorAsync(String url, Map<String, Object> parameterMap) {
        FailNode newNode = JsGraphBuilder.createFailNode(url, parameterMap, true);
        AuthGraphNode currentNode = dynamicallyBuiltBaseNode.get();
        if (currentNode == null) {
            dynamicallyBuiltBaseNode.set(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(currentNode, newNode);
        }
    }

    private static FailNode createFailNode(String url, Map<String, Object> parameterMap, boolean isShowErrorPage) {
        FailNode failNode = new FailNode();
        if (isShowErrorPage && StringUtils.isNotBlank((String)url)) {
            failNode.setErrorPageUri(url);
        }
        failNode.setShowErrorPage(isShowErrorPage);
        parameterMap.forEach((key, value) -> failNode.getFailureData().put((String)key, String.valueOf(value)));
        return failNode;
    }

    public void sendError(String url, Map<String, Object> parameterMap) {
        FailNode newNode = JsGraphBuilder.createFailNode(url, parameterMap, true);
        if (this.currentNode == null) {
            this.result.setStartNode(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(this.currentNode, newNode);
        }
    }

    public void fail(Object ... parameters) {
        Map parameterMap = parameters.length == 1 ? (Map)parameters[0] : Collections.EMPTY_MAP;
        FailNode newNode = JsGraphBuilder.createFailNode("", parameterMap, false);
        if (this.currentNode == null) {
            this.result.setStartNode(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(this.currentNode, newNode);
        }
    }

    public static void failAsync(Object ... parameters) {
        Map parameterMap = parameters.length == 1 ? (Map)parameters[0] : Collections.EMPTY_MAP;
        FailNode newNode = JsGraphBuilder.createFailNode("", parameterMap, false);
        AuthGraphNode currentNode = dynamicallyBuiltBaseNode.get();
        if (currentNode == null) {
            dynamicallyBuiltBaseNode.set(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(currentNode, newNode);
        }
    }

    public final void executeStep(int stepId, Object ... params) {
        StepConfig stepConfig = this.stepNamedMap.get(stepId);
        if (stepConfig == null) {
            log.error((Object)("Given Authentication Step :" + stepId + " is not in Environment"));
            return;
        }
        StepConfigGraphNode newNode = JsGraphBuilder.wrap(stepConfig);
        if (this.currentNode == null) {
            this.result.setStartNode(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(this.currentNode, newNode);
        }
        this.currentNode = newNode;
        if (params.length > 0) {
            if (params[params.length - 1] instanceof Map) {
                this.attachEventListeners((Map)params[params.length - 1]);
            } else {
                log.error((Object)"Invalid argument and hence ignored. Last argument should be a Map of event listeners.");
            }
        }
        if (params.length == 2 && params[0] instanceof Map) {
            Map options = (Map)params[0];
            this.handleOptions(options, stepConfig);
        }
    }

    protected void handleOptions(Map<String, Object> options, StepConfig stepConfig) {
        Object authenticationOptionsObj = options.get("authenticationOptions");
        if (authenticationOptionsObj instanceof Map) {
            this.filterOptions((Map)authenticationOptionsObj, stepConfig);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Authenticator options not provided or invalid, hence proceeding without filtering");
        }
        Object authenticatorParams = options.get("authenticatorParams");
        if (authenticatorParams instanceof Map) {
            this.authenticatorParamsOptions((Map)authenticatorParams, stepConfig);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Authenticator params not provided or invalid, hence proceeding without setting params");
        }
        Object stepOptions = options.get("stepOptions");
        if (stepOptions instanceof Map) {
            this.handleStepOptions(stepConfig, (Map)stepOptions);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Step options not provided or invalid, hence proceeding without handling");
        }
    }

    private void handleStepOptions(StepConfig stepConfig, Map<String, String> stepOptions) {
        stepConfig.setForced(Boolean.parseBoolean(stepOptions.get("forceAuth")));
    }

    protected void filterOptions(Map<String, Map<String, String>> authenticationOptions, StepConfig stepConfig) {
        HashMap filteredOptions = new HashMap();
        authenticationOptions.forEach((id, option) -> {
            String idp = (String)option.get("idp");
            String authenticator = (String)option.get("authenticator");
            if (StringUtils.isNotBlank((String)authenticator) && StringUtils.isBlank((String)idp)) {
                idp = "LOCAL";
            }
            if (StringUtils.isNotBlank((String)idp)) {
                filteredOptions.putIfAbsent(idp, new HashSet());
                if (StringUtils.isNotBlank((String)authenticator)) {
                    ((Set)filteredOptions.get(idp)).add(authenticator);
                }
            }
        });
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : filteredOptions.entrySet()) {
                sb.append('\n').append((String)entry.getKey()).append(" : ");
                sb.append(StringUtils.join((Collection)((Collection)entry.getValue()), (String)","));
            }
            log.debug((Object)("Authenticator options: " + sb.toString()));
        }
        HashSet authenticatorsToRemove = new HashSet();
        HashMap<String, AuthenticatorConfig> idpsToRemove = new HashMap<String, AuthenticatorConfig>();
        stepConfig.getAuthenticatorList().forEach(authenticatorConfig -> authenticatorConfig.getIdps().forEach((idpName, idp) -> {
            Set authenticators = (Set)filteredOptions.get(idpName);
            boolean removeOption = false;
            if (authenticators == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Authentication options didn't include idp: %s. Hence excluding from options list", idpName));
                }
                removeOption = true;
            } else if (!authenticators.isEmpty()) {
                removeOption = true;
                if ("LOCAL".equals(idpName)) {
                    List localAuthenticators = ApplicationAuthenticatorService.getInstance().getLocalAuthenticators();
                    for (LocalAuthenticatorConfig localAuthenticatorConfig : localAuthenticators) {
                        if (!authenticatorConfig.getName().equals(localAuthenticatorConfig.getName()) || !authenticators.contains(localAuthenticatorConfig.getDisplayName())) continue;
                        removeOption = false;
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        if (removeOption) {
                            log.debug((Object)String.format("Authenticator options don't match any entry for localauthenticator: %s. Hence removing the option", authenticatorConfig.getName()));
                        } else {
                            log.debug((Object)String.format("Authenticator options contained a match for local authenticator: %s. Hence keeping the option", authenticatorConfig.getName()));
                        }
                    }
                } else {
                    for (FederatedAuthenticatorConfig federatedAuthConfig : idp.getFederatedAuthenticatorConfigs()) {
                        if (!authenticatorConfig.getName().equals(federatedAuthConfig.getName()) || !authenticators.contains(federatedAuthConfig.getDisplayName())) continue;
                        removeOption = false;
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        if (removeOption) {
                            log.debug((Object)String.format("Authenticator options don't match any entry for idp: %s, authenticator: %s. Hence removing the option", idpName, authenticatorConfig.getName()));
                        } else {
                            log.debug((Object)String.format("Authenticator options contained a match for idp: %s, authenticator: %s. Hence keeping the option", idpName, authenticatorConfig.getName()));
                        }
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No authenticator filters for idp %s, hence keeping it as an option", idpName));
            }
            if (removeOption) {
                if (authenticatorConfig.getIdps().size() > 1) {
                    idpsToRemove.put((String)idpName, (AuthenticatorConfig)authenticatorConfig);
                } else {
                    authenticatorsToRemove.add(authenticatorConfig);
                }
            }
        }));
        if (stepConfig.getAuthenticatorList().size() > authenticatorsToRemove.size()) {
            idpsToRemove.forEach((idp, authenticatorConfig) -> {
                int index = stepConfig.getAuthenticatorList().indexOf(authenticatorConfig);
                stepConfig.getAuthenticatorList().get(index).getIdps().remove(idp);
                stepConfig.getAuthenticatorList().get(index).getIdpNames().remove(idp);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removed " + idp + " option from " + authenticatorConfig.getName() + " as it doesn't match the provided authenticator options"));
                }
            });
            stepConfig.getAuthenticatorList().forEach(authenticatorConfig -> {
                if (authenticatorConfig.getIdps().isEmpty()) {
                    authenticatorsToRemove.add(authenticatorConfig);
                }
            });
            stepConfig.getAuthenticatorList().removeAll(authenticatorsToRemove);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed " + authenticatorsToRemove.size() + " options which doesn't match the provided authenticator options"));
            }
        } else {
            log.warn((Object)"The filtered authenticator list is empty, hence proceeding without filtering");
        }
    }

    protected void authenticatorParamsOptions(Map<String, Object> options, StepConfig stepConfig) {
        Object commonOptions;
        Object federatedOptionsObj;
        HashMap<String, Map<String, String>> authenticatorParams = new HashMap<String, Map<String, String>>();
        Object localOptions = options.get("local");
        if (localOptions instanceof Map) {
            ((Map)localOptions).forEach((authenticatorName, params) -> {
                if (params instanceof Map) {
                    authenticatorParams.put((String)authenticatorName, new HashMap((Map)params));
                }
            });
        }
        if ((federatedOptionsObj = options.get("federated")) instanceof Map) {
            Map federatedOptions = (Map)federatedOptionsObj;
            stepConfig.getAuthenticatorList().forEach(authenticatorConfig -> authenticatorConfig.getIdps().forEach((idpName, idp) -> {
                if (!"LOCAL".equals(idpName) && federatedOptions.containsKey(idpName)) {
                    for (FederatedAuthenticatorConfig federatedAuthConfig : idp.getFederatedAuthenticatorConfigs()) {
                        String authenticatorName = authenticatorConfig.getApplicationAuthenticator().getName();
                        if (!authenticatorConfig.getName().equals(federatedAuthConfig.getName())) continue;
                        authenticatorParams.put(authenticatorName, new HashMap((Map)federatedOptions.get(idpName)));
                    }
                }
            }));
        }
        if ((commonOptions = options.get("common")) instanceof Map) {
            authenticatorParams.put("common", new HashMap((Map)commonOptions));
        }
        if (!authenticatorParams.isEmpty()) {
            this.authenticationContext.addAuthenticatorParams(authenticatorParams);
        }
    }

    public void executeStepInAsyncEvent(int stepId, Object ... params) {
        AuthenticationGraph graph;
        AuthenticationContext context = contextForJs.get();
        AuthGraphNode currentNode = dynamicallyBuiltBaseNode.get();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execute Step on async event. Step ID : " + stepId));
        }
        if ((graph = context.getSequenceConfig().getAuthenticationGraph()) == null) {
            log.error((Object)("The graph happens to be null on the sequence config. Can not execute step : " + stepId));
            return;
        }
        StepConfig stepConfig = graph.getStepMap().get(stepId);
        StepConfig clonedStepConfig = new StepConfig(stepConfig);
        clonedStepConfig.applyStateChangesToNewObjectFromContextStepMap(context.getSequenceConfig().getStepMap().get(stepId));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found step for the Step ID : " + stepId + ", Step Config " + clonedStepConfig));
        }
        StepConfigGraphNode newNode = JsGraphBuilder.wrap(clonedStepConfig);
        if (currentNode == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting a new node at the first time. Node : " + newNode.getName()));
            }
            dynamicallyBuiltBaseNode.set(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(currentNode, newNode);
        }
        if (params.length > 0) {
            if (params[params.length - 1] instanceof Map) {
                JsGraphBuilder.attachEventListeners((Map)params[params.length - 1], newNode);
            } else {
                log.error((Object)"Invalid argument and hence ignored. Last argument should be a Map of event listeners.");
            }
        }
        if (params.length == 2 && params[0] instanceof Map) {
            Map options = (Map)params[0];
            this.handleOptions(options, clonedStepConfig);
        }
    }

    public void addShowPrompt(String templateId, Object ... parameters) {
        ShowPromptNode newNode = new ShowPromptNode();
        newNode.setTemplateId(templateId);
        if (parameters.length == 2) {
            newNode.setData((Map)FrameworkUtils.toJsSerializable(parameters[0]));
        }
        if (this.currentNode == null) {
            this.result.setStartNode(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(this.currentNode, newNode);
        }
        this.currentNode = newNode;
        if (parameters.length > 0) {
            if (parameters[parameters.length - 1] instanceof Map) {
                JsGraphBuilder.addEventListeners(newNode, (Map)parameters[parameters.length - 1]);
            } else {
                log.error((Object)"Invalid argument and hence ignored. Last argument should be a Map of event listeners.");
            }
        }
    }

    public static void addPrompt(String templateId, Map<String, Object> parameters, Map<String, Object> handlers, Map<String, Object> callbacks) {
        ShowPromptNode newNode = new ShowPromptNode();
        newNode.setTemplateId(templateId);
        newNode.setParameters(parameters);
        JsGraphBuilder currentBuilder = JsGraphBuilder.getCurrentBuilder();
        if (currentBuilder.currentNode == null) {
            currentBuilder.result.setStartNode(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(currentBuilder.currentNode, newNode);
        }
        currentBuilder.currentNode = newNode;
        JsGraphBuilder.addEventListeners(newNode, callbacks);
        JsGraphBuilder.addHandlers(newNode, handlers);
    }

    public String loadLocalLibrary(String functionLibraryName) throws FunctionLibraryManagementException {
        FunctionLibraryManagementService functionLibMgtService = FrameworkServiceComponent.getFunctionLibraryManagementService();
        String libraryScript = null;
        FunctionLibrary functionLibrary = functionLibMgtService.getFunctionLibrary(functionLibraryName, CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
        if (functionLibrary != null) {
            libraryScript = functionLibrary.getFunctionLibraryScript();
        } else {
            log.error((Object)("No function library available with " + functionLibraryName + "name."));
        }
        return libraryScript;
    }

    public static void addLongWaitProcess(AsyncProcess asyncProcess, Map<String, Object> parameterMap) {
        JsGraphBuilder.addLongWaitProcess(JsGraphBuilder.getCurrentBuilder(), asyncProcess, parameterMap);
    }

    private static void addLongWaitProcess(JsGraphBuilder jsGraphBuilder, AsyncProcess asyncProcess, Map<String, Object> parameterMap) {
        LongWaitNode newNode = new LongWaitNode(asyncProcess);
        if (parameterMap != null) {
            JsGraphBuilder.addEventListeners(newNode, parameterMap);
        }
        if (jsGraphBuilder.currentNode == null) {
            jsGraphBuilder.result.setStartNode(newNode);
        } else {
            JsGraphBuilder.attachToLeaf(jsGraphBuilder.currentNode, newNode);
        }
        jsGraphBuilder.currentNode = newNode;
    }

    private static void attachEventListeners(Map<String, Object> eventsMap, AuthGraphNode currentNode) {
        if (eventsMap == null) {
            return;
        }
        DynamicDecisionNode decisionNode = new DynamicDecisionNode();
        JsGraphBuilder.addEventListeners(decisionNode, eventsMap);
        if (!decisionNode.getFunctionMap().isEmpty()) {
            JsGraphBuilder.attachToLeaf(currentNode, decisionNode);
        }
    }

    private void attachEventListeners(Map<String, Object> eventsMap) {
        if (eventsMap == null) {
            return;
        }
        DynamicDecisionNode decisionNode = new DynamicDecisionNode();
        JsGraphBuilder.addEventListeners(decisionNode, eventsMap);
        if (!decisionNode.getFunctionMap().isEmpty()) {
            JsGraphBuilder.attachToLeaf(this.currentNode, decisionNode);
            this.currentNode = decisionNode;
        }
    }

    private static void addEventListeners(DynamicDecisionNode decisionNode, Map<String, Object> eventsMap) {
        if (eventsMap == null) {
            return;
        }
        eventsMap.forEach((key, value) -> {
            if (value instanceof ScriptObjectMirror) {
                SerializableJsFunction jsFunction = SerializableJsFunction.toSerializableForm((ScriptObjectMirror)value);
                if (jsFunction != null) {
                    decisionNode.addFunction((String)key, jsFunction);
                } else {
                    log.error((Object)("Event handler : " + key + " is not a function : " + value));
                }
            } else if (value instanceof SerializableJsFunction) {
                decisionNode.addFunction((String)key, (SerializableJsFunction)value);
            }
        });
    }

    private static void addHandlers(ShowPromptNode showPromptNode, Map<String, Object> handlersMap) {
        if (handlersMap == null) {
            return;
        }
        handlersMap.forEach((key, value) -> {
            if (value instanceof ScriptObjectMirror) {
                SerializableJsFunction jsFunction = SerializableJsFunction.toSerializableForm((ScriptObjectMirror)value);
                if (jsFunction != null) {
                    showPromptNode.addHandler((String)key, jsFunction);
                } else {
                    log.error((Object)("Event handler : " + key + " is not a function : " + value));
                }
            } else if (value instanceof SerializableJsFunction) {
                showPromptNode.addHandler((String)key, (SerializableJsFunction)value);
            }
        });
    }

    private static void infuse(AuthGraphNode destination, AuthGraphNode newNode) {
        if (destination instanceof StepConfigGraphNode) {
            StepConfigGraphNode stepConfigGraphNode = (StepConfigGraphNode)destination;
            JsGraphBuilder.attachToLeaf(newNode, stepConfigGraphNode.getNext());
            newNode.setParent(destination);
            stepConfigGraphNode.setNext(newNode);
        } else if (destination instanceof DynamicDecisionNode) {
            DynamicDecisionNode dynamicDecisionNode = (DynamicDecisionNode)destination;
            newNode.setParent(destination);
            JsGraphBuilder.attachToLeaf(newNode, dynamicDecisionNode.getDefaultEdge());
            dynamicDecisionNode.setDefaultEdge(newNode);
        } else {
            log.error((Object)("Can not infuse nodes in node type : " + destination));
        }
    }

    private static void attachToLeaf(AuthGraphNode baseNode, AuthGraphNode nodeToAttach) {
        if (baseNode instanceof StepConfigGraphNode) {
            StepConfigGraphNode stepConfigGraphNode = (StepConfigGraphNode)baseNode;
            if (stepConfigGraphNode.getNext() == null) {
                stepConfigGraphNode.setNext(nodeToAttach);
                if (nodeToAttach != null) {
                    nodeToAttach.setParent(stepConfigGraphNode);
                }
            } else {
                JsGraphBuilder.attachToLeaf(stepConfigGraphNode.getNext(), nodeToAttach);
            }
        } else if (baseNode instanceof LongWaitNode) {
            LongWaitNode longWaitNode = (LongWaitNode)baseNode;
            longWaitNode.setDefaultEdge(nodeToAttach);
            if (nodeToAttach != null) {
                nodeToAttach.setParent(longWaitNode);
            }
        } else if (baseNode instanceof ShowPromptNode) {
            ShowPromptNode showPromptNode = (ShowPromptNode)baseNode;
            showPromptNode.setDefaultEdge(nodeToAttach);
            if (nodeToAttach != null) {
                nodeToAttach.setParent(showPromptNode);
            }
        } else if (baseNode instanceof DynamicDecisionNode) {
            DynamicDecisionNode dynamicDecisionNode = (DynamicDecisionNode)baseNode;
            dynamicDecisionNode.setDefaultEdge(nodeToAttach);
            if (nodeToAttach != null) {
                nodeToAttach.setParent(dynamicDecisionNode);
            }
        } else if (baseNode instanceof EndStep) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The destination is an End Step. Unable to attach the node : " + nodeToAttach));
            }
        } else if (baseNode instanceof FailNode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The destination is an Fail Step. Unable to attach the node : " + nodeToAttach));
            }
        } else {
            log.error((Object)("Unknown graph node found : " + baseNode));
        }
    }

    private static StepConfigGraphNode wrap(StepConfig stepConfig) {
        return new StepConfigGraphNode(stepConfig);
    }

    public void exitFunction(Object ... arg) {
        log.error((Object)"Exit function is restricted.");
    }

    public void quitFunction(Object ... arg) {
        log.error((Object)"Quit function is restricted.");
    }

    public class JsBasedEvaluator
    implements AuthenticationDecisionEvaluator {
        private static final long serialVersionUID = 6853505881096840344L;
        private SerializableJsFunction jsFunction;

        public JsBasedEvaluator(SerializableJsFunction jsFunction) {
            this.jsFunction = jsFunction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object evaluate(AuthenticationContext authenticationContext, Function<JSObject, Object> jsConsumer) {
            JsGraphBuilder graphBuilder = JsGraphBuilder.this;
            Object result = null;
            if (this.jsFunction == null) {
                return null;
            }
            if (!this.jsFunction.isFunction()) return this.jsFunction.getSource();
            ScriptEngine scriptEngine = this.getEngine(authenticationContext);
            try {
                currentBuilder.set(graphBuilder);
                JsGraphBuilderFactory.restoreCurrentContext(authenticationContext, scriptEngine);
                Bindings globalBindings = scriptEngine.getBindings(200);
                globalBindings.put("executeStep", graphBuilder::executeStepInAsyncEvent);
                globalBindings.put("sendError", JsGraphBuilder::sendErrorAsync);
                globalBindings.put("fail", JsGraphBuilder::failAsync);
                globalBindings.put("prompt", graphBuilder::addShowPrompt);
                globalBindings.put("loadLocalLibrary", graphBuilder::loadLocalLibrary);
                JsFunctionRegistry jsFunctionRegistry = FrameworkServiceDataHolder.getInstance().getJsFunctionRegistry();
                if (jsFunctionRegistry != null) {
                    Map<String, Object> functionMap = jsFunctionRegistry.getSubsystemFunctionsMap(JsFunctionRegistry.Subsystem.SEQUENCE_HANDLER);
                    functionMap.forEach(globalBindings::put);
                }
                Compilable compilable = (Compilable)((Object)scriptEngine);
                contextForJs.set(authenticationContext);
                CompiledScript compiledScript = compilable.compile(this.jsFunction.getSource());
                JSObject builderFunction = (JSObject)compiledScript.eval();
                result = jsConsumer.apply(builderFunction);
                JsGraphBuilderFactory.persistCurrentContext(authenticationContext, scriptEngine);
                AuthGraphNode executingNode = (AuthGraphNode)authenticationContext.getProperty("Adaptive.Auth.Current.Graph.Node");
                if (!this.canInfuse(executingNode)) return result;
                JsGraphBuilder.infuse(executingNode, (AuthGraphNode)dynamicallyBuiltBaseNode.get());
                return result;
            }
            catch (Throwable e) {
                log.error((Object)("Error in executing the javascript for service provider : " + authenticationContext.getServiceProviderName() + ", Javascript Fragment : \n" + this.jsFunction.getSource()), e);
                AuthGraphNode executingNode = (AuthGraphNode)authenticationContext.getProperty("Adaptive.Auth.Current.Graph.Node");
                FailNode failNode = new FailNode();
                JsGraphBuilder.attachToLeaf(executingNode, failNode);
                return result;
            }
            finally {
                contextForJs.remove();
                dynamicallyBuiltBaseNode.remove();
                JsGraphBuilder.clearCurrentBuilder();
            }
        }

        @Deprecated
        public Object evaluate(AuthenticationContext authenticationContext) {
            return this.evaluate(authenticationContext, fn -> fn.call(null, new Object[]{new JsAuthenticationContext(authenticationContext)}));
        }

        private boolean canInfuse(AuthGraphNode executingNode) {
            return executingNode instanceof DynamicDecisionNode && dynamicallyBuiltBaseNode.get() != null;
        }

        private ScriptEngine getEngine(AuthenticationContext authenticationContext) {
            return FrameworkServiceDataHolder.getInstance().getJsGraphBuilderFactory().createEngine(authenticationContext);
        }
    }

    @FunctionalInterface
    public static interface LoadExecutor {
        public String loadLocalLibrary(String var1) throws FunctionLibraryManagementException;
    }

    @FunctionalInterface
    public static interface RestrictedFunction {
        public void exit(Object ... var1);
    }

    @FunctionalInterface
    public static interface PromptExecutor {
        public void prompt(String var1, Object ... var2);
    }

    @FunctionalInterface
    public static interface StepExecutor {
        public void executeStep(Integer var1, Object ... var2);
    }

    @FunctionalInterface
    public static interface FailAuthenticationFunction {
        public void fail(Object ... var1);
    }
}

