/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;

public class StepConfig
implements Serializable {
    private static final long serialVersionUID = 7271079506748466841L;
    private int order;
    private String loginPage;
    private AuthenticatedUser authenticatedUser;
    private boolean subjectIdentifierStep;
    private boolean subjectAttributeStep;
    private String authenticatedIdP;
    private AuthenticatorConfig authenticatedAutenticator;
    private List<AuthenticatorConfig> authenticatorList = new ArrayList<AuthenticatorConfig>();
    private List<String> authenticatorMappings = new ArrayList<String>();
    private boolean completed;
    private boolean multiOption;
    private boolean retrying;
    private boolean forced;

    public StepConfig() {
    }

    public StepConfig(StepConfig stepConfig) {
        this.order = stepConfig.getOrder();
        this.loginPage = stepConfig.getLoginPage();
        this.authenticatedUser = stepConfig.getAuthenticatedUser();
        this.subjectIdentifierStep = stepConfig.isSubjectIdentifierStep();
        this.subjectAttributeStep = stepConfig.isSubjectAttributeStep();
        this.authenticatedIdP = stepConfig.getAuthenticatedIdP();
        this.authenticatedAutenticator = stepConfig.getAuthenticatedAutenticator() != null ? new AuthenticatorConfig(stepConfig.getAuthenticatedAutenticator()) : null;
        this.authenticatorList = new ArrayList<AuthenticatorConfig>();
        for (AuthenticatorConfig authenticator : stepConfig.getAuthenticatorList()) {
            this.authenticatorList.add(new AuthenticatorConfig(authenticator));
        }
        this.authenticatorMappings = new ArrayList<String>(stepConfig.getAuthenticatorMappings());
        this.completed = stepConfig.isCompleted();
        this.multiOption = stepConfig.isMultiOption();
        this.retrying = stepConfig.isRetrying();
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public List<String> getAuthenticatorMappings() {
        return this.authenticatorMappings;
    }

    public void setAuthenticatorMappings(List<String> authenticatorMappings) {
        this.authenticatorMappings = authenticatorMappings;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public List<AuthenticatorConfig> getAuthenticatorList() {
        return this.authenticatorList;
    }

    public void setAuthenticatorList(List<AuthenticatorConfig> authenticatorList) {
        this.authenticatorList = authenticatorList;
    }

    public AuthenticatedUser getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public void setAuthenticatedUser(AuthenticatedUser authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
    }

    public String getAuthenticatedIdP() {
        return this.authenticatedIdP;
    }

    public void setAuthenticatedIdP(String authenticatedIdP) {
        this.authenticatedIdP = authenticatedIdP;
    }

    public AuthenticatorConfig getAuthenticatedAutenticator() {
        return this.authenticatedAutenticator;
    }

    public void setAuthenticatedAutenticator(AuthenticatorConfig authenticatedAutenticator) {
        this.authenticatedAutenticator = authenticatedAutenticator;
    }

    public boolean isSubjectAttributeStep() {
        return this.subjectAttributeStep;
    }

    public void setSubjectAttributeStep(boolean subjectAttributeStep) {
        this.subjectAttributeStep = subjectAttributeStep;
    }

    public boolean isSubjectIdentifierStep() {
        return this.subjectIdentifierStep;
    }

    public void setSubjectIdentifierStep(boolean subjectIdentifierStep) {
        this.subjectIdentifierStep = subjectIdentifierStep;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public boolean isMultiOption() {
        return this.multiOption;
    }

    public void setMultiOption(boolean multiOption) {
        this.multiOption = multiOption;
    }

    public boolean isRetrying() {
        return this.retrying;
    }

    public void setRetrying(boolean retrying) {
        this.retrying = retrying;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public void applyStateChangesToNewObjectFromContextStepMap(StepConfig stepConfigFromContext) {
        if (stepConfigFromContext != null) {
            this.completed = stepConfigFromContext.isCompleted();
            this.multiOption = stepConfigFromContext.isMultiOption();
            this.retrying = stepConfigFromContext.isRetrying();
            this.subjectIdentifierStep = stepConfigFromContext.isSubjectIdentifierStep();
            this.subjectAttributeStep = stepConfigFromContext.isSubjectAttributeStep();
        }
    }
}

