/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.JustInTimeProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ExternalIdPConfig
implements Serializable {
    private static final long serialVersionUID = 8406982734621371639L;
    private IdentityProvider identityProvider;
    private ClaimConfig claimConfiguration;
    private PermissionsAndRoleConfig roleConfiguration;
    private JustInTimeProvisioningConfig justInTimeProConfig;
    private Map<String, String> parameterMap = new HashMap<String, String>();
    private Map<String, String> roleMappings = new HashMap<String, String>();

    public ExternalIdPConfig() {
    }

    public ExternalIdPConfig(IdentityProvider identityProvider) {
        RoleMapping[] mappings;
        this.identityProvider = identityProvider;
        this.claimConfiguration = identityProvider.getClaimConfig();
        this.roleConfiguration = identityProvider.getPermissionAndRoleConfig();
        this.justInTimeProConfig = identityProvider.getJustInTimeProvisioningConfig();
        if (this.roleConfiguration != null && (mappings = this.roleConfiguration.getRoleMappings()) != null && mappings.length > 0) {
            for (RoleMapping roleMapping : mappings) {
                if (StringUtils.isNotEmpty((String)roleMapping.getLocalRole().getUserStoreId())) {
                    this.roleMappings.put(roleMapping.getRemoteRole(), UserCoreUtil.addDomainToName((String)roleMapping.getLocalRole().getLocalRoleName(), (String)roleMapping.getLocalRole().getUserStoreId()));
                    continue;
                }
                this.roleMappings.put(roleMapping.getRemoteRole(), roleMapping.getLocalRole().getLocalRoleName());
            }
        }
    }

    public String getIdPName() {
        return this.identityProvider.getIdentityProviderName();
    }

    public String getPublicCert() {
        return this.identityProvider.getCertificate();
    }

    public boolean isPrimary() {
        return this.identityProvider.isPrimary();
    }

    public String getName() {
        return this.identityProvider.getIdentityProviderName();
    }

    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, String> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public String getDomain() {
        return this.identityProvider.getHomeRealmId();
    }

    public boolean isFederationHubIdP() {
        return this.identityProvider.isFederationHub();
    }

    public ClaimMapping[] getClaimMappings() {
        if (this.claimConfiguration != null) {
            return this.claimConfiguration.getClaimMappings();
        }
        return new ClaimMapping[0];
    }

    public String[] getRoles() {
        if (this.roleConfiguration != null) {
            return this.roleConfiguration.getIdpRoles();
        }
        return new String[0];
    }

    public Map<String, String> getRoleMappings() {
        return this.roleMappings;
    }

    public Claim[] getClaims() {
        if (this.claimConfiguration != null) {
            return this.claimConfiguration.getIdpClaims();
        }
        return new Claim[0];
    }

    public String getProvisioningUserStoreId() {
        if (this.justInTimeProConfig != null) {
            return this.justInTimeProConfig.getProvisioningUserStore();
        }
        return null;
    }

    public String getProvisioningUserStoreClaimURI() {
        if (this.justInTimeProConfig != null) {
            return this.justInTimeProConfig.getUserStoreClaimUri();
        }
        return null;
    }

    public String getTokenEndpointAlias() {
        return this.identityProvider.getAlias();
    }

    public boolean isProvisioningEnabled() {
        if (this.justInTimeProConfig != null) {
            return this.justInTimeProConfig.isProvisioningEnabled();
        }
        return false;
    }

    public boolean isPasswordProvisioningEnabled() {
        if (this.justInTimeProConfig != null) {
            return this.justInTimeProConfig.isPasswordProvisioningEnabled();
        }
        return false;
    }

    public boolean isModifyUserNameAllowed() {
        if (this.justInTimeProConfig != null) {
            return this.justInTimeProConfig.isModifyUserNameAllowed();
        }
        return false;
    }

    public boolean isPromptConsentEnabled() {
        if (this.justInTimeProConfig != null) {
            return this.justInTimeProConfig.isPromptConsent();
        }
        return false;
    }

    public String getRoleClaimUri() {
        if (this.identityProvider.getClaimConfig() != null) {
            return this.identityProvider.getClaimConfig().getRoleClaimURI();
        }
        return null;
    }

    public String getUserIdClaimUri() {
        if (this.identityProvider.getClaimConfig() != null) {
            return this.identityProvider.getClaimConfig().getUserClaimURI();
        }
        return null;
    }

    public boolean useDefaultLocalIdpDialect() {
        if (this.claimConfiguration != null) {
            return this.claimConfiguration.isLocalClaimDialect();
        }
        return false;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }
}

