/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorStateInfo;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;

public class AuthenticatorConfig
implements Serializable {
    private static final long serialVersionUID = 4391415512399764048L;
    private String name;
    private boolean enabled;
    private ApplicationAuthenticator applicationAuthenticator;
    private AuthenticatorStateInfo authenticatorStateInfo;
    private Map<String, String> parameterMap;
    private Map<String, IdentityProvider> idps = new HashMap<String, IdentityProvider>();
    private List<String> idpNames = new ArrayList<String>();

    public AuthenticatorConfig() {
    }

    public AuthenticatorConfig(String name, boolean enabled, Map<String, String> parameterMap) {
        this.name = name;
        this.enabled = enabled;
        this.parameterMap = parameterMap;
    }

    public AuthenticatorConfig(AuthenticatorConfig authenticatorConfig) {
        this.name = authenticatorConfig.getName();
        this.applicationAuthenticator = authenticatorConfig.getApplicationAuthenticator();
        this.authenticatorStateInfo = authenticatorConfig.getAuthenticatorStateInfo();
        this.enabled = authenticatorConfig.isEnabled();
        this.idpNames = authenticatorConfig.getIdpNames() != null ? new ArrayList<String>(authenticatorConfig.getIdpNames()) : null;
        this.idps = authenticatorConfig.getIdps() != null ? new HashMap<String, IdentityProvider>(authenticatorConfig.getIdps()) : null;
        this.parameterMap = authenticatorConfig.getParameterMap() != null ? new HashMap<String, String>(authenticatorConfig.getParameterMap()) : null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, String> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ApplicationAuthenticator getApplicationAuthenticator() {
        return this.applicationAuthenticator;
    }

    public void setApplicationAuthenticator(ApplicationAuthenticator applicationAuthenticator) {
        this.applicationAuthenticator = applicationAuthenticator;
    }

    public AuthenticatorStateInfo getAuthenticatorStateInfo() {
        return this.authenticatorStateInfo;
    }

    public void setAuthenticatorStateInfo(AuthenticatorStateInfo authenticatorStateInfo) {
        this.authenticatorStateInfo = authenticatorStateInfo;
    }

    public List<String> getIdpNames() {
        return this.idpNames;
    }

    public Map<String, IdentityProvider> getIdps() {
        return this.idps;
    }
}

