/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.common.model.ApplicationPermission;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;

public class ApplicationConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8082478632322393384L;
    private ServiceProvider serviceProvider = null;
    private int applicationID = 0;
    private String applicationName = null;
    private String roleClaim = null;
    private boolean alwaysSendMappedLocalSubjectId = false;
    private boolean mappedSubjectIDSelected = false;
    private String subjectClaimUri;
    private String[] permissions = new String[0];
    private Map<String, String> claimMappings = new HashMap<String, String>();
    private Map<String, String> roleMappings = new HashMap<String, String>();
    private Map<String, String> requestedClaims = new HashMap<String, String>();
    private Map<String, String> mandatoryClaims = new HashMap<String, String>();
    private boolean isSaaSApp;
    private boolean useTenantDomainInLocalSubjectIdentifier = false;
    private boolean useUserstoreDomainInLocalSubjectIdentifier = false;
    private boolean enableAuthorization = false;
    private boolean useUserstoreDomainInRole = false;
    private static final Log log = LogFactory.getLog(ApplicationConfig.class);

    public ApplicationConfig(ServiceProvider application) {
        PermissionsAndRoleConfig permissionRoleConfiguration;
        ClaimConfig claimConfig;
        this.serviceProvider = application;
        this.applicationID = application.getApplicationID();
        this.applicationName = application.getApplicationName();
        this.isSaaSApp = application.isSaasApp();
        LocalAndOutboundAuthenticationConfig outboundAuthConfig = application.getLocalAndOutBoundAuthenticationConfig();
        if (outboundAuthConfig != null) {
            this.subjectClaimUri = outboundAuthConfig.getSubjectClaimUri();
            this.setUseTenantDomainInLocalSubjectIdentifier(outboundAuthConfig.isUseTenantDomainInLocalSubjectIdentifier());
            this.setUseUserstoreDomainInLocalSubjectIdentifier(outboundAuthConfig.isUseUserstoreDomainInLocalSubjectIdentifier());
            this.setEnableAuthorization(outboundAuthConfig.isEnableAuthorization());
            this.setUseUserstoreDomainInRole(outboundAuthConfig.isUseUserstoreDomainInRoles());
        }
        if ((claimConfig = application.getClaimConfig()) != null) {
            this.roleClaim = claimConfig.getRoleClaimURI();
            this.alwaysSendMappedLocalSubjectId = claimConfig.isAlwaysSendMappedLocalSubjectId();
            ArrayList<ClaimMapping> spClaimMappings = new ArrayList<ClaimMapping>(Arrays.asList(claimConfig.getClaimMappings()));
            this.setSpDialectClaims(claimConfig, spClaimMappings);
            if (CollectionUtils.isNotEmpty(spClaimMappings)) {
                for (ClaimMapping claim : spClaimMappings) {
                    if (claim.getRemoteClaim() == null || claim.getRemoteClaim().getClaimUri() == null) continue;
                    if (claim.getLocalClaim() != null) {
                        this.claimMappings.put(claim.getRemoteClaim().getClaimUri(), claim.getLocalClaim().getClaimUri());
                        if (claim.isRequested()) {
                            this.requestedClaims.put(claim.getRemoteClaim().getClaimUri(), claim.getLocalClaim().getClaimUri());
                        }
                        if (!claim.isMandatory()) continue;
                        this.mandatoryClaims.put(claim.getRemoteClaim().getClaimUri(), claim.getLocalClaim().getClaimUri());
                        continue;
                    }
                    this.claimMappings.put(claim.getRemoteClaim().getClaimUri(), null);
                    if (claim.isRequested()) {
                        this.requestedClaims.put(claim.getRemoteClaim().getClaimUri(), null);
                    }
                    if (!claim.isMandatory()) continue;
                    this.mandatoryClaims.put(claim.getRemoteClaim().getClaimUri(), null);
                }
            }
        }
        if ((permissionRoleConfiguration = application.getPermissionAndRoleConfig()) != null) {
            ApplicationPermission[] permissionList = permissionRoleConfiguration.getPermissions();
            if (permissionList == null) {
                permissionList = new ApplicationPermission[]{};
            }
            this.permissions = new String[permissionList.length];
            for (int i = 0; i < permissionList.length; ++i) {
                ApplicationPermission permission = permissionList[i];
                this.permissions[i] = permission.getValue();
            }
            RoleMapping[] tempRoleMappings = permissionRoleConfiguration.getRoleMappings();
            if (tempRoleMappings != null && tempRoleMappings.length > 0) {
                for (RoleMapping roleMapping : tempRoleMappings) {
                    this.roleMappings.put(roleMapping.getLocalRole().getLocalRoleName(), roleMapping.getRemoteRole());
                }
            }
        }
    }

    public void setUseUserstoreDomainInRole(boolean useUserstoreDomainInRole) {
        this.useUserstoreDomainInRole = useUserstoreDomainInRole;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public void setApplicationID(int applicationID) {
        this.applicationID = applicationID;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getRoleClaim() {
        return this.roleClaim;
    }

    public void setRoleClaim(String roleClaim) {
        this.roleClaim = roleClaim;
    }

    public String[] getPermissions() {
        if (this.permissions != null) {
            return (String[])this.permissions.clone();
        }
        return new String[0];
    }

    public void setPermissions(String[] permissions) {
        if (permissions != null) {
            this.permissions = (String[])permissions.clone();
        }
    }

    public Map<String, String> getClaimMappings() {
        return this.claimMappings;
    }

    public void setClaimMappings(Map<String, String> claimMappings) {
        this.claimMappings = claimMappings;
    }

    public Map<String, String> getRequestedClaimMappings() {
        return this.requestedClaims;
    }

    public void setRequestedClaims(Map<String, String> requestedClaims) {
        this.requestedClaims = requestedClaims;
    }

    public Map<String, String> getMandatoryClaimMappings() {
        return this.mandatoryClaims;
    }

    public void setMandatoryClaims(Map<String, String> mandatoryClaims) {
        this.mandatoryClaims = mandatoryClaims;
    }

    public Map<String, String> getRoleMappings() {
        return this.roleMappings;
    }

    public void setRoleMappings(Map<String, String> roleMappings) {
        this.roleMappings = roleMappings;
    }

    public boolean noClaimMapping() {
        return this.claimMappings == null;
    }

    public boolean isAlwaysSendMappedLocalSubjectId() {
        return this.alwaysSendMappedLocalSubjectId;
    }

    public void setAlwaysSendMappedLocalSubjectId(boolean alwaysSendMappedLocalSubjectId) {
        this.alwaysSendMappedLocalSubjectId = alwaysSendMappedLocalSubjectId;
    }

    public boolean isMappedSubjectIDSelected() {
        return this.mappedSubjectIDSelected;
    }

    public void setMappedSubjectIDSelected(boolean mappedSubjectIDSelected) {
        this.mappedSubjectIDSelected = mappedSubjectIDSelected;
    }

    public String getSubjectClaimUri() {
        return this.subjectClaimUri;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public boolean isSaaSApp() {
        return this.isSaaSApp;
    }

    public boolean isUseTenantDomainInLocalSubjectIdentifier() {
        return this.useTenantDomainInLocalSubjectIdentifier;
    }

    public void setUseTenantDomainInLocalSubjectIdentifier(boolean useTenantDomainInLocalSubjectIdentifier) {
        this.useTenantDomainInLocalSubjectIdentifier = useTenantDomainInLocalSubjectIdentifier;
    }

    public boolean isUseUserstoreDomainInLocalSubjectIdentifier() {
        return this.useUserstoreDomainInLocalSubjectIdentifier;
    }

    public void setUseUserstoreDomainInLocalSubjectIdentifier(boolean useUserstoreDomainInLocalSubjectIdentifier) {
        this.useUserstoreDomainInLocalSubjectIdentifier = useUserstoreDomainInLocalSubjectIdentifier;
    }

    public boolean isEnableAuthorization() {
        return this.enableAuthorization;
    }

    public void setEnableAuthorization(boolean enableAuthorization) {
        this.enableAuthorization = enableAuthorization;
    }

    public Object clone() throws CloneNotSupportedException {
        ApplicationConfig applicationConfig = (ApplicationConfig)super.clone();
        applicationConfig.setClaimMappings(new HashMap<String, String>(this.claimMappings));
        applicationConfig.setRoleMappings(new HashMap<String, String>(this.roleMappings));
        applicationConfig.requestedClaims = new HashMap<String, String>(this.requestedClaims);
        applicationConfig.mandatoryClaims = new HashMap<String, String>(this.mandatoryClaims);
        applicationConfig.setPermissions((String[])this.permissions.clone());
        return applicationConfig;
    }

    private void setSpDialectClaims(ClaimConfig claimConfig, List<ClaimMapping> spClaimMappings) {
        Object[] spClaimDialects = claimConfig.getSpClaimDialects();
        if (!ArrayUtils.isEmpty((Object[])spClaimDialects)) {
            List<Object> spClaimDialectsList = Arrays.asList(spClaimDialects);
            spClaimDialectsList.forEach(spClaimDialect -> {
                try {
                    String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                    if ("http://wso2.org/claims".equals(spClaimDialect)) {
                        List localClaims = FrameworkServiceDataHolder.getInstance().getClaimMetadataManagementService().getLocalClaims(tenantDomain);
                        localClaims.stream().map(localClaim -> ClaimMapping.build((String)localClaim.getClaimURI(), (String)localClaim.getClaimURI(), null, (boolean)true)).forEach(spClaimMappings::add);
                    } else {
                        List externalClaims = FrameworkServiceDataHolder.getInstance().getClaimMetadataManagementService().getExternalClaims(spClaimDialect, tenantDomain);
                        externalClaims.stream().map(externalClaim -> ClaimMapping.build((String)externalClaim.getMappedLocalClaim(), (String)externalClaim.getClaimURI(), null, (boolean)true)).forEach(spClaimMappings::add);
                    }
                }
                catch (ClaimMetadataException e) {
                    log.error((Object)("Error when getting external claims of dialect: " + spClaimDialect), (Throwable)e);
                }
            });
        }
    }
}

