/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.loader.SequenceLoader;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ApplicationConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.AuthenticationGraph;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.JsGraphBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.JsGraphBuilderFactory;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.common.model.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.LocalAndOutboundAuthenticationConfig;
import org.wso2.carbon.identity.application.common.model.LocalAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.RequestPathAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.common.model.script.AuthenticationScriptConfig;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class UIBasedConfigurationLoader
implements SequenceLoader {
    private static final Log log = LogFactory.getLog(UIBasedConfigurationLoader.class);

    @Override
    public SequenceConfig getSequenceConfig(AuthenticationContext context, Map<String, String[]> parameterMap, ServiceProvider serviceProvider) throws FrameworkException {
        String tenantDomain = context.getTenantDomain();
        AuthenticationStep[] authenticationSteps = null;
        LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig = serviceProvider.getLocalAndOutBoundAuthenticationConfig();
        if (localAndOutboundAuthenticationConfig.getAuthenticationSteps() != null && localAndOutboundAuthenticationConfig.getAuthenticationSteps().length > 0) {
            authenticationSteps = localAndOutboundAuthenticationConfig.getAuthenticationSteps();
        }
        SequenceConfig sequenceConfig = this.getSequence(serviceProvider, tenantDomain, authenticationSteps);
        if (this.isAuthenticationScriptBasedSequence(localAndOutboundAuthenticationConfig)) {
            HashMap<Integer, StepConfig> originalStepConfigMap = new HashMap<Integer, StepConfig>(sequenceConfig.getStepMap());
            HashMap<Integer, StepConfig> stepConfigMapCopy = new HashMap<Integer, StepConfig>();
            originalStepConfigMap.forEach((k, v) -> stepConfigMapCopy.put((Integer)k, new StepConfig((StepConfig)v)));
            sequenceConfig.getStepMap().clear();
            JsGraphBuilderFactory jsGraphBuilderFactory = FrameworkServiceDataHolder.getInstance().getJsGraphBuilderFactory();
            JsGraphBuilder jsGraphBuilder = jsGraphBuilderFactory.createBuilder(context, stepConfigMapCopy);
            context.setServiceProviderName(serviceProvider.getApplicationName());
            AuthenticationGraph graph = jsGraphBuilder.createWith(localAndOutboundAuthenticationConfig.getAuthenticationScriptConfig().getContent()).build();
            graph.setEnabled(localAndOutboundAuthenticationConfig.getAuthenticationScriptConfig().isEnabled());
            sequenceConfig.setAuthenticationGraph(graph);
            graph.setStepMap(originalStepConfigMap);
        }
        return sequenceConfig;
    }

    private boolean isAuthenticationScriptBasedSequence(LocalAndOutboundAuthenticationConfig localAndOutboundAuthenticationConfig) {
        if ("flow".equals(localAndOutboundAuthenticationConfig.getAuthenticationType()) || "default".equals(localAndOutboundAuthenticationConfig.getAuthenticationType())) {
            AuthenticationScriptConfig authenticationScriptConfig = localAndOutboundAuthenticationConfig.getAuthenticationScriptConfig();
            return authenticationScriptConfig != null && authenticationScriptConfig.isEnabled();
        }
        return false;
    }

    @Deprecated
    public SequenceConfig getSequence(ServiceProvider serviceProvider, String tenantDomain) throws FrameworkException {
        if (serviceProvider == null) {
            throw new FrameworkException("ServiceProvider cannot be null");
        }
        AuthenticationStep[] authenticationSteps = serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps();
        return this.getSequence(serviceProvider, tenantDomain, authenticationSteps);
    }

    public SequenceConfig getSequence(ServiceProvider serviceProvider, String tenantDomain, AuthenticationStep[] authenticationSteps) throws FrameworkException {
        if (serviceProvider == null) {
            throw new FrameworkException("ServiceProvider cannot be null");
        }
        SequenceConfig sequenceConfig = new SequenceConfig();
        sequenceConfig.setApplicationId(serviceProvider.getApplicationName());
        sequenceConfig.setApplicationConfig(new ApplicationConfig(serviceProvider));
        this.loadRequestPathAuthenticators(sequenceConfig, serviceProvider);
        int stepOrder = 0;
        if (authenticationSteps == null) {
            return sequenceConfig;
        }
        for (AuthenticationStep authenticationStep : authenticationSteps) {
            try {
                stepOrder = authenticationStep.getStepOrder();
            }
            catch (NumberFormatException e) {
                ++stepOrder;
            }
            StepConfig stepConfig = this.createStepConfigurationObject(stepOrder, authenticationStep);
            this.loadFederatedAuthenticators(authenticationStep, stepConfig, tenantDomain);
            this.loadLocalAuthenticators(authenticationStep, stepConfig);
            sequenceConfig.getStepMap().put(stepOrder, stepConfig);
        }
        return sequenceConfig;
    }

    protected StepConfig createStepConfigurationObject(int stepOrder, AuthenticationStep authenticationStep) {
        StepConfig stepConfig = new StepConfig();
        stepConfig.setOrder(stepOrder);
        stepConfig.setSubjectAttributeStep(authenticationStep.isAttributeStep());
        stepConfig.setSubjectIdentifierStep(authenticationStep.isSubjectStep());
        return stepConfig;
    }

    protected void loadRequestPathAuthenticators(SequenceConfig sequenceConfig, ServiceProvider serviceProvider) {
        if (serviceProvider.getRequestPathAuthenticatorConfigs() != null && serviceProvider.getRequestPathAuthenticatorConfigs().length > 0) {
            RequestPathAuthenticatorConfig[] reqAuths;
            ArrayList<AuthenticatorConfig> requestPathAuthenticators = new ArrayList<AuthenticatorConfig>();
            for (RequestPathAuthenticatorConfig reqAuth : reqAuths = serviceProvider.getRequestPathAuthenticatorConfigs()) {
                AuthenticatorConfig authConfig = new AuthenticatorConfig();
                String authenticatorName = reqAuth.getName();
                authConfig.setName(authenticatorName);
                authConfig.setEnabled(true);
                for (ApplicationAuthenticator appAuthenticator : FrameworkServiceComponent.getAuthenticators()) {
                    if (!authenticatorName.equalsIgnoreCase(appAuthenticator.getName())) continue;
                    authConfig.setApplicationAuthenticator(appAuthenticator);
                    break;
                }
                requestPathAuthenticators.add(authConfig);
            }
            sequenceConfig.setReqPathAuthenticators(requestPathAuthenticators);
        }
    }

    protected void loadFederatedAuthenticators(AuthenticationStep authenticationStep, StepConfig stepConfig, String tenantDomain) throws FrameworkException {
        IdentityProvider[] federatedIDPs = authenticationStep.getFederatedIdentityProviders();
        if (federatedIDPs != null) {
            for (IdentityProvider federatedIDP : federatedIDPs) {
                FederatedAuthenticatorConfig federatedAuthenticator = federatedIDP.getDefaultAuthenticatorConfig();
                if (federatedAuthenticator == null) {
                    try {
                        federatedAuthenticator = IdentityProviderManager.getInstance().getIdPByName(federatedIDP.getIdentityProviderName(), tenantDomain).getDefaultAuthenticatorConfig();
                    }
                    catch (IdentityProviderManagementException e) {
                        throw new FrameworkException("Failed to load the default authenticator for IDP : " + federatedIDP.getIdentityProviderName(), e);
                    }
                }
                String actualAuthenticatorName = federatedAuthenticator.getName();
                this.loadStepAuthenticator(stepConfig, federatedIDP, actualAuthenticatorName);
            }
        }
    }

    protected void loadLocalAuthenticators(AuthenticationStep authenticationStep, StepConfig stepConfig) {
        LocalAuthenticatorConfig[] localAuthenticators = authenticationStep.getLocalAuthenticatorConfigs();
        if (localAuthenticators != null) {
            IdentityProvider localIdp = new IdentityProvider();
            localIdp.setIdentityProviderName("LOCAL");
            for (LocalAuthenticatorConfig localAuthenticator : localAuthenticators) {
                String actualAuthenticatorName = localAuthenticator.getName();
                this.loadStepAuthenticator(stepConfig, localIdp, actualAuthenticatorName);
            }
        }
    }

    private void loadStepAuthenticator(StepConfig stepConfig, IdentityProvider idp, String authenticatorName) {
        AuthenticatorConfig authenticatorConfig = null;
        for (AuthenticatorConfig authConfig : stepConfig.getAuthenticatorList()) {
            if (!authenticatorName.equals(authConfig.getName())) continue;
            authenticatorConfig = authConfig;
            break;
        }
        if (authenticatorConfig == null) {
            authenticatorConfig = new AuthenticatorConfig();
            authenticatorConfig.setName(authenticatorName);
            for (ApplicationAuthenticator appAuthenticator : FrameworkServiceComponent.getAuthenticators()) {
                if (!authenticatorName.equalsIgnoreCase(appAuthenticator.getName())) continue;
                authenticatorConfig.setApplicationAuthenticator(appAuthenticator);
                break;
            }
            stepConfig.getAuthenticatorList().add(authenticatorConfig);
        }
        if (idp != null) {
            authenticatorConfig.getIdpNames().add(idp.getIdentityProviderName());
            authenticatorConfig.getIdps().put(idp.getIdentityProviderName(), idp);
        }
        if (!(stepConfig.isMultiOption() || stepConfig.getAuthenticatorList().size() <= 1 && authenticatorConfig.getIdps().size() <= 1)) {
            stepConfig.setMultiOption(true);
        }
    }
}

