/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class FileBasedConfigurationBuilder {
    private static final Log log = LogFactory.getLog(FileBasedConfigurationBuilder.class);
    private static volatile FileBasedConfigurationBuilder instance;
    private static String configFilePath;
    private static OMElement rootElement;
    private static Map<String, Object> configuration;
    public static final String[] UNSUPPORTED_EXTENSIONS;
    private String authenticationEndpointURL;
    private String authenticationEndpointRetryURL;
    private String authenticationEndpointWaitURL;
    private String identifierFirstConfirmationURL;
    private String authenticationEndpointPromptURL;
    private String authenticationEndpointMissingClaimsURL;
    private boolean allowCustomClaimMappingsForAuthenticators = false;
    private List<String> tenantDataEndpointURLs = new ArrayList<String>();
    private boolean isTenantDomainDropdownEnabled;
    private boolean isDumbMode;
    private List<ExternalIdPConfig> idpList = new ArrayList<ExternalIdPConfig>();
    private List<SequenceConfig> sequenceList = new ArrayList<SequenceConfig>();
    private List<String> authEndpointQueryParams = new ArrayList<String>();
    private Map<String, AuthenticatorConfig> authenticatorConfigMap = new HashMap<String, AuthenticatorConfig>();
    private Map<String, Object> extensions = new HashMap<String, Object>();
    private int maxLoginAttemptCount = 5;
    private Map<String, String> authenticatorNameMappings = new HashMap<String, String>();
    private Map<String, Integer> cacheTimeouts = new HashMap<String, Integer>();
    private String authEndpointQueryParamsAction;
    private boolean authEndpointQueryParamsConfigAvailable;
    private boolean removeAPIParametersOnConsume;
    private boolean authEndpointRedirectParamsConfigAvailable;
    private String authEndpointRedirectParamsAction;
    private List<String> authEndpointRedirectParams = new ArrayList<String>();
    private List<String> filteringEnabledHostNames = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileBasedConfigurationBuilder getInstance() {
        if (instance != null) return instance;
        Class<FileBasedConfigurationBuilder> clazz = FileBasedConfigurationBuilder.class;
        synchronized (FileBasedConfigurationBuilder.class) {
            if (instance != null) return instance;
            instance = new FileBasedConfigurationBuilder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public static FileBasedConfigurationBuilder getInstance(String filePath) {
        configFilePath = filePath;
        return FileBasedConfigurationBuilder.getInstance();
    }

    public OMElement getConfigElement(String localPart) {
        return rootElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)localPart));
    }

    public Map<String, Object> getConfiguration() {
        return configuration;
    }

    private FileBasedConfigurationBuilder() {
        this.buildConfiguration();
    }

    private void buildConfiguration() {
        Path configFile = configFilePath != null ? Paths.get(configFilePath, new String[0]) : Paths.get(IdentityUtil.getIdentityConfigDirPath(), "application-authentication.xml");
        try (InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);){
            this.buildConfiguration(inputStream);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"application-authentication.xml file is not available", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private void buildConfiguration(InputStream inStream) throws IOException {
        try {
            StAXOMBuilder builder = new StAXOMBuilder(inStream);
            rootElement = builder.getDocumentElement();
            Stack<String> nameStack = new Stack<String>();
            this.readChildElements(rootElement, nameStack);
            this.readAuthenticationEndpointURL(rootElement);
            this.readAuthenticationEndpointRetryURL(rootElement);
            this.readAuthenticationEndpointWaitURL(rootElement);
            this.readIdentifierFirstConfirmationURL(rootElement);
            this.readAuthenticationEndpointPromptURL(rootElement);
            this.readAuthenticationEndpointMissingClaimsURL(rootElement);
            this.readTenantDataListenerURLs(rootElement);
            this.readTenantDomainDropdownEnabledValue(rootElement);
            this.readProxyModes(rootElement);
            this.readMaximumLoginAttemptCount(rootElement);
            this.readFilteringEnabledHostNames(rootElement);
            this.readAuthenticationEndpointQueryParams(rootElement);
            this.readAuthenticationEndpointRedirectParams(rootElement);
            this.readExtensionPoints(rootElement);
            this.readCacheTimeouts(rootElement);
            this.readAuthenticatorNameMappings(rootElement);
            this.readAuthenticatorConfigs(rootElement);
            this.readIdpConfigs(rootElement);
            this.readSequenceConfigs(rootElement);
            this.readAllowCustomClaimMappingsForAuthenticatorsValue(rootElement);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error reading the application-authentication.xml", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error while parsing application-authentication.xml", (Throwable)e);
        }
    }

    private void readChildElements(OMElement serverConfig, Stack<String> nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            if (this.elementHasText(element)) {
                String key = this.getKey(nameStack);
                Object currentObject = configuration.get(key);
                String value = this.replaceSystemProperty(element.getText());
                if (currentObject == null) {
                    configuration.put(key, value);
                } else if (currentObject instanceof ArrayList) {
                    ArrayList list = (ArrayList)currentObject;
                    if (!list.contains(value)) {
                        list.add(value);
                    }
                } else if (!value.equals(currentObject)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(currentObject);
                    arrayList.add(value);
                    configuration.put(key, arrayList);
                }
            }
            this.readChildElements(element, nameStack);
            nameStack.pop();
        }
    }

    private String getKey(Stack<String> nameStack) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() != 0;
    }

    private String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        String tmpText = null;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue != null) {
                tmpText = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!"carbon.home".equals(sysProp) || !".".equals(System.getProperty("carbon.home"))) continue;
            tmpText = new File(".").getAbsolutePath() + File.separator + text;
        }
        return tmpText;
    }

    private void readSequenceConfigs(OMElement documentElement) {
        OMElement sequencesElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"Sequences"));
        if (sequencesElem != null) {
            Iterator sequenceElements = sequencesElem.getChildrenWithLocalName("Sequence");
            while (sequenceElements.hasNext()) {
                SequenceConfig sequenceConfig = this.processSequenceElement((OMElement)sequenceElements.next());
                if (sequenceConfig == null) continue;
                this.sequenceList.add(sequenceConfig);
            }
        }
    }

    private void readIdpConfigs(OMElement documentElement) {
        OMElement idpConfigsElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"IdPConfigs"));
        if (idpConfigsElem != null) {
            Iterator idpConfigElements = idpConfigsElem.getChildrenWithLocalName("IdPConfig");
            while (idpConfigElements.hasNext()) {
                ExternalIdPConfig idpConfig = this.processIdPConfigElement((OMElement)idpConfigElements.next());
                if (idpConfig == null) continue;
                this.idpList.add(idpConfig);
            }
        }
    }

    private void readAuthenticatorConfigs(OMElement documentElement) {
        OMElement authenticatorConfigsElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticatorConfigs"));
        if (authenticatorConfigsElem != null) {
            Iterator authenticatorConfigElements = authenticatorConfigsElem.getChildrenWithLocalName("AuthenticatorConfig");
            while (authenticatorConfigElements.hasNext()) {
                AuthenticatorConfig authenticatorConfig = this.processAuthenticatorConfigElement((OMElement)authenticatorConfigElements.next());
                if (authenticatorConfig == null) continue;
                this.authenticatorConfigMap.put(authenticatorConfig.getName(), authenticatorConfig);
            }
        }
    }

    private void readAuthenticatorNameMappings(OMElement documentElement) {
        OMElement authenticatorNameMappingsElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticatorNameMappings"));
        if (authenticatorNameMappingsElem != null) {
            Iterator authenticatorNameMappingElems = authenticatorNameMappingsElem.getChildrenWithLocalName("AuthenticatorNameMapping");
            while (authenticatorNameMappingElems.hasNext()) {
                this.processAuthenticatorNameMappingElement((OMElement)authenticatorNameMappingElems.next());
            }
        }
    }

    private void readCacheTimeouts(OMElement documentElement) {
        OMElement cacheTimeoutsElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"CacheTimeouts"));
        if (cacheTimeoutsElem != null) {
            Iterator cacheChildElems = cacheTimeoutsElem.getChildElements();
            while (cacheChildElems.hasNext()) {
                OMElement cacheTimeoutElem = (OMElement)cacheChildElems.next();
                String value = cacheTimeoutElem.getText();
                if (value == null || value.trim().length() <= 0) continue;
                this.readCacheTimeOut(cacheTimeoutElem, value);
            }
        }
    }

    private void readExtensionPoints(OMElement documentElement) {
        OMElement extensionsElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"Extensions"));
        if (extensionsElem != null) {
            Iterator extChildElems = extensionsElem.getChildElements();
            while (extChildElems.hasNext()) {
                OMElement extensionElem = (OMElement)extChildElems.next();
                if (!this.isValidExtension(extensionElem)) continue;
                this.instantiateClass(extensionElem);
            }
        }
    }

    private boolean isValidExtension(OMElement extensionElement) {
        String extensionName = extensionElement.getQName().getLocalPart();
        String extensionClass = extensionElement.getText();
        for (String unsupportedExtension : UNSUPPORTED_EXTENSIONS) {
            if (!unsupportedExtension.equalsIgnoreCase(extensionName)) continue;
            log.warn((Object)("======== Extension " + extensionName + " With class " + extensionClass + " is no longer supported. If you have customized the OOTB class please do an extension migration using migration guide."));
            return false;
        }
        return true;
    }

    private void readFilteringEnabledHostNames(OMElement documentElement) {
        Iterator hostNames;
        OMElement filteringEnabledHostNamesElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"FilteringEnabledHostNames"));
        if (filteringEnabledHostNamesElem != null && (hostNames = filteringEnabledHostNamesElem.getChildrenWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"HostName"))) != null) {
            while (hostNames.hasNext()) {
                OMElement hostNameElement = (OMElement)hostNames.next();
                if (hostNameElement == null) continue;
                this.filteringEnabledHostNames.add(hostNameElement.getText());
            }
        }
    }

    private void readAuthenticationEndpointQueryParams(OMElement documentElement) {
        OMElement authEndpointQueryParamsElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticationEndpointQueryParams"));
        if (authEndpointQueryParamsElem != null) {
            String actionValue;
            this.authEndpointQueryParamsConfigAvailable = true;
            OMAttribute actionAttr = authEndpointQueryParamsElem.getAttribute(new QName("action"));
            this.authEndpointQueryParamsAction = "exclude";
            if (actionAttr != null && (actionValue = actionAttr.getAttributeValue()) != null && !actionValue.isEmpty()) {
                this.authEndpointQueryParamsAction = actionValue;
            }
            Iterator authEndpointQueryParamElems = authEndpointQueryParamsElem.getChildrenWithLocalName("AuthenticationEndpointQueryParam");
            while (authEndpointQueryParamElems.hasNext()) {
                String queryParamName = this.processAuthEndpointQueryParamElem((OMElement)authEndpointQueryParamElems.next());
                if (queryParamName == null) continue;
                this.authEndpointQueryParams.add(queryParamName);
            }
        }
    }

    private void readAuthenticationEndpointRedirectParams(OMElement documentElement) {
        OMElement authEndpointRedirectParamsElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticationEndpointRedirectParams"));
        if (authEndpointRedirectParamsElem != null) {
            String actionValue;
            this.authEndpointRedirectParamsConfigAvailable = true;
            OMAttribute actionAttr = authEndpointRedirectParamsElem.getAttribute(new QName("action"));
            OMAttribute removeOnConsumeAttr = authEndpointRedirectParamsElem.getAttribute(new QName("removeOnConsumeFromAPI"));
            this.authEndpointRedirectParamsAction = "exclude";
            if (actionAttr != null && (actionValue = actionAttr.getAttributeValue()) != null && !actionValue.isEmpty()) {
                this.authEndpointRedirectParamsAction = actionValue;
            }
            if (removeOnConsumeAttr != null) {
                this.removeAPIParametersOnConsume = Boolean.parseBoolean(removeOnConsumeAttr.getAttributeValue());
            }
            Iterator authEndpointRedirectParamElems = authEndpointRedirectParamsElem.getChildrenWithLocalName("AuthenticationEndpointRedirectParam");
            while (authEndpointRedirectParamElems.hasNext()) {
                String redirectParamName = this.processAuthEndpointQueryParamElem((OMElement)authEndpointRedirectParamElems.next());
                if (redirectParamName == null) continue;
                this.authEndpointRedirectParams.add(redirectParamName);
            }
        }
    }

    private void readMaximumLoginAttemptCount(OMElement documentElement) {
        String maxLoginAttemptCountStr;
        OMElement maxLoginAttemptCountElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"MaxLoginAttemptCount"));
        if (maxLoginAttemptCountElem != null && (maxLoginAttemptCountStr = maxLoginAttemptCountElem.getText()) != null && !maxLoginAttemptCountStr.isEmpty()) {
            try {
                this.maxLoginAttemptCount = Integer.parseInt(maxLoginAttemptCountElem.getText());
            }
            catch (NumberFormatException e) {
                log.error((Object)"MaxLoginAttemptCount must be a number");
                this.maxLoginAttemptCount = 5;
            }
        }
    }

    private void readProxyModes(OMElement documentElement) {
        OMElement proxyModeElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"ProxyMode"));
        if (proxyModeElem != null && proxyModeElem.getText() != null && !proxyModeElem.getText().isEmpty() && "dumb".equalsIgnoreCase(proxyModeElem.getText())) {
            this.isDumbMode = true;
        }
    }

    private void readTenantDomainDropdownEnabledValue(OMElement documentElement) {
        OMElement tenantDomainDropdownElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"TenantDomainDropDownEnabled"));
        if (tenantDomainDropdownElem != null) {
            this.isTenantDomainDropdownEnabled = Boolean.parseBoolean(tenantDomainDropdownElem.getText());
        }
    }

    private void readTenantDataListenerURLs(OMElement documentElement) {
        OMElement tenantDataURLsElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"TenantDataListenerURLs"));
        if (tenantDataURLsElem != null) {
            Iterator tenantDataURLElems = tenantDataURLsElem.getChildrenWithLocalName("TenantDataListenerURL");
            while (tenantDataURLElems.hasNext()) {
                OMElement tenantDataListenerURLElem = (OMElement)tenantDataURLElems.next();
                if (tenantDataListenerURLElem == null || !StringUtils.isNotEmpty((String)tenantDataListenerURLElem.getText())) continue;
                this.tenantDataEndpointURLs.add(IdentityUtil.fillURLPlaceholders((String)tenantDataListenerURLElem.getText()));
            }
        }
    }

    private void readAuthenticationEndpointURL(OMElement documentElement) {
        OMElement authEndpointURLElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticationEndpointURL"));
        if (authEndpointURLElem != null) {
            this.authenticationEndpointURL = IdentityUtil.fillURLPlaceholders((String)authEndpointURLElem.getText());
        }
    }

    private void readAuthenticationEndpointRetryURL(OMElement documentElement) {
        OMElement authEndpointRetryURLElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticationEndpointRetryURL"));
        if (authEndpointRetryURLElem != null) {
            this.authenticationEndpointRetryURL = IdentityUtil.fillURLPlaceholders((String)authEndpointRetryURLElem.getText());
        }
    }

    private void readAuthenticationEndpointWaitURL(OMElement documentElement) {
        OMElement authEndpointWaitURLElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticationEndpointWaitURL"));
        if (authEndpointWaitURLElem != null) {
            this.authenticationEndpointWaitURL = IdentityUtil.fillURLPlaceholders((String)authEndpointWaitURLElem.getText());
        }
    }

    private void readIdentifierFirstConfirmationURL(OMElement documentElement) {
        OMElement readIDFConfirmationElement = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"IdentifierFirstConfirmationURL"));
        if (readIDFConfirmationElement != null) {
            this.identifierFirstConfirmationURL = IdentityUtil.fillURLPlaceholders((String)readIDFConfirmationElement.getText());
        }
    }

    private void readAuthenticationEndpointPromptURL(OMElement documentElement) {
        OMElement authEndpointPromptURLElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticationEndpointPromptURL"));
        if (authEndpointPromptURLElem != null) {
            this.authenticationEndpointPromptURL = IdentityUtil.fillURLPlaceholders((String)authEndpointPromptURLElem.getText());
        }
    }

    private void readAuthenticationEndpointMissingClaimsURL(OMElement documentElement) {
        OMElement authEndpointMissingClaimsURLElem = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AuthenticationEndpointMissingClaimsURL"));
        if (authEndpointMissingClaimsURLElem != null) {
            this.authenticationEndpointMissingClaimsURL = IdentityUtil.fillURLPlaceholders((String)authEndpointMissingClaimsURLElem.getText());
        }
    }

    public String getAuthenticationEndpointMissingClaimsURL() {
        return this.authenticationEndpointMissingClaimsURL;
    }

    public void setAuthenticationEndpointMissingClaimsURL(String authenticationEndpointMissingClaimsURL) {
        this.authenticationEndpointMissingClaimsURL = authenticationEndpointMissingClaimsURL;
    }

    private void readCacheTimeOut(OMElement cacheTimeoutElem, String value) {
        try {
            Integer timeout = Integer.valueOf(value);
            this.cacheTimeouts.put(cacheTimeoutElem.getLocalName(), timeout);
        }
        catch (NumberFormatException e) {
            log.warn((Object)(cacheTimeoutElem.getLocalName() + "doesn't have a numeric value specified.Entry is ignored"));
        }
    }

    private void instantiateClass(OMElement extensionElem) {
        try {
            String className = StringUtils.trimToEmpty((String)extensionElem.getText());
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            this.extensions.put(extensionElem.getLocalName(), obj);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stack trace skipped in Error log  : ", (Throwable)e);
            }
            log.error((Object)("ClassNotFoundException while trying to find class " + extensionElem.getText()));
        }
        catch (InstantiationException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stack trace skipped in Error log   : ", (Throwable)e);
            }
            log.error((Object)("InstantiationException while trying to instantiate class " + extensionElem.getText()));
        }
        catch (IllegalAccessException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stack trace skipped in Error log  : ", (Throwable)e);
            }
            log.error((Object)("IllegalAccessException while trying to instantiate class " + extensionElem.getText()));
        }
    }

    private String processAuthEndpointQueryParamElem(OMElement authEndpointQueryParamElem) {
        OMAttribute nameAttr = authEndpointQueryParamElem.getAttribute(new QName("name"));
        if (nameAttr == null) {
            log.warn((Object)"Each Authentication Endpoint Query Param should have a unique name attribute. This Query Param will skipped.");
            return null;
        }
        return nameAttr.getAttributeValue();
    }

    private void processAuthenticatorNameMappingElement(OMElement authenticatorNameMappingElem) {
        OMAttribute nameAttr = authenticatorNameMappingElem.getAttribute(new QName("name"));
        OMAttribute aliasAttr = authenticatorNameMappingElem.getAttribute(new QName("alias"));
        if (nameAttr == null || aliasAttr == null) {
            log.warn((Object)"An AuthenticatorNameMapping must contain 'name' and 'alias' attributes. Skipping the element.");
            return;
        }
        this.authenticatorNameMappings.put(aliasAttr.getAttributeValue(), nameAttr.getAttributeValue());
    }

    private SequenceConfig processSequenceElement(OMElement sequenceElem) {
        OMElement reqPathAuthenticatorsElem;
        OMAttribute checkAuthnAttr;
        SequenceConfig sequenceConfig = new SequenceConfig();
        String applicationId = "default";
        OMAttribute appIdAttr = sequenceElem.getAttribute(new QName("appId"));
        if (appIdAttr != null) {
            applicationId = appIdAttr.getAttributeValue();
        }
        sequenceConfig.setApplicationId(applicationId);
        OMAttribute forceAuthnAttr = sequenceElem.getAttribute(new QName("forceAuthn"));
        if (forceAuthnAttr != null) {
            sequenceConfig.setForceAuthn(Boolean.valueOf(forceAuthnAttr.getAttributeValue()));
        }
        if ((checkAuthnAttr = sequenceElem.getAttribute(new QName("checkAuthn"))) != null) {
            sequenceConfig.setCheckAuthn(Boolean.valueOf(checkAuthnAttr.getAttributeValue()));
        }
        if ((reqPathAuthenticatorsElem = sequenceElem.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"RequestPathAuthenticators"))) != null) {
            Iterator reqPathAuthenticatorElems = reqPathAuthenticatorsElem.getChildElements();
            while (reqPathAuthenticatorElems.hasNext()) {
                OMElement reqPathAuthenticatorElem = (OMElement)reqPathAuthenticatorElems.next();
                String authenticatorName = reqPathAuthenticatorElem.getAttributeValue(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"name"));
                AuthenticatorConfig authenticatorConfig = this.authenticatorConfigMap.get(authenticatorName);
                sequenceConfig.getReqPathAuthenticators().add(authenticatorConfig);
            }
        }
        Iterator stepElements = sequenceElem.getChildrenWithLocalName("Step");
        while (stepElements.hasNext()) {
            StepConfig stepConfig = this.processStepElement((OMElement)stepElements.next());
            if (stepConfig == null) continue;
            sequenceConfig.getStepMap().put(stepConfig.getOrder(), stepConfig);
        }
        return sequenceConfig;
    }

    private StepConfig processStepElement(OMElement stepElem) {
        OMAttribute orderAttr;
        StepConfig stepConfig = new StepConfig();
        OMAttribute loginPageAttr = stepElem.getAttribute(new QName("loginPage"));
        if (loginPageAttr != null) {
            stepConfig.setLoginPage(loginPageAttr.getAttributeValue());
        }
        if ((orderAttr = stepElem.getAttribute(new QName("order"))) == null) {
            log.warn((Object)"Each Step Configuration should have an order. +Authenticators under this Step will not be registered.");
            return null;
        }
        stepConfig.setOrder(Integer.parseInt(orderAttr.getAttributeValue()));
        Iterator authenticatorElements = stepElem.getChildrenWithLocalName("Authenticator");
        while (authenticatorElements.hasNext()) {
            OMElement authenticatorElem = (OMElement)authenticatorElements.next();
            String authenticatorName = authenticatorElem.getAttributeValue(new QName("name"));
            AuthenticatorConfig authenticatorConfig = this.authenticatorConfigMap.get(authenticatorName);
            String idps = authenticatorElem.getAttributeValue(new QName("idpList"));
            if (authenticatorConfig == null) {
                log.error((Object)("There was no authenticator configured for name: " + authenticatorName + " Please add relevant configuration in element: " + "AuthenticatorConfigs"));
                continue;
            }
            if (idps != null && !idps.isEmpty()) {
                String[] idpArr;
                for (String idp : idpArr = idps.split(",")) {
                    authenticatorConfig.getIdpNames().add(idp);
                }
            } else {
                authenticatorConfig.getIdpNames().add("LOCAL");
            }
            stepConfig.getAuthenticatorList().add(authenticatorConfig);
        }
        return stepConfig;
    }

    private AuthenticatorConfig processAuthenticatorConfigElement(OMElement authenticatorConfigElem) {
        OMAttribute nameAttr = authenticatorConfigElem.getAttribute(new QName("name"));
        if (nameAttr == null) {
            log.warn((Object)"Each Authenticator Configuration should have a unique name attribute. +This Authenticator will not be registered.");
            return null;
        }
        String authenticatorName = nameAttr.getAttributeValue();
        boolean enabled = true;
        OMAttribute enabledAttr = authenticatorConfigElem.getAttribute(new QName("enabled"));
        if (enabledAttr != null) {
            enabled = Boolean.parseBoolean(enabledAttr.getAttributeValue());
        }
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Iterator paramIterator = authenticatorConfigElem.getChildrenWithLocalName("Parameter");
        while (paramIterator.hasNext()) {
            OMElement paramElem = (OMElement)paramIterator.next();
            OMAttribute paramNameAttr = paramElem.getAttribute(new QName("name"));
            if (paramNameAttr == null) {
                log.warn((Object)"An Authenticator Parameter should have a name attribute. Skipping the parameter.");
                continue;
            }
            parameterMap.put(paramNameAttr.getAttributeValue(), paramElem.getText());
        }
        AuthenticatorConfig authenticatorConfig = new AuthenticatorConfig(authenticatorName, enabled, parameterMap);
        authenticatorConfig.setApplicationAuthenticator(FrameworkUtils.getAppAuthenticatorByName(authenticatorName));
        return authenticatorConfig;
    }

    private ExternalIdPConfig processIdPConfigElement(OMElement idpConfigElem) {
        OMAttribute nameAttr = idpConfigElem.getAttribute(new QName("name"));
        if (nameAttr == null) {
            log.warn((Object)"Each IDP configuration should have a unique name attribute");
            return null;
        }
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Iterator paramIterator = idpConfigElem.getChildrenWithLocalName("Parameter");
        while (paramIterator.hasNext()) {
            OMElement paramElem = (OMElement)paramIterator.next();
            OMAttribute paramNameAttr = paramElem.getAttribute(new QName("name"));
            if (paramNameAttr == null) {
                log.warn((Object)"A Parameter should have a name attribute. Skipping the parameter.");
                continue;
            }
            parameterMap.put(paramNameAttr.getAttributeValue(), paramElem.getText());
        }
        IdentityProvider fedIdp = new IdentityProvider();
        fedIdp.setIdentityProviderName(nameAttr.getAttributeValue());
        ExternalIdPConfig externalIdPConfig = new ExternalIdPConfig(fedIdp);
        externalIdPConfig.setParameterMap(parameterMap);
        return externalIdPConfig;
    }

    public AuthenticatorConfig getAuthenticatorBean(String authenticatorName) {
        return this.authenticatorConfigMap.get(authenticatorName);
    }

    public Map<String, AuthenticatorConfig> getAuthenticatorConfigMap() {
        return this.authenticatorConfigMap;
    }

    public SequenceConfig findSequenceByApplicationId(String appId) {
        for (SequenceConfig seq : this.sequenceList) {
            if (seq.getApplicationId() == null || !seq.getApplicationId().equalsIgnoreCase(appId)) continue;
            return seq;
        }
        return null;
    }

    public List<SequenceConfig> getSequenceList() {
        return this.sequenceList;
    }

    public List<ExternalIdPConfig> getIdpList() {
        return this.idpList;
    }

    public ExternalIdPConfig getIdPConfigs(String name) {
        for (ExternalIdPConfig externalIdPConfig : this.idpList) {
            if (!externalIdPConfig.getName().equals(name)) continue;
            return externalIdPConfig;
        }
        return null;
    }

    public List<String> getAuthEndpointQueryParams() {
        return this.authEndpointQueryParams;
    }

    public String getAuthEndpointQueryParamsAction() {
        return this.authEndpointQueryParamsAction;
    }

    public boolean isAuthEndpointQueryParamsConfigAvailable() {
        return this.authEndpointQueryParamsConfigAvailable;
    }

    public String getAuthenticationEndpointURL() {
        return this.authenticationEndpointURL;
    }

    public void setAuthenticationEndpointURL(String authenticationEndpointURL) {
        this.authenticationEndpointURL = authenticationEndpointURL;
    }

    public String getAuthenticationEndpointRetryURL() {
        return this.authenticationEndpointRetryURL;
    }

    public void setAuthenticationEndpointRetryURL(String authenticationEndpointRetryURL) {
        this.authenticationEndpointRetryURL = authenticationEndpointRetryURL;
    }

    public String getAuthenticationEndpointWaitURL() {
        return this.authenticationEndpointWaitURL;
    }

    public void setAuthenticationEndpointWaitURL(String authenticationEndpointWaitURL) {
        this.authenticationEndpointWaitURL = authenticationEndpointWaitURL;
    }

    public String getIdentifierFirstConfirmationURL() {
        return this.identifierFirstConfirmationURL;
    }

    public void setIdentifierFirstConfirmationURL(String identifierFirstConfirmationURL) {
        this.identifierFirstConfirmationURL = identifierFirstConfirmationURL;
    }

    public String getAuthenticationEndpointPromptURL() {
        return this.authenticationEndpointPromptURL;
    }

    public void setAuthenticationEndpointPromptURL(String authenticationEndpointPromptURL) {
        this.authenticationEndpointPromptURL = authenticationEndpointPromptURL;
    }

    public List<String> getTenantDataEndpointURLs() {
        return this.tenantDataEndpointURLs;
    }

    public boolean isTenantDomainDropdownEnabled() {
        return this.isTenantDomainDropdownEnabled;
    }

    public boolean isDumbMode() {
        return this.isDumbMode;
    }

    public int getMaxLoginAttemptCount() {
        return this.maxLoginAttemptCount;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public Map<String, String> getAuthenticatorNameMappings() {
        return this.authenticatorNameMappings;
    }

    public Map<String, Integer> getCacheTimeouts() {
        return this.cacheTimeouts;
    }

    public boolean isForceAuthnEnabled(String appId) {
        for (SequenceConfig seqConfig : this.sequenceList) {
            if (!seqConfig.getApplicationId().equalsIgnoreCase(appId)) continue;
            return seqConfig.isForceAuthn();
        }
        return false;
    }

    public boolean isCheckAuthnEnabled(String appId) {
        for (SequenceConfig seqConfig : this.sequenceList) {
            if (!seqConfig.getApplicationId().equalsIgnoreCase(appId)) continue;
            return seqConfig.isCheckAuthn();
        }
        return false;
    }

    public boolean isRemoveAPIParametersOnConsume() {
        return this.removeAPIParametersOnConsume;
    }

    public boolean isAuthEndpointRedirectParamsConfigAvailable() {
        return this.authEndpointRedirectParamsConfigAvailable;
    }

    public String getAuthEndpointRedirectParamsAction() {
        return this.authEndpointRedirectParamsAction;
    }

    public List<String> getAuthEndpointRedirectParams() {
        return this.authEndpointRedirectParams;
    }

    public List<String> getFilteringEnabledHostNames() {
        return this.filteringEnabledHostNames;
    }

    private void readAllowCustomClaimMappingsForAuthenticatorsValue(OMElement documentElement) {
        OMElement element = documentElement.getFirstChildWithName(IdentityApplicationManagementUtil.getQNameWithIdentityApplicationNS((String)"AllowCustomClaimMappingsForAuthenticators"));
        if (element != null) {
            this.allowCustomClaimMappingsForAuthenticators = Boolean.valueOf(element.getText());
        }
    }

    public boolean isCustomClaimMappingsForAuthenticatorsAllowed() {
        return this.allowCustomClaimMappingsForAuthenticators;
    }

    static {
        configuration = new HashMap<String, Object>();
        UNSUPPORTED_EXTENSIONS = new String[]{"AuthorizationHandler", "PostAuthenticationHandler"};
    }
}

