/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.config;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.config.builder.FileBasedConfigurationBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.loader.SequenceLoader;
import org.wso2.carbon.identity.application.authentication.framework.config.loader.UIBasedConfigurationLoader;
import org.wso2.carbon.identity.application.authentication.framework.config.model.ExternalIdPConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.exception.FrameworkException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.AuthenticationStep;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class ConfigurationFacade {
    private static final Log log = LogFactory.getLog(ConfigurationFacade.class);
    private UIBasedConfigurationLoader uiBasedConfigurationLoader;
    private static volatile ConfigurationFacade instance;
    private SequenceLoader sequenceBuilder;

    public ConfigurationFacade() {
        FileBasedConfigurationBuilder.getInstance();
        this.uiBasedConfigurationLoader = new UIBasedConfigurationLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigurationFacade getInstance() {
        if (instance != null) return instance;
        Class<ConfigurationFacade> clazz = ConfigurationFacade.class;
        synchronized (ConfigurationFacade.class) {
            if (instance != null) return instance;
            instance = new ConfigurationFacade();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public SequenceConfig getSequenceConfig(String reqType, String relyingParty, String tenantDomain) throws FrameworkException {
        ServiceProvider serviceProvider;
        ApplicationManagementService appInfo = ApplicationManagementService.getInstance();
        if ("oidc".equals(reqType)) {
            reqType = "oauth2";
        }
        try {
            serviceProvider = appInfo.getServiceProviderByClientId(relyingParty, reqType, tenantDomain);
        }
        catch (IdentityApplicationManagementException e) {
            throw new FrameworkException(e.getMessage(), e);
        }
        if (serviceProvider == null) {
            throw new FrameworkException("ServiceProvider cannot be null");
        }
        AuthenticationStep[] authenticationSteps = serviceProvider.getLocalAndOutBoundAuthenticationConfig().getAuthenticationSteps();
        return this.uiBasedConfigurationLoader.getSequence(serviceProvider, tenantDomain, authenticationSteps);
    }

    public ExternalIdPConfig getIdPConfigByName(String idpName, String tenantDomain) throws IdentityProviderManagementException {
        ExternalIdPConfig externalIdPConfig = null;
        IdentityProvider idpDO = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to find the IdP for name: " + idpName));
        }
        try {
            IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
            idpDO = idpManager.getEnabledIdPByName(idpName, tenantDomain);
            if (idpDO != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"A registered IdP was found");
                }
                externalIdPConfig = new ExternalIdPConfig(idpDO);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"A registered IdP was not found the given name");
            }
        }
        catch (IdentityProviderManagementException e) {
            throw new IdentityProviderManagementException("Exception while getting IdP by name", (Throwable)e);
        }
        return externalIdPConfig;
    }

    public ExternalIdPConfig getIdPConfigByRealm(String realm, String tenantDomain) throws IdentityProviderManagementException {
        ExternalIdPConfig externalIdPConfig = null;
        IdentityProvider idpDO = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to find the IdP for realm: " + realm));
        }
        try {
            IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
            idpDO = idpManager.getEnabledIdPByRealmId(realm, tenantDomain);
            if (idpDO != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"A registered IdP was found");
                }
                externalIdPConfig = new ExternalIdPConfig(idpDO);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"A registered IdP was not found the given realm");
            }
        }
        catch (IdentityProviderManagementException e) {
            throw new IdentityProviderManagementException("Exception while getting IdP by realm", (Throwable)e);
        }
        return externalIdPConfig;
    }

    public String getAuthenticationEndpointURL() {
        return this.buildUrl("/authenticationendpoint/login.do", FileBasedConfigurationBuilder.getInstance()::getAuthenticationEndpointURL);
    }

    public String getAuthenticationEndpointRetryURL() {
        return this.buildUrl("/authenticationendpoint/retry.do", FileBasedConfigurationBuilder.getInstance()::getAuthenticationEndpointRetryURL);
    }

    public String getAuthenticationEndpointWaitURL() {
        return this.buildUrl("/authenticationendpoint/wait.do", FileBasedConfigurationBuilder.getInstance()::getAuthenticationEndpointWaitURL);
    }

    public String getIdentifierFirstConfirmationURL() {
        return this.buildUrl("/authenticationendpoint/idf-confirm.do", FileBasedConfigurationBuilder.getInstance()::getIdentifierFirstConfirmationURL);
    }

    public String getAuthenticationEndpointPromptURL() {
        return this.buildUrl("/authenticationendpoint/dynamic_prompt.do", FileBasedConfigurationBuilder.getInstance()::getAuthenticationEndpointPromptURL);
    }

    public String getAuthenticationEndpointMissingClaimsURL() {
        return this.buildUrl("/authenticationendpoint/claims.do", FileBasedConfigurationBuilder.getInstance()::getAuthenticationEndpointMissingClaimsURL);
    }

    public List<String> getTenantDataEndpointURLs() {
        return FileBasedConfigurationBuilder.getInstance().getTenantDataEndpointURLs();
    }

    public boolean getTenantDropdownEnabled() {
        return FileBasedConfigurationBuilder.getInstance().isTenantDomainDropdownEnabled();
    }

    public boolean isDumbMode() {
        return FileBasedConfigurationBuilder.getInstance().isDumbMode();
    }

    public Map<String, Object> getExtensions() {
        return FileBasedConfigurationBuilder.getInstance().getExtensions();
    }

    public Map<String, String> getAuthenticatorNameMappings() {
        return FileBasedConfigurationBuilder.getInstance().getAuthenticatorNameMappings();
    }

    public Map<String, Integer> getCacheTimeouts() {
        return FileBasedConfigurationBuilder.getInstance().getCacheTimeouts();
    }

    public int getMaxLoginAttemptCount() {
        return FileBasedConfigurationBuilder.getInstance().getMaxLoginAttemptCount();
    }

    private String buildUrl(String defaultContext, Supplier<String> getValueFromFileBasedConfig) {
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
            try {
                return ServiceURLBuilder.create().addPath(new String[]{defaultContext}).build().getAbsolutePublicURL();
            }
            catch (URLBuilderException e) {
                throw new IdentityRuntimeException("Error while building tenant qualified url for context: " + defaultContext, (Throwable)e);
            }
        }
        String urlFromFileBasedConfig = getValueFromFileBasedConfig.get();
        if (StringUtils.isNotBlank((String)urlFromFileBasedConfig)) {
            return urlFromFileBasedConfig;
        }
        return defaultContext;
    }
}

