/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.cache;

import java.util.concurrent.TimeUnit;
import org.wso2.carbon.identity.application.authentication.framework.context.SessionContext;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionContextDO;
import org.wso2.carbon.identity.application.common.cache.CacheEntry;

public class SessionContextCacheEntry
extends CacheEntry {
    private static final long serialVersionUID = 42165605438157753L;
    SessionContext context;
    String loggedInUser;
    private long accessedTime;

    public SessionContextCacheEntry() {
        this.setAccessedTime();
    }

    public SessionContextCacheEntry(SessionContextDO sessionContextDO) {
        SessionContextCacheEntry entry = (SessionContextCacheEntry)((Object)sessionContextDO.getEntry());
        this.context = entry.getContext();
        this.loggedInUser = entry.getLoggedInUser();
        this.setAccessedTime(TimeUnit.NANOSECONDS.toMillis(sessionContextDO.getNanoTime()));
    }

    public String getLoggedInUser() {
        return this.loggedInUser;
    }

    public void setLoggedInUser(String loggedInUser) {
        this.loggedInUser = loggedInUser;
    }

    public SessionContext getContext() {
        return this.context;
    }

    public void setContext(SessionContext context) {
        this.context = context;
    }

    public void setAccessedTime() {
        this.accessedTime = System.currentTimeMillis();
    }

    private void setAccessedTime(long accessedTime) {
        this.accessedTime = accessedTime;
    }

    public long getAccessedTime() {
        return this.accessedTime;
    }
}

