/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.cache;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.cache.SessionContextCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.SessionContextCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionContextDO;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;

public class SessionContextCache
extends BaseCache<SessionContextCacheKey, SessionContextCacheEntry> {
    private static final String SESSION_CONTEXT_CACHE_NAME = "AppAuthFrameworkSessionContextCache";
    private static final Log log = LogFactory.getLog(SessionContextCache.class);
    private static volatile SessionContextCache instance;

    private SessionContextCache() {
        super(SESSION_CONTEXT_CACHE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionContextCache getInstance() {
        if (instance != null) return instance;
        Class<SessionContextCache> clazz = SessionContextCache.class;
        synchronized (SessionContextCache.class) {
            if (instance != null) return instance;
            instance = new SessionContextCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(SessionContextCacheKey key, SessionContextCacheEntry entry) {
        entry.setAccessedTime();
        super.addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        Object authUser = entry.getContext().getProperty("AuthenticatedUser");
        if (authUser != null && authUser instanceof AuthenticatedUser) {
            String tenantDomain = ((AuthenticatedUser)((Object)authUser)).getTenantDomain();
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            SessionDataStore.getInstance().storeSessionData(key.getContextId(), SESSION_CONTEXT_CACHE_NAME, (Object)entry, tenantId);
        } else {
            SessionDataStore.getInstance().storeSessionData(key.getContextId(), SESSION_CONTEXT_CACHE_NAME, (Object)entry);
        }
    }

    public SessionContextCacheEntry getValueFromCache(SessionContextCacheKey key) {
        SessionContextCacheEntry cacheEntry = (SessionContextCacheEntry)((Object)super.getValueFromCache((Serializable)((Object)key)));
        if (cacheEntry == null) {
            cacheEntry = this.getSessionFromDB(key);
        }
        if (cacheEntry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session corresponding to the key : " + key.getContextId() + " cannot be found."));
            }
            return null;
        }
        if (this.isValidIdleSession(key, cacheEntry) || this.isValidRememberMeSession(key, cacheEntry)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a valid session corresponding to the key : " + key.getContextId()));
            }
            return cacheEntry;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found an expired session corresponding to the key : " + key.getContextId()));
        }
        this.clearCacheEntry(key);
        return null;
    }

    private SessionContextCacheEntry getSessionFromDB(SessionContextCacheKey key) {
        SessionContextCacheEntry cacheEntry = null;
        SessionContextDO sessionContextDO = SessionDataStore.getInstance().getSessionContextData(key.getContextId(), SESSION_CONTEXT_CACHE_NAME);
        if (sessionContextDO != null) {
            cacheEntry = new SessionContextCacheEntry(sessionContextDO);
        }
        return cacheEntry;
    }

    public SessionContextCacheEntry getSessionContextCacheEntry(SessionContextCacheKey key) {
        SessionContextCacheEntry cacheEntry = (SessionContextCacheEntry)((Object)super.getValueFromCache((Serializable)((Object)key)));
        if (cacheEntry == null) {
            cacheEntry = this.getSessionFromDB(key);
        }
        if (cacheEntry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session corresponding to the key : " + key.getContextId() + " cannot be found."));
            }
            return null;
        }
        return cacheEntry;
    }

    public boolean isSessionExpired(SessionContextCacheKey cachekey, SessionContextCacheEntry cacheEntry) {
        if (this.isValidIdleSession(cachekey, cacheEntry) || this.isValidRememberMeSession(cachekey, cacheEntry)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A valid session is available corresponding to the key : " + cachekey.getContextId()));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found an expired session corresponding to the key : " + cachekey.getContextId()));
        }
        this.clearCacheEntry(cachekey);
        return true;
    }

    public void clearCacheEntry(SessionContextCacheKey key) {
        super.clearCacheEntry((Serializable)((Object)key));
        SessionDataStore.getInstance().clearSessionData(key.getContextId(), SESSION_CONTEXT_CACHE_NAME);
    }

    public void clearCacheEntry(String sessionContextKey) {
        SessionContextCacheKey sessionContextCacheKey = new SessionContextCacheKey(sessionContextKey);
        super.clearCacheEntry((Serializable)((Object)sessionContextCacheKey));
        SessionDataStore.getInstance().clearSessionData(sessionContextCacheKey.getContextId(), SESSION_CONTEXT_CACHE_NAME);
    }

    private boolean isValidIdleSession(SessionContextCacheKey key, SessionContextCacheEntry cacheEntry) {
        String contextId = key.getContextId();
        if (cacheEntry == null) {
            return false;
        }
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        long idleSessionTimeOut = TimeUnit.SECONDS.toMillis(IdPManagementUtil.getIdleSessionTimeOut((String)tenantDomain));
        long currentTime = System.currentTimeMillis();
        long lastAccessedTime = cacheEntry.getAccessedTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Context ID : " + contextId + " :: idleSessionTimeOut : " + idleSessionTimeOut + ", currentTime : " + currentTime + ", lastAccessedTime : " + lastAccessedTime));
        }
        if (currentTime - lastAccessedTime > idleSessionTimeOut) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Context ID : " + contextId + " :: Idle session expiry"));
            }
            return false;
        }
        return true;
    }

    private boolean isValidRememberMeSession(SessionContextCacheKey key, SessionContextCacheEntry cacheEntry) {
        Object createdTimestampObj;
        String contextId = key.getContextId();
        if (cacheEntry == null) {
            return false;
        }
        if (!cacheEntry.getContext().isRememberMe()) {
            return false;
        }
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        long rememberMeSessionTimeOut = TimeUnit.SECONDS.toMillis(IdPManagementUtil.getRememberMeTimeout((String)tenantDomain));
        long currentTime = System.currentTimeMillis();
        Long createdTime = cacheEntry.getAccessedTime();
        if (cacheEntry.getContext() != null && (createdTimestampObj = cacheEntry.getContext().getProperty("CreatedTimestamp")) != null) {
            createdTime = (Long)createdTimestampObj;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Context ID : " + contextId + " :: rememberMeSessionTimeOut : " + rememberMeSessionTimeOut + ", currentTime : " + currentTime + ", created time : " + createdTime));
        }
        if (currentTime - createdTime > rememberMeSessionTimeOut) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Context ID : " + contextId + " :: Remember me session expiry"));
            }
            return false;
        }
        return true;
    }
}

