/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.cache;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationResultCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationResultCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class AuthenticationResultCache
extends BaseCache<AuthenticationResultCacheKey, AuthenticationResultCacheEntry> {
    private static Log log = LogFactory.getLog(AuthenticationResultCache.class);
    private static final String CACHE_NAME = "AuthenticationResultCache";
    private static volatile AuthenticationResultCache instance;
    private boolean isTemporarySessionDataPersistEnabled = false;

    private AuthenticationResultCache() {
        super(CACHE_NAME, true);
        if (IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary") != null) {
            this.isTemporarySessionDataPersistEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthenticationResultCache getInstance() {
        if (instance != null) return instance;
        Class<AuthenticationResultCache> clazz = AuthenticationResultCache.class;
        synchronized (AuthenticationResultCache.class) {
            if (instance != null) return instance;
            instance = new AuthenticationResultCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(AuthenticationResultCacheKey key, AuthenticationResultCacheEntry entry) {
        super.addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        if (this.isTemporarySessionDataPersistEnabled) {
            String tenantDomain;
            int tenantId = -1;
            if (entry.getResult() != null && entry.getResult().getSubject() != null && (tenantDomain = entry.getResult().getSubject().getTenantDomain()) != null) {
                tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            }
            SessionDataStore.getInstance().storeSessionData(key.getResultId(), CACHE_NAME, (Object)entry, tenantId);
        }
    }

    public AuthenticationResultCacheEntry getValueFromCache(AuthenticationResultCacheKey key) {
        AuthenticationResultCacheEntry entry = (AuthenticationResultCacheEntry)((Object)super.getValueFromCache((Serializable)((Object)key)));
        if (entry == null && this.isTemporarySessionDataPersistEnabled) {
            entry = (AuthenticationResultCacheEntry)((Object)SessionDataStore.getInstance().getSessionData(key.getResultId(), CACHE_NAME));
        }
        return entry;
    }

    public void clearCacheEntry(AuthenticationResultCacheKey key) {
        super.clearCacheEntry((Serializable)((Object)key));
        if (this.isTemporarySessionDataPersistEnabled) {
            SessionDataStore.getInstance().clearSessionData(key.getResultId(), CACHE_NAME);
        }
    }
}

