/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.cache;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationRequestCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class AuthenticationRequestCache
extends BaseCache<AuthenticationRequestCacheKey, AuthenticationRequestCacheEntry> {
    private static Log log = LogFactory.getLog(AuthenticationRequestCache.class);
    private static final String AUTHENTICATION_REQUEST_CACHE_NAME = "AuthenticationRequestCache";
    private static volatile AuthenticationRequestCache instance;
    private boolean isTemporarySessionDataPersistEnabled = false;

    private AuthenticationRequestCache() {
        super(AUTHENTICATION_REQUEST_CACHE_NAME, true);
        if (IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary") != null) {
            this.isTemporarySessionDataPersistEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthenticationRequestCache getInstance() {
        if (instance != null) return instance;
        Class<AuthenticationRequestCache> clazz = AuthenticationRequestCache.class;
        synchronized (AuthenticationRequestCache.class) {
            if (instance != null) return instance;
            instance = new AuthenticationRequestCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(AuthenticationRequestCacheKey key, AuthenticationRequestCacheEntry entry) {
        super.addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        if (this.isTemporarySessionDataPersistEnabled) {
            int tenantId = -1;
            String tenantDomain = entry.getAuthenticationRequest().getTenantDomain();
            if (tenantDomain != null) {
                tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            }
            SessionDataStore.getInstance().storeSessionData(key.getResultId(), AUTHENTICATION_REQUEST_CACHE_NAME, (Object)entry, tenantId);
        }
    }

    public AuthenticationRequestCacheEntry getValueFromCache(AuthenticationRequestCacheKey key) {
        AuthenticationRequestCacheEntry entry = (AuthenticationRequestCacheEntry)((Object)super.getValueFromCache((Serializable)((Object)key)));
        if (entry == null && this.isTemporarySessionDataPersistEnabled) {
            entry = (AuthenticationRequestCacheEntry)((Object)SessionDataStore.getInstance().getSessionData(key.getResultId(), AUTHENTICATION_REQUEST_CACHE_NAME));
        }
        return entry;
    }

    public void clearCacheEntry(AuthenticationRequestCacheKey key) {
        super.clearCacheEntry((Serializable)((Object)key));
        if (this.isTemporarySessionDataPersistEnabled) {
            SessionDataStore.getInstance().clearSessionData(key.getResultId(), AUTHENTICATION_REQUEST_CACHE_NAME);
        }
    }
}

