/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationContextCacheEntry;
import org.wso2.carbon.identity.application.authentication.framework.cache.AuthenticationContextCacheKey;
import org.wso2.carbon.identity.application.authentication.framework.store.SessionDataStore;
import org.wso2.carbon.identity.application.common.cache.BaseCache;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class AuthenticationContextCache
extends BaseCache<AuthenticationContextCacheKey, AuthenticationContextCacheEntry> {
    private static final String AUTHENTICATION_CONTEXT_CACHE_NAME = "AuthenticationContextCache";
    private static Log log = LogFactory.getLog(AuthenticationContextCache.class);
    private static volatile AuthenticationContextCache instance;
    private boolean isTemporarySessionDataPersistEnabled = false;

    private AuthenticationContextCache() {
        super(AUTHENTICATION_CONTEXT_CACHE_NAME, true);
        if (IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary") != null) {
            this.isTemporarySessionDataPersistEnabled = Boolean.parseBoolean(IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.Temporary"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthenticationContextCache getInstance() {
        if (instance != null) return instance;
        Class<AuthenticationContextCache> clazz = AuthenticationContextCache.class;
        synchronized (AuthenticationContextCache.class) {
            if (instance != null) return instance;
            instance = new AuthenticationContextCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addToCache(AuthenticationContextCacheKey key, AuthenticationContextCacheEntry entry) {
        super.addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        if (this.isTemporarySessionDataPersistEnabled) {
            int tenantId = -1;
            String tenantDomain = entry.getContext().getTenantDomain();
            if (tenantDomain != null) {
                tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            }
            if (entry.getContext() != null && entry.getContext().getProperties() != null) {
                Iterator<Map.Entry<String, Object>> it = entry.getContext().getProperties().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Object> item = it.next();
                    if (item.getValue() instanceof Serializable) continue;
                    it.remove();
                }
                if (log.isDebugEnabled()) {
                    String message = "[ Context Id : " + key.getContextId() + ", Cache type : " + AUTHENTICATION_CONTEXT_CACHE_NAME + ", Operation : STORE ]";
                    log.debug((Object)("Authentication context is stored with details " + message));
                }
                SessionDataStore.getInstance().storeSessionData(key.getContextId(), AUTHENTICATION_CONTEXT_CACHE_NAME, (Object)entry, tenantId);
            }
        }
    }

    public AuthenticationContextCacheEntry getValueFromCache(AuthenticationContextCacheKey key) {
        AuthenticationContextCacheEntry entry = (AuthenticationContextCacheEntry)((Object)super.getValueFromCache((Serializable)((Object)key)));
        if (log.isDebugEnabled() && entry != null) {
            log.debug((Object)("Found a valid AuthenticationContextCacheEntry corresponding to the session data key : " + key.getContextId() + " from the cache. "));
        }
        if (entry == null && this.isTemporarySessionDataPersistEnabled) {
            entry = (AuthenticationContextCacheEntry)((Object)SessionDataStore.getInstance().getSessionData(key.getContextId(), AUTHENTICATION_CONTEXT_CACHE_NAME));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a valid AuthenticationContextCacheEntry corresponding to the session data key : " + key.getContextId() + " from the data store. "));
            }
            super.addToCache((Serializable)((Object)key), (Serializable)((Object)entry));
        }
        return entry;
    }

    public void clearCacheEntry(AuthenticationContextCacheKey key) {
        super.clearCacheEntry((Serializable)((Object)key));
        if (this.isTemporarySessionDataPersistEnabled) {
            SessionDataStore.getInstance().clearSessionData(key.getContextId(), AUTHENTICATION_CONTEXT_CACHE_NAME);
        }
    }
}

