/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.FederatedApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.LocalApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.RequestPathApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.exception.ApplicationAuthenticationException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceComponent;

public class ApplicationAuthenticationService {
    private static final Log log = LogFactory.getLog(ApplicationAuthenticationService.class);

    public ApplicationAuthenticator getAuthenticator(String name) throws ApplicationAuthenticationException {
        if (name == null) {
            String errMsg = "Authenticator name cannot be null";
            log.error((Object)errMsg);
            throw new ApplicationAuthenticationException(errMsg);
        }
        ApplicationAuthenticator appAuthenticator = null;
        for (ApplicationAuthenticator authenticator : FrameworkServiceComponent.getAuthenticators()) {
            if (!authenticator.getName().equals(name)) continue;
            appAuthenticator = authenticator;
        }
        return appAuthenticator;
    }

    public List<ApplicationAuthenticator> getAllAuthenticators() throws ApplicationAuthenticationException {
        return FrameworkServiceComponent.getAuthenticators();
    }

    public List<ApplicationAuthenticator> getLocalAuthenticators() throws ApplicationAuthenticationException {
        ArrayList<ApplicationAuthenticator> localAuthenticators = new ArrayList<ApplicationAuthenticator>();
        for (ApplicationAuthenticator authenticator : FrameworkServiceComponent.getAuthenticators()) {
            if (!(authenticator instanceof LocalApplicationAuthenticator)) continue;
            localAuthenticators.add(authenticator);
        }
        return localAuthenticators;
    }

    public List<ApplicationAuthenticator> getFederatedAuthenticators() throws ApplicationAuthenticationException {
        ArrayList<ApplicationAuthenticator> federatedAuthenticators = new ArrayList<ApplicationAuthenticator>();
        for (ApplicationAuthenticator authenticator : FrameworkServiceComponent.getAuthenticators()) {
            if (!(authenticator instanceof FederatedApplicationAuthenticator)) continue;
            federatedAuthenticators.add(authenticator);
        }
        return federatedAuthenticators;
    }

    public List<ApplicationAuthenticator> getRequestPathAuthenticators() throws ApplicationAuthenticationException {
        ArrayList<ApplicationAuthenticator> reqPathAuthenticators = new ArrayList<ApplicationAuthenticator>();
        for (ApplicationAuthenticator authenticator : FrameworkServiceComponent.getAuthenticators()) {
            if (!(authenticator instanceof RequestPathApplicationAuthenticator)) continue;
            reqPathAuthenticators.add(authenticator);
        }
        return reqPathAuthenticators;
    }
}

