/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.AbstractApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.LocalApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.AuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.LogoutFailedException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkErrorConstants;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.services.IdentityEventService;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public abstract class AbstractLocalApplicationAuthenticator
extends AbstractApplicationAuthenticator
implements ApplicationAuthenticator {
    private static final long serialVersionUID = -4406878411547612129L;
    private static final Log log = LogFactory.getLog(AbstractLocalApplicationAuthenticator.class);

    @Override
    public AuthenticatorFlowStatus process(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException, LogoutFailedException {
        if (!context.isLogoutRequest()) {
            if (!this.canHandle(request) || Boolean.TRUE.equals(request.getAttribute("commonAuthHandled"))) {
                context.setRetrying(false);
                return this.initiateAuthenticationFlow(request, response, context);
            }
            try {
                this.fireEvent(context, "PRE_AUTHENTICATION", false);
                this.processAuthenticationResponse(request, response, context);
                if (this instanceof LocalApplicationAuthenticator && !context.getSequenceConfig().getApplicationConfig().isSaaSApp()) {
                    this.validateNonSaasAppLogin(context);
                }
                request.setAttribute("commonAuthHandled", (Object)true);
                context.setProperty("LastFailedAuthenticator", null);
                this.fireEvent(context, "POST_AUTHENTICATION", true);
                return AuthenticatorFlowStatus.SUCCESS_COMPLETED;
            }
            catch (AuthenticationFailedException e) {
                if (this.isAccountLocked(context)) {
                    try {
                        String redirectUrl = this.getRedirectUrlOnAccountLock(context, response);
                        response.sendRedirect(redirectUrl);
                    }
                    catch (IOException e1) {
                        throw new AuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.SYSTEM_ERROR_WHILE_AUTHENTICATING.getCode(), " Error while redirecting to the retry page ", (Throwable)e1);
                    }
                    return AuthenticatorFlowStatus.INCOMPLETE;
                }
                this.fireEvent(context, "POST_AUTHENTICATION", false);
                request.setAttribute("commonAuthHandled", (Object)true);
                return this.handleRetryOnFailure(request, response, context, e);
            }
        }
        return this.processLogoutFlow(request, response, context);
    }

    protected AuthenticatorFlowStatus handleRetryOnFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, AuthenticationFailedException e) throws AuthenticationFailedException {
        boolean sendToMultiOptionPage;
        boolean bl = sendToMultiOptionPage = this.isStepHasMultiOption(context) && this.isRedirectToMultiOptionPageOnFailure();
        if (this.retryAuthenticationEnabled(context) && !sendToMultiOptionPage) {
            context.setRetrying(true);
            return this.initiateAuthenticationFlow(request, response, context);
        }
        context.setProperty("LastFailedAuthenticator", this.getName());
        throw e;
    }

    protected void validateNonSaasAppLogin(AuthenticationContext context) throws AuthenticationFailedException {
        String spTenantDomain;
        String userTenantDomain = context.getSubject().getTenantDomain();
        if (!StringUtils.equals((String)userTenantDomain, (String)(spTenantDomain = context.getTenantDomain()))) {
            context.setProperty("UserTenantDomainMismatch", true);
            throw new AuthenticationFailedException("Service Provider tenant domain must be equal to user tenant domain for non-SaaS applications", context.getSubject());
        }
    }

    protected AuthenticatorFlowStatus initiateAuthenticationFlow(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException {
        if (this.getName().equals(context.getProperty("LastFailedAuthenticator"))) {
            context.setRetrying(true);
        }
        this.initiateAuthenticationRequest(request, response, context);
        context.setCurrentAuthenticator(this.getName());
        return AuthenticatorFlowStatus.INCOMPLETE;
    }

    protected boolean isAccountLocked(AuthenticationContext context) throws AuthenticationFailedException {
        String errorCode = this.getErrorCode();
        if (StringUtils.isNotEmpty((String)errorCode) && errorCode.equals("17003")) {
            context.setRetrying(true);
            context.setCurrentAuthenticator(this.getName());
            return true;
        }
        return false;
    }

    protected String getRedirectUrlOnAccountLock(AuthenticationContext context, HttpServletResponse response) {
        String retryPage = ConfigurationFacade.getInstance().getAuthenticationEndpointRetryURL();
        String queryParams = context.getContextIdIncludedQueryParams();
        return response.encodeRedirectURL(retryPage + "?" + queryParams) + "&statusMsg=" + "This account is locked due to exceeding maximum number of failed attempts." + "&status=" + "ACCOUNT IS LOCKED";
    }

    protected AuthenticatorFlowStatus processLogoutFlow(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws LogoutFailedException {
        try {
            if (!this.canHandle(request)) {
                context.setCurrentAuthenticator(this.getName());
                this.initiateLogoutRequest(request, response, context);
                return AuthenticatorFlowStatus.INCOMPLETE;
            }
            this.processLogoutResponse(request, response, context);
            return AuthenticatorFlowStatus.SUCCESS_COMPLETED;
        }
        catch (UnsupportedOperationException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring UnsupportedOperationException.", (Throwable)e);
            }
            return AuthenticatorFlowStatus.SUCCESS_COMPLETED;
        }
    }

    private void fireEvent(AuthenticationContext context, String eventName, boolean operationStatus) throws AuthenticationFailedException {
        if (this.eventFiringEnabledForAccountLocking()) {
            IdentityEventService eventService = FrameworkServiceDataHolder.getInstance().getIdentityEventService();
            try {
                HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                String userName = (String)context.getProperty("username");
                String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)userName);
                String tenantDomain = context.getTenantDomain();
                int tenantID = IdentityTenantUtil.getTenantId((String)tenantDomain);
                RealmService realmService = FrameworkServiceDataHolder.getInstance().getRealmService();
                UserRealm userRealm = realmService.getTenantUserRealm(tenantID);
                eventProperties.put("user-name", tenantAwareUsername);
                eventProperties.put("userStoreManager", userRealm.getUserStoreManager());
                eventProperties.put("tenant-domain", tenantDomain);
                eventProperties.put("OPERATION_STATUS", operationStatus);
                Event event = new Event(eventName, eventProperties);
                eventService.handleEvent(event);
            }
            catch (UserStoreException e) {
                throw new AuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.SYSTEM_ERROR_WHILE_AUTHENTICATING.getCode(), " Error in accessing user store ", (Throwable)e);
            }
            catch (IdentityEventException e) {
                throw new AuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.SYSTEM_ERROR_WHILE_AUTHENTICATING.getCode(), " Error while firing the events ", (Throwable)e);
            }
        }
    }

    private String getErrorCode() {
        String errorCode = null;
        IdentityErrorMsgContext errorContext = IdentityUtil.getIdentityErrorMsg();
        IdentityUtil.clearIdentityErrorMsg();
        if (errorContext != null && errorContext.getErrorCode() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving error code " + errorContext.getErrorCode() + " from identity error message context "));
            }
            errorCode = errorContext.getErrorCode();
        }
        return errorCode;
    }

    protected boolean eventFiringEnabledForAccountLocking() {
        return false;
    }
}

