/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.framework;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticationDataPublisher;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.FederatedApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.LocalApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.builder.FileBasedConfigurationBuilder;
import org.wso2.carbon.identity.application.authentication.framework.config.model.AuthenticatorConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.SequenceConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.config.model.graph.AuthenticationGraph;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.AuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.LogoutFailedException;
import org.wso2.carbon.identity.application.authentication.framework.internal.FrameworkServiceDataHolder;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkErrorConstants;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public abstract class AbstractApplicationAuthenticator
implements ApplicationAuthenticator {
    private static final long serialVersionUID = -4406878411547612129L;
    private static final Log log = LogFactory.getLog(AbstractApplicationAuthenticator.class);
    public static final String ENABLE_RETRY_FROM_AUTHENTICATOR = "enableRetryFromAuthenticator";

    @Override
    public AuthenticatorFlowStatus process(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException, LogoutFailedException {
        if (!context.isLogoutRequest()) {
            if (!this.canHandle(request) || Boolean.TRUE.equals(request.getAttribute("commonAuthHandled"))) {
                if (this.getName().equals(context.getProperty("LastFailedAuthenticator"))) {
                    context.setRetrying(true);
                }
                this.initiateAuthenticationRequest(request, response, context);
                context.setCurrentAuthenticator(this.getName());
                context.setRetrying(false);
                return AuthenticatorFlowStatus.INCOMPLETE;
            }
            try {
                String tenantDomain;
                String userDomain;
                this.processAuthenticationResponse(request, response, context);
                if (this instanceof LocalApplicationAuthenticator && !context.getSequenceConfig().getApplicationConfig().isSaaSApp() && !StringUtils.equals((String)(userDomain = context.getSubject().getTenantDomain()), (String)(tenantDomain = context.getTenantDomain()))) {
                    context.setProperty("UserTenantDomainMismatch", true);
                    throw new AuthenticationFailedException(FrameworkErrorConstants.ErrorMessages.MISMATCHING_TENANT_DOMAIN.getCode(), FrameworkErrorConstants.ErrorMessages.MISMATCHING_TENANT_DOMAIN.getMessage(), context.getSubject());
                }
                request.setAttribute("commonAuthHandled", (Object)true);
                context.setProperty("LastFailedAuthenticator", null);
                this.publishAuthenticationStepAttempt(request, context, context.getSubject(), true);
                return AuthenticatorFlowStatus.SUCCESS_COMPLETED;
            }
            catch (AuthenticationFailedException e) {
                this.publishAuthenticationStepAttemptFailure(request, context, e.getUser(), e.getErrorCode());
                request.setAttribute("commonAuthHandled", (Object)true);
                boolean sendToMultiOptionPage = this.isStepHasMultiOption(context) && this.isRedirectToMultiOptionPageOnFailure();
                context.setRetrying(this.retryAuthenticationEnabled());
                if (this.retryAuthenticationEnabled(context) && !sendToMultiOptionPage) {
                    context.setCurrentAuthenticator(this.getName());
                    this.initiateAuthenticationRequest(request, response, context);
                    return AuthenticatorFlowStatus.INCOMPLETE;
                }
                context.setProperty("LastFailedAuthenticator", this.getName());
                throw e;
            }
        }
        try {
            if (!this.canHandle(request)) {
                context.setCurrentAuthenticator(this.getName());
                this.initiateLogoutRequest(request, response, context);
                return AuthenticatorFlowStatus.INCOMPLETE;
            }
            this.processLogoutResponse(request, response, context);
            return AuthenticatorFlowStatus.SUCCESS_COMPLETED;
        }
        catch (UnsupportedOperationException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Ignoring UnsupportedOperationException.", (Throwable)e);
            }
            return AuthenticatorFlowStatus.SUCCESS_COMPLETED;
        }
    }

    protected boolean retryAuthenticationEnabled(AuthenticationContext context) {
        SequenceConfig sequenceConfig = context.getSequenceConfig();
        AuthenticationGraph graph = sequenceConfig.getAuthenticationGraph();
        boolean isRetryAuthenticatorEnabled = false;
        Map<String, String> authParams = context.getAuthenticatorParams(context.getCurrentAuthenticator());
        if (MapUtils.isNotEmpty(authParams)) {
            isRetryAuthenticatorEnabled = Boolean.parseBoolean(authParams.get(ENABLE_RETRY_FROM_AUTHENTICATOR));
        }
        if (graph == null || !graph.isEnabled() || isRetryAuthenticatorEnabled) {
            return this.retryAuthenticationEnabled();
        }
        return false;
    }

    protected boolean isStepHasMultiOption(AuthenticationContext context) {
        StepConfig stepConfig;
        Map<Integer, StepConfig> stepMap = context.getSequenceConfig().getStepMap();
        boolean stepHasMultiOption = false;
        if (stepMap != null && !stepMap.isEmpty() && (stepConfig = stepMap.get(context.getCurrentStep())) != null) {
            stepHasMultiOption = stepConfig.isMultiOption();
        }
        return stepHasMultiOption;
    }

    protected void publishAuthenticationStepAttempt(HttpServletRequest request, AuthenticationContext context, User user, boolean success) {
        AuthenticationDataPublisher authnDataPublisherProxy = FrameworkServiceDataHolder.getInstance().getAuthnDataPublisherProxy();
        if (authnDataPublisherProxy != null && authnDataPublisherProxy.isEnabled(context)) {
            Serializable currentAuthenticatorStartTime = context.getAnalyticsData("currentAuthenticatorStartTime");
            if (currentAuthenticatorStartTime instanceof Long) {
                context.setAnalyticsData("currentAuthenticatorDuration", Long.valueOf(System.currentTimeMillis() - (Long)currentAuthenticatorStartTime));
            }
            boolean isFederated = this instanceof FederatedApplicationAuthenticator;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("user", user);
            if (isFederated) {
                context.setProperty("hasFederatedStep", true);
                paramMap.put("isFederated", true);
                paramMap.put("authenticator", this.getName());
                if (user != null) {
                    user.setTenantDomain(context.getTenantDomain());
                }
            } else {
                context.setProperty("hasLocalStep", true);
                paramMap.put("isFederated", false);
            }
            Map<String, Object> unmodifiableParamMap = Collections.unmodifiableMap(paramMap);
            if (success) {
                authnDataPublisherProxy.publishAuthenticationStepSuccess(request, context, unmodifiableParamMap);
                context.setAnalyticsData("currentAuthenticatorStartTime", null);
            } else {
                authnDataPublisherProxy.publishAuthenticationStepFailure(request, context, unmodifiableParamMap);
                context.setAnalyticsData("currentAuthenticatorStartTime", Long.valueOf(System.currentTimeMillis()));
            }
        }
    }

    private void publishAuthenticationStepAttemptFailure(HttpServletRequest request, AuthenticationContext context, User user, String errorCode) {
        context.setAnalyticsData("currentAuthenticatorErrorCode", (Serializable)((Object)errorCode));
        this.publishAuthenticationStepAttempt(request, context, user, false);
    }

    protected void initiateAuthenticationRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException {
    }

    protected abstract void processAuthenticationResponse(HttpServletRequest var1, HttpServletResponse var2, AuthenticationContext var3) throws AuthenticationFailedException;

    protected void initiateLogoutRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws LogoutFailedException {
        throw new UnsupportedOperationException();
    }

    protected void processLogoutResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws LogoutFailedException {
        throw new UnsupportedOperationException();
    }

    protected AuthenticatorConfig getAuthenticatorConfig() {
        AuthenticatorConfig authConfig = FileBasedConfigurationBuilder.getInstance().getAuthenticatorBean(this.getName());
        if (authConfig == null) {
            authConfig = new AuthenticatorConfig();
            authConfig.setParameterMap(new HashMap<String, String>());
        }
        return authConfig;
    }

    protected boolean retryAuthenticationEnabled() {
        return false;
    }

    protected boolean isRedirectToMultiOptionPageOnFailure() {
        Map<String, String> parameterMap = this.getAuthenticatorConfig().getParameterMap();
        boolean isRedirectToMultiOptionPageOnFailure = true;
        if (MapUtils.isNotEmpty(parameterMap)) {
            String redirectToMultiOptionOnFailure = parameterMap.get("redirectToMultiOptionPageOnFailure");
            boolean bl = isRedirectToMultiOptionPageOnFailure = redirectToMultiOptionOnFailure == null || Boolean.parseBoolean(redirectToMultiOptionOnFailure);
            if (log.isDebugEnabled()) {
                log.debug((Object)("redirectToMultiOptionOnFailure has been set as : " + isRedirectToMultiOptionPageOnFailure));
            }
        }
        return isRedirectToMultiOptionPageOnFailure;
    }

    @Override
    public String getClaimDialectURI() {
        return null;
    }

    @Override
    public List<Property> getConfigurationProperties() {
        return new ArrayList<Property>();
    }

    protected String getUserStoreAppendedName(String userName) {
        if (!userName.contains(CarbonConstants.DOMAIN_SEPARATOR) && UserCoreUtil.getDomainFromThreadLocal() != null && !"".equals(UserCoreUtil.getDomainFromThreadLocal())) {
            userName = UserCoreUtil.getDomainFromThreadLocal() + CarbonConstants.DOMAIN_SEPARATOR + userName;
        }
        return userName;
    }

    public Map<String, String> getRuntimeParams(AuthenticationContext context) {
        Map<String, String> runtimeParams = context.getAuthenticatorParams(this.getName());
        Map<String, String> commonParams = context.getAuthenticatorParams("common");
        if (MapUtils.isNotEmpty(commonParams)) {
            if (runtimeParams != null) {
                commonParams.putAll(runtimeParams);
            }
            return commonParams;
        }
        if (runtimeParams != null) {
            return runtimeParams;
        }
        return Collections.emptyMap();
    }

    @Override
    public String getAuthMechanism() {
        String authMechanism = this.getAuthenticatorConfig().getParameterMap().get("AuthMechanism");
        if (StringUtils.isEmpty((String)authMechanism)) {
            authMechanism = this.getName();
        }
        return authMechanism;
    }
}

