/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.userstore.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.wso2.carbon.privacy.forgetme.userstore.exception.UserStoreModuleException;
import org.wso2.carbon.user.api.RealmConfiguration;

public class SecondaryUserStoreReader {
    public RealmConfiguration read(Path userStoreConfigFilePath, RealmConfiguration primaryRealm) throws UserStoreModuleException {
        RealmConfiguration realmConfigurationForSecondaryUserStore = new RealmConfiguration();
        realmConfigurationForSecondaryUserStore.setPrimary(false);
        realmConfigurationForSecondaryUserStore.setRealmClassName(primaryRealm.getRealmClassName());
        realmConfigurationForSecondaryUserStore.setRealmProperties(primaryRealm.getRealmProperties());
        try {
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)new FileInputStream(userStoreConfigFilePath.toFile()));
            OMElement userStoreElement = builder.getDocumentElement();
            String userStoreClassName = userStoreElement.getAttributeValue(new QName("class"));
            realmConfigurationForSecondaryUserStore.setUserStoreClass(userStoreClassName);
            realmConfigurationForSecondaryUserStore.setUserStoreProperties(this.getUserStoreProperties(userStoreElement));
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new UserStoreModuleException("An error occurred while reading the secondary user store.", e);
        }
        return realmConfigurationForSecondaryUserStore;
    }

    private Map<String, String> getUserStoreProperties(OMElement userStoreElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator ite = userStoreElement.getChildrenWithName(new QName("Property"));
        while (ite.hasNext()) {
            OMElement propElem = (OMElement)ite.next();
            String propName = propElem.getAttributeValue(new QName("name"));
            String propValue = propElem.getText();
            if (propName == null || propValue == null) continue;
            map.put(propName.trim(), propValue.trim());
        }
        return map;
    }
}

