/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.userstore.instructions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.report.ReportAppender;
import org.wso2.carbon.privacy.forgetme.api.runtime.Environment;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeInstruction;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeResult;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionExecutionException;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfig;
import org.wso2.carbon.privacy.forgetme.api.user.UserIdentifier;
import org.wso2.carbon.privacy.forgetme.userstore.exception.UserStoreInstructionExecutionException;
import org.wso2.carbon.privacy.forgetme.userstore.exception.UserStoreModuleException;
import org.wso2.carbon.privacy.forgetme.userstore.handler.UserStoreHandler;
import org.wso2.carbon.privacy.forgetme.userstore.instructions.UserStoreProcessorConfig;

public class UserStoreForgetMeInstruction
implements ForgetMeInstruction {
    private static final Logger log = LoggerFactory.getLogger(UserStoreForgetMeInstruction.class);

    public ForgetMeResult execute(UserIdentifier userIdentifier, ProcessorConfig processorConfig, Environment environment, ReportAppender reportAppender) throws InstructionExecutionException {
        try {
            String logMessage = String.format("Renaming user in tenant : '%d' user store domain : '%s'", userIdentifier.getTenantId(), userIdentifier.getUserStoreDomain());
            if (log.isDebugEnabled()) {
                log.debug(logMessage);
            }
            reportAppender.appendSection(logMessage, new Object[0]);
            UserStoreProcessorConfig config = (UserStoreProcessorConfig)processorConfig;
            UserStoreHandler userStoreHandler = config.getUserStoreHandlerFactory().getUserStoreHandler(userIdentifier.getTenantId(), userIdentifier.getUserStoreDomain());
            if (userStoreHandler == null) {
                throw new UserStoreInstructionExecutionException(String.format("An applicable handler can't be found for the tenant id : '%d' and user store domain : '%s'", userIdentifier.getTenantId(), userIdentifier.getUserStoreDomain()));
            }
            userStoreHandler.renameUser(userIdentifier.getUsername(), userIdentifier.getPseudonym());
            logMessage = String.format("Renamed user in tenant : '%d' user store domain : '%s'", userIdentifier.getTenantId(), userIdentifier.getUserStoreDomain());
            reportAppender.appendSection(logMessage, new Object[0]);
            log.info(logMessage);
            return new ForgetMeResult();
        }
        catch (UserStoreModuleException e) {
            throw new UserStoreInstructionExecutionException("An error occurred while renaming user.", (Throwable)((Object)e));
        }
    }
}

