/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.userstore.handler;

import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.privacy.forgetme.userstore.exception.UserStoreModuleException;
import org.wso2.carbon.privacy.forgetme.userstore.handler.UserStoreHandler;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;

public class LDAPUserStoreHandler
extends UserStoreHandler {
    private static final Log log = LogFactory.getLog(LDAPUserStoreHandler.class);

    @Override
    public String getName() {
        return "read-write-ldap-handler";
    }

    @Override
    public void renameUser(String currentName, String newName) throws UserStoreModuleException {
        try {
            String userSearchBase = this.getRealmConfiguration().getUserStoreProperty("UserSearchBase");
            String userNameAttribute = this.getRealmConfiguration().getUserStoreProperty("UserNameAttribute");
            String currentDN = String.format("%s=%s,%s", userNameAttribute, currentName, userSearchBase);
            String newDN = String.format("%s=%s,%s", userNameAttribute, newName, userSearchBase);
            LDAPConnectionContext ldapConnectionContext = new LDAPConnectionContext(this.getRealmConfiguration());
            DirContext context = ldapConnectionContext.getContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Renaming the user. Search base : '%s', Username attribute : '%s'", userSearchBase, userNameAttribute));
            }
            context.rename(currentDN, newDN);
        }
        catch (NamingException | UserStoreException e) {
            throw new UserStoreModuleException("An error occurred while renaming a user in an LDAP user store.", e);
        }
    }
}

