/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.userstore.handler;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.datasource.core.DataSourceManager;
import org.wso2.carbon.datasource.core.beans.CarbonDataSource;
import org.wso2.carbon.datasource.core.beans.DataSourceMetadata;
import org.wso2.carbon.datasource.core.exception.DataSourceException;
import org.wso2.carbon.privacy.forgetme.userstore.exception.UserStoreModuleException;
import org.wso2.carbon.privacy.forgetme.userstore.handler.UserStoreHandler;

public class JDBCUserStoreHandler
extends UserStoreHandler {
    private static final Log log = LogFactory.getLog(JDBCUserStoreHandler.class);
    private static final String USER_STORE_PROPERTY_DB_URL = "url";
    private static final String USER_STORE_PROPERTY_DB_USERNAME = "userName";
    private static final String USER_STORE_PROPERTY_DB_PASSWORD = "password";
    private static final String USER_STORE_PROPERTY_DB_DRIVER_NAME = "driverName";
    private static final String USER_STORE_PROPERTY_DATA_SOURCE = "dataSource";
    private static final String CARBON_DATA_SOURCES_DIRECTORY = "repository/conf/datasources/";
    private static final String HANDLER_PROPERTY_USERNAME_RENAME_QUERY = "rename.query";
    private static final String USERNAME_RENAME_QUERY = "UPDATE UM_USER SET UM_USER_NAME=? WHERE UM_USER_NAME=? AND UM_TENANT_ID=?";

    @Override
    public String getName() {
        return "jdbc-handler";
    }

    @Override
    public void renameUser(String currentName, String newName) throws UserStoreModuleException {
        String query = USERNAME_RENAME_QUERY;
        String queryAsHandlerProperty = this.getProperty(HANDLER_PROPERTY_USERNAME_RENAME_QUERY);
        if (StringUtils.isNotBlank((String)queryAsHandlerProperty)) {
            query = queryAsHandlerProperty;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Username rename query : '%s'", query));
        }
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            preparedStatement.setString(1, newName);
            preparedStatement.setString(2, currentName);
            preparedStatement.setInt(3, this.getTenantId());
            preparedStatement.execute();
        }
        catch (ClassNotFoundException | SQLException | DataSourceException | UserStoreModuleException e) {
            throw new UserStoreModuleException("An error occurred while renaming a user in an JDBC user store.", (Throwable)e);
        }
    }

    private Connection getConnection() throws SQLException, ClassNotFoundException, DataSourceException, UserStoreModuleException {
        if (this.isDatabaseConfiguredInline()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found database access details as inline configurations.");
            }
            return this.getConnectionFromInlineConfiguration();
        }
        if (this.isDataSourceConfiguredInUserStoreConfiguration()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found database access details as the data source in user store configurations.");
            }
            return this.getConnectionFromUserStoreDataSource();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found database access details as the data source in realm configurations.");
        }
        return this.getConnectionFromRealmDataSource();
    }

    private boolean isDatabaseConfiguredInline() {
        return StringUtils.isNotBlank((String)this.getRealmConfiguration().getUserStoreProperty(USER_STORE_PROPERTY_DB_URL));
    }

    private Connection getConnectionFromInlineConfiguration() throws ClassNotFoundException, SQLException {
        String url = this.getRealmConfiguration().getUserStoreProperty(USER_STORE_PROPERTY_DB_URL);
        String userName = this.getRealmConfiguration().getUserStoreProperty(USER_STORE_PROPERTY_DB_USERNAME);
        String password = this.getRealmConfiguration().getUserStoreProperty(USER_STORE_PROPERTY_DB_PASSWORD);
        String driverName = this.getRealmConfiguration().getUserStoreProperty(USER_STORE_PROPERTY_DB_DRIVER_NAME);
        Class.forName(driverName);
        return DriverManager.getConnection(url, userName, password);
    }

    private boolean isDataSourceConfiguredInUserStoreConfiguration() {
        return StringUtils.isNotBlank((String)this.getRealmConfiguration().getUserStoreProperty(USER_STORE_PROPERTY_DATA_SOURCE));
    }

    private Connection getConnectionFromUserStoreDataSource() throws DataSourceException, UserStoreModuleException, SQLException {
        String dataSourceName = this.getRealmConfiguration().getUserStoreProperty(USER_STORE_PROPERTY_DATA_SOURCE);
        DataSource dataSource = this.getDataSourceByJNDIName(dataSourceName);
        return dataSource.getConnection();
    }

    private Connection getConnectionFromRealmDataSource() throws DataSourceException, UserStoreModuleException, SQLException {
        String dataSourceName = this.getRealmConfiguration().getRealmProperty(USER_STORE_PROPERTY_DATA_SOURCE);
        DataSource dataSource = this.getDataSourceByJNDIName(dataSourceName);
        return dataSource.getConnection();
    }

    private DataSource getDataSourceByJNDIName(String jndiName) throws DataSourceException, UserStoreModuleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Looking for the data source for the JNDI name : '%s'", jndiName));
        }
        DataSourceManager dataSourceManager = DataSourceManager.getInstance();
        dataSourceManager.initDataSources(this.getCarbonHome().resolve(CARBON_DATA_SOURCES_DIRECTORY).toString());
        if (dataSourceManager.getDataSourceRepository() != null) {
            List metadata = dataSourceManager.getDataSourceRepository().getMetadata();
            CarbonDataSource userStoreDataStore = null;
            for (DataSourceMetadata m : metadata) {
                if (!m.getJndiConfig().getName().equals(jndiName)) continue;
                userStoreDataStore = dataSourceManager.getDataSourceRepository().getDataSource(m.getName());
            }
            if (userStoreDataStore != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found the data source for the JNDI name : '%s'", jndiName));
                }
                return (DataSource)userStoreDataStore.getDataSourceObject();
            }
            throw new UserStoreModuleException(String.format("Data source for the JNDI name '%s'can't be found.", jndiName));
        }
        throw new UserStoreModuleException(String.format("Data source manager is not initialized to get the data source for the JNDI name '%s'.", jndiName));
    }
}

