/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.userstore.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.privacy.forgetme.userstore.exception.UserStoreModuleException;
import org.wso2.carbon.privacy.forgetme.userstore.handler.UserStoreHandler;
import org.wso2.carbon.privacy.forgetme.userstore.util.SecondaryUserStoreReader;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;

public class UserStoreHandlerFactory {
    private static final Log log = LogFactory.getLog(UserStoreHandlerFactory.class);
    private static final int SUPER_TENANT_ID = -1234;
    public static final String PRIMARY_USER_STORE_NAME = "PRIMARY";
    private static final String HANDLER_PROPERTY_PREFIX_HANDLER_MAPPING = "handler-mapping";
    private static final String HANDLER_PROPERTY_PREFIX_HANDLER_PROPERTY = "handler-property";
    private ServiceLoader<UserStoreHandler> userStoreHandlerServiceLoader;
    private Map<String, UserStoreHandler> userStoreHandlerMappings;
    private final Path carbonHome;
    private final Map<String, String> properties;

    public UserStoreHandlerFactory(Path carbonHome, Map<String, String> properties) {
        this.carbonHome = carbonHome;
        this.properties = properties;
        this.userStoreHandlerMappings = new HashMap<String, UserStoreHandler>();
        this.userStoreHandlerServiceLoader = ServiceLoader.load(UserStoreHandler.class);
        this.userStoreHandlerServiceLoader.forEach(r -> this.userStoreHandlerMappings.put(r.getName(), (UserStoreHandler)r));
    }

    public UserStoreHandler getUserStoreHandler(int tenantId, String userStoreDomain) throws UserStoreModuleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Looking for the user store handler for the tenant id : '%d', user store domain : '%s'", tenantId, userStoreDomain));
        }
        RealmConfiguration realmConfiguration = null;
        try {
            String handlerMappingKey;
            UserStoreHandler applicableHandler;
            realmConfiguration = this.getRealmConfig(tenantId, userStoreDomain);
            String userStoreManagerClassName = realmConfiguration.getUserStoreClass();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("User store manager class name : '%s'", userStoreManagerClassName));
            }
            if ((applicableHandler = this.userStoreHandlerMappings.get(this.properties.get(handlerMappingKey = "handler-mapping;" + userStoreManagerClassName))) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found an applicable handler : '%s'", applicableHandler.getClass().getName()));
                }
                applicableHandler.setRealmConfiguration(realmConfiguration);
                applicableHandler.setTenantId(tenantId);
                applicableHandler.setCarbonHome(this.carbonHome);
                this.addHandlerProperties(applicableHandler);
            }
            return applicableHandler;
        }
        catch (IOException | UserStoreException e) {
            throw new UserStoreModuleException(String.format("An error occurred while retrieving the applicable user store handler for tenant id : '%d', user store domain : '%s'", tenantId, userStoreDomain), e);
        }
    }

    private void addHandlerProperties(UserStoreHandler applicableHandler) {
        String propertyPrefix = String.format("%s;%s;", HANDLER_PROPERTY_PREFIX_HANDLER_PROPERTY, applicableHandler.getName());
        this.properties.forEach((k, v) -> {
            if (k.startsWith(propertyPrefix)) {
                applicableHandler.addProperty(StringUtils.substringAfter((String)k, (String)propertyPrefix), (String)v);
            }
        });
    }

    private RealmConfiguration getRealmConfig(int tenantId, String userStoreDomain) throws IOException, UserStoreException, UserStoreModuleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Looking for the realm config for the tenant id : '%d', user store domain : '%s'", tenantId, userStoreDomain));
        }
        RealmConfiguration realmConfiguration = this.getPrimaryRealmConfiguration();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieved the primary realm configuration.");
        }
        Path userStoreConfigFilePath = null;
        if (-1234 == tenantId) {
            if (PRIMARY_USER_STORE_NAME.equals(userStoreDomain)) {
                return realmConfiguration;
            }
            userStoreConfigFilePath = this.getUserStoreConfigFilePathForDomain("repository/deployment/server/userstores/", userStoreDomain);
        } else {
            if (PRIMARY_USER_STORE_NAME.equals(userStoreDomain)) {
                return realmConfiguration;
            }
            userStoreConfigFilePath = this.getUserStoreConfigFilePathForDomain("repository/tenants/" + tenantId + "/userstores/", userStoreDomain);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Secondary user store configuration file path : " + userStoreConfigFilePath.toString()));
        }
        SecondaryUserStoreReader secondaryUserStoreReader = new SecondaryUserStoreReader();
        realmConfiguration = secondaryUserStoreReader.read(userStoreConfigFilePath, realmConfiguration);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Built the realm configuration for the secondary user store.");
        }
        return realmConfiguration;
    }

    private RealmConfiguration getPrimaryRealmConfiguration() throws IOException, UserStoreException {
        Path primaryUserStoreConfigFilePath = this.carbonHome.resolve("repository/conf/user-mgt.xml");
        try (FileInputStream inStream = new FileInputStream(primaryUserStoreConfigFilePath.toFile());){
            RealmConfigXMLProcessor builder = new RealmConfigXMLProcessor();
            RealmConfiguration realmConfiguration = builder.buildRealmConfiguration((InputStream)inStream);
            return realmConfiguration;
        }
    }

    private Path getUserStoreConfigFilePathForDomain(String useStoreConfigFileDirectory, String userStoreDomain) throws IOException, UserStoreModuleException {
        String expectedUserStoreFileName = userStoreDomain.replace(".", "_") + ".xml";
        Path userStoreConfigFileDirectoryPath = this.carbonHome.resolve(useStoreConfigFileDirectory);
        Path matchedUserStoreFile = Files.list(userStoreConfigFileDirectoryPath).filter(path -> path.toString().endsWith(".xml")).map(Path::getFileName).filter(path -> expectedUserStoreFileName.equalsIgnoreCase(path.toString())).findFirst().orElse(null);
        if (matchedUserStoreFile == null) {
            throw new UserStoreModuleException("Cannot find secondary user store configuration file for user store domain: " + userStoreDomain);
        }
        return userStoreConfigFileDirectoryPath.resolve(matchedUserStoreFile);
    }
}

