/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.manager.commons.utils;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;

public class Utils {
    public static String findAddress(String hostname) throws SocketException {
        if (hostname.trim().equals("localhost") || hostname.trim().equals("127.0.0.1") || hostname.trim().equals("::1")) {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                    return addr.getHostAddress();
                }
            }
            return "127.0.0.1";
        }
        return hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortUsed(int portNumber, String host) {
        boolean isPortUsed;
        ServerSocket serverSocket = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            serverSocket = new ServerSocket(portNumber, 50, inetAddress);
            isPortUsed = false;
        }
        catch (IOException ignored) {
            isPortUsed = true;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    isPortUsed = true;
                }
            }
        }
        if (!isPortUsed) {
            Socket socket = null;
            try {
                socket = new Socket("localhost", portNumber);
                isPortUsed = true;
            }
            catch (IOException ignored) {
                isPortUsed = false;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                        isPortUsed = true;
                    }
                    catch (IOException e) {
                        isPortUsed = true;
                    }
                }
            }
        }
        return isPortUsed;
    }

    public static String constructQueryExpression(List<String> importDefinitions, List<String> exportDefinitions, String queryExpressions) {
        StringBuilder builder = new StringBuilder();
        for (String definition : importDefinitions) {
            builder.append(definition);
        }
        for (String definition : exportDefinitions) {
            builder.append(definition);
        }
        builder.append(queryExpressions);
        return builder.toString();
    }
}

